/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.common.ContainerSignatureMatcher;
import org.apache.tez.common.ServicePluginLifecycle;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.NamedEntityDescriptor;
import org.apache.tez.dag.api.TaskLocationHint;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezConstants;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.client.DAGClientServer;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ContainerContext;
import org.apache.tez.dag.app.ServicePluginLifecycleAbstractService;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.dag.TaskAttempt;
import org.apache.tez.dag.app.dag.event.DAGAppMasterEventType;
import org.apache.tez.dag.app.dag.event.DAGAppMasterEventUserServiceFatalError;
import org.apache.tez.dag.app.dag.event.DAGEventTerminateDag;
import org.apache.tez.dag.app.dag.impl.TaskAttemptImpl;
import org.apache.tez.dag.app.dag.impl.TaskImpl;
import org.apache.tez.dag.app.dag.impl.VertexImpl;
import org.apache.tez.dag.app.rm.AMSchedulerEvent;
import org.apache.tez.dag.app.rm.AMSchedulerEventTALaunchRequest;
import org.apache.tez.dag.app.rm.TaskSchedulerManager;
import org.apache.tez.dag.app.rm.TaskSchedulerWrapper;
import org.apache.tez.dag.app.rm.container.AMContainer;
import org.apache.tez.dag.app.rm.container.AMContainerEventAssignTA;
import org.apache.tez.dag.app.rm.container.AMContainerEventCompleted;
import org.apache.tez.dag.app.rm.container.AMContainerEventType;
import org.apache.tez.dag.app.rm.container.AMContainerMap;
import org.apache.tez.dag.app.rm.container.AMContainerState;
import org.apache.tez.dag.app.web.WebUIService;
import org.apache.tez.dag.helpers.DagInfoImplForTest;
import org.apache.tez.dag.records.TaskAttemptTerminationCause;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.apache.tez.serviceplugins.api.DagInfo;
import org.apache.tez.serviceplugins.api.ServicePluginError;
import org.apache.tez.serviceplugins.api.ServicePluginErrorDefaults;
import org.apache.tez.serviceplugins.api.ServicePluginException;
import org.apache.tez.serviceplugins.api.TaskAttemptEndReason;
import org.apache.tez.serviceplugins.api.TaskScheduler;
import org.apache.tez.serviceplugins.api.TaskSchedulerContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestTaskSchedulerManager {
    AppContext mockAppContext;
    DAGClientServer mockClientService;
    TestEventHandler mockEventHandler;
    ContainerSignatureMatcher mockSigMatcher;
    MockTaskSchedulerManager schedulerHandler;
    TaskScheduler mockTaskScheduler;
    AMContainerMap mockAMContainerMap;
    WebUIService mockWebUIService;
    private static final String DAG_NAME = "dagName";
    private static final int DAG_INDEX = 1;

    @Before
    public void setup() {
        this.mockAppContext = (AppContext)Mockito.mock(AppContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        ((AppContext)Mockito.doReturn((Object)new Configuration(false)).when((Object)this.mockAppContext)).getAMConf();
        this.mockClientService = (DAGClientServer)Mockito.mock(DAGClientServer.class);
        this.mockEventHandler = new TestEventHandler();
        this.mockSigMatcher = (ContainerSignatureMatcher)Mockito.mock(ContainerSignatureMatcher.class);
        this.mockTaskScheduler = (TaskScheduler)Mockito.mock(TaskScheduler.class);
        this.mockAMContainerMap = (AMContainerMap)Mockito.mock(AMContainerMap.class);
        this.mockWebUIService = (WebUIService)Mockito.mock(WebUIService.class);
        Mockito.when((Object)this.mockAppContext.getAllContainers()).thenReturn((Object)this.mockAMContainerMap);
        Mockito.when((Object)this.mockClientService.getBindAddress()).thenReturn((Object)new InetSocketAddress(10000));
        this.schedulerHandler = new MockTaskSchedulerManager(this.mockAppContext, this.mockClientService, this.mockEventHandler, this.mockSigMatcher, this.mockWebUIService);
    }

    @Test(timeout=5000L)
    public void testSimpleAllocate() throws Exception {
        Configuration conf = new Configuration(false);
        this.schedulerHandler.init(conf);
        this.schedulerHandler.start();
        TaskAttemptImpl mockTaskAttempt = (TaskAttemptImpl)Mockito.mock(TaskAttemptImpl.class);
        TezTaskAttemptID mockAttemptId = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
        Mockito.when((Object)mockAttemptId.getId()).thenReturn((Object)0);
        Mockito.when((Object)mockTaskAttempt.getID()).thenReturn((Object)mockAttemptId);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        ContainerContext containerContext = new ContainerContext(new HashMap(), new Credentials(), new HashMap(), "");
        int priority = 10;
        TaskLocationHint locHint = TaskLocationHint.createTaskLocationHint(new HashSet(), null);
        ContainerId mockCId = (ContainerId)Mockito.mock(ContainerId.class);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)mockCId);
        AMContainer mockAMContainer = (AMContainer)Mockito.mock(AMContainer.class);
        Mockito.when((Object)mockAMContainer.getContainerId()).thenReturn((Object)mockCId);
        Mockito.when((Object)mockAMContainer.getState()).thenReturn((Object)AMContainerState.IDLE);
        Mockito.when((Object)this.mockAMContainerMap.get(mockCId)).thenReturn((Object)mockAMContainer);
        AMSchedulerEventTALaunchRequest lr = new AMSchedulerEventTALaunchRequest(mockAttemptId, resource, null, (TaskAttempt)mockTaskAttempt, locHint, priority, containerContext, 0, 0, 0);
        this.schedulerHandler.taskAllocated(0, mockTaskAttempt, lr, container);
        Assert.assertEquals((long)1L, (long)this.mockEventHandler.events.size());
        Assert.assertTrue((boolean)(this.mockEventHandler.events.get(0) instanceof AMContainerEventAssignTA));
        AMContainerEventAssignTA assignEvent = (AMContainerEventAssignTA)this.mockEventHandler.events.get(0);
        Assert.assertEquals((long)priority, (long)assignEvent.getPriority());
        Assert.assertEquals((Object)mockAttemptId, (Object)assignEvent.getTaskAttemptId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testTaskBasedAffinity() throws Exception {
        Configuration conf = new Configuration(false);
        this.schedulerHandler.init(conf);
        this.schedulerHandler.start();
        TaskAttemptImpl mockTaskAttempt = (TaskAttemptImpl)Mockito.mock(TaskAttemptImpl.class);
        TezTaskAttemptID taId = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
        String affVertexName = "srcVertex";
        int affTaskIndex = 1;
        TaskLocationHint locHint = TaskLocationHint.createTaskLocationHint((String)affVertexName, (int)affTaskIndex);
        VertexImpl affVertex = (VertexImpl)Mockito.mock(VertexImpl.class);
        TaskImpl affTask = (TaskImpl)Mockito.mock(TaskImpl.class);
        TaskAttemptImpl affAttempt = (TaskAttemptImpl)Mockito.mock(TaskAttemptImpl.class);
        ContainerId affCId = (ContainerId)Mockito.mock(ContainerId.class);
        Mockito.when((Object)affVertex.getTotalTasks()).thenReturn((Object)2);
        Mockito.when((Object)affVertex.getTask(affTaskIndex)).thenReturn((Object)affTask);
        Mockito.when((Object)affTask.getSuccessfulAttempt()).thenReturn((Object)affAttempt);
        Mockito.when((Object)affAttempt.getAssignedContainerID()).thenReturn((Object)affCId);
        Mockito.when((Object)this.mockAppContext.getCurrentDAG().getVertex(affVertexName)).thenReturn((Object)affVertex);
        Resource resource = Resource.newInstance((int)100, (int)1);
        AMSchedulerEventTALaunchRequest event = new AMSchedulerEventTALaunchRequest(taId, resource, null, (TaskAttempt)mockTaskAttempt, locHint, 3, null, 0, 0, 0);
        this.schedulerHandler.notify.set(false);
        this.schedulerHandler.handle((AMSchedulerEvent)event);
        AtomicBoolean atomicBoolean = this.schedulerHandler.notify;
        synchronized (atomicBoolean) {
            while (!this.schedulerHandler.notify.get()) {
                this.schedulerHandler.notify.wait();
            }
        }
        ((TaskScheduler)Mockito.verify((Object)this.mockTaskScheduler, (VerificationMode)Mockito.times((int)1))).allocateTask((Object)mockTaskAttempt, resource, affCId, Priority.newInstance((int)3), null, (Object)event);
        this.schedulerHandler.stop();
        this.schedulerHandler.close();
    }

    @Test(timeout=5000L)
    public void testContainerPreempted() throws IOException {
        Configuration conf = new Configuration(false);
        this.schedulerHandler.init(conf);
        this.schedulerHandler.start();
        String diagnostics = "Container preempted by RM.";
        TaskAttemptImpl mockTask = (TaskAttemptImpl)Mockito.mock(TaskAttemptImpl.class);
        ContainerStatus mockStatus = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        ContainerId mockCId = (ContainerId)Mockito.mock(ContainerId.class);
        AMContainer mockAMContainer = (AMContainer)Mockito.mock(AMContainer.class);
        Mockito.when((Object)this.mockAMContainerMap.get(mockCId)).thenReturn((Object)mockAMContainer);
        Mockito.when((Object)mockAMContainer.getContainerId()).thenReturn((Object)mockCId);
        Mockito.when((Object)mockStatus.getContainerId()).thenReturn((Object)mockCId);
        Mockito.when((Object)mockStatus.getDiagnostics()).thenReturn((Object)diagnostics);
        Mockito.when((Object)mockStatus.getExitStatus()).thenReturn((Object)-102);
        this.schedulerHandler.containerCompleted(0, mockTask, mockStatus);
        Assert.assertEquals((long)1L, (long)this.mockEventHandler.events.size());
        Event event = this.mockEventHandler.events.get(0);
        Assert.assertEquals((Object)AMContainerEventType.C_COMPLETED, (Object)event.getType());
        AMContainerEventCompleted completedEvent = (AMContainerEventCompleted)event;
        Assert.assertEquals((Object)mockCId, (Object)completedEvent.getContainerId());
        Assert.assertEquals((Object)"Container preempted externally. Container preempted by RM.", (Object)completedEvent.getDiagnostics());
        Assert.assertTrue((boolean)completedEvent.isPreempted());
        Assert.assertEquals((Object)TaskAttemptTerminationCause.EXTERNAL_PREEMPTION, (Object)completedEvent.getTerminationCause());
        Assert.assertFalse((boolean)completedEvent.isDiskFailed());
        this.schedulerHandler.stop();
        this.schedulerHandler.close();
    }

    @Test(timeout=5000L)
    public void testContainerInternalPreempted() throws IOException, ServicePluginException {
        Configuration conf = new Configuration(false);
        this.schedulerHandler.init(conf);
        this.schedulerHandler.start();
        AMContainer mockAmContainer = (AMContainer)Mockito.mock(AMContainer.class);
        Mockito.when((Object)mockAmContainer.getTaskSchedulerIdentifier()).thenReturn((Object)0);
        Mockito.when((Object)mockAmContainer.getContainerLauncherIdentifier()).thenReturn((Object)0);
        Mockito.when((Object)mockAmContainer.getTaskCommunicatorIdentifier()).thenReturn((Object)0);
        ContainerId mockCId = (ContainerId)Mockito.mock(ContainerId.class);
        ((TaskScheduler)Mockito.verify((Object)this.mockTaskScheduler, (VerificationMode)Mockito.times((int)0))).deallocateContainer((ContainerId)Matchers.any());
        Mockito.when((Object)this.mockAMContainerMap.get(mockCId)).thenReturn((Object)mockAmContainer);
        this.schedulerHandler.preemptContainer(0, mockCId);
        ((TaskScheduler)Mockito.verify((Object)this.mockTaskScheduler, (VerificationMode)Mockito.times((int)1))).deallocateContainer(mockCId);
        Assert.assertEquals((long)1L, (long)this.mockEventHandler.events.size());
        Event event = this.mockEventHandler.events.get(0);
        Assert.assertEquals((Object)AMContainerEventType.C_COMPLETED, (Object)event.getType());
        AMContainerEventCompleted completedEvent = (AMContainerEventCompleted)event;
        Assert.assertEquals((Object)mockCId, (Object)completedEvent.getContainerId());
        Assert.assertEquals((Object)"Container preempted internally", (Object)completedEvent.getDiagnostics());
        Assert.assertTrue((boolean)completedEvent.isPreempted());
        Assert.assertFalse((boolean)completedEvent.isDiskFailed());
        Assert.assertEquals((Object)TaskAttemptTerminationCause.INTERNAL_PREEMPTION, (Object)completedEvent.getTerminationCause());
        this.schedulerHandler.stop();
        this.schedulerHandler.close();
    }

    @Test(timeout=5000L)
    public void testContainerDiskFailed() throws IOException {
        Configuration conf = new Configuration(false);
        this.schedulerHandler.init(conf);
        this.schedulerHandler.start();
        String diagnostics = "NM disk failed.";
        TaskAttemptImpl mockTask = (TaskAttemptImpl)Mockito.mock(TaskAttemptImpl.class);
        ContainerStatus mockStatus = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        ContainerId mockCId = (ContainerId)Mockito.mock(ContainerId.class);
        AMContainer mockAMContainer = (AMContainer)Mockito.mock(AMContainer.class);
        Mockito.when((Object)this.mockAMContainerMap.get(mockCId)).thenReturn((Object)mockAMContainer);
        Mockito.when((Object)mockAMContainer.getContainerId()).thenReturn((Object)mockCId);
        Mockito.when((Object)mockStatus.getContainerId()).thenReturn((Object)mockCId);
        Mockito.when((Object)mockStatus.getDiagnostics()).thenReturn((Object)diagnostics);
        Mockito.when((Object)mockStatus.getExitStatus()).thenReturn((Object)-101);
        this.schedulerHandler.containerCompleted(0, mockTask, mockStatus);
        Assert.assertEquals((long)1L, (long)this.mockEventHandler.events.size());
        Event event = this.mockEventHandler.events.get(0);
        Assert.assertEquals((Object)AMContainerEventType.C_COMPLETED, (Object)event.getType());
        AMContainerEventCompleted completedEvent = (AMContainerEventCompleted)event;
        Assert.assertEquals((Object)mockCId, (Object)completedEvent.getContainerId());
        Assert.assertEquals((Object)"Container disk failed. NM disk failed.", (Object)completedEvent.getDiagnostics());
        Assert.assertFalse((boolean)completedEvent.isPreempted());
        Assert.assertTrue((boolean)completedEvent.isDiskFailed());
        Assert.assertEquals((Object)TaskAttemptTerminationCause.NODE_DISK_ERROR, (Object)completedEvent.getTerminationCause());
        this.schedulerHandler.stop();
        this.schedulerHandler.close();
    }

    @Test(timeout=5000L)
    public void testContainerExceededPMem() throws IOException {
        Configuration conf = new Configuration(false);
        this.schedulerHandler.init(conf);
        this.schedulerHandler.start();
        String diagnostics = "Exceeded Physical Memory";
        TaskAttemptImpl mockTask = (TaskAttemptImpl)Mockito.mock(TaskAttemptImpl.class);
        ContainerStatus mockStatus = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        ContainerId mockCId = (ContainerId)Mockito.mock(ContainerId.class);
        AMContainer mockAMContainer = (AMContainer)Mockito.mock(AMContainer.class);
        Mockito.when((Object)this.mockAMContainerMap.get(mockCId)).thenReturn((Object)mockAMContainer);
        Mockito.when((Object)mockAMContainer.getContainerId()).thenReturn((Object)mockCId);
        Mockito.when((Object)mockStatus.getContainerId()).thenReturn((Object)mockCId);
        Mockito.when((Object)mockStatus.getDiagnostics()).thenReturn((Object)diagnostics);
        Mockito.when((Object)mockStatus.getExitStatus()).thenReturn((Object)-104);
        this.schedulerHandler.containerCompleted(0, mockTask, mockStatus);
        Assert.assertEquals((long)1L, (long)this.mockEventHandler.events.size());
        Event event = this.mockEventHandler.events.get(0);
        Assert.assertEquals((Object)AMContainerEventType.C_COMPLETED, (Object)event.getType());
        AMContainerEventCompleted completedEvent = (AMContainerEventCompleted)event;
        Assert.assertEquals((Object)mockCId, (Object)completedEvent.getContainerId());
        Assert.assertEquals((Object)"Container failed, exitCode=-104. Exceeded Physical Memory", (Object)completedEvent.getDiagnostics());
        Assert.assertFalse((boolean)completedEvent.isPreempted());
        Assert.assertFalse((boolean)completedEvent.isDiskFailed());
        Assert.assertEquals((Object)TaskAttemptTerminationCause.CONTAINER_EXITED, (Object)completedEvent.getTerminationCause());
        this.schedulerHandler.stop();
        this.schedulerHandler.close();
    }

    @Test(timeout=5000L)
    public void testHistoryUrlConf() throws Exception {
        Configuration conf = this.schedulerHandler.appContext.getAMConf();
        ApplicationId mockApplicationId = (ApplicationId)Mockito.mock(ApplicationId.class);
        ((ApplicationId)Mockito.doReturn((Object)"TEST_APP_ID").when((Object)mockApplicationId)).toString();
        ((AppContext)Mockito.doReturn((Object)mockApplicationId).when((Object)this.mockAppContext)).getApplicationID();
        conf.set("tez.tez-ui.history-url.base", "http://ui-host:9999");
        Assert.assertTrue((boolean)"http://ui-host:9999/#/tez-app/TEST_APP_ID".equals(this.schedulerHandler.getHistoryUrl()));
        conf.set("tez.tez-ui.history-url.base", "http://ui-host:9998/");
        Assert.assertTrue((boolean)"http://ui-host:9998/#/tez-app/TEST_APP_ID".equals(this.schedulerHandler.getHistoryUrl()));
        conf.set("tez.tez-ui.history-url.base", "ui-host:9998/");
        Assert.assertTrue((boolean)"http://ui-host:9998/#/tez-app/TEST_APP_ID".equals(this.schedulerHandler.getHistoryUrl()));
        conf.set("tez.am.tez-ui.history-url.template", "__HISTORY_URL_BASE__#/somepath");
        Assert.assertTrue((boolean)"http://ui-host:9998/#/somepath".equals(this.schedulerHandler.getHistoryUrl()));
        conf.set("tez.am.tez-ui.history-url.template", "__HISTORY_URL_BASE__?viewPath=tez-app/__APPLICATION_ID__");
        conf.set("tez.tez-ui.history-url.base", "http://localhost/ui/tez");
        Assert.assertTrue((boolean)"http://localhost/ui/tez?viewPath=tez-app/TEST_APP_ID".equals(this.schedulerHandler.getHistoryUrl()));
    }

    @Test(timeout=5000L)
    public void testNoSchedulerSpecified() throws IOException {
        try {
            new TSEHForMultipleSchedulersTest(this.mockAppContext, this.mockClientService, this.mockEventHandler, this.mockSigMatcher, this.mockWebUIService, null, false);
            Assert.fail((String)"Expecting an IllegalStateException with no schedulers specified");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(timeout=5000L)
    public void testCustomTaskSchedulerSetup() throws IOException {
        Configuration conf = new Configuration(false);
        conf.set("testkey", "testval");
        UserPayload defaultPayload = TezUtils.createUserPayloadFromConf((Configuration)conf);
        String customSchedulerName = "fakeScheduler";
        LinkedList<NamedEntityDescriptor> taskSchedulers = new LinkedList<NamedEntityDescriptor>();
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(0, 3);
        UserPayload userPayload = UserPayload.create((ByteBuffer)bb);
        taskSchedulers.add(new NamedEntityDescriptor(customSchedulerName, FakeTaskScheduler.class.getName()).setUserPayload(userPayload));
        taskSchedulers.add(new NamedEntityDescriptor(TezConstants.getTezYarnServicePluginName(), null).setUserPayload(defaultPayload));
        TSEHForMultipleSchedulersTest tseh = new TSEHForMultipleSchedulersTest(this.mockAppContext, this.mockClientService, this.mockEventHandler, this.mockSigMatcher, this.mockWebUIService, taskSchedulers, false);
        tseh.init(conf);
        tseh.start();
        Assert.assertTrue((boolean)tseh.getYarnSchedulerCreated());
        Assert.assertFalse((boolean)tseh.getUberSchedulerCreated());
        Assert.assertEquals((long)2L, (long)tseh.getNumCreateInvocations());
        Assert.assertEquals((Object)customSchedulerName, (Object)tseh.getTaskSchedulerName(0));
        Assert.assertEquals((Object)TezConstants.getTezYarnServicePluginName(), (Object)tseh.getTaskSchedulerName(1));
        Assert.assertNotNull((Object)tseh.getTaskSchedulerContext(0));
        Assert.assertEquals((Object)bb, (Object)tseh.getTaskSchedulerContext(0).getInitialUserPayload().getPayload());
        Assert.assertNotNull((Object)tseh.getTaskSchedulerContext(1));
        Configuration parsed = TezUtils.createConfFromUserPayload((UserPayload)tseh.getTaskSchedulerContext(1).getInitialUserPayload());
        Assert.assertEquals((Object)"testval", (Object)parsed.get("testkey"));
    }

    @Test(timeout=5000L)
    public void testTaskSchedulerRouting() throws Exception {
        Configuration conf = new Configuration(false);
        UserPayload defaultPayload = TezUtils.createUserPayloadFromConf((Configuration)conf);
        String customSchedulerName = "fakeScheduler";
        LinkedList<NamedEntityDescriptor> taskSchedulers = new LinkedList<NamedEntityDescriptor>();
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(0, 3);
        UserPayload userPayload = UserPayload.create((ByteBuffer)bb);
        taskSchedulers.add(new NamedEntityDescriptor(customSchedulerName, FakeTaskScheduler.class.getName()).setUserPayload(userPayload));
        taskSchedulers.add(new NamedEntityDescriptor(TezConstants.getTezYarnServicePluginName(), null).setUserPayload(defaultPayload));
        TSEHForMultipleSchedulersTest tseh = new TSEHForMultipleSchedulersTest(this.mockAppContext, this.mockClientService, this.mockEventHandler, this.mockSigMatcher, this.mockWebUIService, taskSchedulers, false);
        tseh.init(conf);
        tseh.start();
        Assert.assertTrue((boolean)tseh.getYarnSchedulerCreated());
        Assert.assertFalse((boolean)tseh.getUberSchedulerCreated());
        Assert.assertEquals((long)2L, (long)tseh.getNumCreateInvocations());
        Assert.assertEquals((Object)customSchedulerName, (Object)tseh.getTaskSchedulerName(0));
        Assert.assertEquals((Object)TezConstants.getTezYarnServicePluginName(), (Object)tseh.getTaskSchedulerName(1));
        ((TaskScheduler)Mockito.verify((Object)tseh.getTestTaskScheduler(0))).initialize();
        ((TaskScheduler)Mockito.verify((Object)tseh.getTestTaskScheduler(0))).start();
        ApplicationId appId = ApplicationId.newInstance((long)1000L, (int)1);
        TezDAGID dagId = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagId, (int)1);
        TezTaskID taskId1 = TezTaskID.getInstance((TezVertexID)vertexID, (int)1);
        TezTaskAttemptID attemptId11 = TezTaskAttemptID.getInstance((TezTaskID)taskId1, (int)1);
        TezTaskID taskId2 = TezTaskID.getInstance((TezVertexID)vertexID, (int)2);
        TezTaskAttemptID attemptId21 = TezTaskAttemptID.getInstance((TezTaskID)taskId2, (int)1);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        TaskAttempt mockTaskAttempt1 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        TaskAttempt mockTaskAttempt2 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        AMSchedulerEventTALaunchRequest launchRequest1 = new AMSchedulerEventTALaunchRequest(attemptId11, resource, (TaskSpec)Mockito.mock(TaskSpec.class), mockTaskAttempt1, (TaskLocationHint)Mockito.mock(TaskLocationHint.class), 1, (ContainerContext)Mockito.mock(ContainerContext.class), 0, 0, 0);
        tseh.handle((AMSchedulerEvent)launchRequest1);
        ((TaskScheduler)Mockito.verify((Object)tseh.getTestTaskScheduler(0))).allocateTask(Matchers.eq((Object)mockTaskAttempt1), (Resource)Matchers.eq((Object)resource), (String[])Matchers.any(String[].class), (String[])Matchers.any(String[].class), (Priority)Matchers.any(Priority.class), Matchers.any(Object.class), Matchers.eq((Object)launchRequest1));
        AMSchedulerEventTALaunchRequest launchRequest2 = new AMSchedulerEventTALaunchRequest(attemptId21, resource, (TaskSpec)Mockito.mock(TaskSpec.class), mockTaskAttempt2, (TaskLocationHint)Mockito.mock(TaskLocationHint.class), 1, (ContainerContext)Mockito.mock(ContainerContext.class), 1, 0, 0);
        tseh.handle((AMSchedulerEvent)launchRequest2);
        ((TaskScheduler)Mockito.verify((Object)tseh.getTestTaskScheduler(1))).allocateTask(Matchers.eq((Object)mockTaskAttempt2), (Resource)Matchers.eq((Object)resource), (String[])Matchers.any(String[].class), (String[])Matchers.any(String[].class), (Priority)Matchers.any(Priority.class), Matchers.any(Object.class), Matchers.eq((Object)launchRequest2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testReportFailureFromTaskScheduler() {
        String dagName = DAG_NAME;
        TezConfiguration conf = new TezConfiguration();
        String taskSchedulerName = "testTaskScheduler";
        String expIdentifier = "[0:" + taskSchedulerName + "]";
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        ((AppContext)Mockito.doReturn((Object)taskSchedulerName).when((Object)appContext)).getTaskSchedulerName(0);
        ((AppContext)Mockito.doReturn((Object)eventHandler).when((Object)appContext)).getEventHandler();
        ((AppContext)Mockito.doReturn((Object)conf).when((Object)appContext)).getAMConf();
        InetSocketAddress address = new InetSocketAddress("host", 55000);
        DAGClientServer dagClientServer = (DAGClientServer)Mockito.mock(DAGClientServer.class);
        ((DAGClientServer)Mockito.doReturn((Object)address).when((Object)dagClientServer)).getBindAddress();
        DAG dag = (DAG)Mockito.mock(DAG.class);
        TezDAGID dagId = TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)0), (int)1);
        ((DAG)Mockito.doReturn((Object)dagName).when((Object)dag)).getName();
        ((DAG)Mockito.doReturn((Object)dagId).when((Object)dag)).getID();
        ((AppContext)Mockito.doReturn((Object)dag).when((Object)appContext)).getCurrentDAG();
        NamedEntityDescriptor namedEntityDescriptor = new NamedEntityDescriptor(taskSchedulerName, TaskSchedulerForFailureTest.class.getName());
        LinkedList<NamedEntityDescriptor> list = new LinkedList<NamedEntityDescriptor>();
        list.add(namedEntityDescriptor);
        TaskSchedulerManager taskSchedulerManager = new TaskSchedulerManager(appContext, dagClientServer, eventHandler, (ContainerSignatureMatcher)Mockito.mock(ContainerSignatureMatcher.class), (WebUIService)Mockito.mock(WebUIService.class), list, false){

            TaskSchedulerContext wrapTaskSchedulerContext(TaskSchedulerContext rawContext) {
                return rawContext;
            }
        };
        try {
            taskSchedulerManager.init((Configuration)new TezConfiguration());
            taskSchedulerManager.start();
            taskSchedulerManager.getTotalResources(0);
            ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(Event.class);
            ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)1))).handle((Event)argumentCaptor.capture());
            Event rawEvent = (Event)argumentCaptor.getValue();
            Assert.assertTrue((boolean)(rawEvent instanceof DAGEventTerminateDag));
            DAGEventTerminateDag killEvent = (DAGEventTerminateDag)rawEvent;
            Assert.assertTrue((boolean)killEvent.getDiagnosticInfo().contains("ReportError"));
            Assert.assertTrue((boolean)killEvent.getDiagnosticInfo().contains(ServicePluginErrorDefaults.SERVICE_UNAVAILABLE.name()));
            Assert.assertTrue((boolean)killEvent.getDiagnosticInfo().contains(expIdentifier));
            Mockito.reset((Object[])new EventHandler[]{eventHandler});
            taskSchedulerManager.getAvailableResources(0);
            argumentCaptor = ArgumentCaptor.forClass(Event.class);
            ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)1))).handle((Event)argumentCaptor.capture());
            rawEvent = (Event)argumentCaptor.getValue();
            Assert.assertTrue((boolean)(rawEvent instanceof DAGAppMasterEventUserServiceFatalError));
            DAGAppMasterEventUserServiceFatalError event = (DAGAppMasterEventUserServiceFatalError)rawEvent;
            Assert.assertEquals((Object)DAGAppMasterEventType.TASK_SCHEDULER_SERVICE_FATAL_ERROR, (Object)event.getType());
            Assert.assertTrue((boolean)event.getDiagnosticInfo().contains("ReportedFatalError"));
            Assert.assertTrue((boolean)event.getDiagnosticInfo().contains(ServicePluginErrorDefaults.INCONSISTENT_STATE.name()));
            Assert.assertTrue((boolean)event.getDiagnosticInfo().contains(expIdentifier));
        }
        finally {
            taskSchedulerManager.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testTaskSchedulerUserError() {
        TaskScheduler taskScheduler = (TaskScheduler)Mockito.mock(TaskScheduler.class, (Answer)new ExceptionAnswer());
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)appContext.getEventHandler()).thenReturn((Object)eventHandler);
        ((AppContext)Mockito.doReturn((Object)"testTaskScheduler").when((Object)appContext)).getTaskSchedulerName(0);
        String expectedId = "[0:testTaskScheduler]";
        Configuration conf = new Configuration(false);
        InetSocketAddress address = new InetSocketAddress(15222);
        DAGClientServer mockClientService = (DAGClientServer)Mockito.mock(DAGClientServer.class);
        ((DAGClientServer)Mockito.doReturn((Object)address).when((Object)mockClientService)).getBindAddress();
        TaskSchedulerManager taskSchedulerManager = new TaskSchedulerManager(taskScheduler, appContext, (ContainerSignatureMatcher)Mockito.mock(ContainerSignatureMatcher.class), mockClientService, Executors.newFixedThreadPool(1)){

            protected void instantiateSchedulers(String host, int port, String trackingUrl, AppContext appContext) throws TezException {
            }
        };
        try {
            taskSchedulerManager.init(conf);
            taskSchedulerManager.start();
            AMSchedulerEventTALaunchRequest launchRequest = new AMSchedulerEventTALaunchRequest((TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class), (Resource)Mockito.mock(Resource.class), (TaskSpec)Mockito.mock(TaskSpec.class), (TaskAttempt)Mockito.mock(TaskAttempt.class), (TaskLocationHint)Mockito.mock(TaskLocationHint.class), 0, (ContainerContext)Mockito.mock(ContainerContext.class), 0, 0, 0);
            taskSchedulerManager.handleEvent((AMSchedulerEvent)launchRequest);
            ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(Event.class);
            ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)1))).handle((Event)argumentCaptor.capture());
            Event rawEvent = (Event)argumentCaptor.getValue();
            Assert.assertTrue((boolean)(rawEvent instanceof DAGAppMasterEventUserServiceFatalError));
            DAGAppMasterEventUserServiceFatalError event = (DAGAppMasterEventUserServiceFatalError)rawEvent;
            Assert.assertEquals((Object)DAGAppMasterEventType.TASK_SCHEDULER_SERVICE_FATAL_ERROR, (Object)event.getType());
            Assert.assertTrue((boolean)event.getError().getMessage().contains("TestException_allocateTask"));
            Assert.assertTrue((boolean)event.getDiagnosticInfo().contains("Task Allocation"));
            Assert.assertTrue((boolean)event.getDiagnosticInfo().contains(expectedId));
            taskSchedulerManager.dagCompleted();
            argumentCaptor = ArgumentCaptor.forClass(Event.class);
            ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)2))).handle((Event)argumentCaptor.capture());
            rawEvent = (Event)argumentCaptor.getAllValues().get(1);
            Assert.assertTrue((boolean)(rawEvent instanceof DAGAppMasterEventUserServiceFatalError));
            event = (DAGAppMasterEventUserServiceFatalError)rawEvent;
            Assert.assertEquals((Object)DAGAppMasterEventType.TASK_SCHEDULER_SERVICE_FATAL_ERROR, (Object)event.getType());
            Assert.assertTrue((boolean)event.getError().getMessage().contains("TestException_dagComplete"));
            Assert.assertTrue((boolean)event.getDiagnosticInfo().contains("Dag Completion"));
            Assert.assertTrue((boolean)event.getDiagnosticInfo().contains(expectedId));
        }
        finally {
            taskSchedulerManager.stop();
        }
    }

    public static class TaskSchedulerForFailureTest
    extends TaskScheduler {
        public TaskSchedulerForFailureTest(TaskSchedulerContext taskSchedulerContext) {
            super(taskSchedulerContext);
        }

        public Resource getAvailableResources() throws ServicePluginException {
            this.getContext().reportError((ServicePluginError)ServicePluginErrorDefaults.INCONSISTENT_STATE, "ReportedFatalError", null);
            return Resource.newInstance((int)1024, (int)1);
        }

        public Resource getTotalResources() throws ServicePluginException {
            this.getContext().reportError((ServicePluginError)ServicePluginErrorDefaults.SERVICE_UNAVAILABLE, "ReportError", (DagInfo)new DagInfoImplForTest(1, TestTaskSchedulerManager.DAG_NAME));
            return Resource.newInstance((int)1024, (int)1);
        }

        public int getClusterNodeCount() throws ServicePluginException {
            return 0;
        }

        public void blacklistNode(NodeId nodeId) throws ServicePluginException {
        }

        public void unblacklistNode(NodeId nodeId) throws ServicePluginException {
        }

        public void allocateTask(Object task, Resource capability, String[] hosts, String[] racks, Priority priority, Object containerSignature, Object clientCookie) throws ServicePluginException {
        }

        public void allocateTask(Object task, Resource capability, ContainerId containerId, Priority priority, Object containerSignature, Object clientCookie) throws ServicePluginException {
        }

        public boolean deallocateTask(Object task, boolean taskSucceeded, TaskAttemptEndReason endReason, @Nullable String diagnostics) throws ServicePluginException {
            return false;
        }

        public Object deallocateContainer(ContainerId containerId) throws ServicePluginException {
            return null;
        }

        public void setShouldUnregister() throws ServicePluginException {
        }

        public boolean hasUnregistered() throws ServicePluginException {
            return false;
        }

        public void dagComplete() throws ServicePluginException {
        }
    }

    public static class FakeTaskScheduler
    extends TaskScheduler {
        public FakeTaskScheduler(TaskSchedulerContext taskSchedulerContext) {
            super(taskSchedulerContext);
        }

        public Resource getAvailableResources() {
            return null;
        }

        public int getClusterNodeCount() {
            return 0;
        }

        public void dagComplete() {
        }

        public Resource getTotalResources() {
            return null;
        }

        public void blacklistNode(NodeId nodeId) {
        }

        public void unblacklistNode(NodeId nodeId) {
        }

        public void allocateTask(Object task, Resource capability, String[] hosts, String[] racks, Priority priority, Object containerSignature, Object clientCookie) {
        }

        public void allocateTask(Object task, Resource capability, ContainerId containerId, Priority priority, Object containerSignature, Object clientCookie) {
        }

        public boolean deallocateTask(Object task, boolean taskSucceeded, TaskAttemptEndReason endReason, String diagnostics) {
            return false;
        }

        public Object deallocateContainer(ContainerId containerId) {
            return null;
        }

        public void setShouldUnregister() {
        }

        public boolean hasUnregistered() {
            return false;
        }
    }

    public static class TSEHForMultipleSchedulersTest
    extends TaskSchedulerManager {
        private final TaskScheduler yarnTaskScheduler;
        private final TaskScheduler uberTaskScheduler;
        private final AtomicBoolean uberSchedulerCreated = new AtomicBoolean(false);
        private final AtomicBoolean yarnSchedulerCreated = new AtomicBoolean(false);
        private final AtomicInteger numCreateInvocations = new AtomicInteger(0);
        private final Set<Integer> seenSchedulers = new HashSet<Integer>();
        private final List<TaskSchedulerContext> taskSchedulerContexts = new LinkedList<TaskSchedulerContext>();
        private final List<String> taskSchedulerNames = new LinkedList<String>();
        private final List<TaskScheduler> testTaskSchedulers = new LinkedList<TaskScheduler>();

        public TSEHForMultipleSchedulersTest(AppContext appContext, DAGClientServer clientService, EventHandler eventHandler, ContainerSignatureMatcher containerSignatureMatcher, WebUIService webUI, List<NamedEntityDescriptor> schedulerDescriptors, boolean isPureLocalMode) {
            super(appContext, clientService, eventHandler, containerSignatureMatcher, webUI, schedulerDescriptors, isPureLocalMode);
            this.yarnTaskScheduler = (TaskScheduler)Mockito.mock(TaskScheduler.class);
            this.uberTaskScheduler = (TaskScheduler)Mockito.mock(TaskScheduler.class);
        }

        TaskScheduler createTaskScheduler(String host, int port, String trackingUrl, AppContext appContext, NamedEntityDescriptor taskSchedulerDescriptor, long customAppIdIdentifier, int schedulerId) throws TezException {
            this.numCreateInvocations.incrementAndGet();
            boolean added = this.seenSchedulers.add(schedulerId);
            Assert.assertTrue((String)"Cannot add multiple schedulers with the same schedulerId", (boolean)added);
            this.taskSchedulerNames.add(taskSchedulerDescriptor.getEntityName());
            return super.createTaskScheduler(host, port, trackingUrl, appContext, taskSchedulerDescriptor, customAppIdIdentifier, schedulerId);
        }

        TaskSchedulerContext wrapTaskSchedulerContext(TaskSchedulerContext rawContext) {
            return rawContext;
        }

        TaskScheduler createYarnTaskScheduler(TaskSchedulerContext taskSchedulerContext, int schedulerId) {
            this.taskSchedulerContexts.add(taskSchedulerContext);
            this.testTaskSchedulers.add(this.yarnTaskScheduler);
            this.yarnSchedulerCreated.set(true);
            return this.yarnTaskScheduler;
        }

        TaskScheduler createUberTaskScheduler(TaskSchedulerContext taskSchedulerContext, int schedulerId) {
            this.taskSchedulerContexts.add(taskSchedulerContext);
            this.uberSchedulerCreated.set(true);
            this.testTaskSchedulers.add(this.yarnTaskScheduler);
            return this.uberTaskScheduler;
        }

        TaskScheduler createCustomTaskScheduler(TaskSchedulerContext taskSchedulerContext, NamedEntityDescriptor taskSchedulerDescriptor, int schedulerId) throws TezException {
            this.taskSchedulerContexts.add(taskSchedulerContext);
            TaskScheduler taskScheduler = (TaskScheduler)Mockito.spy((Object)super.createCustomTaskScheduler(taskSchedulerContext, taskSchedulerDescriptor, schedulerId));
            this.testTaskSchedulers.add(taskScheduler);
            return taskScheduler;
        }

        public void handle(AMSchedulerEvent event) {
            this.handleEvent(event);
        }

        public boolean getUberSchedulerCreated() {
            return this.uberSchedulerCreated.get();
        }

        public boolean getYarnSchedulerCreated() {
            return this.yarnSchedulerCreated.get();
        }

        public int getNumCreateInvocations() {
            return this.numCreateInvocations.get();
        }

        public TaskSchedulerContext getTaskSchedulerContext(int schedulerId) {
            return this.taskSchedulerContexts.get(schedulerId);
        }

        public String getTaskSchedulerName(int schedulerId) {
            return this.taskSchedulerNames.get(schedulerId);
        }

        public TaskScheduler getTestTaskScheduler(int schedulerId) {
            return this.testTaskSchedulers.get(schedulerId);
        }
    }

    private static class ExceptionAnswer
    implements Answer {
        private ExceptionAnswer() {
        }

        public Object answer(InvocationOnMock invocation) throws Throwable {
            Method method = invocation.getMethod();
            if (!(!method.getDeclaringClass().equals(TaskScheduler.class) || method.getName().equals("getContext") || method.getName().equals("initialize") || method.getName().equals("start") || method.getName().equals("shutdown"))) {
                throw new RuntimeException("TestException_" + method.getName());
            }
            return invocation.callRealMethod();
        }
    }

    class MockTaskSchedulerManager
    extends TaskSchedulerManager {
        final AtomicBoolean notify;

        public MockTaskSchedulerManager(AppContext appContext, DAGClientServer clientService, EventHandler eventHandler, ContainerSignatureMatcher containerSignatureMatcher, WebUIService webUI) {
            super(appContext, clientService, eventHandler, containerSignatureMatcher, webUI, (List)Lists.newArrayList((Object[])new NamedEntityDescriptor[]{new NamedEntityDescriptor("FakeDescriptor", null)}), false);
            this.notify = new AtomicBoolean(false);
        }

        protected void instantiateSchedulers(String host, int port, String trackingUrl, AppContext appContext) {
            this.taskSchedulers[0] = new TaskSchedulerWrapper(TestTaskSchedulerManager.this.mockTaskScheduler);
            this.taskSchedulerServiceWrappers[0] = new ServicePluginLifecycleAbstractService((ServicePluginLifecycle)this.taskSchedulers[0].getTaskScheduler());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void notifyForTest() {
            AtomicBoolean atomicBoolean = this.notify;
            synchronized (atomicBoolean) {
                this.notify.set(true);
                this.notify.notifyAll();
            }
        }
    }

    class TestEventHandler
    implements EventHandler {
        List<Event> events = Lists.newLinkedList();

        TestEventHandler() {
        }

        public void handle(Event event) {
            this.events.add(event);
        }
    }
}

