/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.common.ContainerSignatureMatcher;
import org.apache.tez.common.MockDNSToSwitchMapping;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TaskLocationHint;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ClusterInfo;
import org.apache.tez.dag.app.ContainerContext;
import org.apache.tez.dag.app.ContainerHeartbeatHandler;
import org.apache.tez.dag.app.DAGAppMasterState;
import org.apache.tez.dag.app.TaskCommunicatorManagerInterface;
import org.apache.tez.dag.app.dag.TaskAttempt;
import org.apache.tez.dag.app.rm.AMSchedulerEvent;
import org.apache.tez.dag.app.rm.AMSchedulerEventTAEnded;
import org.apache.tez.dag.app.rm.AMSchedulerEventTALaunchRequest;
import org.apache.tez.dag.app.rm.TaskSchedulerManager;
import org.apache.tez.dag.app.rm.TestTaskSchedulerHelpers;
import org.apache.tez.dag.app.rm.TezAMRMClientAsync;
import org.apache.tez.dag.app.rm.YarnTaskSchedulerService;
import org.apache.tez.dag.app.rm.container.AMContainerEventAssignTA;
import org.apache.tez.dag.app.rm.container.AMContainerEventStopRequest;
import org.apache.tez.dag.app.rm.container.AMContainerMap;
import org.apache.tez.dag.app.rm.container.ContainerContextMatcher;
import org.apache.tez.dag.app.rm.node.AMNodeTracker;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.dag.utils.TaskSpecificLaunchCmdOption;
import org.apache.tez.runtime.api.impl.InputSpec;
import org.apache.tez.runtime.api.impl.OutputSpec;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.apache.tez.serviceplugins.api.TaskAttemptEndReason;
import org.apache.tez.serviceplugins.api.TaskScheduler;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestContainerReuse {
    private static final Logger LOG = LoggerFactory.getLogger(TestContainerReuse.class);

    @BeforeClass
    public static void setup() {
        MockDNSToSwitchMapping.initializeMockRackResolver();
    }

    @Test(timeout=15000L)
    public void testDelayedReuseContainerBecomesAvailable() throws IOException, InterruptedException, ExecutionException {
        AtomicBoolean drainNotifier;
        LOG.info("Test testDelayedReuseContainerBecomesAvailable");
        Configuration conf = new Configuration((Configuration)new YarnConfiguration());
        conf.setBoolean("tez.am.container.reuse.enabled", true);
        conf.setBoolean("tez.am.container.reuse.rack-fallback.enabled", false);
        conf.setBoolean("tez.am.container.reuse.non-local-fallback.enabled", false);
        conf.setLong("tez.am.container.reuse.locality.delay-allocation-millis", 3000L);
        conf.setLong("tez.am.container.idle.release-timeout-min.millis", 0L);
        conf.setLong("tez.am.container.idle.release-timeout-max.millis", 0L);
        TestTaskSchedulerHelpers.CapturingEventHandler eventHandler = new TestTaskSchedulerHelpers.CapturingEventHandler();
        TezDAGID dagID = TezDAGID.getInstance((String)"0", (int)0, (int)0);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TestTaskSchedulerHelpers.AMRMClientForTest rmClientCore = new TestTaskSchedulerHelpers.AMRMClientForTest();
        TezAMRMClientAsync rmClient = (TezAMRMClientAsync)Mockito.spy((Object)((Object)new TestTaskSchedulerHelpers.AMRMClientAsyncForTest((AMRMClient<YarnTaskSchedulerService.CookieContainerRequest>)rmClientCore, 100)));
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        ((AppContext)Mockito.doReturn((Object)conf).when((Object)appContext)).getAMConf();
        AMContainerMap amContainerMap = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), appContext);
        AMNodeTracker amNodeTracker = new AMNodeTracker((EventHandler)eventHandler, appContext);
        ((AppContext)Mockito.doReturn((Object)amContainerMap).when((Object)appContext)).getAllContainers();
        ((AppContext)Mockito.doReturn((Object)DAGAppMasterState.RUNNING).when((Object)appContext)).getAMState();
        ((AppContext)Mockito.doReturn((Object)amNodeTracker).when((Object)appContext)).getNodeTracker();
        ((AppContext)Mockito.doReturn((Object)dagID).when((Object)appContext)).getCurrentDAGID();
        ((AppContext)Mockito.doReturn((Object)Mockito.mock(ClusterInfo.class)).when((Object)appContext)).getClusterInfo();
        TestTaskSchedulerHelpers.TaskSchedulerManagerForTest taskSchedulerManagerReal = new TestTaskSchedulerHelpers.TaskSchedulerManagerForTest(appContext, eventHandler, (TezAMRMClientAsync<YarnTaskSchedulerService.CookieContainerRequest>)rmClient, new TestTaskSchedulerHelpers.AlwaysMatchesContainerMatcher(), TezUtils.createUserPayloadFromConf((Configuration)conf));
        TaskSchedulerManager taskSchedulerManager = (TaskSchedulerManager)Mockito.spy((Object)((Object)taskSchedulerManagerReal));
        taskSchedulerManager.init(conf);
        taskSchedulerManager.start();
        TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext taskScheduler = (TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext)((TestTaskSchedulerHelpers.TaskSchedulerManagerForTest)taskSchedulerManager).getSpyTaskScheduler();
        TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback = taskScheduler.getDrainableAppCallback();
        taskScheduler.delayedContainerManager.drainedDelayedContainersForTest = drainNotifier = new AtomicBoolean(false);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        Priority priority = Priority.newInstance((int)5);
        String[] host1 = new String[]{"host1"};
        String[] host2 = new String[]{"host2"};
        String[] defaultRack = new String[]{"/default-rack"};
        TezTaskAttemptID taID11 = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexID, (int)1), (int)1);
        TezTaskAttemptID taID21 = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexID, (int)2), (int)1);
        TezTaskAttemptID taID31 = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexID, (int)3), (int)1);
        TaskAttempt ta11 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        TaskAttempt ta21 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        TaskAttempt ta31 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        AMSchedulerEventTALaunchRequest lrTa11 = this.createLaunchRequestEvent(taID11, ta11, resource, host1, defaultRack, priority);
        AMSchedulerEventTALaunchRequest lrTa21 = this.createLaunchRequestEvent(taID21, ta21, resource, host2, defaultRack, priority);
        AMSchedulerEventTALaunchRequest lrTa31 = this.createLaunchRequestEvent(taID31, ta31, resource, host1, defaultRack, priority);
        drainNotifier.set(false);
        taskSchedulerManager.handleEvent((AMSchedulerEvent)lrTa11);
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        drainNotifier.set(false);
        taskSchedulerManager.handleEvent((AMSchedulerEvent)lrTa21);
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        Container containerHost1 = this.createContainer(1, host1[0], resource, priority);
        Container containerHost2 = this.createContainer(2, host2[0], resource, priority);
        drainNotifier.set(false);
        taskScheduler.onContainersAllocated(Lists.newArrayList((Object[])new Container[]{containerHost1, containerHost2}));
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        drainableAppCallback.drain();
        ((TaskSchedulerManager)Mockito.verify((Object)taskSchedulerManager)).taskAllocated(Matchers.eq((int)0), Matchers.eq((Object)ta11), Matchers.any(Object.class), (Container)Matchers.eq((Object)containerHost1));
        ((TaskSchedulerManager)Mockito.verify((Object)taskSchedulerManager)).taskAllocated(Matchers.eq((int)0), Matchers.eq((Object)ta21), Matchers.any(Object.class), (Container)Matchers.eq((Object)containerHost2));
        taskSchedulerManager.handleEvent((AMSchedulerEvent)lrTa31);
        taskSchedulerManager.handleEvent((AMSchedulerEvent)new AMSchedulerEventTAEnded(ta11, containerHost1.getId(), TaskAttemptState.SUCCEEDED, null, null, 0));
        drainableAppCallback.drain();
        this.verifyDeAllocateTask((TaskScheduler)taskScheduler, ta11, true, null, null);
        ((TaskSchedulerManager)Mockito.verify((Object)taskSchedulerManager, (VerificationMode)Mockito.times((int)1))).taskAllocated(Matchers.eq((int)0), Matchers.eq((Object)ta31), Matchers.any(Object.class), (Container)Matchers.eq((Object)containerHost1));
        ((TezAMRMClientAsync)Mockito.verify((Object)rmClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Matchers.eq((Object)containerHost1.getId()));
        eventHandler.verifyNoInvocations(AMContainerEventStopRequest.class);
        eventHandler.reset();
        taskSchedulerManager.handleEvent((AMSchedulerEvent)new AMSchedulerEventTAEnded(ta21, containerHost2.getId(), TaskAttemptState.SUCCEEDED, null, null, 0));
        long currentTs = System.currentTimeMillis();
        Throwable exception = null;
        while (System.currentTimeMillis() < currentTs + 5000L) {
            try {
                ((TaskSchedulerManager)Mockito.verify((Object)taskSchedulerManager, (VerificationMode)Mockito.times((int)1))).containerBeingReleased(Matchers.eq((int)0), (ContainerId)Matchers.eq((Object)containerHost2.getId()));
                exception = null;
                break;
            }
            catch (Throwable e) {
                exception = e;
            }
        }
        Assert.assertTrue((String)"containerHost2 was not released", (exception == null ? 1 : 0) != 0);
        taskScheduler.shutdown();
        taskSchedulerManager.close();
    }

    @Test(timeout=15000L)
    public void testDelayedReuseContainerNotAvailable() throws IOException, InterruptedException, ExecutionException {
        AtomicBoolean drainNotifier;
        LOG.info("Test testDelayedReuseContainerNotAvailable");
        Configuration conf = new Configuration((Configuration)new YarnConfiguration());
        conf.setBoolean("tez.am.container.reuse.enabled", true);
        conf.setBoolean("tez.am.container.reuse.rack-fallback.enabled", false);
        conf.setBoolean("tez.am.container.reuse.non-local-fallback.enabled", false);
        conf.setLong("tez.am.container.reuse.locality.delay-allocation-millis", 1000L);
        conf.setLong("tez.am.container.idle.release-timeout-min.millis", 0L);
        conf.setLong("tez.am.container.idle.release-timeout-max.millis", 0L);
        TestTaskSchedulerHelpers.CapturingEventHandler eventHandler = new TestTaskSchedulerHelpers.CapturingEventHandler();
        TezDAGID dagID = TezDAGID.getInstance((String)"0", (int)0, (int)0);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TestTaskSchedulerHelpers.AMRMClientForTest rmClientCore = new TestTaskSchedulerHelpers.AMRMClientForTest();
        TezAMRMClientAsync rmClient = (TezAMRMClientAsync)Mockito.spy((Object)((Object)new TestTaskSchedulerHelpers.AMRMClientAsyncForTest((AMRMClient<YarnTaskSchedulerService.CookieContainerRequest>)rmClientCore, 100)));
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        ((AppContext)Mockito.doReturn((Object)new Configuration(false)).when((Object)appContext)).getAMConf();
        AMContainerMap amContainerMap = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), appContext);
        AMNodeTracker amNodeTracker = new AMNodeTracker((EventHandler)eventHandler, appContext);
        ((AppContext)Mockito.doReturn((Object)amContainerMap).when((Object)appContext)).getAllContainers();
        ((AppContext)Mockito.doReturn((Object)amNodeTracker).when((Object)appContext)).getNodeTracker();
        ((AppContext)Mockito.doReturn((Object)DAGAppMasterState.RUNNING).when((Object)appContext)).getAMState();
        ((AppContext)Mockito.doReturn((Object)dagID).when((Object)appContext)).getCurrentDAGID();
        ((AppContext)Mockito.doReturn((Object)Mockito.mock(ClusterInfo.class)).when((Object)appContext)).getClusterInfo();
        TestTaskSchedulerHelpers.TaskSchedulerManagerForTest taskSchedulerManagerReal = new TestTaskSchedulerHelpers.TaskSchedulerManagerForTest(appContext, eventHandler, (TezAMRMClientAsync<YarnTaskSchedulerService.CookieContainerRequest>)rmClient, new TestTaskSchedulerHelpers.AlwaysMatchesContainerMatcher(), TezUtils.createUserPayloadFromConf((Configuration)conf));
        TaskSchedulerManager taskSchedulerManager = (TaskSchedulerManager)Mockito.spy((Object)((Object)taskSchedulerManagerReal));
        taskSchedulerManager.init(conf);
        taskSchedulerManager.start();
        TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext taskScheduler = (TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext)((TestTaskSchedulerHelpers.TaskSchedulerManagerForTest)taskSchedulerManager).getSpyTaskScheduler();
        TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback = taskScheduler.getDrainableAppCallback();
        taskScheduler.delayedContainerManager.drainedDelayedContainersForTest = drainNotifier = new AtomicBoolean(false);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        Priority priority = Priority.newInstance((int)5);
        String[] host1 = new String[]{"host1"};
        String[] host2 = new String[]{"host2"};
        String[] defaultRack = new String[]{"/default-rack"};
        TezTaskAttemptID taID11 = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexID, (int)1), (int)1);
        TezTaskAttemptID taID21 = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexID, (int)2), (int)1);
        TezTaskAttemptID taID31 = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexID, (int)3), (int)1);
        TaskAttempt ta11 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        TaskAttempt ta21 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        TaskAttempt ta31 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        AMSchedulerEventTALaunchRequest lrTa11 = this.createLaunchRequestEvent(taID11, ta11, resource, host1, defaultRack, priority);
        AMSchedulerEventTALaunchRequest lrTa21 = this.createLaunchRequestEvent(taID21, ta21, resource, host2, defaultRack, priority);
        AMSchedulerEventTALaunchRequest lrTa31 = this.createLaunchRequestEvent(taID31, ta31, resource, host1, defaultRack, priority);
        drainNotifier.set(false);
        taskSchedulerManager.handleEvent((AMSchedulerEvent)lrTa11);
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        drainNotifier.set(false);
        taskSchedulerManager.handleEvent((AMSchedulerEvent)lrTa21);
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        Container containerHost1 = this.createContainer(1, host1[0], resource, priority);
        Container containerHost2 = this.createContainer(2, host2[0], resource, priority);
        drainNotifier.set(false);
        taskScheduler.onContainersAllocated(Lists.newArrayList((Object[])new Container[]{containerHost1, containerHost2}));
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        drainableAppCallback.drain();
        ((TaskSchedulerManager)Mockito.verify((Object)taskSchedulerManager)).taskAllocated(Matchers.eq((int)0), Matchers.eq((Object)ta11), Matchers.any(Object.class), (Container)Matchers.eq((Object)containerHost1));
        ((TaskSchedulerManager)Mockito.verify((Object)taskSchedulerManager)).taskAllocated(Matchers.eq((int)0), Matchers.eq((Object)ta21), Matchers.any(Object.class), (Container)Matchers.eq((Object)containerHost2));
        taskSchedulerManager.handleEvent((AMSchedulerEvent)lrTa31);
        taskSchedulerManager.handleEvent((AMSchedulerEvent)new AMSchedulerEventTAEnded(ta21, containerHost2.getId(), TaskAttemptState.SUCCEEDED, null, null, 0));
        drainableAppCallback.drain();
        this.verifyDeAllocateTask((TaskScheduler)taskScheduler, ta21, true, null, null);
        ((TaskSchedulerManager)Mockito.verify((Object)taskSchedulerManager, (VerificationMode)Mockito.times((int)0))).taskAllocated(Matchers.eq((int)0), Matchers.eq((Object)ta31), Matchers.any(Object.class), (Container)Matchers.eq((Object)containerHost2));
        ((TezAMRMClientAsync)Mockito.verify((Object)rmClient, (VerificationMode)Mockito.times((int)1))).releaseAssignedContainer((ContainerId)Matchers.eq((Object)containerHost2.getId()));
        eventHandler.verifyInvocation(AMContainerEventStopRequest.class);
        taskScheduler.shutdown();
        taskSchedulerManager.close();
    }

    @Test(timeout=10000L)
    public void testSimpleReuse() throws IOException, InterruptedException, ExecutionException {
        AtomicBoolean drainNotifier;
        LOG.info("Test testSimpleReuse");
        Configuration tezConf = new Configuration((Configuration)new YarnConfiguration());
        tezConf.setBoolean("tez.am.container.reuse.enabled", true);
        tezConf.setBoolean("tez.am.container.reuse.rack-fallback.enabled", true);
        tezConf.setLong("tez.am.container.reuse.locality.delay-allocation-millis", 0L);
        tezConf.setLong("tez.am.container.idle.release-timeout-min.millis", 0L);
        tezConf.setLong("tez.am.container.idle.release-timeout-max.millis", 0L);
        TestTaskSchedulerHelpers.CapturingEventHandler eventHandler = new TestTaskSchedulerHelpers.CapturingEventHandler();
        TezDAGID dagID = TezDAGID.getInstance((String)"0", (int)0, (int)0);
        TestTaskSchedulerHelpers.AMRMClientForTest rmClientCore = new TestTaskSchedulerHelpers.AMRMClientForTest();
        TezAMRMClientAsync rmClient = (TezAMRMClientAsync)Mockito.spy((Object)((Object)new TestTaskSchedulerHelpers.AMRMClientAsyncForTest((AMRMClient<YarnTaskSchedulerService.CookieContainerRequest>)rmClientCore, 100)));
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        ((AppContext)Mockito.doReturn((Object)new Configuration(false)).when((Object)appContext)).getAMConf();
        AMContainerMap amContainerMap = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), appContext);
        AMNodeTracker amNodeTracker = new AMNodeTracker((EventHandler)eventHandler, appContext);
        ((AppContext)Mockito.doReturn((Object)amContainerMap).when((Object)appContext)).getAllContainers();
        ((AppContext)Mockito.doReturn((Object)amNodeTracker).when((Object)appContext)).getNodeTracker();
        ((AppContext)Mockito.doReturn((Object)DAGAppMasterState.RUNNING).when((Object)appContext)).getAMState();
        ((AppContext)Mockito.doReturn((Object)dagID).when((Object)appContext)).getCurrentDAGID();
        ((AppContext)Mockito.doReturn((Object)Mockito.mock(ClusterInfo.class)).when((Object)appContext)).getClusterInfo();
        TestTaskSchedulerHelpers.TaskSchedulerManagerForTest taskSchedulerManagerReal = new TestTaskSchedulerHelpers.TaskSchedulerManagerForTest(appContext, eventHandler, (TezAMRMClientAsync<YarnTaskSchedulerService.CookieContainerRequest>)rmClient, new TestTaskSchedulerHelpers.AlwaysMatchesContainerMatcher(), TezUtils.createUserPayloadFromConf((Configuration)tezConf));
        TaskSchedulerManager taskSchedulerManager = (TaskSchedulerManager)Mockito.spy((Object)((Object)taskSchedulerManagerReal));
        taskSchedulerManager.init(tezConf);
        taskSchedulerManager.start();
        TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext taskScheduler = (TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext)((TestTaskSchedulerHelpers.TaskSchedulerManagerForTest)taskSchedulerManager).getSpyTaskScheduler();
        TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback = taskScheduler.getDrainableAppCallback();
        taskScheduler.delayedContainerManager.drainedDelayedContainersForTest = drainNotifier = new AtomicBoolean(false);
        Resource resource1 = Resource.newInstance((int)1024, (int)1);
        String[] host1 = new String[]{"host1"};
        String[] host2 = new String[]{"host2"};
        String[] racks = new String[]{"/default-rack"};
        Priority priority1 = Priority.newInstance((int)1);
        TezVertexID vertexID1 = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezTaskAttemptID taID11 = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexID1, (int)1), (int)1);
        TaskAttempt ta11 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        AMSchedulerEventTALaunchRequest lrEvent1 = this.createLaunchRequestEvent(taID11, ta11, resource1, host1, racks, priority1);
        TezTaskAttemptID taID12 = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexID1, (int)2), (int)1);
        TaskAttempt ta12 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        AMSchedulerEventTALaunchRequest lrEvent2 = this.createLaunchRequestEvent(taID12, ta12, resource1, host1, racks, priority1);
        TezTaskAttemptID taID13 = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexID1, (int)3), (int)1);
        TaskAttempt ta13 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        AMSchedulerEventTALaunchRequest lrEvent3 = this.createLaunchRequestEvent(taID13, ta13, resource1, host2, racks, priority1);
        TezTaskAttemptID taID14 = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexID1, (int)4), (int)1);
        TaskAttempt ta14 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        AMSchedulerEventTALaunchRequest lrEvent4 = this.createLaunchRequestEvent(taID14, ta14, resource1, host2, racks, priority1);
        taskSchedulerManager.handleEvent((AMSchedulerEvent)lrEvent1);
        taskSchedulerManager.handleEvent((AMSchedulerEvent)lrEvent2);
        taskSchedulerManager.handleEvent((AMSchedulerEvent)lrEvent3);
        taskSchedulerManager.handleEvent((AMSchedulerEvent)lrEvent4);
        Container container1 = this.createContainer(1, "host1", resource1, priority1);
        drainNotifier.set(false);
        taskScheduler.onContainersAllocated(Collections.singletonList(container1));
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        drainableAppCallback.drain();
        ((TaskSchedulerManager)Mockito.verify((Object)taskSchedulerManager)).taskAllocated(Matchers.eq((int)0), Matchers.eq((Object)ta11), Matchers.any(Object.class), (Container)Matchers.eq((Object)container1));
        taskSchedulerManager.handleEvent((AMSchedulerEvent)new AMSchedulerEventTAEnded(ta11, container1.getId(), TaskAttemptState.SUCCEEDED, null, null, 0));
        drainableAppCallback.drain();
        this.verifyDeAllocateTask((TaskScheduler)taskScheduler, ta11, true, null, null);
        ((TaskSchedulerManager)Mockito.verify((Object)taskSchedulerManager)).taskAllocated(Matchers.eq((int)0), Matchers.eq((Object)ta12), Matchers.any(Object.class), (Container)Matchers.eq((Object)container1));
        ((TezAMRMClientAsync)Mockito.verify((Object)rmClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Matchers.eq((Object)container1.getId()));
        eventHandler.verifyNoInvocations(AMContainerEventStopRequest.class);
        eventHandler.reset();
        taskSchedulerManager.handleEvent((AMSchedulerEvent)new AMSchedulerEventTAEnded(ta12, container1.getId(), TaskAttemptState.SUCCEEDED, null, null, 0));
        drainableAppCallback.drain();
        this.verifyDeAllocateTask((TaskScheduler)taskScheduler, ta12, true, null, null);
        ((TaskSchedulerManager)Mockito.verify((Object)taskSchedulerManager)).taskAllocated(Matchers.eq((int)0), Matchers.eq((Object)ta13), Matchers.any(Object.class), (Container)Matchers.eq((Object)container1));
        ((TezAMRMClientAsync)Mockito.verify((Object)rmClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Matchers.eq((Object)container1.getId()));
        eventHandler.verifyNoInvocations(AMContainerEventStopRequest.class);
        eventHandler.reset();
        taskSchedulerManager.handleEvent((AMSchedulerEvent)new AMSchedulerEventTAEnded(ta13, container1.getId(), TaskAttemptState.FAILED, null, "TIMEOUT", 0));
        drainableAppCallback.drain();
        ((TaskSchedulerManager)Mockito.verify((Object)taskSchedulerManager, (VerificationMode)Mockito.times((int)0))).taskAllocated(Matchers.eq((int)0), Matchers.eq((Object)ta14), Matchers.any(Object.class), (Container)Matchers.eq((Object)container1));
        this.verifyDeAllocateTask((TaskScheduler)taskScheduler, ta13, false, null, "TIMEOUT");
        ((TezAMRMClientAsync)Mockito.verify((Object)rmClient)).releaseAssignedContainer((ContainerId)Matchers.eq((Object)container1.getId()));
        eventHandler.verifyInvocation(AMContainerEventStopRequest.class);
        eventHandler.reset();
        Container container2 = this.createContainer(2, "host2", resource1, priority1);
        drainNotifier.set(false);
        taskScheduler.onContainersAllocated(Collections.singletonList(container2));
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        drainableAppCallback.drain();
        ((TaskSchedulerManager)Mockito.verify((Object)taskSchedulerManager)).taskAllocated(Matchers.eq((int)0), Matchers.eq((Object)ta14), Matchers.any(Object.class), (Container)Matchers.eq((Object)container2));
        taskSchedulerManager.handleEvent((AMSchedulerEvent)new AMSchedulerEventTAEnded(ta14, container2.getId(), TaskAttemptState.SUCCEEDED, null, null, 0));
        drainableAppCallback.drain();
        this.verifyDeAllocateTask((TaskScheduler)taskScheduler, ta14, true, null, null);
        ((TezAMRMClientAsync)Mockito.verify((Object)rmClient)).releaseAssignedContainer((ContainerId)Matchers.eq((Object)container2.getId()));
        eventHandler.verifyInvocation(AMContainerEventStopRequest.class);
        eventHandler.reset();
        taskScheduler.shutdown();
        taskSchedulerManager.close();
    }

    @Test(timeout=10000L)
    public void testReuseWithTaskSpecificLaunchCmdOption() throws IOException, InterruptedException, ExecutionException {
        AtomicBoolean drainNotifier;
        LOG.info("Test testReuseWithTaskSpecificLaunchCmdOption");
        Configuration tezConf = new Configuration((Configuration)new YarnConfiguration());
        tezConf.setBoolean("tez.am.container.reuse.enabled", true);
        tezConf.setBoolean("tez.am.container.reuse.rack-fallback.enabled", true);
        tezConf.setLong("tez.am.container.reuse.locality.delay-allocation-millis", 0L);
        tezConf.setLong("tez.am.container.idle.release-timeout-min.millis", 0L);
        tezConf.setLong("tez.am.container.idle.release-timeout-max.millis", 0L);
        tezConf.set("tez.task-specific.launch.cmd-opts.list", "v1[1,3,4]");
        tezConf.set("tez.task-specific.launch.cmd-opts", "dir=/tmp/__VERTEX_NAME__/__TASK_INDEX__");
        TaskSpecificLaunchCmdOption taskSpecificLaunchCmdOption = new TaskSpecificLaunchCmdOption(tezConf);
        TestTaskSchedulerHelpers.CapturingEventHandler eventHandler = new TestTaskSchedulerHelpers.CapturingEventHandler();
        TezDAGID dagID = TezDAGID.getInstance((String)"0", (int)0, (int)0);
        TestTaskSchedulerHelpers.AMRMClientForTest rmClientCore = new TestTaskSchedulerHelpers.AMRMClientForTest();
        TezAMRMClientAsync rmClient = (TezAMRMClientAsync)Mockito.spy((Object)((Object)new TestTaskSchedulerHelpers.AMRMClientAsyncForTest((AMRMClient<YarnTaskSchedulerService.CookieContainerRequest>)rmClientCore, 100)));
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        ((AppContext)Mockito.doReturn((Object)new Configuration(false)).when((Object)appContext)).getAMConf();
        AMContainerMap amContainerMap = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), appContext);
        AMNodeTracker amNodeTracker = new AMNodeTracker((EventHandler)eventHandler, appContext);
        ((AppContext)Mockito.doReturn((Object)amContainerMap).when((Object)appContext)).getAllContainers();
        ((AppContext)Mockito.doReturn((Object)amNodeTracker).when((Object)appContext)).getNodeTracker();
        ((AppContext)Mockito.doReturn((Object)DAGAppMasterState.RUNNING).when((Object)appContext)).getAMState();
        ((AppContext)Mockito.doReturn((Object)dagID).when((Object)appContext)).getCurrentDAGID();
        ((AppContext)Mockito.doReturn((Object)Mockito.mock(ClusterInfo.class)).when((Object)appContext)).getClusterInfo();
        TestTaskSchedulerHelpers.TaskSchedulerManagerForTest taskSchedulerManagerReal = new TestTaskSchedulerHelpers.TaskSchedulerManagerForTest(appContext, eventHandler, (TezAMRMClientAsync<YarnTaskSchedulerService.CookieContainerRequest>)rmClient, (ContainerSignatureMatcher)new ContainerContextMatcher(), TezUtils.createUserPayloadFromConf((Configuration)tezConf));
        TaskSchedulerManager taskSchedulerManager = (TaskSchedulerManager)Mockito.spy((Object)((Object)taskSchedulerManagerReal));
        taskSchedulerManager.init(tezConf);
        taskSchedulerManager.start();
        TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext taskScheduler = (TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext)((TestTaskSchedulerHelpers.TaskSchedulerManagerForTest)taskSchedulerManager).getSpyTaskScheduler();
        TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback = taskScheduler.getDrainableAppCallback();
        taskScheduler.delayedContainerManager.drainedDelayedContainersForTest = drainNotifier = new AtomicBoolean(false);
        Resource resource1 = Resource.newInstance((int)1024, (int)1);
        String[] host1 = new String[]{"host1"};
        String[] host2 = new String[]{"host2"};
        String[] host3 = new String[]{"host3"};
        String[] racks = new String[]{"/default-rack"};
        Priority priority1 = Priority.newInstance((int)1);
        TezVertexID vertexID1 = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
        String tsLaunchCmdOpts = taskSpecificLaunchCmdOption.getTaskSpecificOption("", "v1", 1);
        TezTaskAttemptID taID11 = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexID1, (int)1), (int)1);
        TaskAttempt ta11 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        AMSchedulerEventTALaunchRequest lrEvent1 = this.createLaunchRequestEvent(taID11, ta11, resource1, host1, racks, priority1, localResources, tsLaunchCmdOpts);
        TezTaskAttemptID taID12 = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexID1, (int)2), (int)1);
        TaskAttempt ta12 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        AMSchedulerEventTALaunchRequest lrEvent2 = this.createLaunchRequestEvent(taID12, ta12, resource1, host1, racks, priority1);
        drainNotifier.set(false);
        taskSchedulerManager.handleEvent((AMSchedulerEvent)lrEvent1);
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        drainNotifier.set(false);
        taskSchedulerManager.handleEvent((AMSchedulerEvent)lrEvent2);
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        Container container1 = this.createContainer(1, "host1", resource1, priority1);
        drainNotifier.set(false);
        taskScheduler.onContainersAllocated(Collections.singletonList(container1));
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        drainableAppCallback.drain();
        ((TaskSchedulerManager)Mockito.verify((Object)taskSchedulerManager)).taskAllocated(Matchers.eq((int)0), Matchers.eq((Object)ta11), Matchers.any(Object.class), (Container)Matchers.eq((Object)container1));
        taskSchedulerManager.handleEvent((AMSchedulerEvent)new AMSchedulerEventTAEnded(ta11, container1.getId(), TaskAttemptState.SUCCEEDED, null, null, 0));
        drainableAppCallback.drain();
        this.verifyDeAllocateTask((TaskScheduler)taskScheduler, ta11, true, null, null);
        ((TaskSchedulerManager)Mockito.verify((Object)taskSchedulerManager, (VerificationMode)Mockito.times((int)0))).taskAllocated(Matchers.eq((int)0), Matchers.eq((Object)ta12), Matchers.any(Object.class), (Container)Matchers.eq((Object)container1));
        ((TezAMRMClientAsync)Mockito.verify((Object)rmClient, (VerificationMode)Mockito.times((int)1))).releaseAssignedContainer((ContainerId)Matchers.eq((Object)container1.getId()));
        eventHandler.verifyInvocation(AMContainerEventStopRequest.class);
        eventHandler.reset();
        tsLaunchCmdOpts = taskSpecificLaunchCmdOption.getTaskSpecificOption("", "v1", 3);
        TezTaskAttemptID taID13 = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexID1, (int)3), (int)1);
        TaskAttempt ta13 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        AMSchedulerEventTALaunchRequest lrEvent3 = this.createLaunchRequestEvent(taID13, ta13, resource1, host2, racks, priority1, localResources, tsLaunchCmdOpts);
        tsLaunchCmdOpts = taskSpecificLaunchCmdOption.getTaskSpecificOption("", "v1", 4);
        TezTaskAttemptID taID14 = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexID1, (int)4), (int)1);
        TaskAttempt ta14 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        AMSchedulerEventTALaunchRequest lrEvent4 = this.createLaunchRequestEvent(taID14, ta14, resource1, host2, racks, priority1, localResources, tsLaunchCmdOpts);
        Container container2 = this.createContainer(2, "host2", resource1, priority1);
        drainNotifier.set(false);
        taskSchedulerManager.handleEvent((AMSchedulerEvent)lrEvent3);
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        drainNotifier.set(false);
        taskSchedulerManager.handleEvent((AMSchedulerEvent)lrEvent4);
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        drainNotifier.set(false);
        taskScheduler.onContainersAllocated(Collections.singletonList(container2));
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        drainableAppCallback.drain();
        ((TaskSchedulerManager)Mockito.verify((Object)taskSchedulerManager)).taskAllocated(Matchers.eq((int)0), Matchers.eq((Object)ta13), Matchers.any(Object.class), (Container)Matchers.eq((Object)container2));
        taskSchedulerManager.handleEvent((AMSchedulerEvent)new AMSchedulerEventTAEnded(ta13, container2.getId(), TaskAttemptState.SUCCEEDED, null, null, 0));
        drainableAppCallback.drain();
        this.verifyDeAllocateTask((TaskScheduler)taskScheduler, ta13, true, null, null);
        ((TaskSchedulerManager)Mockito.verify((Object)taskSchedulerManager, (VerificationMode)Mockito.times((int)0))).taskAllocated(Matchers.eq((int)0), Matchers.eq((Object)ta14), Matchers.any(Object.class), (Container)Matchers.eq((Object)container2));
        ((TezAMRMClientAsync)Mockito.verify((Object)rmClient, (VerificationMode)Mockito.times((int)1))).releaseAssignedContainer((ContainerId)Matchers.eq((Object)container2.getId()));
        eventHandler.verifyInvocation(AMContainerEventStopRequest.class);
        eventHandler.reset();
        tezConf.set("tez.task-specific.launch.cmd-opts.list", "v1[1,2,3,5,6]");
        tezConf.set("tez.task-specific.launch.cmd-opts", "dummyOpts");
        taskSpecificLaunchCmdOption = new TaskSpecificLaunchCmdOption(tezConf);
        TezTaskAttemptID taID15 = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexID1, (int)3), (int)1);
        TaskAttempt ta15 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        AMSchedulerEventTALaunchRequest lrEvent5 = this.createLaunchRequestEvent(taID15, ta15, resource1, host3, racks, priority1, localResources, taskSpecificLaunchCmdOption.getTaskSpecificOption("", "v1", 5));
        tsLaunchCmdOpts = taskSpecificLaunchCmdOption.getTaskSpecificOption("", "v1", 4);
        TezTaskAttemptID taID16 = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexID1, (int)4), (int)1);
        TaskAttempt ta16 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        AMSchedulerEventTALaunchRequest lrEvent6 = this.createLaunchRequestEvent(taID16, ta16, resource1, host3, racks, priority1, localResources, taskSpecificLaunchCmdOption.getTaskSpecificOption("", "v1", 6));
        Container container3 = this.createContainer(2, "host3", resource1, priority1);
        taskSchedulerManager.handleEvent((AMSchedulerEvent)lrEvent5);
        taskSchedulerManager.handleEvent((AMSchedulerEvent)lrEvent6);
        drainNotifier.set(false);
        taskScheduler.onContainersAllocated(Collections.singletonList(container3));
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        drainableAppCallback.drain();
        ((TaskSchedulerManager)Mockito.verify((Object)taskSchedulerManager)).taskAllocated(Matchers.eq((int)0), Matchers.eq((Object)ta15), Matchers.any(Object.class), (Container)Matchers.eq((Object)container3));
        taskSchedulerManager.handleEvent((AMSchedulerEvent)new AMSchedulerEventTAEnded(ta15, container3.getId(), TaskAttemptState.SUCCEEDED, null, null, 0));
        drainableAppCallback.drain();
        this.verifyDeAllocateTask((TaskScheduler)taskScheduler, ta15, true, null, null);
        ((TaskSchedulerManager)Mockito.verify((Object)taskSchedulerManager)).taskAllocated(Matchers.eq((int)0), Matchers.eq((Object)ta16), Matchers.any(Object.class), (Container)Matchers.eq((Object)container3));
        eventHandler.reset();
        taskScheduler.shutdown();
        taskSchedulerManager.close();
    }

    @Test(timeout=30000L)
    public void testReuseNonLocalRequest() throws IOException, InterruptedException, ExecutionException {
        AtomicBoolean drainNotifier;
        LOG.info("Test testReuseNonLocalRequest");
        Configuration tezConf = new Configuration((Configuration)new YarnConfiguration());
        tezConf.setBoolean("tez.am.container.reuse.enabled", true);
        tezConf.setBoolean("tez.am.container.reuse.rack-fallback.enabled", true);
        tezConf.setBoolean("tez.am.container.reuse.non-local-fallback.enabled", true);
        tezConf.setLong("tez.am.container.reuse.locality.delay-allocation-millis", 100L);
        tezConf.setLong("tez.am.container.idle.release-timeout-min.millis", 1000L);
        tezConf.setLong("tez.am.container.idle.release-timeout-max.millis", 1000L);
        TestTaskSchedulerHelpers.CapturingEventHandler eventHandler = new TestTaskSchedulerHelpers.CapturingEventHandler();
        TezDAGID dagID = TezDAGID.getInstance((String)"0", (int)0, (int)0);
        TestTaskSchedulerHelpers.AMRMClientForTest rmClientCore = new TestTaskSchedulerHelpers.AMRMClientForTest();
        TezAMRMClientAsync rmClient = (TezAMRMClientAsync)Mockito.spy((Object)((Object)new TestTaskSchedulerHelpers.AMRMClientAsyncForTest((AMRMClient<YarnTaskSchedulerService.CookieContainerRequest>)rmClientCore, 100)));
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        ((AppContext)Mockito.doReturn((Object)new Configuration(false)).when((Object)appContext)).getAMConf();
        AMContainerMap amContainerMap = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), appContext);
        AMNodeTracker amNodeTracker = new AMNodeTracker((EventHandler)eventHandler, appContext);
        ((AppContext)Mockito.doReturn((Object)amContainerMap).when((Object)appContext)).getAllContainers();
        ((AppContext)Mockito.doReturn((Object)amNodeTracker).when((Object)appContext)).getNodeTracker();
        ((AppContext)Mockito.doReturn((Object)DAGAppMasterState.RUNNING).when((Object)appContext)).getAMState();
        ((AppContext)Mockito.doReturn((Object)dagID).when((Object)appContext)).getCurrentDAGID();
        ((AppContext)Mockito.doReturn((Object)Mockito.mock(ClusterInfo.class)).when((Object)appContext)).getClusterInfo();
        TestTaskSchedulerHelpers.TaskSchedulerManagerForTest taskSchedulerManagerReal = new TestTaskSchedulerHelpers.TaskSchedulerManagerForTest(appContext, eventHandler, (TezAMRMClientAsync<YarnTaskSchedulerService.CookieContainerRequest>)rmClient, new TestTaskSchedulerHelpers.AlwaysMatchesContainerMatcher(), TezUtils.createUserPayloadFromConf((Configuration)tezConf));
        TaskSchedulerManager taskSchedulerManager = (TaskSchedulerManager)Mockito.spy((Object)((Object)taskSchedulerManagerReal));
        taskSchedulerManager.init(tezConf);
        taskSchedulerManager.start();
        TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext taskScheduler = (TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext)((TestTaskSchedulerHelpers.TaskSchedulerManagerForTest)taskSchedulerManager).getSpyTaskScheduler();
        TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback = taskScheduler.getDrainableAppCallback();
        taskScheduler.delayedContainerManager.drainedDelayedContainersForTest = drainNotifier = new AtomicBoolean(false);
        Resource resource1 = Resource.newInstance((int)1024, (int)1);
        String[] emptyHosts = new String[]{};
        String[] racks = new String[]{"default-rack"};
        Priority priority = Priority.newInstance((int)3);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezTaskAttemptID taID11 = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexID, (int)1), (int)1);
        TaskAttempt ta11 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        ((TaskAttempt)Mockito.doReturn((Object)vertexID).when((Object)ta11)).getVertexID();
        AMSchedulerEventTALaunchRequest lrEvent11 = this.createLaunchRequestEvent(taID11, ta11, resource1, emptyHosts, racks, priority);
        TezTaskAttemptID taID12 = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexID, (int)2), (int)1);
        TaskAttempt ta12 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        ((TaskAttempt)Mockito.doReturn((Object)vertexID).when((Object)ta12)).getVertexID();
        AMSchedulerEventTALaunchRequest lrEvent12 = this.createLaunchRequestEvent(taID12, ta12, resource1, emptyHosts, racks, priority);
        drainNotifier.set(false);
        taskSchedulerManager.handleEvent((AMSchedulerEvent)lrEvent11);
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        Container container1 = this.createContainer(1, "randomHost", resource1, priority);
        drainNotifier.set(false);
        taskScheduler.onContainersAllocated(Collections.singletonList(container1));
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        drainableAppCallback.drain();
        ((TaskSchedulerManager)Mockito.verify((Object)taskSchedulerManager)).taskAllocated(Matchers.eq((int)0), Matchers.eq((Object)ta11), Matchers.any(Object.class), (Container)Matchers.eq((Object)container1));
        taskSchedulerManager.handleEvent((AMSchedulerEvent)lrEvent12);
        taskSchedulerManager.handleEvent((AMSchedulerEvent)new AMSchedulerEventTAEnded(ta11, container1.getId(), TaskAttemptState.SUCCEEDED, null, null, 0));
        drainableAppCallback.drain();
        this.verifyDeAllocateTask((TaskScheduler)taskScheduler, ta11, true, null, null);
        ((TaskSchedulerManager)Mockito.verify((Object)taskSchedulerManager, (VerificationMode)Mockito.times((int)0))).taskAllocated(Matchers.eq((int)0), Matchers.eq((Object)ta12), Matchers.any(Object.class), (Container)Matchers.eq((Object)container1));
        ((TezAMRMClientAsync)Mockito.verify((Object)rmClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Matchers.eq((Object)container1.getId()));
        eventHandler.verifyNoInvocations(AMContainerEventStopRequest.class);
        eventHandler.reset();
        LOG.info("Sleeping to ensure that the scheduling loop runs");
        Thread.sleep(3000L);
        ((TaskSchedulerManager)Mockito.verify((Object)taskSchedulerManager)).taskAllocated(Matchers.eq((int)0), Matchers.eq((Object)ta12), Matchers.any(Object.class), (Container)Matchers.eq((Object)container1));
        taskSchedulerManager.handleEvent((AMSchedulerEvent)new AMSchedulerEventTAEnded(ta12, container1.getId(), TaskAttemptState.SUCCEEDED, null, null, 0));
        drainableAppCallback.drain();
        LOG.info("Sleeping to ensure that the scheduling loop runs");
        Thread.sleep(3000L);
        ((TezAMRMClientAsync)Mockito.verify((Object)rmClient)).releaseAssignedContainer((ContainerId)Matchers.eq((Object)container1.getId()));
        eventHandler.verifyInvocation(AMContainerEventStopRequest.class);
        taskScheduler.shutdown();
        taskSchedulerManager.close();
    }

    @Test(timeout=30000L)
    public void testReuseAcrossVertices() throws IOException, InterruptedException, ExecutionException {
        AtomicBoolean drainNotifier;
        LOG.info("Test testReuseAcrossVertices");
        Configuration tezConf = new Configuration((Configuration)new YarnConfiguration());
        tezConf.setBoolean("tez.am.container.reuse.enabled", true);
        tezConf.setLong("tez.am.container.reuse.locality.delay-allocation-millis", 1L);
        tezConf.setLong("tez.am.container.idle.release-timeout-min.millis", 2000L);
        tezConf.setInt("tez.am.session.min.held-containers", 1);
        TestTaskSchedulerHelpers.CapturingEventHandler eventHandler = new TestTaskSchedulerHelpers.CapturingEventHandler();
        TezDAGID dagID = TezDAGID.getInstance((String)"0", (int)0, (int)0);
        TestTaskSchedulerHelpers.AMRMClientForTest rmClientCore = new TestTaskSchedulerHelpers.AMRMClientForTest();
        TezAMRMClientAsync rmClient = (TezAMRMClientAsync)Mockito.spy((Object)((Object)new TestTaskSchedulerHelpers.AMRMClientAsyncForTest((AMRMClient<YarnTaskSchedulerService.CookieContainerRequest>)rmClientCore, 100)));
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        ((AppContext)Mockito.doReturn((Object)new Configuration(false)).when((Object)appContext)).getAMConf();
        AMContainerMap amContainerMap = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), appContext);
        AMNodeTracker amNodeTracker = new AMNodeTracker((EventHandler)eventHandler, appContext);
        ((AppContext)Mockito.doReturn((Object)amContainerMap).when((Object)appContext)).getAllContainers();
        ((AppContext)Mockito.doReturn((Object)amNodeTracker).when((Object)appContext)).getNodeTracker();
        ((AppContext)Mockito.doReturn((Object)DAGAppMasterState.RUNNING).when((Object)appContext)).getAMState();
        ((AppContext)Mockito.doReturn((Object)true).when((Object)appContext)).isSession();
        ((AppContext)Mockito.doReturn((Object)dagID).when((Object)appContext)).getCurrentDAGID();
        ((AppContext)Mockito.doReturn((Object)Mockito.mock(ClusterInfo.class)).when((Object)appContext)).getClusterInfo();
        TestTaskSchedulerHelpers.TaskSchedulerManagerForTest taskSchedulerManagerReal = new TestTaskSchedulerHelpers.TaskSchedulerManagerForTest(appContext, eventHandler, (TezAMRMClientAsync<YarnTaskSchedulerService.CookieContainerRequest>)rmClient, new TestTaskSchedulerHelpers.AlwaysMatchesContainerMatcher(), TezUtils.createUserPayloadFromConf((Configuration)tezConf));
        TaskSchedulerManager taskSchedulerManager = (TaskSchedulerManager)Mockito.spy((Object)((Object)taskSchedulerManagerReal));
        taskSchedulerManager.init(tezConf);
        taskSchedulerManager.start();
        TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext taskScheduler = (TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext)((TestTaskSchedulerHelpers.TaskSchedulerManagerForTest)taskSchedulerManager).getSpyTaskScheduler();
        TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback = taskScheduler.getDrainableAppCallback();
        taskScheduler.delayedContainerManager.drainedDelayedContainersForTest = drainNotifier = new AtomicBoolean(false);
        Resource resource1 = Resource.newInstance((int)1024, (int)1);
        String[] host1 = new String[]{"host1"};
        String[] racks = new String[]{"/default-rack"};
        Priority priority1 = Priority.newInstance((int)3);
        Priority priority2 = Priority.newInstance((int)4);
        TezVertexID vertexID1 = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezVertexID vertexID2 = TezVertexID.getInstance((TezDAGID)dagID, (int)2);
        TezTaskAttemptID taID11 = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexID1, (int)1), (int)1);
        TaskAttempt ta11 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        ((TaskAttempt)Mockito.doReturn((Object)vertexID1).when((Object)ta11)).getVertexID();
        AMSchedulerEventTALaunchRequest lrEvent11 = this.createLaunchRequestEvent(taID11, ta11, resource1, host1, racks, priority1);
        TezTaskAttemptID taID21 = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexID2, (int)1), (int)1);
        TaskAttempt ta21 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        ((TaskAttempt)Mockito.doReturn((Object)vertexID2).when((Object)ta21)).getVertexID();
        AMSchedulerEventTALaunchRequest lrEvent21 = this.createLaunchRequestEvent(taID21, ta21, resource1, host1, racks, priority2);
        drainNotifier.set(false);
        taskSchedulerManager.handleEvent((AMSchedulerEvent)lrEvent11);
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        Container container1 = this.createContainer(1, host1[0], resource1, priority1);
        drainNotifier.set(false);
        taskScheduler.onContainersAllocated(Collections.singletonList(container1));
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        drainableAppCallback.drain();
        ((TaskSchedulerManager)Mockito.verify((Object)taskSchedulerManager)).taskAllocated(Matchers.eq((int)0), Matchers.eq((Object)ta11), Matchers.any(Object.class), (Container)Matchers.eq((Object)container1));
        taskSchedulerManager.handleEvent((AMSchedulerEvent)lrEvent21);
        taskSchedulerManager.handleEvent((AMSchedulerEvent)new AMSchedulerEventTAEnded(ta11, container1.getId(), TaskAttemptState.SUCCEEDED, null, null, 0));
        drainableAppCallback.drain();
        this.verifyDeAllocateTask((TaskScheduler)taskScheduler, ta11, true, null, null);
        ((TaskSchedulerManager)Mockito.verify((Object)taskSchedulerManager)).taskAllocated(Matchers.eq((int)0), Matchers.eq((Object)ta21), Matchers.any(Object.class), (Container)Matchers.eq((Object)container1));
        ((TezAMRMClientAsync)Mockito.verify((Object)rmClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Matchers.eq((Object)container1.getId()));
        taskSchedulerManager.handleEvent((AMSchedulerEvent)new AMSchedulerEventTAEnded(ta21, container1.getId(), TaskAttemptState.SUCCEEDED, null, null, 0));
        ((TezAMRMClientAsync)Mockito.verify((Object)rmClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Matchers.eq((Object)container1.getId()));
        LOG.info("Sleeping to ensure that the scheduling loop runs");
        Thread.sleep(3000L);
        ((TezAMRMClientAsync)Mockito.verify((Object)rmClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Matchers.eq((Object)container1.getId()));
        taskScheduler.shutdown();
        taskSchedulerManager.close();
    }

    @Test(timeout=30000L)
    public void testReuseLocalResourcesChanged() throws IOException, InterruptedException, ExecutionException {
        AtomicBoolean drainNotifier;
        LOG.info("Test testReuseLocalResourcesChanged");
        Configuration tezConf = new Configuration((Configuration)new YarnConfiguration());
        tezConf.setBoolean("tez.am.container.reuse.enabled", true);
        tezConf.setBoolean("tez.am.container.reuse.rack-fallback.enabled", true);
        tezConf.setBoolean("tez.am.container.reuse.non-local-fallback.enabled", true);
        tezConf.setLong("tez.am.container.reuse.locality.delay-allocation-millis", 0L);
        tezConf.setLong("tez.am.container.idle.release-timeout-min.millis", -1L);
        TestTaskSchedulerHelpers.CapturingEventHandler eventHandler = new TestTaskSchedulerHelpers.CapturingEventHandler();
        TezDAGID dagID1 = TezDAGID.getInstance((String)"0", (int)1, (int)0);
        TestTaskSchedulerHelpers.AMRMClientForTest rmClientCore = new TestTaskSchedulerHelpers.AMRMClientForTest();
        TezAMRMClientAsync rmClient = (TezAMRMClientAsync)Mockito.spy((Object)((Object)new TestTaskSchedulerHelpers.AMRMClientAsyncForTest((AMRMClient<YarnTaskSchedulerService.CookieContainerRequest>)rmClientCore, 100)));
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        ((AppContext)Mockito.doReturn((Object)new Configuration(false)).when((Object)appContext)).getAMConf();
        ChangingDAGIDAnswer dagIDAnswer = new ChangingDAGIDAnswer(dagID1);
        AMContainerMap amContainerMap = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), appContext);
        AMNodeTracker amNodeTracker = new AMNodeTracker((EventHandler)eventHandler, appContext);
        ((AppContext)Mockito.doReturn((Object)amContainerMap).when((Object)appContext)).getAllContainers();
        ((AppContext)Mockito.doReturn((Object)amNodeTracker).when((Object)appContext)).getNodeTracker();
        ((AppContext)Mockito.doReturn((Object)DAGAppMasterState.RUNNING).when((Object)appContext)).getAMState();
        ((AppContext)Mockito.doReturn((Object)true).when((Object)appContext)).isSession();
        ((AppContext)Mockito.doAnswer((Answer)dagIDAnswer).when((Object)appContext)).getCurrentDAGID();
        ((AppContext)Mockito.doReturn((Object)Mockito.mock(ClusterInfo.class)).when((Object)appContext)).getClusterInfo();
        TestTaskSchedulerHelpers.TaskSchedulerManagerForTest taskSchedulerManagerReal = new TestTaskSchedulerHelpers.TaskSchedulerManagerForTest(appContext, eventHandler, (TezAMRMClientAsync<YarnTaskSchedulerService.CookieContainerRequest>)rmClient, new TestTaskSchedulerHelpers.AlwaysMatchesContainerMatcher(), TezUtils.createUserPayloadFromConf((Configuration)tezConf));
        TaskSchedulerManager taskSchedulerManager = (TaskSchedulerManager)Mockito.spy((Object)((Object)taskSchedulerManagerReal));
        taskSchedulerManager.init(tezConf);
        taskSchedulerManager.start();
        TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext taskScheduler = (TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext)((TestTaskSchedulerHelpers.TaskSchedulerManagerForTest)taskSchedulerManager).getSpyTaskScheduler();
        TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback = taskScheduler.getDrainableAppCallback();
        taskScheduler.delayedContainerManager.drainedDelayedContainersForTest = drainNotifier = new AtomicBoolean(false);
        Resource resource1 = Resource.newInstance((int)1024, (int)1);
        String[] host1 = new String[]{"host1"};
        String[] racks = new String[]{"/default-rack"};
        Priority priority1 = Priority.newInstance((int)1);
        String rsrc1 = "rsrc1";
        String rsrc2 = "rsrc2";
        String rsrc3 = "rsrc3";
        LocalResource lr1 = (LocalResource)Mockito.mock(LocalResource.class);
        LocalResource lr2 = (LocalResource)Mockito.mock(LocalResource.class);
        LocalResource lr3 = (LocalResource)Mockito.mock(LocalResource.class);
        AMContainerEventAssignTA assignEvent = null;
        HashMap dag1LRs = Maps.newHashMap();
        dag1LRs.put(rsrc1, lr1);
        TezVertexID vertexID11 = TezVertexID.getInstance((TezDAGID)dagID1, (int)1);
        TezTaskAttemptID taID111 = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexID11, (int)1), (int)1);
        TaskAttempt ta111 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        AMSchedulerEventTALaunchRequest lrEvent11 = this.createLaunchRequestEvent(taID111, ta111, resource1, host1, racks, priority1, dag1LRs);
        TezTaskAttemptID taID112 = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexID11, (int)2), (int)1);
        TaskAttempt ta112 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        AMSchedulerEventTALaunchRequest lrEvent12 = this.createLaunchRequestEvent(taID112, ta112, resource1, host1, racks, priority1, dag1LRs);
        drainNotifier.set(false);
        taskSchedulerManager.handleEvent((AMSchedulerEvent)lrEvent11);
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        drainNotifier.set(false);
        taskSchedulerManager.handleEvent((AMSchedulerEvent)lrEvent12);
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        Container container1 = this.createContainer(1, "host1", resource1, priority1);
        drainNotifier.set(false);
        taskScheduler.onContainersAllocated(Collections.singletonList(container1));
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        drainableAppCallback.drain();
        ((TaskSchedulerManager)Mockito.verify((Object)taskSchedulerManager)).taskAllocated(Matchers.eq((int)0), Matchers.eq((Object)ta111), Matchers.any(Object.class), (Container)Matchers.eq((Object)container1));
        assignEvent = (AMContainerEventAssignTA)eventHandler.verifyInvocation(AMContainerEventAssignTA.class);
        Assert.assertEquals((long)1L, (long)assignEvent.getRemoteTaskLocalResources().size());
        taskSchedulerManager.handleEvent((AMSchedulerEvent)new AMSchedulerEventTAEnded(ta111, container1.getId(), TaskAttemptState.SUCCEEDED, null, null, 0));
        drainableAppCallback.drain();
        this.verifyDeAllocateTask((TaskScheduler)taskScheduler, ta111, true, null, null);
        ((TaskSchedulerManager)Mockito.verify((Object)taskSchedulerManager)).taskAllocated(Matchers.eq((int)0), Matchers.eq((Object)ta112), Matchers.any(Object.class), (Container)Matchers.eq((Object)container1));
        ((TezAMRMClientAsync)Mockito.verify((Object)rmClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Matchers.eq((Object)container1.getId()));
        eventHandler.verifyNoInvocations(AMContainerEventStopRequest.class);
        assignEvent = (AMContainerEventAssignTA)eventHandler.verifyInvocation(AMContainerEventAssignTA.class);
        Assert.assertEquals((long)1L, (long)assignEvent.getRemoteTaskLocalResources().size());
        eventHandler.reset();
        taskSchedulerManager.handleEvent((AMSchedulerEvent)new AMSchedulerEventTAEnded(ta112, container1.getId(), TaskAttemptState.SUCCEEDED, null, null, 0));
        drainableAppCallback.drain();
        this.verifyDeAllocateTask((TaskScheduler)taskScheduler, ta112, true, null, null);
        ((TezAMRMClientAsync)Mockito.verify((Object)rmClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Matchers.eq((Object)container1.getId()));
        eventHandler.verifyNoInvocations(AMContainerEventStopRequest.class);
        eventHandler.reset();
        TezDAGID dagID2 = TezDAGID.getInstance((String)"0", (int)2, (int)0);
        dagIDAnswer.setDAGID(dagID2);
        HashMap dag2LRs = Maps.newHashMap();
        dag2LRs.put(rsrc2, lr2);
        dag2LRs.put(rsrc3, lr3);
        TezVertexID vertexID21 = TezVertexID.getInstance((TezDAGID)dagID2, (int)1);
        TezTaskAttemptID taID211 = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexID21, (int)1), (int)1);
        TaskAttempt ta211 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        AMSchedulerEventTALaunchRequest lrEvent21 = this.createLaunchRequestEvent(taID211, ta211, resource1, host1, racks, priority1, dag2LRs);
        TezTaskAttemptID taID212 = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexID21, (int)2), (int)1);
        TaskAttempt ta212 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        AMSchedulerEventTALaunchRequest lrEvent22 = this.createLaunchRequestEvent(taID212, ta212, resource1, host1, racks, priority1, dag2LRs);
        taskSchedulerManager.handleEvent((AMSchedulerEvent)lrEvent21);
        taskSchedulerManager.handleEvent((AMSchedulerEvent)lrEvent22);
        drainableAppCallback.drain();
        LOG.info("Sleeping to ensure that the scheduling loop runs");
        Thread.sleep(6000L);
        ((TaskSchedulerManager)Mockito.verify((Object)taskSchedulerManager)).taskAllocated(Matchers.eq((int)0), Matchers.eq((Object)ta211), Matchers.any(Object.class), (Container)Matchers.eq((Object)container1));
        ((TezAMRMClientAsync)Mockito.verify((Object)rmClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Matchers.eq((Object)container1.getId()));
        eventHandler.verifyNoInvocations(AMContainerEventStopRequest.class);
        assignEvent = (AMContainerEventAssignTA)eventHandler.verifyInvocation(AMContainerEventAssignTA.class);
        Assert.assertEquals((long)2L, (long)assignEvent.getRemoteTaskLocalResources().size());
        eventHandler.reset();
        taskSchedulerManager.handleEvent((AMSchedulerEvent)new AMSchedulerEventTAEnded(ta211, container1.getId(), TaskAttemptState.SUCCEEDED, null, null, 0));
        drainableAppCallback.drain();
        this.verifyDeAllocateTask((TaskScheduler)taskScheduler, ta211, true, null, null);
        ((TaskSchedulerManager)Mockito.verify((Object)taskSchedulerManager)).taskAllocated(Matchers.eq((int)0), Matchers.eq((Object)ta212), Matchers.any(Object.class), (Container)Matchers.eq((Object)container1));
        ((TezAMRMClientAsync)Mockito.verify((Object)rmClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Matchers.eq((Object)container1.getId()));
        eventHandler.verifyNoInvocations(AMContainerEventStopRequest.class);
        assignEvent = (AMContainerEventAssignTA)eventHandler.verifyInvocation(AMContainerEventAssignTA.class);
        Assert.assertEquals((long)2L, (long)assignEvent.getRemoteTaskLocalResources().size());
        eventHandler.reset();
        taskScheduler.shutdown();
        taskSchedulerManager.close();
    }

    @Test(timeout=30000L)
    public void testReuseConflictLocalResources() throws IOException, InterruptedException, ExecutionException {
        AtomicBoolean drainNotifier;
        LOG.info("Test testReuseLocalResourcesChanged");
        Configuration tezConf = new Configuration((Configuration)new YarnConfiguration());
        tezConf.setBoolean("tez.am.container.reuse.enabled", true);
        tezConf.setBoolean("tez.am.container.reuse.rack-fallback.enabled", true);
        tezConf.setBoolean("tez.am.container.reuse.non-local-fallback.enabled", true);
        tezConf.setLong("tez.am.container.reuse.locality.delay-allocation-millis", 0L);
        tezConf.setLong("tez.am.container.idle.release-timeout-min.millis", -1L);
        TestTaskSchedulerHelpers.CapturingEventHandler eventHandler = new TestTaskSchedulerHelpers.CapturingEventHandler();
        TezDAGID dagID1 = TezDAGID.getInstance((String)"0", (int)1, (int)0);
        TestTaskSchedulerHelpers.AMRMClientForTest rmClientCore = new TestTaskSchedulerHelpers.AMRMClientForTest();
        TezAMRMClientAsync rmClient = (TezAMRMClientAsync)Mockito.spy((Object)((Object)new TestTaskSchedulerHelpers.AMRMClientAsyncForTest((AMRMClient<YarnTaskSchedulerService.CookieContainerRequest>)rmClientCore, 100)));
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        ((AppContext)Mockito.doReturn((Object)new Configuration(false)).when((Object)appContext)).getAMConf();
        ChangingDAGIDAnswer dagIDAnswer = new ChangingDAGIDAnswer(dagID1);
        AMContainerMap amContainerMap = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), appContext);
        AMNodeTracker amNodeTracker = new AMNodeTracker((EventHandler)eventHandler, appContext);
        ((AppContext)Mockito.doReturn((Object)amContainerMap).when((Object)appContext)).getAllContainers();
        ((AppContext)Mockito.doReturn((Object)amNodeTracker).when((Object)appContext)).getNodeTracker();
        ((AppContext)Mockito.doReturn((Object)DAGAppMasterState.RUNNING).when((Object)appContext)).getAMState();
        ((AppContext)Mockito.doReturn((Object)true).when((Object)appContext)).isSession();
        ((AppContext)Mockito.doAnswer((Answer)dagIDAnswer).when((Object)appContext)).getCurrentDAGID();
        ((AppContext)Mockito.doReturn((Object)Mockito.mock(ClusterInfo.class)).when((Object)appContext)).getClusterInfo();
        TestTaskSchedulerHelpers.TaskSchedulerManagerForTest taskSchedulerManagerReal = new TestTaskSchedulerHelpers.TaskSchedulerManagerForTest(appContext, eventHandler, (TezAMRMClientAsync<YarnTaskSchedulerService.CookieContainerRequest>)rmClient, (ContainerSignatureMatcher)new ContainerContextMatcher(), TezUtils.createUserPayloadFromConf((Configuration)tezConf));
        TaskSchedulerManager taskSchedulerManager = (TaskSchedulerManager)Mockito.spy((Object)((Object)taskSchedulerManagerReal));
        taskSchedulerManager.init(tezConf);
        taskSchedulerManager.start();
        TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext taskScheduler = (TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext)((TestTaskSchedulerHelpers.TaskSchedulerManagerForTest)taskSchedulerManager).getSpyTaskScheduler();
        TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback = taskScheduler.getDrainableAppCallback();
        taskScheduler.delayedContainerManager.drainedDelayedContainersForTest = drainNotifier = new AtomicBoolean(false);
        Resource resource1 = Resource.newInstance((int)1024, (int)1);
        String[] host1 = new String[]{"host1"};
        String[] racks = new String[]{"/default-rack"};
        Priority priority1 = Priority.newInstance((int)1);
        String rsrc1 = "rsrc1";
        String rsrc2 = "rsrc2";
        LocalResource lr1 = (LocalResource)Mockito.mock(LocalResource.class);
        LocalResource lr2 = (LocalResource)Mockito.mock(LocalResource.class);
        LocalResource lr3 = (LocalResource)Mockito.mock(LocalResource.class);
        AMContainerEventAssignTA assignEvent = null;
        HashMap v11LR = Maps.newHashMap();
        v11LR.put(rsrc1, lr1);
        TezVertexID vertexID11 = TezVertexID.getInstance((TezDAGID)dagID1, (int)1);
        TezTaskAttemptID taID111 = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexID11, (int)1), (int)1);
        TaskAttempt ta111 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        ((TaskAttempt)Mockito.doReturn((Object)taID111).when((Object)ta111)).getID();
        ((TaskAttempt)Mockito.doReturn((Object)("Mock for TA " + taID111.toString())).when((Object)ta111)).toString();
        AMSchedulerEventTALaunchRequest lrEvent11 = this.createLaunchRequestEvent(taID111, ta111, resource1, host1, racks, priority1, v11LR);
        HashMap v12LR = Maps.newHashMap();
        v12LR.put(rsrc1, lr1);
        v12LR.put(rsrc2, lr2);
        TezTaskAttemptID taID112 = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexID11, (int)2), (int)1);
        TaskAttempt ta112 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        ((TaskAttempt)Mockito.doReturn((Object)taID112).when((Object)ta112)).getID();
        ((TaskAttempt)Mockito.doReturn((Object)("Mock for TA " + taID112.toString())).when((Object)ta112)).toString();
        AMSchedulerEventTALaunchRequest lrEvent12 = this.createLaunchRequestEvent(taID112, ta112, resource1, host1, racks, priority1, v12LR);
        TezTaskAttemptID taID113 = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexID11, (int)3), (int)1);
        TaskAttempt ta113 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        ((TaskAttempt)Mockito.doReturn((Object)taID113).when((Object)ta113)).getID();
        ((TaskAttempt)Mockito.doReturn((Object)("Mock for TA " + taID113.toString())).when((Object)ta113)).toString();
        AMSchedulerEventTALaunchRequest lrEvent13 = this.createLaunchRequestEvent(taID113, ta113, resource1, host1, racks, priority1, new HashMap<String, LocalResource>());
        TezTaskAttemptID taID114 = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexID11, (int)4), (int)1);
        TaskAttempt ta114 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        ((TaskAttempt)Mockito.doReturn((Object)taID114).when((Object)ta114)).getID();
        ((TaskAttempt)Mockito.doReturn((Object)("Mock for TA " + taID114.toString())).when((Object)ta114)).toString();
        AMSchedulerEventTALaunchRequest lrEvent14 = this.createLaunchRequestEvent(taID114, ta114, resource1, host1, racks, priority1, new HashMap<String, LocalResource>());
        drainNotifier.set(false);
        taskSchedulerManager.handleEvent((AMSchedulerEvent)lrEvent11);
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        drainNotifier.set(false);
        taskSchedulerManager.handleEvent((AMSchedulerEvent)lrEvent12);
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        Container container1 = this.createContainer(1, "host1", resource1, priority1);
        Container container2 = this.createContainer(2, "host1", resource1, priority1);
        drainNotifier.set(false);
        taskScheduler.onContainersAllocated(Collections.singletonList(container1));
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        drainableAppCallback.drain();
        ((TaskSchedulerManager)Mockito.verify((Object)taskSchedulerManager)).taskAllocated(Matchers.eq((int)0), Matchers.eq((Object)ta111), Matchers.any(Object.class), (Container)Matchers.eq((Object)container1));
        assignEvent = (AMContainerEventAssignTA)eventHandler.verifyInvocation(AMContainerEventAssignTA.class);
        Assert.assertEquals((long)1L, (long)assignEvent.getRemoteTaskLocalResources().size());
        taskSchedulerManager.handleEvent((AMSchedulerEvent)new AMSchedulerEventTAEnded(ta111, container1.getId(), TaskAttemptState.SUCCEEDED, null, null, 0));
        drainableAppCallback.drain();
        this.verifyDeAllocateTask((TaskScheduler)taskScheduler, ta111, true, null, null);
        ((TaskSchedulerManager)Mockito.verify((Object)taskSchedulerManager)).taskAllocated(Matchers.eq((int)0), Matchers.eq((Object)ta112), Matchers.any(Object.class), (Container)Matchers.eq((Object)container1));
        ((TezAMRMClientAsync)Mockito.verify((Object)rmClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Matchers.eq((Object)container1.getId()));
        eventHandler.verifyNoInvocations(AMContainerEventStopRequest.class);
        assignEvent = (AMContainerEventAssignTA)eventHandler.verifyInvocation(AMContainerEventAssignTA.class);
        Assert.assertEquals((long)1L, (long)assignEvent.getRemoteTaskLocalResources().size());
        eventHandler.reset();
        taskSchedulerManager.handleEvent((AMSchedulerEvent)new AMSchedulerEventTAEnded(ta112, container1.getId(), TaskAttemptState.SUCCEEDED, null, null, 0));
        drainableAppCallback.drain();
        this.verifyDeAllocateTask((TaskScheduler)taskScheduler, ta112, true, null, null);
        ((TezAMRMClientAsync)Mockito.verify((Object)rmClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Matchers.eq((Object)container1.getId()));
        eventHandler.verifyNoInvocations(AMContainerEventStopRequest.class);
        eventHandler.reset();
        drainNotifier.set(false);
        taskSchedulerManager.handleEvent((AMSchedulerEvent)lrEvent13);
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        ((TaskSchedulerManager)Mockito.verify((Object)taskSchedulerManager)).taskAllocated(Matchers.eq((int)0), Matchers.eq((Object)ta113), Matchers.any(Object.class), (Container)Matchers.eq((Object)container1));
        ((TezAMRMClientAsync)Mockito.verify((Object)rmClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Matchers.eq((Object)container1.getId()));
        eventHandler.verifyNoInvocations(AMContainerEventStopRequest.class);
        eventHandler.reset();
        taskSchedulerManager.handleEvent((AMSchedulerEvent)new AMSchedulerEventTAEnded(ta113, container1.getId(), TaskAttemptState.SUCCEEDED, null, null, 0));
        drainableAppCallback.drain();
        this.verifyDeAllocateTask((TaskScheduler)taskScheduler, ta113, true, null, null);
        ((TezAMRMClientAsync)Mockito.verify((Object)rmClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Matchers.eq((Object)container1.getId()));
        eventHandler.verifyNoInvocations(AMContainerEventStopRequest.class);
        eventHandler.reset();
        drainNotifier.set(false);
        taskSchedulerManager.handleEvent((AMSchedulerEvent)lrEvent14);
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        ((TaskSchedulerManager)Mockito.verify((Object)taskSchedulerManager)).taskAllocated(Matchers.eq((int)0), Matchers.eq((Object)ta114), Matchers.any(Object.class), (Container)Matchers.eq((Object)container1));
        ((TezAMRMClientAsync)Mockito.verify((Object)rmClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Matchers.eq((Object)container1.getId()));
        eventHandler.verifyNoInvocations(AMContainerEventStopRequest.class);
        eventHandler.reset();
        taskSchedulerManager.handleEvent((AMSchedulerEvent)new AMSchedulerEventTAEnded(ta114, container1.getId(), TaskAttemptState.SUCCEEDED, null, null, 0));
        drainableAppCallback.drain();
        this.verifyDeAllocateTask((TaskScheduler)taskScheduler, ta114, true, null, null);
        ((TezAMRMClientAsync)Mockito.verify((Object)rmClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Matchers.eq((Object)container1.getId()));
        eventHandler.verifyNoInvocations(AMContainerEventStopRequest.class);
        eventHandler.reset();
        TezDAGID dagID2 = TezDAGID.getInstance((String)"0", (int)2, (int)0);
        dagIDAnswer.setDAGID(dagID2);
        HashMap v21LR = Maps.newHashMap();
        v21LR.put(rsrc1, lr1);
        v21LR.put(rsrc2, lr3);
        TezVertexID vertexID21 = TezVertexID.getInstance((TezDAGID)dagID2, (int)1);
        TezTaskAttemptID taID211 = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexID21, (int)1), (int)1);
        TaskAttempt ta211 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        ((TaskAttempt)Mockito.doReturn((Object)taID211).when((Object)ta211)).getID();
        ((TaskAttempt)Mockito.doReturn((Object)("Mock for TA " + taID211.toString())).when((Object)ta211)).toString();
        AMSchedulerEventTALaunchRequest lrEvent21 = this.createLaunchRequestEvent(taID211, ta211, resource1, host1, racks, priority1, v21LR);
        taskSchedulerManager.handleEvent((AMSchedulerEvent)lrEvent21);
        drainableAppCallback.drain();
        LOG.info("Sleeping to ensure that the scheduling loop runs");
        Thread.sleep(6000L);
        drainNotifier.set(false);
        taskScheduler.onContainersAllocated(Collections.singletonList(container2));
        Thread.sleep(6000L);
        ((TezAMRMClientAsync)Mockito.verify((Object)rmClient, (VerificationMode)Mockito.times((int)1))).releaseAssignedContainer((ContainerId)Matchers.eq((Object)container1.getId()));
        ((TaskSchedulerManager)Mockito.verify((Object)taskSchedulerManager)).taskAllocated(Matchers.eq((int)0), Matchers.eq((Object)ta211), Matchers.any(Object.class), (Container)Matchers.eq((Object)container2));
        eventHandler.reset();
        taskScheduler.shutdown();
        taskSchedulerManager.close();
    }

    @Test(timeout=10000L)
    public void testAssignmentOnShutdown() throws IOException, InterruptedException, ExecutionException {
        AtomicBoolean drainNotifier;
        LOG.info("Test testAssignmentOnShutdown");
        Configuration tezConf = new Configuration((Configuration)new YarnConfiguration());
        tezConf.setBoolean("tez.am.container.reuse.enabled", false);
        tezConf.setBoolean("tez.am.container.reuse.rack-fallback.enabled", true);
        tezConf.setLong("tez.am.container.reuse.locality.delay-allocation-millis", 0L);
        tezConf.setLong("tez.am.container.idle.release-timeout-min.millis", 0L);
        tezConf.setLong("tez.am.container.idle.release-timeout-max.millis", 0L);
        TestTaskSchedulerHelpers.CapturingEventHandler eventHandler = new TestTaskSchedulerHelpers.CapturingEventHandler();
        TezDAGID dagID = TezDAGID.getInstance((String)"0", (int)0, (int)0);
        TestTaskSchedulerHelpers.AMRMClientForTest rmClientCore = new TestTaskSchedulerHelpers.AMRMClientForTest();
        TezAMRMClientAsync rmClient = (TezAMRMClientAsync)Mockito.spy((Object)((Object)new TestTaskSchedulerHelpers.AMRMClientAsyncForTest((AMRMClient<YarnTaskSchedulerService.CookieContainerRequest>)rmClientCore, 100)));
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        ((AppContext)Mockito.doReturn((Object)new Configuration(false)).when((Object)appContext)).getAMConf();
        AMContainerMap amContainerMap = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), appContext);
        AMNodeTracker amNodeTracker = new AMNodeTracker((EventHandler)eventHandler, appContext);
        ((AppContext)Mockito.doReturn((Object)amContainerMap).when((Object)appContext)).getAllContainers();
        ((AppContext)Mockito.doReturn((Object)amNodeTracker).when((Object)appContext)).getNodeTracker();
        ((AppContext)Mockito.doReturn((Object)DAGAppMasterState.SUCCEEDED).when((Object)appContext)).getAMState();
        ((AppContext)Mockito.doReturn((Object)true).when((Object)appContext)).isAMInCompletionState();
        ((AppContext)Mockito.doReturn((Object)dagID).when((Object)appContext)).getCurrentDAGID();
        ((AppContext)Mockito.doReturn((Object)Mockito.mock(ClusterInfo.class)).when((Object)appContext)).getClusterInfo();
        TestTaskSchedulerHelpers.TaskSchedulerManagerForTest taskSchedulerManagerReal = new TestTaskSchedulerHelpers.TaskSchedulerManagerForTest(appContext, eventHandler, (TezAMRMClientAsync<YarnTaskSchedulerService.CookieContainerRequest>)rmClient, new TestTaskSchedulerHelpers.AlwaysMatchesContainerMatcher(), TezUtils.createUserPayloadFromConf((Configuration)tezConf));
        TaskSchedulerManager taskSchedulerManager = (TaskSchedulerManager)Mockito.spy((Object)((Object)taskSchedulerManagerReal));
        taskSchedulerManager.init(tezConf);
        taskSchedulerManager.start();
        TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext taskScheduler = (TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext)((TestTaskSchedulerHelpers.TaskSchedulerManagerForTest)taskSchedulerManager).getSpyTaskScheduler();
        TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback = taskScheduler.getDrainableAppCallback();
        taskScheduler.delayedContainerManager.drainedDelayedContainersForTest = drainNotifier = new AtomicBoolean(false);
        Resource resource1 = Resource.newInstance((int)1024, (int)1);
        String[] host1 = new String[]{"host1"};
        String[] host2 = new String[]{"host2"};
        String[] racks = new String[]{"/default-rack"};
        Priority priority1 = Priority.newInstance((int)1);
        TezVertexID vertexID1 = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezTaskAttemptID taID11 = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexID1, (int)1), (int)1);
        TaskAttempt ta11 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        AMSchedulerEventTALaunchRequest lrEvent1 = this.createLaunchRequestEvent(taID11, ta11, resource1, host1, racks, priority1);
        taskSchedulerManager.handleEvent((AMSchedulerEvent)lrEvent1);
        Container container1 = this.createContainer(1, "host1", resource1, priority1);
        drainNotifier.set(false);
        taskScheduler.onContainersAllocated(Collections.singletonList(container1));
        drainableAppCallback.drain();
        ((TaskSchedulerManager)Mockito.verify((Object)taskSchedulerManager, (VerificationMode)Mockito.times((int)0))).taskAllocated(Matchers.eq((int)0), Matchers.eq((Object)ta11), Matchers.any(Object.class), (Container)Matchers.eq((Object)container1));
        taskScheduler.shutdown();
        taskSchedulerManager.close();
    }

    private Container createContainer(int id, String host, Resource resource, Priority priority) {
        ContainerId containerID = ContainerId.newInstance((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1), (int)id);
        NodeId nodeID = NodeId.newInstance((String)host, (int)0);
        Container container = Container.newInstance((ContainerId)containerID, (NodeId)nodeID, (String)(host + ":0"), (Resource)resource, (Priority)priority, null);
        return container;
    }

    private AMSchedulerEventTALaunchRequest createLaunchRequestEvent(TezTaskAttemptID taID, TaskAttempt ta, Resource capability, String[] hosts, String[] racks, Priority priority, ContainerContext containerContext) {
        TaskLocationHint locationHint = null;
        if (hosts != null || racks != null) {
            HashSet hostsSet = Sets.newHashSet((Object[])hosts);
            HashSet racksSet = Sets.newHashSet((Object[])racks);
            locationHint = TaskLocationHint.createTaskLocationHint((Set)hostsSet, (Set)racksSet);
        }
        AMSchedulerEventTALaunchRequest lr = new AMSchedulerEventTALaunchRequest(taID, capability, new TaskSpec(taID, "dagName", "vertexName", -1, ProcessorDescriptor.create((String)"processorClassName"), Collections.singletonList(new InputSpec("vertexName", InputDescriptor.create((String)"inputClassName"), 1)), Collections.singletonList(new OutputSpec("vertexName", OutputDescriptor.create((String)"outputClassName"), 1)), null, null), ta, locationHint, priority.getPriority(), containerContext, 0, 0, 0);
        return lr;
    }

    private AMSchedulerEventTALaunchRequest createLaunchRequestEvent(TezTaskAttemptID taID, TaskAttempt ta, Resource capability, String[] hosts, String[] racks, Priority priority) {
        return this.createLaunchRequestEvent(taID, ta, capability, hosts, racks, priority, new HashMap<String, LocalResource>());
    }

    private AMSchedulerEventTALaunchRequest createLaunchRequestEvent(TezTaskAttemptID taID, TaskAttempt ta, Resource capability, String[] hosts, String[] racks, Priority priority, Map<String, LocalResource> localResources) {
        return this.createLaunchRequestEvent(taID, ta, capability, hosts, racks, priority, localResources, "");
    }

    private AMSchedulerEventTALaunchRequest createLaunchRequestEvent(TezTaskAttemptID taID, TaskAttempt ta, Resource capability, String[] hosts, String[] racks, Priority priority, Map<String, LocalResource> localResources, String jvmOpts) {
        return this.createLaunchRequestEvent(taID, ta, capability, hosts, racks, priority, new ContainerContext(localResources, new Credentials(), new HashMap(), jvmOpts));
    }

    private void verifyDeAllocateTask(TaskScheduler taskScheduler, Object ta, boolean taskSucceeded, TaskAttemptEndReason endReason, String diagContains) {
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(String.class);
        try {
            ((TaskScheduler)Mockito.verify((Object)taskScheduler)).deallocateTask(Matchers.eq((Object)ta), Matchers.eq((boolean)taskSucceeded), (TaskAttemptEndReason)Matchers.eq((Object)endReason), (String)argumentCaptor.capture());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Assert.assertEquals((long)1L, (long)argumentCaptor.getAllValues().size());
        if (diagContains == null) {
            Assert.assertNull((Object)argumentCaptor.getValue());
        } else {
            Assert.assertTrue((boolean)((String)argumentCaptor.getValue()).contains(diagContains));
        }
    }

    private static class ChangingDAGIDAnswer
    implements Answer<TezDAGID> {
        private TezDAGID dagID;

        public ChangingDAGIDAnswer(TezDAGID dagID) {
            this.dagID = dagID;
        }

        public void setDAGID(TezDAGID dagID) {
            this.dagID = dagID;
        }

        public TezDAGID answer(InvocationOnMock invocation) throws Throwable {
            return this.dagID;
        }
    }
}

