/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api.client.rpc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.tez.common.security.ACLManager;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.client.DAGClientHandler;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolBlockingPBServerImpl;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolRPC;
import org.apache.tez.dag.api.records.DAGProtos;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class TestDAGClientAMProtocolBlockingPBServerImpl {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder(new File("target"));
    @Captor
    private ArgumentCaptor<Map<String, LocalResource>> localResourcesCaptor;

    @Before
    public void init() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test(timeout=5000L)
    public void testSubmitDagInSessionWithLargeDagPlan() throws Exception {
        int maxIPCMsgSize = 1024;
        String dagPlanName = "dagplan-name";
        File requestFile = this.tmpFolder.newFile("request-file");
        TezConfiguration conf = new TezConfiguration();
        conf.setInt("ipc.maximum.data.length", maxIPCMsgSize);
        byte[] randomBytes = new byte[2 * maxIPCMsgSize];
        new Random().nextBytes(randomBytes);
        UserPayload payload = UserPayload.create((ByteBuffer)ByteBuffer.wrap(randomBytes));
        Vertex vertex = Vertex.create((String)"V", (ProcessorDescriptor)((ProcessorDescriptor)ProcessorDescriptor.create((String)"P").setUserPayload(payload)), (int)1);
        DAGProtos.DAGPlan dagPlan = DAG.create((String)dagPlanName).addVertex(vertex).createDag((Configuration)conf, null, null, null, false);
        String lrName = "localResource";
        String scheme = "file";
        String host = "localhost";
        int port = 80;
        String path = "/test";
        URL lrURL = URL.newInstance((String)scheme, (String)host, (int)port, (String)path);
        LocalResource localResource = LocalResource.newInstance((URL)lrURL, (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)1L, (long)1L);
        Map localResources = new HashMap<String, LocalResource>();
        localResources.put(lrName, localResource);
        DAGClientAMProtocolRPC.SubmitDAGRequestProto.Builder requestBuilder = DAGClientAMProtocolRPC.SubmitDAGRequestProto.newBuilder().setDAGPlan(dagPlan).setAdditionalAmResources(DagTypeConverters.convertFromLocalResources(localResources));
        try (FileOutputStream fileOutputStream = new FileOutputStream(requestFile);){
            requestBuilder.build().writeTo((OutputStream)fileOutputStream);
        }
        DAGClientHandler dagClientHandler = (DAGClientHandler)Mockito.mock(DAGClientHandler.class);
        ACLManager aclManager = (ACLManager)Mockito.mock(ACLManager.class);
        DAGClientAMProtocolBlockingPBServerImpl serverImpl = (DAGClientAMProtocolBlockingPBServerImpl)Mockito.spy((Object)new DAGClientAMProtocolBlockingPBServerImpl(dagClientHandler, FileSystem.get((Configuration)conf)));
        Mockito.when((Object)dagClientHandler.getACLManager()).thenReturn((Object)aclManager);
        Mockito.when((Object)dagClientHandler.submitDAG((DAGProtos.DAGPlan)Matchers.any(), (Map)Matchers.any())).thenReturn((Object)"dag-id");
        Mockito.when((Object)aclManager.checkAMModifyAccess((UserGroupInformation)Matchers.any())).thenReturn((Object)true);
        requestBuilder.clear().setSerializedRequestPath(requestFile.getAbsolutePath());
        serverImpl.submitDAG(null, requestBuilder.build());
        ArgumentCaptor dagPlanCaptor = ArgumentCaptor.forClass(DAGProtos.DAGPlan.class);
        ((DAGClientHandler)Mockito.verify((Object)dagClientHandler)).submitDAG((DAGProtos.DAGPlan)dagPlanCaptor.capture(), (Map)this.localResourcesCaptor.capture());
        dagPlan = (DAGProtos.DAGPlan)dagPlanCaptor.getValue();
        localResources = (Map)this.localResourcesCaptor.getValue();
        TestCase.assertEquals((String)dagPlan.getName(), (String)dagPlanName);
        TestCase.assertEquals((int)dagPlan.getVertexCount(), (int)1);
        Assert.assertTrue((dagPlan.getSerializedSize() > maxIPCMsgSize ? 1 : 0) != 0);
        Assert.assertArrayEquals((byte[])randomBytes, (byte[])dagPlan.getVertex(0).getProcessorDescriptor().getTezUserPayload().getUserPayload().toByteArray());
        TestCase.assertEquals((int)localResources.size(), (int)1);
        Assert.assertTrue((boolean)localResources.containsKey(lrName));
        localResource = (LocalResource)localResources.get(lrName);
        TestCase.assertEquals((Object)localResource.getType(), (Object)LocalResourceType.FILE);
        TestCase.assertEquals((Object)localResource.getVisibility(), (Object)LocalResourceVisibility.PUBLIC);
        lrURL = localResource.getResource();
        TestCase.assertEquals((String)lrURL.getScheme(), (String)scheme);
        TestCase.assertEquals((String)lrURL.getHost(), (String)host);
        TestCase.assertEquals((int)lrURL.getPort(), (int)port);
        TestCase.assertEquals((String)lrURL.getFile(), (String)path);
    }
}

