/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm.container;

import com.google.common.collect.Maps;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.tez.common.ContainerSignatureMatcher;
import org.apache.tez.common.security.TokenCache;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ContainerContext;
import org.apache.tez.dag.app.ContainerHeartbeatHandler;
import org.apache.tez.dag.app.TaskCommunicatorManagerInterface;
import org.apache.tez.dag.app.TaskCommunicatorWrapper;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventContainerTerminated;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventContainerTerminatedBySystem;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventContainerTerminating;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventNodeFailed;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventType;
import org.apache.tez.dag.app.rm.AMSchedulerEventType;
import org.apache.tez.dag.app.rm.ContainerLauncherEventType;
import org.apache.tez.dag.app.rm.container.AMContainerEvent;
import org.apache.tez.dag.app.rm.container.AMContainerEventAssignTA;
import org.apache.tez.dag.app.rm.container.AMContainerEventCompleted;
import org.apache.tez.dag.app.rm.container.AMContainerEventLaunchFailed;
import org.apache.tez.dag.app.rm.container.AMContainerEventLaunchRequest;
import org.apache.tez.dag.app.rm.container.AMContainerEventLaunched;
import org.apache.tez.dag.app.rm.container.AMContainerEventNodeFailed;
import org.apache.tez.dag.app.rm.container.AMContainerEventStopRequest;
import org.apache.tez.dag.app.rm.container.AMContainerEventTASucceeded;
import org.apache.tez.dag.app.rm.container.AMContainerEventType;
import org.apache.tez.dag.app.rm.container.AMContainerImpl;
import org.apache.tez.dag.app.rm.container.AMContainerState;
import org.apache.tez.dag.app.rm.container.AMContainerTask;
import org.apache.tez.dag.app.rm.container.ContainerContextMatcher;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.HistoryEventHandler;
import org.apache.tez.dag.records.TaskAttemptTerminationCause;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.apache.tez.serviceplugins.api.ContainerEndReason;
import org.apache.tez.serviceplugins.api.ServicePluginException;
import org.apache.tez.serviceplugins.api.TaskAttemptEndReason;
import org.apache.tez.serviceplugins.api.TaskCommunicator;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestAMContainer {
    @Test(timeout=5000L)
    public void tetSingleSuccessfulTaskFlow() {
        WrappedContainer wc = new WrappedContainer();
        wc.verifyState(AMContainerState.ALLOCATED);
        wc.launchContainer();
        wc.verifyState(AMContainerState.LAUNCHING);
        wc.verifyCountAndGetOutgoingEvents(1);
        ((TaskCommunicatorManagerInterface)Mockito.verify((Object)wc.tal)).registerRunningContainer(wc.containerID, 0);
        Assert.assertNull((Object)wc.amContainer.getCurrentTaskAttempt());
        long currTime = wc.appContext.getClock().getTime();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.verifyState(AMContainerState.LAUNCHING);
        wc.verifyNoOutgoingEvents();
        Assert.assertEquals((Object)wc.taskAttemptID, (Object)wc.amContainer.getCurrentTaskAttempt());
        Assert.assertTrue((wc.amContainer.getCurrentTaskAttemptAllocationTime() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((wc.amContainer.getCurrentTaskAttemptAllocationTime() >= currTime ? 1 : 0) != 0);
        wc.containerLaunched();
        wc.verifyState(AMContainerState.RUNNING);
        wc.verifyNoOutgoingEvents();
        Assert.assertEquals((Object)wc.taskAttemptID, (Object)wc.amContainer.getCurrentTaskAttempt());
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).register((Object)wc.containerID);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(AMContainerTask.class);
        ((TaskCommunicatorManagerInterface)Mockito.verify((Object)wc.tal, (VerificationMode)Mockito.times((int)1))).registerTaskAttempt((AMContainerTask)argumentCaptor.capture(), (ContainerId)Matchers.eq((Object)wc.containerID), Matchers.eq((int)0));
        Assert.assertEquals((long)1L, (long)argumentCaptor.getAllValues().size());
        Assert.assertEquals((Object)wc.taskAttemptID, (Object)((AMContainerTask)argumentCaptor.getAllValues().get(0)).getTask().getTaskAttemptID());
        Assert.assertEquals((long)10L, (long)((AMContainerTask)argumentCaptor.getAllValues().get(0)).getPriority());
        wc.taskAttemptSucceeded(wc.taskAttemptID);
        wc.verifyState(AMContainerState.IDLE);
        wc.verifyNoOutgoingEvents();
        Assert.assertNull((Object)wc.amContainer.getCurrentTaskAttempt());
        this.verifyUnregisterTaskAttempt(wc.tal, wc.taskAttemptID, 0, TaskAttemptEndReason.OTHER, null);
        wc.containerCompleted();
        wc.verifyHistoryStopEvent();
        wc.verifyState(AMContainerState.COMPLETED);
        wc.verifyNoOutgoingEvents();
        this.verifyUnregisterRunningContainer(wc.tal, wc.containerID, 0, ContainerEndReason.COMPLETED, null);
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).unregister((Object)wc.containerID);
        Assert.assertEquals((long)1L, (long)wc.amContainer.getAllTaskAttempts().size());
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
    }

    @Test(timeout=5000L)
    public void testSingleSuccessfulTaskFlow2() {
        WrappedContainer wc = new WrappedContainer();
        wc.verifyState(AMContainerState.ALLOCATED);
        wc.launchContainer();
        wc.verifyState(AMContainerState.LAUNCHING);
        wc.verifyCountAndGetOutgoingEvents(1);
        ((TaskCommunicatorManagerInterface)Mockito.verify((Object)wc.tal)).registerRunningContainer(wc.containerID, 0);
        wc.containerLaunched();
        wc.verifyState(AMContainerState.IDLE);
        wc.verifyNoOutgoingEvents();
        Assert.assertNull((Object)wc.amContainer.getCurrentTaskAttempt());
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).register((Object)wc.containerID);
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.verifyState(AMContainerState.RUNNING);
        wc.verifyNoOutgoingEvents();
        Assert.assertEquals((Object)wc.taskAttemptID, (Object)wc.amContainer.getCurrentTaskAttempt());
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(AMContainerTask.class);
        ((TaskCommunicatorManagerInterface)Mockito.verify((Object)wc.tal, (VerificationMode)Mockito.times((int)1))).registerTaskAttempt((AMContainerTask)argumentCaptor.capture(), (ContainerId)Matchers.eq((Object)wc.containerID), Matchers.eq((int)0));
        Assert.assertEquals((long)1L, (long)argumentCaptor.getAllValues().size());
        Assert.assertEquals((Object)wc.taskAttemptID, (Object)((AMContainerTask)argumentCaptor.getAllValues().get(0)).getTask().getTaskAttemptID());
        wc.taskAttemptSucceeded(wc.taskAttemptID);
        wc.verifyState(AMContainerState.IDLE);
        wc.verifyNoOutgoingEvents();
        Assert.assertNull((Object)wc.amContainer.getCurrentTaskAttempt());
        this.verifyUnregisterTaskAttempt(wc.tal, wc.taskAttemptID, 0, TaskAttemptEndReason.OTHER, null);
        wc.containerCompleted();
        wc.verifyHistoryStopEvent();
        wc.verifyState(AMContainerState.COMPLETED);
        wc.verifyNoOutgoingEvents();
        this.verifyUnregisterRunningContainer(wc.tal, wc.containerID, 0, ContainerEndReason.COMPLETED, null);
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).unregister((Object)wc.containerID);
        Assert.assertEquals((long)1L, (long)wc.amContainer.getAllTaskAttempts().size());
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
    }

    @Test(timeout=5000L)
    public void tetMultipleSuccessfulTaskFlow() {
        WrappedContainer wc = new WrappedContainer();
        wc.verifyState(AMContainerState.ALLOCATED);
        wc.launchContainer();
        wc.verifyState(AMContainerState.LAUNCHING);
        wc.verifyCountAndGetOutgoingEvents(1);
        ((TaskCommunicatorManagerInterface)Mockito.verify((Object)wc.tal)).registerRunningContainer(wc.containerID, 0);
        Assert.assertNull((Object)wc.amContainer.getCurrentTaskAttempt());
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.verifyState(AMContainerState.LAUNCHING);
        wc.verifyNoOutgoingEvents();
        Assert.assertEquals((Object)wc.taskAttemptID, (Object)wc.amContainer.getCurrentTaskAttempt());
        wc.containerLaunched();
        wc.verifyState(AMContainerState.RUNNING);
        wc.verifyNoOutgoingEvents();
        Assert.assertEquals((Object)wc.taskAttemptID, (Object)wc.amContainer.getCurrentTaskAttempt());
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).register((Object)wc.containerID);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(AMContainerTask.class);
        ((TaskCommunicatorManagerInterface)Mockito.verify((Object)wc.tal, (VerificationMode)Mockito.times((int)1))).registerTaskAttempt((AMContainerTask)argumentCaptor.capture(), (ContainerId)Matchers.eq((Object)wc.containerID), Matchers.eq((int)0));
        Assert.assertEquals((long)1L, (long)argumentCaptor.getAllValues().size());
        Assert.assertEquals((Object)wc.taskAttemptID, (Object)((AMContainerTask)argumentCaptor.getAllValues().get(0)).getTask().getTaskAttemptID());
        wc.taskAttemptSucceeded(wc.taskAttemptID);
        wc.verifyState(AMContainerState.IDLE);
        wc.verifyNoOutgoingEvents();
        Assert.assertNull((Object)wc.amContainer.getCurrentTaskAttempt());
        this.verifyUnregisterTaskAttempt(wc.tal, wc.taskAttemptID, 0, TaskAttemptEndReason.OTHER, null);
        TezTaskAttemptID taId2 = TezTaskAttemptID.getInstance((TezTaskID)wc.taskID, (int)2);
        wc.assignTaskAttempt(taId2);
        wc.verifyState(AMContainerState.RUNNING);
        argumentCaptor = ArgumentCaptor.forClass(AMContainerTask.class);
        ((TaskCommunicatorManagerInterface)Mockito.verify((Object)wc.tal, (VerificationMode)Mockito.times((int)2))).registerTaskAttempt((AMContainerTask)argumentCaptor.capture(), (ContainerId)Matchers.eq((Object)wc.containerID), Matchers.eq((int)0));
        Assert.assertEquals((long)2L, (long)argumentCaptor.getAllValues().size());
        Assert.assertEquals((Object)taId2, (Object)((AMContainerTask)argumentCaptor.getAllValues().get(1)).getTask().getTaskAttemptID());
        wc.taskAttemptSucceeded(taId2);
        wc.verifyState(AMContainerState.IDLE);
        wc.verifyNoOutgoingEvents();
        Assert.assertNull((Object)wc.amContainer.getCurrentTaskAttempt());
        this.verifyUnregisterTaskAttempt(wc.tal, wc.taskAttemptID, 0, TaskAttemptEndReason.OTHER, null);
        wc.containerCompleted();
        wc.verifyHistoryStopEvent();
        wc.verifyState(AMContainerState.COMPLETED);
        wc.verifyNoOutgoingEvents();
        this.verifyUnregisterRunningContainer(wc.tal, wc.containerID, 0, ContainerEndReason.COMPLETED, null);
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).unregister((Object)wc.containerID);
        Assert.assertEquals((long)2L, (long)wc.amContainer.getAllTaskAttempts().size());
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
    }

    @Test(timeout=5000L)
    public void testSingleSuccessfulTaskFlowStopRequest() {
        WrappedContainer wc = new WrappedContainer();
        wc.verifyState(AMContainerState.ALLOCATED);
        wc.launchContainer();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.containerLaunched();
        wc.taskAttemptSucceeded(wc.taskAttemptID);
        wc.stopRequest();
        wc.verifyState(AMContainerState.STOP_REQUESTED);
        wc.verifyCountAndGetOutgoingEvents(1);
        Assert.assertTrue((wc.verifyCountAndGetOutgoingEvents(1).get(0).getType() == ContainerLauncherEventType.CONTAINER_STOP_REQUEST ? 1 : 0) != 0);
        wc.nmStopSent();
        wc.verifyState(AMContainerState.STOPPING);
        wc.verifyNoOutgoingEvents();
        wc.containerCompleted();
        wc.verifyHistoryStopEvent();
        wc.verifyState(AMContainerState.COMPLETED);
        wc.verifyNoOutgoingEvents();
        this.verifyUnregisterRunningContainer(wc.tal, wc.containerID, 0, ContainerEndReason.OTHER, "received a STOP_REQUEST");
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).unregister((Object)wc.containerID);
        Assert.assertNull((Object)wc.amContainer.getCurrentTaskAttempt());
        Assert.assertEquals((long)1L, (long)wc.amContainer.getAllTaskAttempts().size());
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
    }

    @Test(timeout=5000L)
    public void testSingleSuccessfulTaskFlowFailedNMStopRequest() {
        WrappedContainer wc = new WrappedContainer();
        wc.verifyState(AMContainerState.ALLOCATED);
        wc.launchContainer();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.containerLaunched();
        wc.taskAttemptSucceeded(wc.taskAttemptID);
        wc.stopRequest();
        wc.verifyState(AMContainerState.STOP_REQUESTED);
        wc.verifyCountAndGetOutgoingEvents(1);
        Assert.assertTrue((wc.verifyCountAndGetOutgoingEvents(1).get(0).getType() == ContainerLauncherEventType.CONTAINER_STOP_REQUEST ? 1 : 0) != 0);
        wc.nmStopFailed();
        wc.verifyState(AMContainerState.STOPPING);
        wc.verifyCountAndGetOutgoingEvents(1);
        Assert.assertTrue((wc.verifyCountAndGetOutgoingEvents(1).get(0).getType() == AMSchedulerEventType.S_CONTAINER_DEALLOCATE ? 1 : 0) != 0);
        wc.containerCompleted();
        wc.verifyHistoryStopEvent();
        wc.verifyState(AMContainerState.COMPLETED);
        wc.verifyNoOutgoingEvents();
        this.verifyUnregisterRunningContainer(wc.tal, wc.containerID, 0, ContainerEndReason.OTHER, "received a STOP_REQUEST");
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).unregister((Object)wc.containerID);
        Assert.assertNull((Object)wc.amContainer.getCurrentTaskAttempt());
        Assert.assertEquals((long)1L, (long)wc.amContainer.getAllTaskAttempts().size());
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
    }

    @Test(timeout=5000L)
    public void testMultipleAllocationsWhileActive() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.containerLaunched();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.verifyState(AMContainerState.RUNNING);
        TezTaskAttemptID taID2 = TezTaskAttemptID.getInstance((TezTaskID)wc.taskID, (int)2);
        wc.assignTaskAttempt(taID2);
        wc.verifyState(AMContainerState.STOP_REQUESTED);
        this.verifyUnregisterRunningContainer(wc.tal, wc.containerID, 0, ContainerEndReason.FRAMEWORK_ERROR, "Multiple simultaneous taskAttempt");
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).unregister((Object)wc.containerID);
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(3);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{ContainerLauncherEventType.CONTAINER_STOP_REQUEST, TaskAttemptEventType.TA_CONTAINER_TERMINATING, TaskAttemptEventType.TA_CONTAINER_TERMINATING});
        Assert.assertTrue((boolean)wc.amContainer.isInErrorState());
        wc.nmStopSent();
        wc.containerCompleted();
        wc.verifyHistoryStopEvent();
        outgoingEvents = wc.verifyCountAndGetOutgoingEvents(2);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATED, TaskAttemptEventType.TA_CONTAINER_TERMINATED});
        Assert.assertNull((Object)wc.amContainer.getCurrentTaskAttempt());
        Assert.assertEquals((long)2L, (long)wc.amContainer.getAllTaskAttempts().size());
    }

    @Test(timeout=5000L)
    public void testMultipleAllocationsAtLaunching() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.verifyState(AMContainerState.LAUNCHING);
        ((TaskCommunicatorManagerInterface)Mockito.verify((Object)wc.tal)).registerRunningContainer(wc.containerID, 0);
        TezTaskAttemptID taID2 = TezTaskAttemptID.getInstance((TezTaskID)wc.taskID, (int)2);
        wc.assignTaskAttempt(taID2);
        wc.verifyState(AMContainerState.STOP_REQUESTED);
        this.verifyUnregisterRunningContainer(wc.tal, wc.containerID, 0, ContainerEndReason.FRAMEWORK_ERROR, "Multiple simultaneous taskAttempt");
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).unregister((Object)wc.containerID);
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(3);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{ContainerLauncherEventType.CONTAINER_STOP_REQUEST, TaskAttemptEventType.TA_CONTAINER_TERMINATING, TaskAttemptEventType.TA_CONTAINER_TERMINATING});
        Assert.assertTrue((boolean)wc.amContainer.isInErrorState());
        wc.nmStopSent();
        wc.containerCompleted();
        wc.verifyHistoryStopEvent();
        outgoingEvents = wc.verifyCountAndGetOutgoingEvents(2);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATED, TaskAttemptEventType.TA_CONTAINER_TERMINATED});
        Assert.assertNull((Object)wc.amContainer.getCurrentTaskAttempt());
        Assert.assertEquals((long)2L, (long)wc.amContainer.getAllTaskAttempts().size());
    }

    @Test(timeout=5000L)
    public void testContainerTimedOutAtRunning() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.containerLaunched();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.verifyState(AMContainerState.RUNNING);
        wc.containerTimedOut();
        wc.verifyState(AMContainerState.STOP_REQUESTED);
        this.verifyUnregisterRunningContainer(wc.tal, wc.containerID, 0, ContainerEndReason.OTHER, "timed out");
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).unregister((Object)wc.containerID);
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(2);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATING, ContainerLauncherEventType.CONTAINER_STOP_REQUEST});
        wc.containerCompleted();
        wc.verifyHistoryStopEvent();
        outgoingEvents = wc.verifyCountAndGetOutgoingEvents(1);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATED});
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
        Assert.assertNull((Object)wc.amContainer.getCurrentTaskAttempt());
        Assert.assertEquals((long)1L, (long)wc.amContainer.getAllTaskAttempts().size());
    }

    @Test(timeout=5000L)
    public void testStopRequestedAtRunning() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.containerLaunched();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.verifyState(AMContainerState.RUNNING);
        wc.stopRequest();
        wc.verifyState(AMContainerState.STOP_REQUESTED);
        this.verifyUnregisterRunningContainer(wc.tal, wc.containerID, 0, ContainerEndReason.OTHER, "received a STOP_REQUEST");
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).unregister((Object)wc.containerID);
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(2);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATING, ContainerLauncherEventType.CONTAINER_STOP_REQUEST});
        wc.containerCompleted();
        wc.verifyHistoryStopEvent();
        outgoingEvents = wc.verifyCountAndGetOutgoingEvents(1);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATED});
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
        Assert.assertNull((Object)wc.amContainer.getCurrentTaskAttempt());
        Assert.assertEquals((long)1L, (long)wc.amContainer.getAllTaskAttempts().size());
    }

    @Test(timeout=5000L)
    public void testLaunchFailure() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.verifyState(AMContainerState.LAUNCHING);
        ((TaskCommunicatorManagerInterface)Mockito.verify((Object)wc.tal)).registerRunningContainer(wc.containerID, 0);
        wc.launchFailed();
        wc.verifyState(AMContainerState.STOPPING);
        ((TaskCommunicatorManagerInterface)Mockito.verify((Object)wc.tal)).registerRunningContainer(wc.containerID, 0);
        this.verifyUnregisterRunningContainer(wc.tal, wc.containerID, 0, ContainerEndReason.LAUNCH_FAILED, "launchFailed");
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(2);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATING, AMSchedulerEventType.S_CONTAINER_DEALLOCATE});
        for (Event e : outgoingEvents) {
            if (e.getType() != TaskAttemptEventType.TA_CONTAINER_TERMINATING) continue;
            Assert.assertEquals((Object)TaskAttemptTerminationCause.CONTAINER_LAUNCH_FAILED, (Object)((TaskAttemptEventContainerTerminating)e).getTerminationCause());
        }
        wc.containerCompleted();
        outgoingEvents = wc.verifyCountAndGetOutgoingEvents(1);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATED});
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
    }

    @Test(timeout=5000L)
    public void testContainerCompletedAtAllocated() {
        WrappedContainer wc = new WrappedContainer();
        wc.verifyState(AMContainerState.ALLOCATED);
        wc.containerCompleted();
        wc.verifyState(AMContainerState.COMPLETED);
        wc.verifyNoOutgoingEvents();
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
    }

    @Test(timeout=5000L)
    public void testContainerCompletedAtLaunching() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.containerCompleted();
        wc.verifyState(AMContainerState.COMPLETED);
        ((TaskCommunicatorManagerInterface)Mockito.verify((Object)wc.tal)).registerRunningContainer(wc.containerID, 0);
        this.verifyUnregisterRunningContainer(wc.tal, wc.containerID, 0, ContainerEndReason.COMPLETED, null);
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(1);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATED});
        Assert.assertEquals((Object)TaskAttemptTerminationCause.CONTAINER_LAUNCH_FAILED, (Object)((TaskAttemptEventContainerTerminated)outgoingEvents.get(0)).getTerminationCause());
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
        wc.containerLaunched();
        wc.verifyNoOutgoingEvents();
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
    }

    @Test(timeout=5000L)
    public void testContainerCompletedAtLaunchingSpecificClusterError() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.containerCompleted(-101, TaskAttemptTerminationCause.NODE_DISK_ERROR, "DiskFailed");
        wc.verifyState(AMContainerState.COMPLETED);
        ((TaskCommunicatorManagerInterface)Mockito.verify((Object)wc.tal)).registerRunningContainer(wc.containerID, 0);
        this.verifyUnregisterRunningContainer(wc.tal, wc.containerID, 0, ContainerEndReason.OTHER, "DiskFailed");
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(1);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATED_BY_SYSTEM});
        Assert.assertEquals((Object)TaskAttemptTerminationCause.NODE_DISK_ERROR, (Object)((TaskAttemptEventContainerTerminatedBySystem)outgoingEvents.get(0)).getTerminationCause());
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
        wc.containerLaunched();
        wc.verifyNoOutgoingEvents();
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
    }

    @Test(timeout=5000L)
    public void testContainerCompletedAtLaunchingSpecificError() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.containerCompleted(-100, TaskAttemptTerminationCause.NODE_FAILED, "NodeFailed");
        wc.verifyState(AMContainerState.COMPLETED);
        ((TaskCommunicatorManagerInterface)Mockito.verify((Object)wc.tal)).registerRunningContainer(wc.containerID, 0);
        this.verifyUnregisterRunningContainer(wc.tal, wc.containerID, 0, ContainerEndReason.NODE_FAILED, "NodeFailed");
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(1);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATED});
        Assert.assertEquals((Object)TaskAttemptTerminationCause.NODE_FAILED, (Object)((TaskAttemptEventContainerTerminated)outgoingEvents.get(0)).getTerminationCause());
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
        wc.containerLaunched();
        wc.verifyNoOutgoingEvents();
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
    }

    @Test(timeout=5000L)
    public void testContainerCompletedAtIdle() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.containerLaunched();
        wc.verifyState(AMContainerState.IDLE);
        wc.containerCompleted();
        wc.verifyState(AMContainerState.COMPLETED);
        ((TaskCommunicatorManagerInterface)Mockito.verify((Object)wc.tal)).registerRunningContainer(wc.containerID, 0);
        this.verifyUnregisterRunningContainer(wc.tal, wc.containerID, 0, ContainerEndReason.COMPLETED, null);
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).register((Object)wc.containerID);
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).unregister((Object)wc.containerID);
        wc.verifyCountAndGetOutgoingEvents(0);
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
        wc.verifyNoOutgoingEvents();
        wc.verifyHistoryStopEvent();
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
    }

    @Test(timeout=5000L)
    public void testContainerCompletedAtRunning() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.containerLaunched();
        wc.verifyState(AMContainerState.RUNNING);
        wc.containerCompleted();
        wc.verifyState(AMContainerState.COMPLETED);
        ((TaskCommunicatorManagerInterface)Mockito.verify((Object)wc.tal)).registerRunningContainer(wc.containerID, 0);
        this.verifyUnregisterRunningContainer(wc.tal, wc.containerID, 0, ContainerEndReason.COMPLETED, null);
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).register((Object)wc.containerID);
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).unregister((Object)wc.containerID);
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(1);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATED});
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
        wc.taskAttemptSucceeded(wc.taskAttemptID);
        wc.verifyNoOutgoingEvents();
        wc.verifyHistoryStopEvent();
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
    }

    @Test(timeout=5000L)
    public void testContainerPreemptedAtRunning() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.containerLaunched();
        wc.verifyState(AMContainerState.RUNNING);
        wc.containerCompleted(-102, TaskAttemptTerminationCause.EXTERNAL_PREEMPTION, "Container preempted externally");
        wc.verifyState(AMContainerState.COMPLETED);
        ((TaskCommunicatorManagerInterface)Mockito.verify((Object)wc.tal)).registerRunningContainer(wc.containerID, 0);
        this.verifyUnregisterRunningContainer(wc.tal, wc.containerID, 0, ContainerEndReason.EXTERNAL_PREEMPTION, "Container preempted externally");
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).register((Object)wc.containerID);
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).unregister((Object)wc.containerID);
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(1);
        Assert.assertEquals((Object)TaskAttemptTerminationCause.EXTERNAL_PREEMPTION, (Object)((TaskAttemptEventContainerTerminatedBySystem)outgoingEvents.get(0)).getTerminationCause());
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATED_BY_SYSTEM});
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
        wc.taskAttemptSucceeded(wc.taskAttemptID);
        wc.verifyNoOutgoingEvents();
        wc.verifyHistoryStopEvent();
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
    }

    @Test(timeout=5000L)
    public void testContainerInternallyPreemptedAtRunning() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.containerLaunched();
        wc.verifyState(AMContainerState.RUNNING);
        wc.containerCompleted(-1000, TaskAttemptTerminationCause.INTERNAL_PREEMPTION, "Container preempted internally");
        wc.verifyState(AMContainerState.COMPLETED);
        ((TaskCommunicatorManagerInterface)Mockito.verify((Object)wc.tal)).registerRunningContainer(wc.containerID, 0);
        this.verifyUnregisterRunningContainer(wc.tal, wc.containerID, 0, ContainerEndReason.INTERNAL_PREEMPTION, "Container preempted internally");
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).register((Object)wc.containerID);
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).unregister((Object)wc.containerID);
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(1);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATED_BY_SYSTEM});
        Assert.assertEquals((Object)TaskAttemptTerminationCause.INTERNAL_PREEMPTION, (Object)((TaskAttemptEventContainerTerminatedBySystem)outgoingEvents.get(0)).getTerminationCause());
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
        wc.taskAttemptSucceeded(wc.taskAttemptID);
        wc.verifyNoOutgoingEvents();
        wc.verifyHistoryStopEvent();
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
    }

    @Test(timeout=5000L)
    public void testContainerDiskFailedAtRunning() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.containerLaunched();
        wc.verifyState(AMContainerState.RUNNING);
        wc.containerCompleted(-101, TaskAttemptTerminationCause.NODE_DISK_ERROR, "NodeDiskError");
        wc.verifyState(AMContainerState.COMPLETED);
        ((TaskCommunicatorManagerInterface)Mockito.verify((Object)wc.tal)).registerRunningContainer(wc.containerID, 0);
        this.verifyUnregisterRunningContainer(wc.tal, wc.containerID, 0, ContainerEndReason.OTHER, "NodeDiskError");
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).register((Object)wc.containerID);
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).unregister((Object)wc.containerID);
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(1);
        Assert.assertEquals((Object)TaskAttemptTerminationCause.NODE_DISK_ERROR, (Object)((TaskAttemptEventContainerTerminatedBySystem)outgoingEvents.get(0)).getTerminationCause());
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATED_BY_SYSTEM});
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
        wc.taskAttemptSucceeded(wc.taskAttemptID);
        wc.verifyNoOutgoingEvents();
        wc.verifyHistoryStopEvent();
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
    }

    @Test(timeout=5000L)
    public void testTaskAssignedToCompletedContainer() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.containerLaunched();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.taskAttemptSucceeded(wc.taskAttemptID);
        wc.containerCompleted();
        wc.verifyState(AMContainerState.COMPLETED);
        TezTaskAttemptID taID2 = TezTaskAttemptID.getInstance((TezTaskID)wc.taskID, (int)2);
        wc.assignTaskAttempt(taID2);
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(1);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATED});
        TaskAttemptEventContainerTerminated ctEvent = (TaskAttemptEventContainerTerminated)outgoingEvents.get(0);
        Assert.assertEquals((Object)taID2, (Object)ctEvent.getTaskAttemptID());
        wc.verifyHistoryStopEvent();
        Assert.assertTrue((boolean)wc.amContainer.isInErrorState());
    }

    @Test(timeout=5000L)
    public void testNodeFailedAtRunning() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.containerLaunched();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.verifyState(AMContainerState.RUNNING);
        wc.nodeFailed();
        wc.verifyState(AMContainerState.STOPPING);
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(3);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_NODE_FAILED, TaskAttemptEventType.TA_CONTAINER_TERMINATING, AMSchedulerEventType.S_CONTAINER_DEALLOCATE});
        for (Event event : outgoingEvents) {
            if (event.getType() != TaskAttemptEventType.TA_NODE_FAILED) continue;
            TaskAttemptEventNodeFailed nfEvent = (TaskAttemptEventNodeFailed)event;
            Assert.assertTrue((boolean)nfEvent.getDiagnosticInfo().contains("nodeFailed"));
        }
        wc.containerCompleted();
        wc.verifyHistoryStopEvent();
        outgoingEvents = wc.verifyCountAndGetOutgoingEvents(1);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATED});
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
    }

    @Test(timeout=5000L)
    public void testNodeFailedAtIdleMultipleAttempts() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.containerLaunched();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.taskAttemptSucceeded(wc.taskAttemptID);
        wc.verifyState(AMContainerState.IDLE);
        TezTaskAttemptID taID2 = TezTaskAttemptID.getInstance((TezTaskID)wc.taskID, (int)2);
        wc.assignTaskAttempt(taID2);
        wc.taskAttemptSucceeded(taID2);
        wc.verifyState(AMContainerState.IDLE);
        wc.nodeFailed();
        wc.verifyState(AMContainerState.STOPPING);
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(3);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_NODE_FAILED, TaskAttemptEventType.TA_NODE_FAILED, AMSchedulerEventType.S_CONTAINER_DEALLOCATE});
        for (Event event : outgoingEvents) {
            if (event.getType() != TaskAttemptEventType.TA_NODE_FAILED) continue;
            TaskAttemptEventNodeFailed nfEvent = (TaskAttemptEventNodeFailed)event;
            Assert.assertTrue((boolean)nfEvent.getDiagnosticInfo().contains("nodeFailed"));
        }
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
        wc.containerCompleted();
        wc.verifyNoOutgoingEvents();
        wc.verifyHistoryStopEvent();
        Assert.assertNull((Object)wc.amContainer.getCurrentTaskAttempt());
        Assert.assertEquals((long)2L, (long)wc.amContainer.getAllTaskAttempts().size());
    }

    @Test(timeout=5000L)
    public void testNodeFailedAtRunningMultipleAttempts() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.containerLaunched();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.taskAttemptSucceeded(wc.taskAttemptID);
        TezTaskAttemptID taID2 = TezTaskAttemptID.getInstance((TezTaskID)wc.taskID, (int)2);
        wc.assignTaskAttempt(taID2);
        wc.verifyState(AMContainerState.RUNNING);
        wc.nodeFailed();
        wc.verifyState(AMContainerState.STOPPING);
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(4);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_NODE_FAILED, TaskAttemptEventType.TA_NODE_FAILED, TaskAttemptEventType.TA_CONTAINER_TERMINATING, AMSchedulerEventType.S_CONTAINER_DEALLOCATE});
        for (Event event : outgoingEvents) {
            if (event.getType() != TaskAttemptEventType.TA_NODE_FAILED) continue;
            TaskAttemptEventNodeFailed nfEvent = (TaskAttemptEventNodeFailed)event;
            Assert.assertTrue((boolean)nfEvent.getDiagnosticInfo().contains("nodeFailed"));
        }
        wc.containerCompleted();
        wc.verifyHistoryStopEvent();
        outgoingEvents = wc.verifyCountAndGetOutgoingEvents(1);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATED});
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
        Assert.assertNull((Object)wc.amContainer.getCurrentTaskAttempt());
        Assert.assertEquals((long)2L, (long)wc.amContainer.getAllTaskAttempts().size());
    }

    @Test(timeout=5000L)
    public void testNodeFailedAtCompletedMultipleSuccessfulTAs() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.containerLaunched();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.taskAttemptSucceeded(wc.taskAttemptID);
        TezTaskAttemptID taID2 = TezTaskAttemptID.getInstance((TezTaskID)wc.taskID, (int)2);
        wc.assignTaskAttempt(taID2);
        wc.taskAttemptSucceeded(taID2);
        wc.stopRequest();
        wc.nmStopSent();
        wc.containerCompleted();
        wc.verifyState(AMContainerState.COMPLETED);
        wc.nodeFailed();
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(2);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_NODE_FAILED, TaskAttemptEventType.TA_NODE_FAILED});
        Assert.assertNull((Object)wc.amContainer.getCurrentTaskAttempt());
        Assert.assertEquals((long)2L, (long)wc.amContainer.getAllTaskAttempts().size());
    }

    @Test(timeout=5000L)
    public void testDuplicateCompletedEvents() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.containerLaunched();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.taskAttemptSucceeded(wc.taskAttemptID);
        TezTaskAttemptID taID2 = TezTaskAttemptID.getInstance((TezTaskID)wc.taskID, (int)2);
        wc.assignTaskAttempt(taID2);
        wc.taskAttemptSucceeded(taID2);
        wc.stopRequest();
        wc.nmStopSent();
        wc.containerCompleted();
        wc.verifyState(AMContainerState.COMPLETED);
        wc.verifyNoOutgoingEvents();
        wc.containerCompleted();
        wc.verifyNoOutgoingEvents();
        wc.verifyHistoryStopEvent();
    }

    @Test(timeout=5000L)
    public void testLocalResourceAddition() {
        WrappedContainer wc = new WrappedContainer();
        String rsrc1 = "rsrc1";
        String rsrc2 = "rsrc2";
        String rsrc3 = "rsrc3";
        HashMap initialResources = Maps.newHashMap();
        initialResources.put(rsrc1, this.createLocalResource(rsrc1));
        wc.launchContainer(initialResources, new Credentials());
        wc.containerLaunched();
        wc.assignTaskAttempt(wc.taskAttemptID);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(AMContainerTask.class);
        ((TaskCommunicatorManagerInterface)Mockito.verify((Object)wc.tal, (VerificationMode)Mockito.times((int)1))).registerTaskAttempt((AMContainerTask)argumentCaptor.capture(), (ContainerId)Matchers.eq((Object)wc.containerID), Matchers.eq((int)0));
        AMContainerTask task1 = (AMContainerTask)argumentCaptor.getAllValues().get(0);
        Assert.assertEquals((long)0L, (long)task1.getAdditionalResources().size());
        wc.taskAttemptSucceeded(wc.taskAttemptID);
        HashMap additionalResources = Maps.newHashMap();
        additionalResources.put(rsrc2, this.createLocalResource(rsrc2));
        additionalResources.put(rsrc3, this.createLocalResource(rsrc3));
        TezTaskAttemptID taID2 = TezTaskAttemptID.getInstance((TezTaskID)wc.taskID, (int)2);
        wc.assignTaskAttempt(taID2, additionalResources, new Credentials());
        argumentCaptor = ArgumentCaptor.forClass(AMContainerTask.class);
        ((TaskCommunicatorManagerInterface)Mockito.verify((Object)wc.tal, (VerificationMode)Mockito.times((int)2))).registerTaskAttempt((AMContainerTask)argumentCaptor.capture(), (ContainerId)Matchers.eq((Object)wc.containerID), Matchers.eq((int)0));
        AMContainerTask task2 = (AMContainerTask)argumentCaptor.getAllValues().get(1);
        Map pullTaskAdditionalResources = task2.getAdditionalResources();
        Assert.assertEquals((long)2L, (long)pullTaskAdditionalResources.size());
        pullTaskAdditionalResources.remove(rsrc2);
        pullTaskAdditionalResources.remove(rsrc3);
        Assert.assertEquals((long)0L, (long)pullTaskAdditionalResources.size());
        wc.taskAttemptSucceeded(taID2);
        HashMap containerLRs = new HashMap(wc.amContainer.containerLocalResources);
        Assert.assertEquals((long)3L, (long)containerLRs.size());
        containerLRs.remove(rsrc1);
        containerLRs.remove(rsrc2);
        containerLRs.remove(rsrc3);
        Assert.assertEquals((long)0L, (long)containerLRs.size());
        TezTaskAttemptID taID3 = TezTaskAttemptID.getInstance((TezTaskID)wc.taskID, (int)3);
        wc.assignTaskAttempt(taID3, new HashMap<String, LocalResource>(), new Credentials());
        argumentCaptor = ArgumentCaptor.forClass(AMContainerTask.class);
        ((TaskCommunicatorManagerInterface)Mockito.verify((Object)wc.tal, (VerificationMode)Mockito.times((int)3))).registerTaskAttempt((AMContainerTask)argumentCaptor.capture(), (ContainerId)Matchers.eq((Object)wc.containerID), Matchers.eq((int)0));
        AMContainerTask task3 = (AMContainerTask)argumentCaptor.getAllValues().get(2);
        Assert.assertEquals((long)0L, (long)task3.getAdditionalResources().size());
        wc.taskAttemptSucceeded(taID3);
        wc.containerCompleted();
        Assert.assertNull((Object)wc.amContainer.containerLocalResources);
        Assert.assertNull((Object)wc.amContainer.additionalLocalResources);
    }

    @Test(timeout=5000L)
    public void testCredentialsTransfer() {
        WrappedContainerMultipleDAGs wc = new WrappedContainerMultipleDAGs();
        TezDAGID dagID2 = TezDAGID.getInstance((String)"800", (int)500, (int)2);
        TezDAGID dagID3 = TezDAGID.getInstance((String)"800", (int)500, (int)3);
        TezVertexID vertexID2 = TezVertexID.getInstance((TezDAGID)dagID2, (int)1);
        TezVertexID vertexID3 = TezVertexID.getInstance((TezDAGID)dagID3, (int)1);
        TezTaskID taskID2 = TezTaskID.getInstance((TezVertexID)vertexID2, (int)1);
        TezTaskID taskID3 = TezTaskID.getInstance((TezVertexID)vertexID3, (int)1);
        TezTaskAttemptID attempt11 = TezTaskAttemptID.getInstance((TezTaskID)wc.taskID, (int)200);
        TezTaskAttemptID attempt12 = TezTaskAttemptID.getInstance((TezTaskID)wc.taskID, (int)300);
        TezTaskAttemptID attempt21 = TezTaskAttemptID.getInstance((TezTaskID)taskID2, (int)200);
        TezTaskAttemptID attempt22 = TezTaskAttemptID.getInstance((TezTaskID)taskID2, (int)300);
        TezTaskAttemptID attempt31 = TezTaskAttemptID.getInstance((TezTaskID)taskID3, (int)200);
        TezTaskAttemptID attempt32 = TezTaskAttemptID.getInstance((TezTaskID)taskID3, (int)300);
        HashMap<String, LocalResource> LRs = new HashMap<String, LocalResource>();
        AMContainerTask fetchedTask = null;
        ArgumentCaptor argumentCaptor = null;
        Token amGenToken = (Token)Mockito.mock(Token.class);
        Token token1 = (Token)Mockito.mock(Token.class);
        Token token3 = (Token)Mockito.mock(Token.class);
        Credentials containerCredentials = new Credentials();
        TokenCache.setSessionToken((Token)amGenToken, (Credentials)containerCredentials);
        Text token1Name = new Text("tokenDag1");
        Text token3Name = new Text("tokenDag3");
        Credentials dag1Credentials = new Credentials();
        dag1Credentials.addToken(new Text(token1Name), token1);
        Credentials dag3Credentials = new Credentials();
        dag3Credentials.addToken(new Text(token3Name), token3);
        wc.launchContainer(new HashMap<String, LocalResource>(), containerCredentials);
        wc.containerLaunched();
        wc.assignTaskAttempt(attempt11, LRs, dag1Credentials);
        argumentCaptor = ArgumentCaptor.forClass(AMContainerTask.class);
        ((TaskCommunicatorManagerInterface)Mockito.verify((Object)wc.tal, (VerificationMode)Mockito.times((int)1))).registerTaskAttempt((AMContainerTask)argumentCaptor.capture(), (ContainerId)Matchers.eq((Object)wc.containerID), Matchers.eq((int)0));
        fetchedTask = (AMContainerTask)argumentCaptor.getAllValues().get(0);
        Assert.assertTrue((boolean)fetchedTask.haveCredentialsChanged());
        Assert.assertNotNull((Object)fetchedTask.getCredentials());
        Assert.assertNotNull((Object)fetchedTask.getCredentials().getToken(token1Name));
        wc.taskAttemptSucceeded(attempt11);
        wc.assignTaskAttempt(attempt12, LRs, dag1Credentials);
        argumentCaptor = ArgumentCaptor.forClass(AMContainerTask.class);
        ((TaskCommunicatorManagerInterface)Mockito.verify((Object)wc.tal, (VerificationMode)Mockito.times((int)2))).registerTaskAttempt((AMContainerTask)argumentCaptor.capture(), (ContainerId)Matchers.eq((Object)wc.containerID), Matchers.eq((int)0));
        fetchedTask = (AMContainerTask)argumentCaptor.getAllValues().get(1);
        Assert.assertFalse((boolean)fetchedTask.haveCredentialsChanged());
        Assert.assertNull((Object)fetchedTask.getCredentials());
        wc.taskAttemptSucceeded(attempt12);
        wc.setNewDAGID(dagID2);
        wc.assignTaskAttempt(attempt21, LRs, null);
        argumentCaptor = ArgumentCaptor.forClass(AMContainerTask.class);
        ((TaskCommunicatorManagerInterface)Mockito.verify((Object)wc.tal, (VerificationMode)Mockito.times((int)3))).registerTaskAttempt((AMContainerTask)argumentCaptor.capture(), (ContainerId)Matchers.eq((Object)wc.containerID), Matchers.eq((int)0));
        fetchedTask = (AMContainerTask)argumentCaptor.getAllValues().get(2);
        Assert.assertTrue((boolean)fetchedTask.haveCredentialsChanged());
        Assert.assertNull((Object)fetchedTask.getCredentials());
        wc.taskAttemptSucceeded(attempt21);
        wc.assignTaskAttempt(attempt22, LRs, null);
        argumentCaptor = ArgumentCaptor.forClass(AMContainerTask.class);
        ((TaskCommunicatorManagerInterface)Mockito.verify((Object)wc.tal, (VerificationMode)Mockito.times((int)4))).registerTaskAttempt((AMContainerTask)argumentCaptor.capture(), (ContainerId)Matchers.eq((Object)wc.containerID), Matchers.eq((int)0));
        fetchedTask = (AMContainerTask)argumentCaptor.getAllValues().get(3);
        Assert.assertFalse((boolean)fetchedTask.haveCredentialsChanged());
        Assert.assertNull((Object)fetchedTask.getCredentials());
        wc.taskAttemptSucceeded(attempt22);
        wc.setNewDAGID(dagID3);
        wc.assignTaskAttempt(attempt31, LRs, dag3Credentials);
        argumentCaptor = ArgumentCaptor.forClass(AMContainerTask.class);
        ((TaskCommunicatorManagerInterface)Mockito.verify((Object)wc.tal, (VerificationMode)Mockito.times((int)5))).registerTaskAttempt((AMContainerTask)argumentCaptor.capture(), (ContainerId)Matchers.eq((Object)wc.containerID), Matchers.eq((int)0));
        fetchedTask = (AMContainerTask)argumentCaptor.getAllValues().get(4);
        Assert.assertTrue((boolean)fetchedTask.haveCredentialsChanged());
        Assert.assertNotNull((Object)fetchedTask.getCredentials());
        Assert.assertNotNull((Object)fetchedTask.getCredentials().getToken(token3Name));
        Assert.assertNull((Object)fetchedTask.getCredentials().getToken(token1Name));
        wc.taskAttemptSucceeded(attempt31);
        wc.assignTaskAttempt(attempt32, LRs, dag1Credentials);
        argumentCaptor = ArgumentCaptor.forClass(AMContainerTask.class);
        ((TaskCommunicatorManagerInterface)Mockito.verify((Object)wc.tal, (VerificationMode)Mockito.times((int)6))).registerTaskAttempt((AMContainerTask)argumentCaptor.capture(), (ContainerId)Matchers.eq((Object)wc.containerID), Matchers.eq((int)0));
        fetchedTask = (AMContainerTask)argumentCaptor.getAllValues().get(5);
        Assert.assertFalse((boolean)fetchedTask.haveCredentialsChanged());
        Assert.assertNull((Object)fetchedTask.getCredentials());
        wc.taskAttemptSucceeded(attempt32);
    }

    private void verifyUnOrderedOutgoingEventTypes(List<Event> events, Enum<?> ... expectedTypes) {
        LinkedList expectedTypeList = new LinkedList();
        for (Enum<?> expectedType : expectedTypes) {
            expectedTypeList.add(expectedType);
        }
        LinkedList<Event> eventsCopy = new LinkedList<Event>(events);
        Iterator expectedTypeIterator = expectedTypeList.iterator();
        block1: while (expectedTypeIterator.hasNext()) {
            Enum expectedType = (Enum)expectedTypeIterator.next();
            Iterator iter = eventsCopy.iterator();
            while (iter.hasNext()) {
                Event e = (Event)iter.next();
                if (e.getType() != expectedType) continue;
                iter.remove();
                expectedTypeIterator.remove();
                continue block1;
            }
        }
        Assert.assertTrue((String)("Did not find types : " + expectedTypeList + " in outgoing event list"), (boolean)expectedTypeList.isEmpty());
        Assert.assertTrue((String)("Found unexpected events: " + eventsCopy + " in outgoing event list"), (boolean)eventsCopy.isEmpty());
    }

    private LocalResource createLocalResource(String name) {
        LocalResource lr = LocalResource.newInstance((URL)URL.newInstance(null, (String)"localhost", (int)2321, (String)name), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.APPLICATION, (long)1L, (long)1000000L);
        return lr;
    }

    private void verifyUnregisterRunningContainer(TaskCommunicatorManagerInterface tal, ContainerId containerId, int taskCommId, ContainerEndReason containerEndReason, String diagContains) {
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(String.class);
        ((TaskCommunicatorManagerInterface)Mockito.verify((Object)tal)).unregisterRunningContainer((ContainerId)Matchers.eq((Object)containerId), Matchers.eq((int)taskCommId), (ContainerEndReason)Matchers.eq((Object)containerEndReason), (String)argumentCaptor.capture());
        Assert.assertEquals((long)1L, (long)argumentCaptor.getAllValues().size());
        if (diagContains != null) {
            Assert.assertTrue((boolean)((String)argumentCaptor.getValue()).contains(diagContains));
        } else {
            Assert.assertNull((Object)argumentCaptor.getValue());
        }
    }

    private void verifyUnregisterTaskAttempt(TaskCommunicatorManagerInterface tal, TezTaskAttemptID taId, int taskCommId, TaskAttemptEndReason endReason, String diagContains) {
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(String.class);
        ((TaskCommunicatorManagerInterface)Mockito.verify((Object)tal)).unregisterTaskAttempt((TezTaskAttemptID)Matchers.eq((Object)taId), Matchers.eq((int)taskCommId), (TaskAttemptEndReason)Matchers.eq((Object)endReason), (String)argumentCaptor.capture());
        Assert.assertEquals((long)1L, (long)argumentCaptor.getAllValues().size());
        if (diagContains != null) {
            Assert.assertTrue((boolean)((String)argumentCaptor.getValue()).contains(diagContains));
        } else {
            Assert.assertNull((Object)argumentCaptor.getValue());
        }
    }

    private static class WrappedContainerMultipleDAGs
    extends WrappedContainer {
        private TezDAGID newDAGID = null;

        private WrappedContainerMultipleDAGs() {
        }

        @Override
        protected void mockDAGID() {
            ((AppContext)Mockito.doAnswer((Answer)new Answer<TezDAGID>(){

                public TezDAGID answer(InvocationOnMock invocation) throws Throwable {
                    return WrappedContainerMultipleDAGs.this.newDAGID == null ? WrappedContainerMultipleDAGs.this.dagID : WrappedContainerMultipleDAGs.this.newDAGID;
                }
            }).when((Object)this.appContext)).getCurrentDAGID();
        }

        void setNewDAGID(TezDAGID newDAGID) {
            this.newDAGID = newDAGID;
        }
    }

    private static class WrappedContainer {
        long rmIdentifier = 2000L;
        static final int taskPriority = 10;
        ApplicationId applicationID = ApplicationId.newInstance((long)this.rmIdentifier, (int)1);
        ApplicationAttemptId appAttemptID = ApplicationAttemptId.newInstance((ApplicationId)this.applicationID, (int)1);
        ContainerId containerID = ContainerId.newInstance((ApplicationAttemptId)this.appAttemptID, (int)1);
        NodeId nodeID = NodeId.newInstance((String)"host", (int)12500);
        String nodeHttpAddress = "host:12501";
        Resource resource = Resource.newInstance((int)1024, (int)1);
        Priority priority = Priority.newInstance((int)1);
        Container container = Container.newInstance((ContainerId)this.containerID, (NodeId)this.nodeID, (String)this.nodeHttpAddress, (Resource)this.resource, (Priority)this.priority, null);
        ContainerHeartbeatHandler chh = (ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class);
        TaskCommunicatorManagerInterface tal = (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class);
        EventHandler eventHandler;
        AppContext appContext;
        HistoryEventHandler historyEventHandler;
        TezDAGID dagID;
        TezVertexID vertexID;
        TezTaskID taskID;
        TezTaskAttemptID taskAttemptID;
        TaskSpec taskSpec;
        public AMContainerImpl amContainer;

        public WrappedContainer(boolean shouldProfile, String profileString) {
            TaskCommunicator taskComm = (TaskCommunicator)Mockito.mock(TaskCommunicator.class);
            try {
                ((TaskCommunicator)Mockito.doReturn((Object)new InetSocketAddress("localhost", 0)).when((Object)taskComm)).getAddress();
            }
            catch (ServicePluginException e) {
                throw new RuntimeException(e);
            }
            ((TaskCommunicatorManagerInterface)Mockito.doReturn((Object)new TaskCommunicatorWrapper(taskComm)).when((Object)this.tal)).getTaskCommunicator(0);
            this.dagID = TezDAGID.getInstance((ApplicationId)this.applicationID, (int)1);
            this.vertexID = TezVertexID.getInstance((TezDAGID)this.dagID, (int)1);
            this.taskID = TezTaskID.getInstance((TezVertexID)this.vertexID, (int)1);
            this.taskAttemptID = TezTaskAttemptID.getInstance((TezTaskID)this.taskID, (int)1);
            this.eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
            this.historyEventHandler = (HistoryEventHandler)Mockito.mock(HistoryEventHandler.class);
            Configuration conf = new Configuration(false);
            this.appContext = (AppContext)Mockito.mock(AppContext.class);
            ((AppContext)Mockito.doReturn(new HashMap()).when((Object)this.appContext)).getApplicationACLs();
            ((AppContext)Mockito.doReturn((Object)this.eventHandler).when((Object)this.appContext)).getEventHandler();
            ((AppContext)Mockito.doReturn((Object)this.appAttemptID).when((Object)this.appContext)).getApplicationAttemptId();
            ((AppContext)Mockito.doReturn((Object)this.applicationID).when((Object)this.appContext)).getApplicationID();
            ((AppContext)Mockito.doReturn((Object)new SystemClock()).when((Object)this.appContext)).getClock();
            ((AppContext)Mockito.doReturn((Object)this.historyEventHandler).when((Object)this.appContext)).getHistoryHandler();
            ((AppContext)Mockito.doReturn((Object)conf).when((Object)this.appContext)).getAMConf();
            this.mockDAGID();
            this.taskSpec = (TaskSpec)Mockito.mock(TaskSpec.class);
            ((TaskSpec)Mockito.doReturn((Object)this.taskAttemptID).when((Object)this.taskSpec)).getTaskAttemptID();
            this.amContainer = new AMContainerImpl(this.container, this.chh, this.tal, (ContainerSignatureMatcher)new ContainerContextMatcher(), this.appContext, 0, 0, 0);
        }

        public WrappedContainer() {
            this(false, null);
        }

        protected void mockDAGID() {
            ((AppContext)Mockito.doReturn((Object)this.dagID).when((Object)this.appContext)).getCurrentDAGID();
        }

        public void verifyNoOutgoingEvents() {
            ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.never())).handle((Event)Matchers.any(Event.class));
        }

        public List<Event> verifyCountAndGetOutgoingEvents(int invocations) {
            ArgumentCaptor args = ArgumentCaptor.forClass(Event.class);
            ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)invocations))).handle((Event)args.capture());
            return args.getAllValues();
        }

        public void verifyHistoryStopEvent() {
            ArgumentCaptor args = ArgumentCaptor.forClass(DAGHistoryEvent.class);
            ((HistoryEventHandler)Mockito.verify((Object)this.historyEventHandler, (VerificationMode)Mockito.times((int)1))).handle((DAGHistoryEvent)args.capture());
            Assert.assertEquals((long)1L, (long)args.getAllValues().size());
        }

        public void launchContainer() {
            this.launchContainer(new HashMap<String, LocalResource>(), new Credentials());
        }

        public void launchContainer(Map<String, LocalResource> localResources, Credentials credentials) {
            Mockito.reset((Object[])new EventHandler[]{this.eventHandler});
            Token jobToken = (Token)Mockito.mock(Token.class);
            TokenCache.setSessionToken((Token)jobToken, (Credentials)credentials);
            this.amContainer.handle((AMContainerEvent)new AMContainerEventLaunchRequest(this.containerID, this.vertexID, new ContainerContext(localResources, credentials, new HashMap(), ""), 0, 0));
        }

        public void assignTaskAttempt(TezTaskAttemptID taID) {
            this.assignTaskAttempt(taID, new HashMap<String, LocalResource>(), new Credentials());
        }

        public void assignTaskAttempt(TezTaskAttemptID taID, Map<String, LocalResource> additionalResources, Credentials credentials) {
            Mockito.reset((Object[])new EventHandler[]{this.eventHandler});
            ((TaskSpec)Mockito.doReturn((Object)taID).when((Object)this.taskSpec)).getTaskAttemptID();
            this.amContainer.handle((AMContainerEvent)new AMContainerEventAssignTA(this.containerID, taID, (Object)this.taskSpec, additionalResources, credentials, 10));
        }

        public void containerLaunched() {
            Mockito.reset((Object[])new EventHandler[]{this.eventHandler});
            this.amContainer.handle((AMContainerEvent)new AMContainerEventLaunched(this.containerID));
        }

        public void taskAttemptSucceeded(TezTaskAttemptID taID) {
            Mockito.reset((Object[])new EventHandler[]{this.eventHandler});
            this.amContainer.handle((AMContainerEvent)new AMContainerEventTASucceeded(this.containerID, taID));
        }

        public void stopRequest() {
            Mockito.reset((Object[])new EventHandler[]{this.eventHandler});
            this.amContainer.handle((AMContainerEvent)new AMContainerEventStopRequest(this.containerID));
        }

        public void nmStopSent() {
            Mockito.reset((Object[])new EventHandler[]{this.eventHandler});
            this.amContainer.handle(new AMContainerEvent(this.containerID, AMContainerEventType.C_NM_STOP_SENT));
        }

        public void nmStopFailed() {
            Mockito.reset((Object[])new EventHandler[]{this.eventHandler});
            this.amContainer.handle(new AMContainerEvent(this.containerID, AMContainerEventType.C_NM_STOP_FAILED));
        }

        public void containerCompleted() {
            Mockito.reset((Object[])new EventHandler[]{this.eventHandler});
            this.amContainer.handle((AMContainerEvent)new AMContainerEventCompleted(this.containerID, 0, null, TaskAttemptTerminationCause.CONTAINER_EXITED));
        }

        public void containerCompleted(int exitStatus, TaskAttemptTerminationCause errCause, String diagnostics) {
            Mockito.reset((Object[])new EventHandler[]{this.eventHandler});
            this.amContainer.handle((AMContainerEvent)new AMContainerEventCompleted(this.containerID, exitStatus, diagnostics, errCause));
        }

        public void containerTimedOut() {
            Mockito.reset((Object[])new EventHandler[]{this.eventHandler});
            this.amContainer.handle(new AMContainerEvent(this.containerID, AMContainerEventType.C_TIMED_OUT));
        }

        public void launchFailed() {
            Mockito.reset((Object[])new EventHandler[]{this.eventHandler});
            this.amContainer.handle((AMContainerEvent)new AMContainerEventLaunchFailed(this.containerID, "launchFailed"));
        }

        public void nodeFailed() {
            Mockito.reset((Object[])new EventHandler[]{this.eventHandler});
            this.amContainer.handle((AMContainerEvent)new AMContainerEventNodeFailed(this.containerID, "nodeFailed"));
        }

        public void verifyState(AMContainerState state) {
            Assert.assertEquals((String)("Expected state: " + state + ", but found: " + this.amContainer.getState()), (Object)state, (Object)this.amContainer.getState());
        }
    }
}

