/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import java.util.LinkedList;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.VertexManagerPluginContext;
import org.apache.tez.dag.app.dag.impl.RootInputVertexManager;
import org.apache.tez.runtime.api.events.InputConfigureVertexTasksEvent;
import org.apache.tez.runtime.api.events.InputDataInformationEvent;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestRootInputVertexManager {
    @Test(timeout=5000L)
    public void testEventsFromMultipleInputs() {
        VertexManagerPluginContext context = (VertexManagerPluginContext)Mockito.mock(VertexManagerPluginContext.class);
        ((VertexManagerPluginContext)Mockito.doReturn((Object)"vertex1").when((Object)context)).getVertexName();
        ((VertexManagerPluginContext)Mockito.doReturn((Object)1).when((Object)context)).getVertexNumTasks((String)Matchers.eq((Object)"vertex1"));
        RootInputVertexManager rootInputVertexManager = new RootInputVertexManager(context);
        rootInputVertexManager.initialize();
        InputDescriptor id1 = (InputDescriptor)Mockito.mock(InputDescriptor.class);
        LinkedList<InputDataInformationEvent> events1 = new LinkedList<InputDataInformationEvent>();
        InputDataInformationEvent diEvent11 = InputDataInformationEvent.createWithSerializedPayload((int)0, null);
        events1.add(diEvent11);
        rootInputVertexManager.onRootVertexInitialized("input1", id1, events1);
        InputDescriptor id2 = (InputDescriptor)Mockito.mock(InputDescriptor.class);
        LinkedList<InputDataInformationEvent> events2 = new LinkedList<InputDataInformationEvent>();
        InputDataInformationEvent diEvent21 = InputDataInformationEvent.createWithSerializedPayload((int)0, null);
        events2.add(diEvent21);
        try {
            rootInputVertexManager.onRootVertexInitialized("input2", id2, events2);
            Assert.fail((String)"Expecting failure in case of multiple inputs attempting to send events");
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("RootInputVertexManager cannot configure multiple inputs. Use a custom VertexManager"));
        }
    }

    @Test(timeout=5000L)
    public void testConfigureFromMultipleInputs() {
        VertexManagerPluginContext context = (VertexManagerPluginContext)Mockito.mock(VertexManagerPluginContext.class);
        ((VertexManagerPluginContext)Mockito.doReturn((Object)"vertex1").when((Object)context)).getVertexName();
        ((VertexManagerPluginContext)Mockito.doReturn((Object)-1).when((Object)context)).getVertexNumTasks((String)Matchers.eq((Object)"vertex1"));
        RootInputVertexManager rootInputVertexManager = new RootInputVertexManager(context);
        rootInputVertexManager.initialize();
        InputDescriptor id1 = (InputDescriptor)Mockito.mock(InputDescriptor.class);
        LinkedList<InputConfigureVertexTasksEvent> events1 = new LinkedList<InputConfigureVertexTasksEvent>();
        InputConfigureVertexTasksEvent diEvent11 = InputConfigureVertexTasksEvent.create((int)1, null, null);
        events1.add(diEvent11);
        rootInputVertexManager.onRootVertexInitialized("input1", id1, events1);
        InputDescriptor id2 = (InputDescriptor)Mockito.mock(InputDescriptor.class);
        LinkedList<InputConfigureVertexTasksEvent> events2 = new LinkedList<InputConfigureVertexTasksEvent>();
        InputConfigureVertexTasksEvent diEvent21 = InputConfigureVertexTasksEvent.create((int)1, null, null);
        events2.add(diEvent21);
        try {
            rootInputVertexManager.onRootVertexInitialized("input2", id2, events2);
            Assert.fail((String)"Expecting failure in case of multiple inputs attempting to send events");
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("RootInputVertexManager cannot configure multiple inputs. Use a custom VertexManager"));
        }
    }
}

