/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.dag.TaskAttempt;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.event.DAGEventSchedulerUpdate;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventSchedule;
import org.apache.tez.dag.app.dag.impl.DAGSchedulerNaturalOrderControlled;
import org.apache.tez.dag.app.dag.impl.Edge;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestDAGSchedulerNaturalOrderControlled {
    @Test(timeout=5000L)
    public void testSimpleFlow() {
        int i;
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        DAG dag = this.createMockDag();
        DAGSchedulerNaturalOrderControlled dagScheduler = new DAGSchedulerNaturalOrderControlled(dag, eventHandler);
        int numVertices = 5;
        Vertex[] vertices = new Vertex[numVertices];
        for (i = 0; i < numVertices; ++i) {
            vertices[i] = dag.getVertex("vertex" + i);
        }
        for (i = 0; i < vertices[0].getTotalTasks(); ++i) {
            dagScheduler.scheduleTaskEx(this.createScheduleRequest(vertices[0].getVertexId(), i, 0));
        }
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)vertices[0].getTotalTasks()))).handle((Event)Matchers.any(Event.class));
        Mockito.reset((Object[])new EventHandler[]{eventHandler});
        for (i = 0; i < 3; ++i) {
            dagScheduler.scheduleTaskEx(this.createScheduleRequest(vertices[2].getVertexId(), i, 0));
        }
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)3))).handle((Event)Matchers.any(Event.class));
        Mockito.reset((Object[])new EventHandler[]{eventHandler});
        for (i = 0; i < 3; ++i) {
            dagScheduler.scheduleTaskEx(this.createScheduleRequest(vertices[3].getVertexId(), i, 0));
        }
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)3))).handle((Event)Matchers.any(Event.class));
        Mockito.reset((Object[])new EventHandler[]{eventHandler});
        for (i = 3; i < vertices[2].getTotalTasks(); ++i) {
            dagScheduler.scheduleTaskEx(this.createScheduleRequest(vertices[2].getVertexId(), i, 0));
        }
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)(vertices[2].getTotalTasks() - 3)))).handle((Event)Matchers.any(Event.class));
        Mockito.reset((Object[])new EventHandler[]{eventHandler});
        for (i = 3; i < vertices[3].getTotalTasks(); ++i) {
            dagScheduler.scheduleTaskEx(this.createScheduleRequest(vertices[3].getVertexId(), i, 0));
        }
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)(vertices[3].getTotalTasks() - 3)))).handle((Event)Matchers.any(Event.class));
        Mockito.reset((Object[])new EventHandler[]{eventHandler});
        for (i = 0; i < vertices[4].getTotalTasks(); ++i) {
            dagScheduler.scheduleTaskEx(this.createScheduleRequest(vertices[4].getVertexId(), i, 0));
        }
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)vertices[4].getTotalTasks()))).handle((Event)Matchers.any(Event.class));
        Mockito.reset((Object[])new EventHandler[]{eventHandler});
    }

    @Test(timeout=5000L)
    public void testSourceRequestDelayed() {
        int i;
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        DAG dag = this.createMockDag();
        DAGSchedulerNaturalOrderControlled dagScheduler = new DAGSchedulerNaturalOrderControlled(dag, eventHandler);
        int numVertices = 5;
        Vertex[] vertices = new Vertex[numVertices];
        for (i = 0; i < numVertices; ++i) {
            vertices[i] = dag.getVertex("vertex" + i);
        }
        for (i = 0; i < vertices[0].getTotalTasks(); ++i) {
            dagScheduler.scheduleTaskEx(this.createScheduleRequest(vertices[0].getVertexId(), i, 0));
        }
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)vertices[0].getTotalTasks()))).handle((Event)Matchers.any(Event.class));
        Mockito.reset((Object[])new EventHandler[]{eventHandler});
        for (i = 0; i < vertices[3].getTotalTasks(); ++i) {
            dagScheduler.scheduleTaskEx(this.createScheduleRequest(vertices[3].getVertexId(), i, 0));
        }
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)vertices[3].getTotalTasks()))).handle((Event)Matchers.any(Event.class));
        Mockito.reset((Object[])new EventHandler[]{eventHandler});
        for (i = 0; i < vertices[4].getTotalTasks(); ++i) {
            dagScheduler.scheduleTaskEx(this.createScheduleRequest(vertices[4].getVertexId(), i, 0));
        }
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.never())).handle((Event)Matchers.any(Event.class));
        Mockito.reset((Object[])new EventHandler[]{eventHandler});
        for (i = 0; i < 3; ++i) {
            dagScheduler.scheduleTaskEx(this.createScheduleRequest(vertices[2].getVertexId(), i, 0));
        }
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)3))).handle((Event)Matchers.any(Event.class));
        Mockito.reset((Object[])new EventHandler[]{eventHandler});
        for (i = 3; i < vertices[2].getTotalTasks(); ++i) {
            dagScheduler.scheduleTaskEx(this.createScheduleRequest(vertices[2].getVertexId(), i, 0));
        }
        ArgumentCaptor args = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)(vertices[2].getTotalTasks() - 3 + vertices[4].getTotalTasks())))).handle((Event)args.capture());
        int count = 0;
        for (Event raw : args.getAllValues()) {
            TaskAttemptEventSchedule event = (TaskAttemptEventSchedule)raw;
            if (count < vertices[2].getTotalTasks() - 3) {
                Assert.assertEquals((long)2L, (long)event.getTaskAttemptID().getTaskID().getVertexID().getId());
            } else {
                Assert.assertEquals((long)4L, (long)event.getTaskAttemptID().getTaskID().getVertexID().getId());
            }
            ++count;
        }
        Mockito.reset((Object[])new EventHandler[]{eventHandler});
    }

    @Test(timeout=5000L)
    public void testParallelismUpdated() {
        int i;
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        DAG dag = this.createMockDag();
        DAGSchedulerNaturalOrderControlled dagScheduler = new DAGSchedulerNaturalOrderControlled(dag, eventHandler);
        int numVertices = 5;
        Vertex[] vertices = new Vertex[numVertices];
        for (i = 0; i < numVertices; ++i) {
            vertices[i] = dag.getVertex("vertex" + i);
        }
        for (i = 0; i < vertices[0].getTotalTasks(); ++i) {
            dagScheduler.scheduleTaskEx(this.createScheduleRequest(vertices[0].getVertexId(), i, 0));
        }
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)vertices[0].getTotalTasks()))).handle((Event)Matchers.any(Event.class));
        Mockito.reset((Object[])new EventHandler[]{eventHandler});
        Assert.assertEquals((long)10L, (long)vertices[2].getTotalTasks());
        for (i = 0; i < vertices[3].getTotalTasks(); ++i) {
            dagScheduler.scheduleTaskEx(this.createScheduleRequest(vertices[3].getVertexId(), i, 0));
        }
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)vertices[3].getTotalTasks()))).handle((Event)Matchers.any(Event.class));
        Mockito.reset((Object[])new EventHandler[]{eventHandler});
        for (i = 0; i < vertices[4].getTotalTasks(); ++i) {
            dagScheduler.scheduleTaskEx(this.createScheduleRequest(vertices[4].getVertexId(), i, 0));
        }
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.never())).handle((Event)Matchers.any(Event.class));
        Mockito.reset((Object[])new EventHandler[]{eventHandler});
        this.updateParallelismOnMockVertex(vertices[2], 3);
        Assert.assertEquals((long)3L, (long)vertices[2].getTotalTasks());
        for (i = 0; i < vertices[2].getTotalTasks(); ++i) {
            dagScheduler.scheduleTaskEx(this.createScheduleRequest(vertices[2].getVertexId(), i, 0));
        }
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)(vertices[2].getTotalTasks() + vertices[4].getTotalTasks())))).handle((Event)Matchers.any(Event.class));
        Mockito.reset((Object[])new EventHandler[]{eventHandler});
    }

    @Test(timeout=5000L)
    public void testMultipleRequestsForSameTask() {
        int i;
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        DAG dag = this.createMockDag();
        DAGSchedulerNaturalOrderControlled dagScheduler = new DAGSchedulerNaturalOrderControlled(dag, eventHandler);
        int numVertices = 5;
        Vertex[] vertices = new Vertex[numVertices];
        for (i = 0; i < numVertices; ++i) {
            vertices[i] = dag.getVertex("vertex" + i);
        }
        for (i = 0; i < vertices[0].getTotalTasks() - 1; ++i) {
            dagScheduler.scheduleTaskEx(this.createScheduleRequest(vertices[0].getVertexId(), i, 0));
        }
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)(vertices[0].getTotalTasks() - 1)))).handle((Event)Matchers.any(Event.class));
        Mockito.reset((Object[])new EventHandler[]{eventHandler});
        for (i = 0; i < vertices[2].getTotalTasks(); ++i) {
            dagScheduler.scheduleTaskEx(this.createScheduleRequest(vertices[2].getVertexId(), i, 0));
        }
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.never())).handle((Event)Matchers.any(Event.class));
        Mockito.reset((Object[])new EventHandler[]{eventHandler});
        for (i = 0; i < vertices[0].getTotalTasks() - 1; ++i) {
            dagScheduler.scheduleTaskEx(this.createScheduleRequest(vertices[0].getVertexId(), i, 1));
        }
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)(vertices[0].getTotalTasks() - 1)))).handle((Event)Matchers.any(Event.class));
        Mockito.reset((Object[])new EventHandler[]{eventHandler});
        dagScheduler.scheduleTaskEx(this.createScheduleRequest(vertices[0].getVertexId(), vertices[0].getTotalTasks() - 1, 1));
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)(1 + vertices[2].getTotalTasks())))).handle((Event)Matchers.any(Event.class));
    }

    private DAG createMockDag() {
        DAG dag = (DAG)Mockito.mock(DAG.class);
        int numVertices = 5;
        Vertex[] vertices = new Vertex[numVertices];
        vertices[0] = this.createMockVertex("vertex0", 0, 10, 0);
        vertices[1] = this.createMockVertex("vertex1", 1, 0, 0);
        vertices[2] = this.createMockVertex("vertex2", 2, 10, 1);
        vertices[3] = this.createMockVertex("vertex3", 3, 10, 1);
        vertices[4] = this.createMockVertex("vertex4", 4, 10, 2);
        for (int i = 0; i < numVertices; ++i) {
            String name = vertices[i].getName();
            TezVertexID vertexId = vertices[i].getVertexId();
            ((DAG)Mockito.doReturn((Object)vertices[i]).when((Object)dag)).getVertex(name);
            ((DAG)Mockito.doReturn((Object)vertices[i]).when((Object)dag)).getVertex(vertexId);
        }
        this.updateMockVertexWithConnections(vertices[0], this.createConnectionMap(null), this.createConnectionMap(vertices[2]));
        this.updateMockVertexWithConnections(vertices[1], this.createConnectionMap(null), this.createConnectionMap(vertices[3]));
        this.updateMockVertexWithConnections(vertices[2], this.createConnectionMap(vertices[0]), this.createConnectionMap(vertices[4]));
        this.updateMockVertexWithConnections(vertices[3], this.createConnectionMap(vertices[1]), this.createConnectionMap(vertices[4]));
        this.updateMockVertexWithConnections(vertices[4], this.createConnectionMap(vertices[2], vertices[3]), this.createConnectionMap(null));
        return dag;
    }

    private void updateParallelismOnMockVertex(Vertex vertex, int newParallelism) {
        ((Vertex)Mockito.doReturn((Object)newParallelism).when((Object)vertex)).getTotalTasks();
    }

    private Vertex createMockVertex(String name, int vertexIdInt, int totalTasks, int distanceFromRoot) {
        ApplicationId appId = ApplicationId.newInstance((long)1000L, (int)1);
        TezDAGID dagId = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexId = TezVertexID.getInstance((TezDAGID)dagId, (int)vertexIdInt);
        Vertex vertex = (Vertex)Mockito.mock(Vertex.class);
        ((Vertex)Mockito.doReturn((Object)name).when((Object)vertex)).getName();
        ((Vertex)Mockito.doReturn((Object)totalTasks).when((Object)vertex)).getTotalTasks();
        ((Vertex)Mockito.doReturn((Object)vertexId).when((Object)vertex)).getVertexId();
        ((Vertex)Mockito.doReturn((Object)distanceFromRoot).when((Object)vertex)).getDistanceFromRoot();
        ((Vertex)Mockito.doReturn((Object)(vertexId + " [" + name + "]")).when((Object)vertex)).getLogIdentifier();
        return vertex;
    }

    private Map<Vertex, Edge> createConnectionMap(Vertex ... vertices) {
        HashMap<Vertex, Edge> map = new HashMap<Vertex, Edge>();
        if (vertices != null) {
            for (Vertex vertex : vertices) {
                map.put(vertex, (Edge)Mockito.mock(Edge.class));
            }
        }
        return map;
    }

    private void updateMockVertexWithConnections(Vertex mockVertex, Map<Vertex, Edge> sources, Map<Vertex, Edge> destinations) {
        ((Vertex)Mockito.doReturn(sources).when((Object)mockVertex)).getInputVertices();
        ((Vertex)Mockito.doReturn(destinations).when((Object)mockVertex)).getOutputVertices();
    }

    private TaskAttempt createTaskAttempt(TezVertexID vertexId, int taskIdInt, int attemptIdInt) {
        TaskAttempt taskAttempt = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        TezTaskID taskId = TezTaskID.getInstance((TezVertexID)vertexId, (int)taskIdInt);
        TezTaskAttemptID taskAttemptId = TezTaskAttemptID.getInstance((TezTaskID)taskId, (int)attemptIdInt);
        ((TaskAttempt)Mockito.doReturn((Object)taskAttemptId).when((Object)taskAttempt)).getID();
        ((TaskAttempt)Mockito.doReturn((Object)vertexId).when((Object)taskAttempt)).getVertexID();
        return taskAttempt;
    }

    private DAGEventSchedulerUpdate createScheduleRequest(TezVertexID vertexId, int taskIdInt, int attemptIdInt) {
        TaskAttempt mockAttempt = this.createTaskAttempt(vertexId, taskIdInt, attemptIdInt);
        return new DAGEventSchedulerUpdate(DAGEventSchedulerUpdate.UpdateType.TA_SCHEDULE, mockAttempt);
    }
}

