/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.dag.TaskAttempt;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.event.DAGEventSchedulerUpdate;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventSchedule;
import org.apache.tez.dag.app.dag.impl.DAGSchedulerNaturalOrder;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestDAGScheduler {
    @Test(timeout=5000L)
    public void testDAGSchedulerNaturalOrder() {
        MockEventHandler mockEventHandler = new MockEventHandler();
        DAG mockDag = (DAG)Mockito.mock(DAG.class);
        Vertex mockVertex = (Vertex)Mockito.mock(Vertex.class);
        TaskAttempt mockAttempt = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        Mockito.when((Object)mockDag.getVertex((TezVertexID)Mockito.any())).thenReturn((Object)mockVertex);
        Mockito.when((Object)mockVertex.getDistanceFromRoot()).thenReturn((Object)0).thenReturn((Object)1).thenReturn((Object)2);
        DAGEventSchedulerUpdate event = new DAGEventSchedulerUpdate(DAGEventSchedulerUpdate.UpdateType.TA_SCHEDULE, mockAttempt);
        DAGSchedulerNaturalOrder scheduler = new DAGSchedulerNaturalOrder(mockDag, (EventHandler)mockEventHandler);
        scheduler.scheduleTaskEx(event);
        Assert.assertEquals((long)1L, (long)mockEventHandler.event.getPriorityHighLimit());
        Assert.assertEquals((long)3L, (long)mockEventHandler.event.getPriorityLowLimit());
        scheduler.scheduleTaskEx(event);
        Assert.assertEquals((long)4L, (long)mockEventHandler.event.getPriorityHighLimit());
        Assert.assertEquals((long)6L, (long)mockEventHandler.event.getPriorityLowLimit());
        scheduler.scheduleTaskEx(event);
        Assert.assertEquals((long)7L, (long)mockEventHandler.event.getPriorityHighLimit());
        Assert.assertEquals((long)9L, (long)mockEventHandler.event.getPriorityLowLimit());
    }

    @Test(timeout=5000L)
    public void testConcurrencyLimit() {
        MockEventHandler mockEventHandler = new MockEventHandler();
        DAG mockDag = (DAG)Mockito.mock(DAG.class);
        TezVertexID vId0 = TezVertexID.fromString((String)"vertex_1436907267600_195589_1_00");
        TezVertexID vId1 = TezVertexID.fromString((String)"vertex_1436907267600_195589_1_01");
        TezTaskID tId0 = TezTaskID.getInstance((TezVertexID)vId0, (int)0);
        TezTaskID tId1 = TezTaskID.getInstance((TezVertexID)vId1, (int)0);
        Vertex mockVertex = (Vertex)Mockito.mock(Vertex.class);
        Mockito.when((Object)mockDag.getVertex((TezVertexID)Mockito.any())).thenReturn((Object)mockVertex);
        Mockito.when((Object)mockVertex.getDistanceFromRoot()).thenReturn((Object)0);
        DAGSchedulerNaturalOrder scheduler = new DAGSchedulerNaturalOrder(mockDag, (EventHandler)mockEventHandler);
        scheduler.addVertexConcurrencyLimit(vId0, 0);
        TaskAttempt mockAttempt = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        Mockito.when((Object)mockAttempt.getID()).thenReturn((Object)TezTaskAttemptID.getInstance((TezTaskID)tId0, (int)0));
        scheduler.scheduleTask(new DAGEventSchedulerUpdate(DAGEventSchedulerUpdate.UpdateType.TA_SCHEDULE, mockAttempt));
        Assert.assertEquals((long)1L, (long)mockEventHandler.events.size());
        mockAttempt = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        Mockito.when((Object)mockAttempt.getID()).thenReturn((Object)TezTaskAttemptID.getInstance((TezTaskID)tId0, (int)1));
        scheduler.scheduleTask(new DAGEventSchedulerUpdate(DAGEventSchedulerUpdate.UpdateType.TA_SCHEDULE, mockAttempt));
        Assert.assertEquals((long)2L, (long)mockEventHandler.events.size());
        mockAttempt = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        Mockito.when((Object)mockAttempt.getID()).thenReturn((Object)TezTaskAttemptID.getInstance((TezTaskID)tId0, (int)2));
        scheduler.scheduleTask(new DAGEventSchedulerUpdate(DAGEventSchedulerUpdate.UpdateType.TA_SCHEDULE, mockAttempt));
        Assert.assertEquals((long)3L, (long)mockEventHandler.events.size());
        mockEventHandler.events.clear();
        ArrayList mockAttempts = Lists.newArrayList();
        int completed = 0;
        int requested = 0;
        int scheduled = 0;
        scheduler.addVertexConcurrencyLimit(vId1, 2);
        mockAttempt = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        mockAttempts.add(mockAttempt);
        Mockito.when((Object)mockAttempt.getID()).thenReturn((Object)TezTaskAttemptID.getInstance((TezTaskID)tId1, (int)requested++));
        scheduler.scheduleTask(new DAGEventSchedulerUpdate(DAGEventSchedulerUpdate.UpdateType.TA_SCHEDULE, mockAttempt));
        Assert.assertEquals((long)(scheduled + 1), (long)mockEventHandler.events.size());
        Assert.assertEquals((Object)((TaskAttempt)mockAttempts.get(scheduled)).getID(), (Object)mockEventHandler.events.get(scheduled).getTaskAttemptID());
        ++scheduled;
        mockAttempt = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        mockAttempts.add(mockAttempt);
        Mockito.when((Object)mockAttempt.getID()).thenReturn((Object)TezTaskAttemptID.getInstance((TezTaskID)tId1, (int)requested++));
        scheduler.scheduleTask(new DAGEventSchedulerUpdate(DAGEventSchedulerUpdate.UpdateType.TA_SCHEDULE, mockAttempt));
        Assert.assertEquals((long)(scheduled + 1), (long)mockEventHandler.events.size());
        Assert.assertEquals((Object)((TaskAttempt)mockAttempts.get(scheduled)).getID(), (Object)mockEventHandler.events.get(scheduled).getTaskAttemptID());
        ++scheduled;
        mockAttempt = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        mockAttempts.add(mockAttempt);
        Mockito.when((Object)mockAttempt.getID()).thenReturn((Object)TezTaskAttemptID.getInstance((TezTaskID)tId1, (int)requested++));
        scheduler.scheduleTask(new DAGEventSchedulerUpdate(DAGEventSchedulerUpdate.UpdateType.TA_SCHEDULE, mockAttempt));
        Assert.assertEquals((long)scheduled, (long)mockEventHandler.events.size());
        mockAttempt = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        mockAttempts.add(mockAttempt);
        Mockito.when((Object)mockAttempt.getID()).thenReturn((Object)TezTaskAttemptID.getInstance((TezTaskID)tId1, (int)requested++));
        scheduler.scheduleTask(new DAGEventSchedulerUpdate(DAGEventSchedulerUpdate.UpdateType.TA_SCHEDULE, mockAttempt));
        Assert.assertEquals((long)scheduled, (long)mockEventHandler.events.size());
        scheduler.taskCompleted(new DAGEventSchedulerUpdate(DAGEventSchedulerUpdate.UpdateType.TA_COMPLETED, (TaskAttempt)mockAttempts.get(completed++)));
        Assert.assertEquals((long)(scheduled + 1), (long)mockEventHandler.events.size());
        Assert.assertEquals((Object)((TaskAttempt)mockAttempts.get(scheduled)).getID(), (Object)mockEventHandler.events.get(scheduled).getTaskAttemptID());
        scheduler.taskCompleted(new DAGEventSchedulerUpdate(DAGEventSchedulerUpdate.UpdateType.TA_COMPLETED, (TaskAttempt)mockAttempts.get(completed++)));
        Assert.assertEquals((long)(++scheduled + 1), (long)mockEventHandler.events.size());
        Assert.assertEquals((Object)((TaskAttempt)mockAttempts.get(scheduled)).getID(), (Object)mockEventHandler.events.get(scheduled).getTaskAttemptID());
        scheduler.taskCompleted(new DAGEventSchedulerUpdate(DAGEventSchedulerUpdate.UpdateType.TA_COMPLETED, (TaskAttempt)mockAttempts.get(completed++)));
        Assert.assertEquals((long)(++scheduled), (long)mockEventHandler.events.size());
        mockAttempt = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        mockAttempts.add(mockAttempt);
        Mockito.when((Object)mockAttempt.getID()).thenReturn((Object)TezTaskAttemptID.getInstance((TezTaskID)tId1, (int)requested++));
        scheduler.scheduleTask(new DAGEventSchedulerUpdate(DAGEventSchedulerUpdate.UpdateType.TA_SCHEDULE, mockAttempt));
        Assert.assertEquals((long)(scheduled + 1), (long)mockEventHandler.events.size());
        Assert.assertEquals((Object)((TaskAttempt)mockAttempts.get(scheduled)).getID(), (Object)mockEventHandler.events.get(scheduled).getTaskAttemptID());
        ++scheduled;
    }

    class MockEventHandler
    implements EventHandler<TaskAttemptEventSchedule> {
        TaskAttemptEventSchedule event;
        List<TaskAttemptEventSchedule> events = Lists.newLinkedList();

        MockEventHandler() {
        }

        public void handle(TaskAttemptEventSchedule event) {
            this.event = event;
            this.events.add(event);
        }
    }
}

