/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app;

import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.tez.common.ContainerSignatureMatcher;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ContainerHeartbeatHandler;
import org.apache.tez.dag.app.TaskCommunicatorContextImpl;
import org.apache.tez.dag.app.TaskCommunicatorManager;
import org.apache.tez.dag.app.TaskCommunicatorManagerInterface;
import org.apache.tez.dag.app.rm.container.AMContainerMap;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestTaskCommunicatorContextImpl {
    @Test(timeout=5000L)
    public void testIsKnownContainer() {
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        TaskCommunicatorManager tal = (TaskCommunicatorManager)Mockito.mock(TaskCommunicatorManager.class);
        AMContainerMap amContainerMap = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskCommunicatorManagerInterface)tal, (ContainerSignatureMatcher)Mockito.mock(ContainerSignatureMatcher.class), appContext);
        ((AppContext)Mockito.doReturn((Object)amContainerMap).when((Object)appContext)).getAllContainers();
        ContainerId containerId01 = (ContainerId)Mockito.mock(ContainerId.class);
        Container container01 = (Container)Mockito.mock(Container.class);
        ((Container)Mockito.doReturn((Object)containerId01).when((Object)container01)).getId();
        ContainerId containerId11 = (ContainerId)Mockito.mock(ContainerId.class);
        Container container11 = (Container)Mockito.mock(Container.class);
        ((Container)Mockito.doReturn((Object)containerId11).when((Object)container11)).getId();
        amContainerMap.addContainerIfNew(container01, 0, 0, 0);
        amContainerMap.addContainerIfNew(container11, 1, 1, 1);
        TaskCommunicatorContextImpl taskCommContext0 = new TaskCommunicatorContextImpl(appContext, tal, null, 0);
        TaskCommunicatorContextImpl taskCommContext1 = new TaskCommunicatorContextImpl(appContext, tal, null, 1);
        Assert.assertTrue((boolean)taskCommContext0.isKnownContainer(containerId01));
        Assert.assertFalse((boolean)taskCommContext0.isKnownContainer(containerId11));
        Assert.assertFalse((boolean)taskCommContext1.isKnownContainer(containerId01));
        Assert.assertTrue((boolean)taskCommContext1.isKnownContainer(containerId11));
        taskCommContext0.containerAlive(containerId01);
        ((TaskCommunicatorManager)Mockito.verify((Object)tal)).containerAlive(containerId01);
        Mockito.reset((Object[])new TaskCommunicatorManager[]{tal});
        taskCommContext0.containerAlive(containerId11);
        ((TaskCommunicatorManager)Mockito.verify((Object)tal, (VerificationMode)Mockito.never())).containerAlive(containerId11);
        Mockito.reset((Object[])new TaskCommunicatorManager[]{tal});
        taskCommContext1.containerAlive(containerId01);
        ((TaskCommunicatorManager)Mockito.verify((Object)tal, (VerificationMode)Mockito.never())).containerAlive(containerId01);
        Mockito.reset((Object[])new TaskCommunicatorManager[]{tal});
        taskCommContext1.containerAlive(containerId11);
        ((TaskCommunicatorManager)Mockito.verify((Object)tal)).containerAlive(containerId11);
        Mockito.reset((Object[])new TaskCommunicatorManager[]{tal});
        taskCommContext1.containerAlive(containerId01);
        ((TaskCommunicatorManager)Mockito.verify((Object)tal, (VerificationMode)Mockito.never())).containerAlive(containerId01);
        Mockito.reset((Object[])new TaskCommunicatorManager[]{tal});
    }
}

