/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.recovery;

import java.io.IOException;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.events.TaskStartedEvent;
import org.apache.tez.dag.history.recovery.RecoveryService;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRecoveryService {
    private static String TEST_ROOT_DIR = "target/" + TestRecoveryService.class.getName() + "-tmpDir";

    @Test(timeout=5000L)
    public void testDrainEvents() throws IOException {
        Configuration conf = new Configuration();
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)appContext.getCurrentRecoveryDir()).thenReturn((Object)new Path(TEST_ROOT_DIR));
        Mockito.when((Object)appContext.getClock()).thenReturn((Object)new SystemClock());
        MockRecoveryService recoveryService = new MockRecoveryService(appContext);
        conf.setBoolean("tez.test.recovery.drain_event", true);
        recoveryService.init(conf);
        recoveryService.start();
        TezDAGID dagId = TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1), (int)1);
        int randEventCount = new Random().nextInt(100) + 100;
        for (int i = 0; i < randEventCount; ++i) {
            recoveryService.handle(new DAGHistoryEvent(dagId, (HistoryEvent)new TaskStartedEvent(TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)dagId, (int)1), (int)1), "v1", 0L, 0L)));
        }
        recoveryService.stop();
        Assert.assertEquals((long)randEventCount, (long)recoveryService.processedRecoveryEventCounter.get());
    }

    private static class MockRecoveryService
    extends RecoveryService {
        public AtomicInteger processedRecoveryEventCounter = new AtomicInteger(0);

        public MockRecoveryService(AppContext appContext) {
            super(appContext);
        }

        protected void handleRecoveryEvent(DAGHistoryEvent event) throws IOException {
            super.handleRecoveryEvent(event);
            this.processedRecoveryEventCounter.addAndGet(1);
        }
    }
}

