/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm.node;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.rm.AMSchedulerEventNodeBlacklistUpdate;
import org.apache.tez.dag.app.rm.AMSchedulerEventType;
import org.apache.tez.dag.app.rm.TaskSchedulerEventHandler;
import org.apache.tez.dag.app.rm.container.AMContainerEventNodeFailed;
import org.apache.tez.dag.app.rm.container.AMContainerEventType;
import org.apache.tez.dag.app.rm.container.AMContainerMap;
import org.apache.tez.dag.app.rm.node.AMNodeEvent;
import org.apache.tez.dag.app.rm.node.AMNodeEventContainerAllocated;
import org.apache.tez.dag.app.rm.node.AMNodeEventNodeCountUpdated;
import org.apache.tez.dag.app.rm.node.AMNodeEventStateChanged;
import org.apache.tez.dag.app.rm.node.AMNodeEventTaskAttemptEnded;
import org.apache.tez.dag.app.rm.node.AMNodeEventTaskAttemptSucceeded;
import org.apache.tez.dag.app.rm.node.AMNodeEventType;
import org.apache.tez.dag.app.rm.node.AMNodeImpl;
import org.apache.tez.dag.app.rm.node.AMNodeState;
import org.apache.tez.dag.app.rm.node.AMNodeTracker;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAMNodeTracker {
    private static final Log LOG = LogFactory.getLog(TestAMNodeTracker.class);
    DrainDispatcher dispatcher;
    EventHandler eventHandler;

    @Before
    public void setup() {
        this.dispatcher = new DrainDispatcher();
        this.dispatcher.init(new Configuration());
        this.dispatcher.start();
        this.eventHandler = this.dispatcher.getEventHandler();
    }

    @After
    public void teardown() {
        this.dispatcher.stop();
    }

    @Test(timeout=5000L)
    public void testHealthUpdateKnownNode() {
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        AMNodeTracker amNodeTracker = new AMNodeTracker(this.eventHandler, appContext);
        ((AppContext)Mockito.doReturn((Object)amNodeTracker).when((Object)appContext)).getNodeTracker();
        amNodeTracker.init(new Configuration(false));
        amNodeTracker.start();
        NodeId nodeId = NodeId.newInstance((String)"host1", (int)2342);
        amNodeTracker.nodeSeen(nodeId);
        NodeReport nodeReport = TestAMNodeTracker.generateNodeReport(nodeId, NodeState.UNHEALTHY);
        amNodeTracker.handle((AMNodeEvent)new AMNodeEventStateChanged(nodeReport));
        this.dispatcher.await();
        Assert.assertEquals((Object)AMNodeState.UNHEALTHY, (Object)amNodeTracker.get(nodeId).getState());
        amNodeTracker.stop();
    }

    @Test(timeout=5000L)
    public void testHealthUpdateUnknownNode() {
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        AMNodeTracker amNodeTracker = new AMNodeTracker(this.eventHandler, appContext);
        ((AppContext)Mockito.doReturn((Object)amNodeTracker).when((Object)appContext)).getNodeTracker();
        amNodeTracker.init(new Configuration(false));
        amNodeTracker.start();
        NodeId nodeId = NodeId.newInstance((String)"unknownhost", (int)2342);
        NodeReport nodeReport = TestAMNodeTracker.generateNodeReport(nodeId, NodeState.UNHEALTHY);
        amNodeTracker.handle((AMNodeEvent)new AMNodeEventStateChanged(nodeReport));
        this.dispatcher.await();
        amNodeTracker.stop();
    }

    @Test(timeout=5000L)
    public void testSingleNodeNotBlacklisted() {
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        Configuration conf = new Configuration(false);
        conf.setInt("tez.am.maxtaskfailures.per.node", 2);
        conf.setBoolean("tez.am.node-blacklisting.enabled", true);
        conf.setInt("tez.am.node-blacklisting.ignore-threshold-node-percent", 33);
        TestEventHandler handler = new TestEventHandler();
        AMNodeTracker amNodeTracker = new AMNodeTracker((EventHandler)handler, appContext);
        ((AppContext)Mockito.doReturn((Object)amNodeTracker).when((Object)appContext)).getNodeTracker();
        AMContainerMap amContainerMap = (AMContainerMap)Mockito.mock(AMContainerMap.class);
        TaskSchedulerEventHandler taskSchedulerEventHandler = (TaskSchedulerEventHandler)Mockito.mock(TaskSchedulerEventHandler.class);
        this.dispatcher.register(AMNodeEventType.class, (EventHandler)amNodeTracker);
        this.dispatcher.register(AMContainerEventType.class, (EventHandler)amContainerMap);
        this.dispatcher.register(AMSchedulerEventType.class, (EventHandler)taskSchedulerEventHandler);
        amNodeTracker.init(conf);
        amNodeTracker.start();
        amNodeTracker.handle((AMNodeEvent)new AMNodeEventNodeCountUpdated(1));
        NodeId nodeId = NodeId.newInstance((String)"host1", (int)1234);
        amNodeTracker.nodeSeen(nodeId);
        AMNodeImpl node = (AMNodeImpl)amNodeTracker.get(nodeId);
        ContainerId cId1 = (ContainerId)Mockito.mock(ContainerId.class);
        ContainerId cId2 = (ContainerId)Mockito.mock(ContainerId.class);
        amNodeTracker.handle((AMNodeEvent)new AMNodeEventContainerAllocated(nodeId, cId1));
        amNodeTracker.handle((AMNodeEvent)new AMNodeEventContainerAllocated(nodeId, cId2));
        TezTaskAttemptID ta1 = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
        TezTaskAttemptID ta2 = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
        amNodeTracker.handle((AMNodeEvent)new AMNodeEventTaskAttemptEnded(nodeId, cId1, ta1, true));
        this.dispatcher.await();
        Assert.assertEquals((long)1L, (long)node.numFailedTAs);
        Assert.assertEquals((Object)AMNodeState.ACTIVE, (Object)node.getState());
        amNodeTracker.handle((AMNodeEvent)new AMNodeEventTaskAttemptEnded(nodeId, cId2, ta2, true));
        this.dispatcher.await();
        Assert.assertEquals((long)2L, (long)node.numFailedTAs);
        Assert.assertEquals((long)1L, (long)handler.events.size());
        Assert.assertEquals((Object)AMNodeEventType.N_IGNORE_BLACKLISTING_ENABLED, (Object)handler.events.get(0).getType());
        Assert.assertEquals((Object)AMNodeState.FORCED_ACTIVE, (Object)node.getState());
    }

    @Test(timeout=10000L)
    public void testNodeSelfBlacklist() {
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        Configuration conf = new Configuration(false);
        conf.setInt("tez.am.maxtaskfailures.per.node", 2);
        TestEventHandler handler = new TestEventHandler();
        AMNodeTracker amNodeTracker = new AMNodeTracker((EventHandler)handler, appContext);
        ((AppContext)Mockito.doReturn((Object)amNodeTracker).when((Object)appContext)).getNodeTracker();
        AMContainerMap amContainerMap = (AMContainerMap)Mockito.mock(AMContainerMap.class);
        TaskSchedulerEventHandler taskSchedulerEventHandler = (TaskSchedulerEventHandler)Mockito.mock(TaskSchedulerEventHandler.class);
        this.dispatcher.register(AMNodeEventType.class, (EventHandler)amNodeTracker);
        this.dispatcher.register(AMContainerEventType.class, (EventHandler)amContainerMap);
        this.dispatcher.register(AMSchedulerEventType.class, (EventHandler)taskSchedulerEventHandler);
        amNodeTracker.init(conf);
        amNodeTracker.start();
        amNodeTracker.handle((AMNodeEvent)new AMNodeEventNodeCountUpdated(4));
        NodeId nodeId = NodeId.newInstance((String)"host1", (int)1234);
        NodeId nodeId2 = NodeId.newInstance((String)"host2", (int)1234);
        NodeId nodeId3 = NodeId.newInstance((String)"host3", (int)1234);
        NodeId nodeId4 = NodeId.newInstance((String)"host4", (int)1234);
        amNodeTracker.nodeSeen(nodeId);
        amNodeTracker.nodeSeen(nodeId2);
        amNodeTracker.nodeSeen(nodeId3);
        amNodeTracker.nodeSeen(nodeId4);
        AMNodeImpl node = (AMNodeImpl)amNodeTracker.get(nodeId);
        ContainerId cId1 = (ContainerId)Mockito.mock(ContainerId.class);
        ContainerId cId2 = (ContainerId)Mockito.mock(ContainerId.class);
        ContainerId cId3 = (ContainerId)Mockito.mock(ContainerId.class);
        amNodeTracker.handle((AMNodeEvent)new AMNodeEventContainerAllocated(nodeId, cId1));
        amNodeTracker.handle((AMNodeEvent)new AMNodeEventContainerAllocated(nodeId, cId2));
        amNodeTracker.handle((AMNodeEvent)new AMNodeEventContainerAllocated(nodeId, cId3));
        Assert.assertEquals((long)3L, (long)node.containers.size());
        TezTaskAttemptID ta1 = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
        TezTaskAttemptID ta2 = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
        TezTaskAttemptID ta3 = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
        amNodeTracker.handle((AMNodeEvent)new AMNodeEventTaskAttemptSucceeded(nodeId, cId1, ta1));
        Assert.assertEquals((long)1L, (long)node.numSuccessfulTAs);
        amNodeTracker.handle((AMNodeEvent)new AMNodeEventTaskAttemptEnded(nodeId, cId2, ta2, true));
        Assert.assertEquals((long)1L, (long)node.numSuccessfulTAs);
        Assert.assertEquals((long)1L, (long)node.numFailedTAs);
        Assert.assertEquals((Object)AMNodeState.ACTIVE, (Object)node.getState());
        amNodeTracker.handle((AMNodeEvent)new AMNodeEventTaskAttemptEnded(nodeId, cId2, ta2, true));
        Assert.assertEquals((long)1L, (long)node.numSuccessfulTAs);
        Assert.assertEquals((long)1L, (long)node.numFailedTAs);
        Assert.assertEquals((Object)AMNodeState.ACTIVE, (Object)node.getState());
        amNodeTracker.handle((AMNodeEvent)new AMNodeEventTaskAttemptEnded(nodeId, cId3, ta3, true));
        this.dispatcher.await();
        Assert.assertEquals((long)1L, (long)node.numSuccessfulTAs);
        Assert.assertEquals((long)2L, (long)node.numFailedTAs);
        Assert.assertEquals((Object)AMNodeState.BLACKLISTED, (Object)node.getState());
        Assert.assertEquals((long)4L, (long)handler.events.size());
        Assert.assertEquals((Object)AMContainerEventType.C_NODE_FAILED, (Object)handler.events.get(0).getType());
        Assert.assertEquals((Object)cId1, (Object)((AMContainerEventNodeFailed)handler.events.get(0)).getContainerId());
        Assert.assertEquals((Object)AMContainerEventType.C_NODE_FAILED, (Object)handler.events.get(1).getType());
        Assert.assertEquals((Object)cId2, (Object)((AMContainerEventNodeFailed)handler.events.get(1)).getContainerId());
        Assert.assertEquals((Object)AMContainerEventType.C_NODE_FAILED, (Object)handler.events.get(2).getType());
        Assert.assertEquals((Object)cId3, (Object)((AMContainerEventNodeFailed)handler.events.get(2)).getContainerId());
        Assert.assertEquals((Object)AMSchedulerEventType.S_NODE_BLACKLISTED, (Object)handler.events.get(3).getType());
        Assert.assertEquals((Object)node.getNodeId(), (Object)((AMSchedulerEventNodeBlacklistUpdate)handler.events.get(3)).getNodeId());
        ContainerId cId4 = (ContainerId)Mockito.mock(ContainerId.class);
        ContainerId cId5 = (ContainerId)Mockito.mock(ContainerId.class);
        TezTaskAttemptID ta4 = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
        TezTaskAttemptID ta5 = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
        AMNodeImpl node2 = (AMNodeImpl)amNodeTracker.get(nodeId2);
        amNodeTracker.handle((AMNodeEvent)new AMNodeEventContainerAllocated(nodeId2, cId4));
        amNodeTracker.handle((AMNodeEvent)new AMNodeEventContainerAllocated(nodeId2, cId5));
        amNodeTracker.handle((AMNodeEvent)new AMNodeEventTaskAttemptEnded(nodeId2, cId4, ta4, true));
        Assert.assertEquals((long)1L, (long)node2.numFailedTAs);
        Assert.assertEquals((Object)AMNodeState.ACTIVE, (Object)node2.getState());
        handler.events.clear();
        amNodeTracker.handle((AMNodeEvent)new AMNodeEventTaskAttemptEnded(nodeId2, cId5, ta5, true));
        this.dispatcher.await();
        Assert.assertEquals((long)2L, (long)node2.numFailedTAs);
        Assert.assertEquals((Object)AMNodeState.FORCED_ACTIVE, (Object)node2.getState());
        AMNodeImpl node3 = (AMNodeImpl)amNodeTracker.get(nodeId3);
        Assert.assertEquals((Object)AMNodeState.FORCED_ACTIVE, (Object)node3.getState());
        Assert.assertEquals((long)5L, (long)handler.events.size());
        int numIgnoreBlacklistingEnabledEvents = 0;
        int numUnblacklistedEvents = 0;
        for (Event event : handler.events) {
            if (event.getType() == AMNodeEventType.N_IGNORE_BLACKLISTING_ENABLED) {
                ++numIgnoreBlacklistingEnabledEvents;
                continue;
            }
            if (event.getType() == AMSchedulerEventType.S_NODE_UNBLACKLISTED) {
                ++numUnblacklistedEvents;
                continue;
            }
            Assert.fail((String)("Unexpected event of type: " + event.getType()));
        }
        Assert.assertEquals((long)4L, (long)numIgnoreBlacklistingEnabledEvents);
        Assert.assertEquals((long)1L, (long)numUnblacklistedEvents);
        this.dispatcher.await();
        handler.events.clear();
        amNodeTracker.handle((AMNodeEvent)new AMNodeEventNodeCountUpdated(8));
        this.dispatcher.await();
        LOG.info((Object)"Completed waiting for dispatcher to process all pending events");
        Assert.assertEquals((Object)AMNodeState.BLACKLISTED, (Object)node.getState());
        Assert.assertEquals((Object)AMNodeState.BLACKLISTED, (Object)node2.getState());
        Assert.assertEquals((Object)AMNodeState.ACTIVE, (Object)node3.getState());
        Assert.assertEquals((long)8L, (long)handler.events.size());
        int index = 0;
        int numIgnoreBlacklistingDisabledEvents = 0;
        int numBlacklistedEvents = 0;
        int numNodeFailedEvents = 0;
        for (Event event : handler.events) {
            LOG.info((Object)("Logging event: index:" + index++ + " type: " + event.getType()));
            if (event.getType() == AMNodeEventType.N_IGNORE_BLACKLISTING_DISABLED) {
                ++numIgnoreBlacklistingDisabledEvents;
                continue;
            }
            if (event.getType() == AMSchedulerEventType.S_NODE_BLACKLISTED) {
                ++numBlacklistedEvents;
                continue;
            }
            if (event.getType() == AMContainerEventType.C_NODE_FAILED) {
                ++numNodeFailedEvents;
                Assert.assertTrue((((AMContainerEventNodeFailed)event).getContainerId() == cId4 || ((AMContainerEventNodeFailed)event).getContainerId() == cId5 ? 1 : 0) != 0);
                continue;
            }
            Assert.fail((String)("Unexpected event of type: " + event.getType()));
        }
        Assert.assertEquals((long)4L, (long)numIgnoreBlacklistingDisabledEvents);
        Assert.assertEquals((long)2L, (long)numBlacklistedEvents);
        Assert.assertEquals((long)2L, (long)numNodeFailedEvents);
        amNodeTracker.stop();
    }

    private static NodeReport generateNodeReport(NodeId nodeId, NodeState nodeState) {
        NodeReport nodeReport = (NodeReport)Mockito.mock(NodeReport.class);
        ((NodeReport)Mockito.doReturn((Object)nodeId).when((Object)nodeReport)).getNodeId();
        ((NodeReport)Mockito.doReturn((Object)nodeState).when((Object)nodeReport)).getNodeState();
        String httpAddress = nodeId.getHost() + ":3433";
        ((NodeReport)Mockito.doReturn((Object)httpAddress).when((Object)nodeReport)).getHttpAddress();
        ((NodeReport)Mockito.doReturn((Object)"/default-rack").when((Object)nodeReport)).getRackName();
        ((NodeReport)Mockito.doReturn((Object)Resource.newInstance((int)0, (int)0)).when((Object)nodeReport)).getUsed();
        ((NodeReport)Mockito.doReturn((Object)Resource.newInstance((int)10240, (int)12)).when((Object)nodeReport)).getCapability();
        ((NodeReport)Mockito.doReturn((Object)10).when((Object)nodeReport)).getNumContainers();
        ((NodeReport)Mockito.doReturn((Object)nodeState.toString()).when((Object)nodeReport)).getHealthReport();
        long healthReportTime = System.currentTimeMillis();
        ((NodeReport)Mockito.doReturn((Object)healthReportTime).when((Object)nodeReport)).getLastHealthReportTime();
        return nodeReport;
    }

    class TestEventHandler
    implements EventHandler {
        List<Event> events = Lists.newLinkedList();

        TestEventHandler() {
        }

        public void handle(Event event) {
            this.events.add(event);
            TestAMNodeTracker.this.eventHandler.handle(event);
        }
    }
}

