/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm;

import java.util.HashMap;
import java.util.concurrent.BlockingQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.app.rm.LocalTaskSchedulerService;
import org.apache.tez.dag.app.rm.TaskSchedulerService;
import org.apache.tez.dag.app.rm.container.ContainerSignatureMatcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestLocalTaskSchedulerService {
    LocalTaskSchedulerService ltss;
    int core = 10;

    @Test(timeout=5000L)
    public void testCreateResource() {
        long value = 0x400000L;
        Resource resource = LocalTaskSchedulerService.createResource((long)value, (int)this.core);
        Assert.assertEquals((long)((int)(value / 0x100000L)), (long)resource.getMemory());
    }

    @Test(timeout=5000L)
    public void testCreateResourceLargerThanIntMax() {
        try {
            LocalTaskSchedulerService.createResource((long)Long.MAX_VALUE, (int)this.core);
            Assert.fail((String)"No exception thrown.");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof IllegalArgumentException));
            Assert.assertTrue((boolean)ex.getMessage().contains("Out of range:"));
        }
    }

    @Test(timeout=5000L)
    public void testCreateResourceWithNegativeValue() {
        try {
            LocalTaskSchedulerService.createResource((long)-1048576L, (int)this.core);
            Assert.fail((String)"No exception thrown.");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof IllegalArgumentException));
            Assert.assertTrue((boolean)ex.getMessage().contains("Negative Memory or Core provided!"));
        }
    }

    @Test(timeout=5000L)
    public void testDeallocationBeforeAllocation() {
        MockLocalTaskSchedulerSerivce taskSchedulerService = new MockLocalTaskSchedulerSerivce((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.mock(TaskSchedulerService.TaskSchedulerAppCallback.class), (ContainerSignatureMatcher)Mockito.mock(ContainerSignatureMatcher.class), "", 0, "", (AppContext)Mockito.mock(AppContext.class));
        taskSchedulerService.init(new Configuration());
        taskSchedulerService.start();
        Task task = (Task)Mockito.mock(Task.class);
        taskSchedulerService.allocateTask(task, Resource.newInstance((int)1024, (int)1), null, null, Priority.newInstance((int)1), null, null);
        taskSchedulerService.deallocateTask(task, false);
        taskSchedulerService.startRequestHandlerThread();
        MockLocalTaskSchedulerSerivce.MockAsyncDelegateRequestHandler requestHandler = taskSchedulerService.getRequestHandler();
        requestHandler.drainRequest(1);
        Assert.assertEquals((long)1L, (long)requestHandler.deallocateCount);
        Assert.assertEquals((long)0L, (long)requestHandler.allocateCount);
        taskSchedulerService.stop();
    }

    @Test(timeout=5000L)
    public void testDeallocationAfterAllocation() {
        MockLocalTaskSchedulerSerivce taskSchedulerService = new MockLocalTaskSchedulerSerivce((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.mock(TaskSchedulerService.TaskSchedulerAppCallback.class), (ContainerSignatureMatcher)Mockito.mock(ContainerSignatureMatcher.class), "", 0, "", (AppContext)Mockito.mock(AppContext.class));
        taskSchedulerService.init(new Configuration());
        taskSchedulerService.start();
        Task task = (Task)Mockito.mock(Task.class);
        taskSchedulerService.allocateTask(task, Resource.newInstance((int)1024, (int)1), null, null, Priority.newInstance((int)1), null, null);
        taskSchedulerService.startRequestHandlerThread();
        MockLocalTaskSchedulerSerivce.MockAsyncDelegateRequestHandler requestHandler = taskSchedulerService.getRequestHandler();
        requestHandler.drainRequest(1);
        taskSchedulerService.deallocateTask(task, false);
        requestHandler.drainRequest(2);
        Assert.assertEquals((long)1L, (long)requestHandler.deallocateCount);
        Assert.assertEquals((long)1L, (long)requestHandler.allocateCount);
        taskSchedulerService.stop();
    }

    static class MockLocalTaskSchedulerSerivce
    extends LocalTaskSchedulerService {
        private MockAsyncDelegateRequestHandler requestHandler;

        public MockLocalTaskSchedulerSerivce(TaskSchedulerService.TaskSchedulerAppCallback appClient, ContainerSignatureMatcher containerSignatureMatcher, String appHostName, int appHostPort, String appTrackingUrl, AppContext appContext) {
            super(appClient, containerSignatureMatcher, appHostName, appHostPort, appTrackingUrl, appContext);
        }

        public LocalTaskSchedulerService.AsyncDelegateRequestHandler createRequestHandler(Configuration conf) {
            this.requestHandler = new MockAsyncDelegateRequestHandler(this.taskRequestQueue, new LocalTaskSchedulerService.LocalContainerFactory(this.appContext), this.taskAllocations, this.appClientDelegate, conf);
            return this.requestHandler;
        }

        public void serviceStart() {
        }

        public void startRequestHandlerThread() {
            this.asyncDelegateRequestThread.start();
        }

        public MockAsyncDelegateRequestHandler getRequestHandler() {
            return this.requestHandler;
        }

        static class MockAsyncDelegateRequestHandler
        extends LocalTaskSchedulerService.AsyncDelegateRequestHandler {
            public int allocateCount = 0;
            public int deallocateCount = 0;
            public int processedCount = 0;

            MockAsyncDelegateRequestHandler(BlockingQueue<LocalTaskSchedulerService.TaskRequest> taskRequestQueue, LocalTaskSchedulerService.LocalContainerFactory localContainerFactory, HashMap<Object, Container> taskAllocations, TaskSchedulerService.TaskSchedulerAppCallback appClientDelegate, Configuration conf) {
                super(taskRequestQueue, localContainerFactory, taskAllocations, appClientDelegate, conf);
            }

            void processRequest() {
                super.processRequest();
                ++this.processedCount;
            }

            public void drainRequest(int count) {
                while (this.processedCount != count || !this.taskRequestQueue.isEmpty()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }

            void allocateTask(LocalTaskSchedulerService.AllocateTaskRequest request) {
                super.allocateTask(request);
                ++this.allocateCount;
            }

            void deallocateTask(LocalTaskSchedulerService.DeallocateTaskRequest request) {
                super.deallocateTask(request);
                ++this.deallocateCount;
            }
        }
    }
}

