/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import java.util.LinkedList;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ContainerContext;
import org.apache.tez.dag.app.TaskAttemptListener;
import org.apache.tez.dag.app.TaskHeartbeatHandler;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.dag.StateChangeNotifier;
import org.apache.tez.dag.app.dag.impl.VertexImpl;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.dag.utils.TaskSpecificLaunchCmdOption;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestVertexImpl2 {
    @Test(timeout=5000L)
    public void testTaskLoggingOptsPerLogger() {
        TezConfiguration conf = new TezConfiguration();
        conf.set("tez.task.log.level", "DEBUG;org.apache.hadoop.ipc=INFO;org.apache.hadoop.server=INFO");
        LogTestInfoHolder testInfo = new LogTestInfoHolder((Configuration)conf);
        LinkedList<String> expectedCommands = new LinkedList<String>();
        expectedCommands.add("-Dlog4j.configuratorClass=org.apache.tez.common.TezLog4jConfigurator");
        expectedCommands.add("-Dlog4j.configuration=tez-container-log4j.properties");
        expectedCommands.add("-Dyarn.app.container.log.dir=<LOG_DIR>");
        expectedCommands.add("-Dtez.root.logger=DEBUG,CLA");
        for (int i = 0; i < testInfo.numTasks; ++i) {
            ContainerContext containerContext = testInfo.vertex.getContainerContext(i);
            String javaOpts = containerContext.getJavaOpts();
            Assert.assertTrue((boolean)javaOpts.contains(testInfo.initialJavaOpts));
            for (String expectedCmd : expectedCommands) {
                Assert.assertTrue((boolean)javaOpts.contains(expectedCmd));
            }
            Map env = containerContext.getEnvironment();
            String val = (String)env.get(testInfo.envKey);
            Assert.assertEquals((Object)testInfo.envVal, (Object)val);
            String logEnvVal = (String)env.get("TEZ_CONTAINER_LOG_PARAMS");
            Assert.assertEquals((Object)"org.apache.hadoop.ipc=INFO;org.apache.hadoop.server=INFO", (Object)logEnvVal);
        }
    }

    @Test(timeout=5000L)
    public void testTaskLoggingOptsSimple() {
        TezConfiguration conf = new TezConfiguration();
        conf.set("tez.task.log.level", "DEBUG");
        LogTestInfoHolder testInfo = new LogTestInfoHolder((Configuration)conf);
        LinkedList<String> expectedCommands = new LinkedList<String>();
        expectedCommands.add("-Dlog4j.configuratorClass=org.apache.tez.common.TezLog4jConfigurator");
        expectedCommands.add("-Dlog4j.configuration=tez-container-log4j.properties");
        expectedCommands.add("-Dyarn.app.container.log.dir=<LOG_DIR>");
        expectedCommands.add("-Dtez.root.logger=DEBUG,CLA");
        for (int i = 0; i < testInfo.numTasks; ++i) {
            ContainerContext containerContext = testInfo.vertex.getContainerContext(i);
            String javaOpts = containerContext.getJavaOpts();
            Assert.assertTrue((boolean)javaOpts.contains(testInfo.initialJavaOpts));
            for (String expectedCmd : expectedCommands) {
                Assert.assertTrue((boolean)javaOpts.contains(expectedCmd));
            }
            Map env = containerContext.getEnvironment();
            String val = (String)env.get(testInfo.envKey);
            Assert.assertEquals((Object)testInfo.envVal, (Object)val);
            String logEnvVal = (String)env.get("TEZ_CONTAINER_LOG_PARAMS");
            Assert.assertNull((Object)logEnvVal);
        }
    }

    @Test(timeout=5000L)
    public void testTaskSpecificLoggingOpts() {
        String logEnvVal;
        String val;
        Map env;
        String javaOpts;
        ContainerContext containerContext;
        int i;
        String vertexName = "testvertex";
        String customJavaOpts = "-Xmx128m";
        TezConfiguration conf = new TezConfiguration();
        conf.set("tez.task.log.level", "INFO");
        conf.set("tez.task-specific.launch.cmd-opts.list", vertexName + "[0,1,2]");
        conf.set("tez.task-specific.log.level", "DEBUG;org.apache.tez=INFO");
        conf.set("tez.task-specific.launch.cmd-opts", customJavaOpts);
        LogTestInfoHolder testInfo = new LogTestInfoHolder((Configuration)conf);
        LinkedList<String> expectedCommands = new LinkedList<String>();
        expectedCommands.add("-Dlog4j.configuratorClass=org.apache.tez.common.TezLog4jConfigurator");
        expectedCommands.add("-Dlog4j.configuration=tez-container-log4j.properties");
        expectedCommands.add("-Dyarn.app.container.log.dir=<LOG_DIR>");
        expectedCommands.add("-Dtez.root.logger=INFO,CLA");
        for (i = 3; i < testInfo.numTasks; ++i) {
            containerContext = testInfo.vertex.getContainerContext(i);
            javaOpts = containerContext.getJavaOpts();
            Assert.assertTrue((boolean)javaOpts.contains(testInfo.initialJavaOpts));
            for (String expectedCmd : expectedCommands) {
                Assert.assertTrue((boolean)javaOpts.contains(expectedCmd));
            }
            env = containerContext.getEnvironment();
            val = (String)env.get(testInfo.envKey);
            Assert.assertEquals((Object)testInfo.envVal, (Object)val);
            logEnvVal = (String)env.get("TEZ_CONTAINER_LOG_PARAMS");
            Assert.assertNull((Object)logEnvVal);
        }
        expectedCommands = new LinkedList();
        expectedCommands.add("-Dlog4j.configuratorClass=org.apache.tez.common.TezLog4jConfigurator");
        expectedCommands.add("-Dlog4j.configuration=tez-container-log4j.properties");
        expectedCommands.add("-Dyarn.app.container.log.dir=<LOG_DIR>");
        expectedCommands.add("-Dtez.root.logger=DEBUG,CLA");
        for (i = 0; i < 3; ++i) {
            containerContext = testInfo.vertex.getContainerContext(i);
            javaOpts = containerContext.getJavaOpts();
            Assert.assertTrue((boolean)javaOpts.contains(testInfo.initialJavaOpts));
            for (String expectedCmd : expectedCommands) {
                Assert.assertTrue((boolean)javaOpts.contains(expectedCmd));
            }
            env = containerContext.getEnvironment();
            val = (String)env.get(testInfo.envKey);
            Assert.assertEquals((Object)testInfo.envVal, (Object)val);
            logEnvVal = (String)env.get("TEZ_CONTAINER_LOG_PARAMS");
            Assert.assertEquals((Object)"org.apache.tez=INFO", (Object)logEnvVal);
        }
    }

    @Test(timeout=5000L)
    public void testTaskSpecificLoggingOpts2() {
        String logEnvVal;
        String val;
        Map env;
        String javaOpts;
        ContainerContext containerContext;
        int i;
        String vertexName = "testvertex";
        String customJavaOpts = "-Xmx128m";
        TezConfiguration conf = new TezConfiguration();
        conf.set("tez.task.log.level", "WARN;org.apache.tez=INFO");
        conf.set("tez.task-specific.launch.cmd-opts.list", vertexName + "[0,1,2]");
        conf.set("tez.task-specific.log.level", "DEBUG");
        conf.set("tez.task-specific.launch.cmd-opts", customJavaOpts);
        LogTestInfoHolder testInfo = new LogTestInfoHolder((Configuration)conf);
        LinkedList<String> expectedCommands = new LinkedList<String>();
        expectedCommands.add("-Dlog4j.configuratorClass=org.apache.tez.common.TezLog4jConfigurator");
        expectedCommands.add("-Dlog4j.configuration=tez-container-log4j.properties");
        expectedCommands.add("-Dyarn.app.container.log.dir=<LOG_DIR>");
        expectedCommands.add("-Dtez.root.logger=WARN,CLA");
        for (i = 3; i < testInfo.numTasks; ++i) {
            containerContext = testInfo.vertex.getContainerContext(i);
            javaOpts = containerContext.getJavaOpts();
            Assert.assertTrue((boolean)javaOpts.contains(testInfo.initialJavaOpts));
            for (String expectedCmd : expectedCommands) {
                Assert.assertTrue((boolean)javaOpts.contains(expectedCmd));
            }
            env = containerContext.getEnvironment();
            val = (String)env.get(testInfo.envKey);
            Assert.assertEquals((Object)testInfo.envVal, (Object)val);
            logEnvVal = (String)env.get("TEZ_CONTAINER_LOG_PARAMS");
            Assert.assertEquals((Object)"org.apache.tez=INFO", (Object)logEnvVal);
        }
        expectedCommands = new LinkedList();
        expectedCommands.add("-Dlog4j.configuratorClass=org.apache.tez.common.TezLog4jConfigurator");
        expectedCommands.add("-Dlog4j.configuration=tez-container-log4j.properties");
        expectedCommands.add("-Dyarn.app.container.log.dir=<LOG_DIR>");
        expectedCommands.add("-Dtez.root.logger=DEBUG,CLA");
        for (i = 0; i < 3; ++i) {
            containerContext = testInfo.vertex.getContainerContext(i);
            javaOpts = containerContext.getJavaOpts();
            Assert.assertTrue((boolean)javaOpts.contains(testInfo.initialJavaOpts));
            for (String expectedCmd : expectedCommands) {
                Assert.assertTrue((boolean)javaOpts.contains(expectedCmd));
            }
            env = containerContext.getEnvironment();
            val = (String)env.get(testInfo.envKey);
            Assert.assertEquals((Object)testInfo.envVal, (Object)val);
            logEnvVal = (String)env.get("TEZ_CONTAINER_LOG_PARAMS");
            Assert.assertNull((Object)logEnvVal);
        }
    }

    private static class LogTestInfoHolder {
        final AppContext mockAppContext = (AppContext)Mockito.mock(AppContext.class);
        final DAG mockDag = (DAG)Mockito.mock(DAG.class);
        final VertexImpl vertex;
        final DAGProtos.VertexPlan vertexPlan;
        final int numTasks = 10;
        final String initialJavaOpts = "initialJavaOpts";
        final String envKey = "key1";
        final String envVal = "val1";

        LogTestInfoHolder(Configuration conf) {
            this(conf, "testvertex");
        }

        LogTestInfoHolder(Configuration conf, String vertexName) {
            ((DAG)Mockito.doReturn((Object)new Credentials()).when((Object)this.mockDag)).getCredentials();
            ((AppContext)Mockito.doReturn((Object)this.mockDag).when((Object)this.mockAppContext)).getCurrentDAG();
            this.vertexPlan = DAGProtos.VertexPlan.newBuilder().setName(vertexName).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setJavaOpts("initialJavaOpts").setNumTasks(10).setMemoryMb(1024).setVirtualCores(1).setTaskModule("taskmodule").addEnvironmentSetting(DAGProtos.PlanKeyValuePair.newBuilder().setKey("key1").setValue("val1").build()).build()).setType(DAGProtos.PlanVertexType.NORMAL).build();
            this.vertex = new VertexImpl(TezVertexID.fromString((String)"vertex_1418197758681_0001_1_00"), this.vertexPlan, "testvertex", conf, (EventHandler)Mockito.mock(EventHandler.class), (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class), (Clock)Mockito.mock(Clock.class), (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), false, this.mockAppContext, VertexLocationHint.create(new LinkedList()), null, new TaskSpecificLaunchCmdOption(conf), (StateChangeNotifier)Mockito.mock(StateChangeNotifier.class));
        }
    }
}

