/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.client.VertexStatus;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.api.oldrecords.TaskState;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ContainerContext;
import org.apache.tez.dag.app.TaskAttemptListener;
import org.apache.tez.dag.app.TaskHeartbeatHandler;
import org.apache.tez.dag.app.dag.StateChangeNotifier;
import org.apache.tez.dag.app.dag.TaskAttemptStateInternal;
import org.apache.tez.dag.app.dag.TaskStateInternal;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.event.DAGEventType;
import org.apache.tez.dag.app.dag.event.TaskAttemptEvent;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventType;
import org.apache.tez.dag.app.dag.event.TaskEvent;
import org.apache.tez.dag.app.dag.event.TaskEventRecoverTask;
import org.apache.tez.dag.app.dag.event.TaskEventType;
import org.apache.tez.dag.app.dag.event.VertexEventType;
import org.apache.tez.dag.app.dag.impl.TaskAttemptImpl;
import org.apache.tez.dag.app.dag.impl.TaskImpl;
import org.apache.tez.dag.app.dag.impl.TestTaskAttemptRecovery;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.events.TaskAttemptFinishedEvent;
import org.apache.tez.dag.history.events.TaskAttemptStartedEvent;
import org.apache.tez.dag.history.events.TaskFinishedEvent;
import org.apache.tez.dag.history.events.TaskStartedEvent;
import org.apache.tez.dag.records.TaskAttemptTerminationCause;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.OutputCommitter;
import org.apache.tez.runtime.api.OutputCommitterContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class TestTaskRecovery {
    private TaskImpl task;
    private DrainDispatcher dispatcher;
    private int taskAttemptCounter = 0;
    private Configuration conf = new Configuration();
    private AppContext mockAppContext;
    private TestTaskAttemptRecovery.MockHistoryEventHandler mockHistoryEventHandler;
    private ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
    private TezDAGID dagId = TezDAGID.getInstance((ApplicationId)this.appId, (int)1);
    private TezVertexID vertexId = TezVertexID.getInstance((TezDAGID)this.dagId, (int)1);
    private Vertex vertex;
    private String vertexName = "v1";
    private long taskScheduledTime = 100L;
    private long taskStartTime = this.taskScheduledTime + 100L;
    private long taskFinishTime = this.taskStartTime + 100L;
    private TaskAttemptEventHandler taEventHandler = new TaskAttemptEventHandler();

    @Before
    public void setUp() {
        this.dispatcher = new DrainDispatcher();
        this.dispatcher.register(DAGEventType.class, (EventHandler)Mockito.mock(EventHandler.class));
        this.dispatcher.register(VertexEventType.class, (EventHandler)Mockito.mock(EventHandler.class));
        this.dispatcher.register(TaskEventType.class, (EventHandler)new TaskEventHandler());
        this.dispatcher.register(TaskAttemptEventType.class, (EventHandler)this.taEventHandler);
        this.dispatcher.init(new Configuration());
        this.dispatcher.start();
        this.vertex = (Vertex)Mockito.mock(Vertex.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.vertex.getProcessorDescriptor().getClassName()).thenReturn((Object)"");
        this.mockAppContext = (AppContext)Mockito.mock(AppContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.mockAppContext.getCurrentDAG().getVertex((TezVertexID)Matchers.any(TezVertexID.class))).thenReturn((Object)this.vertex);
        this.mockHistoryEventHandler = new TestTaskAttemptRecovery.MockHistoryEventHandler(this.mockAppContext);
        Mockito.when((Object)this.mockAppContext.getHistoryHandler()).thenReturn((Object)this.mockHistoryEventHandler);
        this.task = new TaskImpl(this.vertexId, 0, this.dispatcher.getEventHandler(), new Configuration(), (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class), (Clock)new SystemClock(), (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), this.mockAppContext, false, Resource.newInstance((int)1, (int)1), (ContainerContext)Mockito.mock(ContainerContext.class), (StateChangeNotifier)Mockito.mock(StateChangeNotifier.class));
        HashMap<String, TestOutputCommitter> committers = new HashMap<String, TestOutputCommitter>();
        committers.put("out1", new TestOutputCommitter((OutputCommitterContext)Mockito.mock(OutputCommitterContext.class), true, false));
        Mockito.when((Object)this.task.getVertex().getOutputCommitters()).thenReturn(committers);
    }

    private void restoreFromTaskStartEvent() {
        TaskState recoveredState = this.task.restoreFromEvent((HistoryEvent)new TaskStartedEvent(this.task.getTaskId(), this.vertexName, this.taskScheduledTime, this.taskStartTime));
        Assert.assertEquals((Object)TaskState.SCHEDULED, (Object)recoveredState);
        Assert.assertEquals((long)0L, (long)this.task.getFinishedAttemptsCount());
        Assert.assertEquals((long)this.taskScheduledTime, (long)this.task.scheduledTime);
        Assert.assertEquals((long)0L, (long)this.task.getAttempts().size());
    }

    private void restoreFromFirstTaskAttemptStartEvent(TezTaskAttemptID taId) {
        long taStartTime = this.taskStartTime + 100L;
        TaskState recoveredState = this.task.restoreFromEvent((HistoryEvent)new TaskAttemptStartedEvent(taId, this.vertexName, taStartTime, (ContainerId)Mockito.mock(ContainerId.class), (NodeId)Mockito.mock(NodeId.class), "", "", ""));
        Assert.assertEquals((Object)TaskState.RUNNING, (Object)recoveredState);
        Assert.assertEquals((long)0L, (long)this.task.getFinishedAttemptsCount());
        Assert.assertEquals((long)this.taskScheduledTime, (long)this.task.scheduledTime);
        Assert.assertEquals((long)1L, (long)this.task.getAttempts().size());
        Assert.assertEquals((Object)TaskAttemptStateInternal.NEW, (Object)((TaskAttemptImpl)this.task.getAttempt(taId)).getInternalState());
        Assert.assertEquals((long)1L, (long)this.task.getUncompletedAttemptsCount());
    }

    @Test(timeout=5000L)
    public void testRecovery_New() {
        this.task.handle((TaskEvent)new TaskEventRecoverTask(this.task.getTaskId()));
        Assert.assertEquals((Object)TaskStateInternal.NEW, (Object)this.task.getInternalState());
    }

    @Test(timeout=5000L)
    public void testRecovery_NoStartEvent() {
        try {
            this.task.restoreFromEvent((HistoryEvent)new TaskFinishedEvent(this.task.getTaskId(), this.vertexName, this.taskStartTime, this.taskFinishTime, null, TaskState.SUCCEEDED, "", new TezCounters()));
            Assert.fail((String)"Should fail due to no TaskStartEvent before TaskFinishEvent");
        }
        catch (Throwable e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Finished Event seen but no Started Event was encountered earlier"));
        }
    }

    @Test(timeout=5000L)
    public void testRecoveryNewToKilled_NoStartEvent() {
        this.task.restoreFromEvent((HistoryEvent)new TaskFinishedEvent(this.task.getTaskId(), this.vertexName, this.taskStartTime, this.taskFinishTime, null, TaskState.KILLED, "", new TezCounters()));
    }

    @Test(timeout=5000L)
    public void testRecovery_Started() {
        this.restoreFromTaskStartEvent();
        this.task.handle((TaskEvent)new TaskEventRecoverTask(this.task.getTaskId()));
        Assert.assertEquals((Object)TaskStateInternal.RUNNING, (Object)this.task.getInternalState());
        Assert.assertEquals((long)1L, (long)this.task.getAttempts().size());
        Assert.assertEquals((long)0L, (long)this.task.getFinishedAttemptsCount());
        Assert.assertEquals((long)0L, (long)this.task.failedAttempts);
        Assert.assertEquals(null, (Object)this.task.successfulAttempt);
    }

    @Test(timeout=5000L)
    public void testRecovery_OnlyTAFinishedEvent_KILLED() {
        this.restoreFromTaskStartEvent();
        TezTaskAttemptID taId = this.getNewTaskAttemptID(this.task.getTaskId());
        this.task.restoreFromEvent((HistoryEvent)new TaskAttemptFinishedEvent(taId, this.vertexName, 0L, 0L, TaskAttemptState.KILLED, TaskAttemptTerminationCause.TERMINATED_BY_CLIENT, "", new TezCounters()));
        this.task.handle((TaskEvent)new TaskEventRecoverTask(this.task.getTaskId()));
        this.dispatcher.await();
        Assert.assertEquals((Object)TaskStateInternal.RUNNING, (Object)this.task.getInternalState());
        Assert.assertEquals((long)2L, (long)this.task.getAttempts().size());
        Assert.assertEquals((long)1L, (long)this.task.getFinishedAttemptsCount());
        Assert.assertEquals((long)0L, (long)this.task.failedAttempts);
        Assert.assertEquals(null, (Object)this.task.successfulAttempt);
    }

    @Test(timeout=5000L)
    public void testRecovery_OnlyTAFinishedEvent_FAILED() {
        this.restoreFromTaskStartEvent();
        TezTaskAttemptID taId = this.getNewTaskAttemptID(this.task.getTaskId());
        this.task.restoreFromEvent((HistoryEvent)new TaskAttemptFinishedEvent(taId, this.vertexName, 0L, 0L, TaskAttemptState.FAILED, TaskAttemptTerminationCause.CONTAINER_LAUNCH_FAILED, "", new TezCounters()));
        this.task.handle((TaskEvent)new TaskEventRecoverTask(this.task.getTaskId()));
        this.dispatcher.await();
        Assert.assertEquals((Object)TaskStateInternal.RUNNING, (Object)this.task.getInternalState());
        Assert.assertEquals((long)2L, (long)this.task.getAttempts().size());
        Assert.assertEquals((long)1L, (long)this.task.getFinishedAttemptsCount());
        Assert.assertEquals((long)1L, (long)this.task.failedAttempts);
        Assert.assertEquals(null, (Object)this.task.successfulAttempt);
    }

    @Test(timeout=5000L)
    public void testRecovery_OnlyTAFinishedEvent_SUCCEEDED() {
        this.restoreFromTaskStartEvent();
        TezTaskAttemptID taId = this.getNewTaskAttemptID(this.task.getTaskId());
        try {
            this.task.restoreFromEvent((HistoryEvent)new TaskAttemptFinishedEvent(taId, this.vertexName, 0L, 0L, TaskAttemptState.SUCCEEDED, null, "", new TezCounters()));
            Assert.fail((String)"Should fail due to no TaskAttemptStartedEvent but with TaskAttemptFinishedEvent(Succeeded)");
        }
        catch (TezUncheckedException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Could not find task attempt when trying to recover"));
        }
    }

    @Test(timeout=5000L)
    public void testRecovery_OneTAStarted() {
        this.restoreFromTaskStartEvent();
        TezTaskAttemptID taId = this.getNewTaskAttemptID(this.task.getTaskId());
        this.restoreFromFirstTaskAttemptStartEvent(taId);
        this.task.handle((TaskEvent)new TaskEventRecoverTask(this.task.getTaskId()));
        this.dispatcher.await();
        Assert.assertEquals((Object)TaskStateInternal.RUNNING, (Object)this.task.getInternalState());
        Assert.assertEquals((long)2L, (long)this.task.getAttempts().size());
        Assert.assertEquals((long)1L, (long)this.task.getFinishedAttemptsCount());
        Assert.assertEquals((long)0L, (long)this.task.failedAttempts);
        Assert.assertEquals(null, (Object)this.task.successfulAttempt);
    }

    @Test(timeout=5000L)
    public void testRecovery_OneTAStarted_SUCCEEDED() {
        this.restoreFromTaskStartEvent();
        TezTaskAttemptID taId = this.getNewTaskAttemptID(this.task.getTaskId());
        this.restoreFromFirstTaskAttemptStartEvent(taId);
        long taStartTime = this.taskStartTime + 100L;
        long taFinishTime = taStartTime + 100L;
        TaskState recoveredState = this.task.restoreFromEvent((HistoryEvent)new TaskAttemptFinishedEvent(taId, this.vertexName, taStartTime, taFinishTime, TaskAttemptState.SUCCEEDED, null, "", new TezCounters()));
        Assert.assertEquals((Object)TaskState.SUCCEEDED, (Object)recoveredState);
        Assert.assertEquals((long)1L, (long)this.task.getAttempts().size());
        Assert.assertEquals((long)1L, (long)this.task.getFinishedAttemptsCount());
        Assert.assertEquals((long)0L, (long)this.task.failedAttempts);
        Assert.assertEquals((long)0L, (long)this.task.getUncompletedAttemptsCount());
        Assert.assertEquals((Object)taId, (Object)this.task.successfulAttempt);
        this.task.handle((TaskEvent)new TaskEventRecoverTask(this.task.getTaskId()));
        Assert.assertEquals((Object)TaskStateInternal.SUCCEEDED, (Object)this.task.getInternalState());
        Assert.assertEquals((long)1L, (long)this.task.getAttempts().size());
        Assert.assertEquals((long)1L, (long)this.task.getFinishedAttemptsCount());
        Assert.assertEquals((long)0L, (long)this.task.failedAttempts);
        Assert.assertEquals((long)0L, (long)this.task.getUncompletedAttemptsCount());
        Assert.assertEquals((Object)taId, (Object)this.task.successfulAttempt);
        this.mockHistoryEventHandler.verifyTaskFinishedEvent(this.task.getTaskId(), TaskState.SUCCEEDED, 1);
    }

    @Test(timeout=5000L)
    public void testRecovery_OneTAStarted_FAILED() {
        this.restoreFromTaskStartEvent();
        TezTaskAttemptID taId = this.getNewTaskAttemptID(this.task.getTaskId());
        this.restoreFromFirstTaskAttemptStartEvent(taId);
        long taStartTime = this.taskStartTime + 100L;
        long taFinishTime = taStartTime + 100L;
        TaskState recoveredState = this.task.restoreFromEvent((HistoryEvent)new TaskAttemptFinishedEvent(taId, this.vertexName, taStartTime, taFinishTime, TaskAttemptState.FAILED, null, "", new TezCounters()));
        Assert.assertEquals((Object)TaskState.RUNNING, (Object)recoveredState);
        Assert.assertEquals((long)1L, (long)this.task.getAttempts().size());
        Assert.assertEquals((long)1L, (long)this.task.getFinishedAttemptsCount());
        Assert.assertEquals((long)1L, (long)this.task.failedAttempts);
        Assert.assertEquals((long)0L, (long)this.task.getUncompletedAttemptsCount());
        Assert.assertEquals(null, (Object)this.task.successfulAttempt);
        this.task.handle((TaskEvent)new TaskEventRecoverTask(this.task.getTaskId()));
        Assert.assertEquals((Object)TaskStateInternal.RUNNING, (Object)this.task.getInternalState());
        Assert.assertEquals((long)2L, (long)this.task.getAttempts().size());
        Assert.assertEquals((long)1L, (long)this.task.getFinishedAttemptsCount());
        Assert.assertEquals((long)1L, (long)this.task.failedAttempts);
        Assert.assertEquals((long)1L, (long)this.task.getUncompletedAttemptsCount());
        Assert.assertEquals(null, (Object)this.task.successfulAttempt);
    }

    @Test(timeout=5000L)
    public void testRecovery_OneTAStarted_KILLED() {
        this.restoreFromTaskStartEvent();
        TezTaskAttemptID taId = this.getNewTaskAttemptID(this.task.getTaskId());
        this.restoreFromFirstTaskAttemptStartEvent(taId);
        long taStartTime = this.taskStartTime + 100L;
        long taFinishTime = taStartTime + 100L;
        TaskState recoveredState = this.task.restoreFromEvent((HistoryEvent)new TaskAttemptFinishedEvent(taId, this.vertexName, taStartTime, taFinishTime, TaskAttemptState.KILLED, null, "", new TezCounters()));
        Assert.assertEquals((Object)TaskState.RUNNING, (Object)recoveredState);
        Assert.assertEquals((long)1L, (long)this.task.getAttempts().size());
        Assert.assertEquals((long)1L, (long)this.task.getFinishedAttemptsCount());
        Assert.assertEquals((long)0L, (long)this.task.failedAttempts);
        Assert.assertEquals((long)0L, (long)this.task.getUncompletedAttemptsCount());
        Assert.assertEquals(null, (Object)this.task.successfulAttempt);
        this.task.handle((TaskEvent)new TaskEventRecoverTask(this.task.getTaskId()));
        Assert.assertEquals((Object)TaskStateInternal.RUNNING, (Object)this.task.getInternalState());
        Assert.assertEquals((long)2L, (long)this.task.getAttempts().size());
        Assert.assertEquals((long)1L, (long)this.task.getFinishedAttemptsCount());
        Assert.assertEquals((long)0L, (long)this.task.failedAttempts);
        Assert.assertEquals((long)1L, (long)this.task.getUncompletedAttemptsCount());
        Assert.assertEquals(null, (Object)this.task.successfulAttempt);
    }

    @Test(timeout=5000L)
    public void testRecovery_OneTAStarted_SUCCEEDED_Finished() {
        this.restoreFromTaskStartEvent();
        TezTaskAttemptID taId = this.getNewTaskAttemptID(this.task.getTaskId());
        this.restoreFromFirstTaskAttemptStartEvent(taId);
        long taStartTime = this.taskStartTime + 100L;
        long taFinishTime = taStartTime + 100L;
        TaskState recoveredState = this.task.restoreFromEvent((HistoryEvent)new TaskAttemptFinishedEvent(taId, this.vertexName, taStartTime, taFinishTime, TaskAttemptState.SUCCEEDED, null, "", new TezCounters()));
        Assert.assertEquals((Object)TaskState.SUCCEEDED, (Object)recoveredState);
        Assert.assertEquals((long)1L, (long)this.task.getAttempts().size());
        Assert.assertEquals((long)1L, (long)this.task.getFinishedAttemptsCount());
        Assert.assertEquals((long)0L, (long)this.task.failedAttempts);
        Assert.assertEquals((long)0L, (long)this.task.getUncompletedAttemptsCount());
        Assert.assertEquals((Object)taId, (Object)this.task.successfulAttempt);
        recoveredState = this.task.restoreFromEvent((HistoryEvent)new TaskFinishedEvent(this.task.getTaskId(), this.vertexName, this.taskStartTime, this.taskFinishTime, taId, TaskState.SUCCEEDED, "", new TezCounters()));
        Assert.assertEquals((Object)TaskState.SUCCEEDED, (Object)recoveredState);
        Assert.assertEquals((Object)taId, (Object)this.task.successfulAttempt);
        this.task.handle((TaskEvent)new TaskEventRecoverTask(this.task.getTaskId()));
        Assert.assertEquals((Object)TaskStateInternal.SUCCEEDED, (Object)this.task.getInternalState());
        Assert.assertEquals((long)1L, (long)this.task.getAttempts().size());
        Assert.assertEquals((long)1L, (long)this.task.getFinishedAttemptsCount());
        Assert.assertEquals((long)0L, (long)this.task.failedAttempts);
        Assert.assertEquals((long)0L, (long)this.task.getUncompletedAttemptsCount());
        Assert.assertEquals((Object)taId, (Object)this.task.successfulAttempt);
        this.mockHistoryEventHandler.verifyTaskFinishedEvent(this.task.getTaskId(), TaskState.SUCCEEDED, 1);
    }

    @Test(timeout=5000L)
    public void testRecovery_OneTAStarted_SUCCEEDED_FAILED() {
        this.restoreFromTaskStartEvent();
        TezTaskAttemptID taId = this.getNewTaskAttemptID(this.task.getTaskId());
        this.restoreFromFirstTaskAttemptStartEvent(taId);
        long taStartTime = this.taskStartTime + 100L;
        long taFinishTime = taStartTime + 100L;
        TaskState recoveredState = this.task.restoreFromEvent((HistoryEvent)new TaskAttemptFinishedEvent(taId, this.vertexName, taStartTime, taFinishTime, TaskAttemptState.SUCCEEDED, null, "", new TezCounters()));
        Assert.assertEquals((Object)TaskState.SUCCEEDED, (Object)recoveredState);
        Assert.assertEquals((long)1L, (long)this.task.getAttempts().size());
        Assert.assertEquals((long)1L, (long)this.task.getFinishedAttemptsCount());
        Assert.assertEquals((long)0L, (long)this.task.failedAttempts);
        Assert.assertEquals((long)0L, (long)this.task.getUncompletedAttemptsCount());
        Assert.assertEquals((Object)taId, (Object)this.task.successfulAttempt);
        recoveredState = this.task.restoreFromEvent((HistoryEvent)new TaskAttemptFinishedEvent(taId, this.vertexName, taStartTime, taFinishTime, TaskAttemptState.FAILED, null, "", new TezCounters()));
        Assert.assertEquals((Object)TaskState.RUNNING, (Object)recoveredState);
        Assert.assertEquals((long)1L, (long)this.task.getAttempts().size());
        Assert.assertEquals((long)1L, (long)this.task.getFinishedAttemptsCount());
        Assert.assertEquals((long)1L, (long)this.task.failedAttempts);
        Assert.assertEquals((long)0L, (long)this.task.getUncompletedAttemptsCount());
        Assert.assertEquals(null, (Object)this.task.successfulAttempt);
        this.task.handle((TaskEvent)new TaskEventRecoverTask(this.task.getTaskId()));
        Assert.assertEquals((Object)TaskStateInternal.RUNNING, (Object)this.task.getInternalState());
        Assert.assertEquals((long)2L, (long)this.task.getAttempts().size());
        Assert.assertEquals((long)1L, (long)this.task.getFinishedAttemptsCount());
        Assert.assertEquals((long)1L, (long)this.task.failedAttempts);
        Assert.assertEquals((long)1L, (long)this.task.getUncompletedAttemptsCount());
        Assert.assertEquals(null, (Object)this.task.successfulAttempt);
    }

    @Test(timeout=5000L)
    public void testRecovery_OneTAStarted_SUCCEEDED_KILLED() {
        this.restoreFromTaskStartEvent();
        TezTaskAttemptID taId = this.getNewTaskAttemptID(this.task.getTaskId());
        this.restoreFromFirstTaskAttemptStartEvent(taId);
        long taStartTime = this.taskStartTime + 100L;
        long taFinishTime = taStartTime + 100L;
        TaskState recoveredState = this.task.restoreFromEvent((HistoryEvent)new TaskAttemptFinishedEvent(taId, this.vertexName, taStartTime, taFinishTime, TaskAttemptState.SUCCEEDED, null, "", new TezCounters()));
        Assert.assertEquals((Object)TaskState.SUCCEEDED, (Object)recoveredState);
        Assert.assertEquals((long)1L, (long)this.task.getAttempts().size());
        Assert.assertEquals((long)1L, (long)this.task.getFinishedAttemptsCount());
        Assert.assertEquals((long)0L, (long)this.task.failedAttempts);
        Assert.assertEquals((long)0L, (long)this.task.getUncompletedAttemptsCount());
        Assert.assertEquals((Object)taId, (Object)this.task.successfulAttempt);
        recoveredState = this.task.restoreFromEvent((HistoryEvent)new TaskAttemptFinishedEvent(taId, this.vertexName, taStartTime, taFinishTime, TaskAttemptState.KILLED, null, "", new TezCounters()));
        Assert.assertEquals((Object)TaskState.RUNNING, (Object)recoveredState);
        Assert.assertEquals((long)1L, (long)this.task.getAttempts().size());
        Assert.assertEquals((long)1L, (long)this.task.getFinishedAttemptsCount());
        Assert.assertEquals((long)0L, (long)this.task.failedAttempts);
        Assert.assertEquals((long)0L, (long)this.task.getUncompletedAttemptsCount());
        Assert.assertEquals(null, (Object)this.task.successfulAttempt);
        this.task.handle((TaskEvent)new TaskEventRecoverTask(this.task.getTaskId()));
        Assert.assertEquals((Object)TaskStateInternal.RUNNING, (Object)this.task.getInternalState());
        Assert.assertEquals((long)2L, (long)this.task.getAttempts().size());
        Assert.assertEquals((long)1L, (long)this.task.getFinishedAttemptsCount());
        Assert.assertEquals((long)0L, (long)this.task.failedAttempts);
        Assert.assertEquals((long)1L, (long)this.task.getUncompletedAttemptsCount());
        Assert.assertEquals(null, (Object)this.task.successfulAttempt);
    }

    @Test(timeout=5000L)
    public void testRecovery_Commit_Failed_Recovery_Not_Supported() {
        HashMap<String, TestOutputCommitter> committers = new HashMap<String, TestOutputCommitter>();
        committers.put("out1", new TestOutputCommitter((OutputCommitterContext)Mockito.mock(OutputCommitterContext.class), false, false));
        Mockito.when((Object)this.task.getVertex().getOutputCommitters()).thenReturn(committers);
        this.restoreFromTaskStartEvent();
        TezTaskAttemptID taId = this.getNewTaskAttemptID(this.task.getTaskId());
        this.restoreFromFirstTaskAttemptStartEvent(taId);
        long taStartTime = this.taskStartTime + 100L;
        long taFinishTime = taStartTime + 100L;
        TaskState recoveredState = this.task.restoreFromEvent((HistoryEvent)new TaskAttemptFinishedEvent(taId, this.vertexName, taStartTime, taFinishTime, TaskAttemptState.SUCCEEDED, null, "", new TezCounters()));
        Assert.assertEquals((Object)TaskState.SUCCEEDED, (Object)recoveredState);
        Assert.assertEquals((long)1L, (long)this.task.getAttempts().size());
        Assert.assertEquals((long)1L, (long)this.task.getFinishedAttemptsCount());
        Assert.assertEquals((long)0L, (long)this.task.failedAttempts);
        Assert.assertEquals((long)0L, (long)this.task.getUncompletedAttemptsCount());
        Assert.assertEquals((Object)taId, (Object)this.task.successfulAttempt);
        this.task.handle((TaskEvent)new TaskEventRecoverTask(this.task.getTaskId()));
        Assert.assertEquals((Object)TaskStateInternal.RUNNING, (Object)this.task.getInternalState());
        Assert.assertEquals((long)2L, (long)this.task.getAttempts().size());
        Assert.assertEquals((long)1L, (long)this.task.getFinishedAttemptsCount());
        Assert.assertEquals((long)0L, (long)this.task.failedAttempts);
        Assert.assertEquals((long)1L, (long)this.task.getUncompletedAttemptsCount());
        Assert.assertEquals(null, (Object)this.task.successfulAttempt);
    }

    @Test(timeout=5000L)
    public void testRecovery_Commit_Failed_recover_fail() {
        HashMap<String, TestOutputCommitter> committers = new HashMap<String, TestOutputCommitter>();
        committers.put("out1", new TestOutputCommitter((OutputCommitterContext)Mockito.mock(OutputCommitterContext.class), true, true));
        Mockito.when((Object)this.task.getVertex().getOutputCommitters()).thenReturn(committers);
        this.restoreFromTaskStartEvent();
        TezTaskAttemptID taId = this.getNewTaskAttemptID(this.task.getTaskId());
        this.restoreFromFirstTaskAttemptStartEvent(taId);
        long taStartTime = this.taskStartTime + 100L;
        long taFinishTime = taStartTime + 100L;
        TaskState recoveredState = this.task.restoreFromEvent((HistoryEvent)new TaskAttemptFinishedEvent(taId, this.vertexName, taStartTime, taFinishTime, TaskAttemptState.SUCCEEDED, null, "", new TezCounters()));
        Assert.assertEquals((Object)TaskState.SUCCEEDED, (Object)recoveredState);
        Assert.assertEquals((long)1L, (long)this.task.getAttempts().size());
        Assert.assertEquals((long)1L, (long)this.task.getFinishedAttemptsCount());
        Assert.assertEquals((long)0L, (long)this.task.failedAttempts);
        Assert.assertEquals((long)0L, (long)this.task.getUncompletedAttemptsCount());
        Assert.assertEquals((Object)taId, (Object)this.task.successfulAttempt);
        this.task.handle((TaskEvent)new TaskEventRecoverTask(this.task.getTaskId()));
        Assert.assertEquals((Object)TaskStateInternal.RUNNING, (Object)this.task.getInternalState());
        Assert.assertEquals((long)2L, (long)this.task.getAttempts().size());
        Assert.assertEquals((long)1L, (long)this.task.getFinishedAttemptsCount());
        Assert.assertEquals((long)0L, (long)this.task.failedAttempts);
        Assert.assertEquals((long)1L, (long)this.task.getUncompletedAttemptsCount());
        Assert.assertEquals(null, (Object)this.task.successfulAttempt);
    }

    @Test(timeout=5000L)
    public void testRecovery_WithDesired_SUCCEEDED() {
        this.restoreFromTaskStartEvent();
        TezTaskAttemptID taId = this.getNewTaskAttemptID(this.task.getTaskId());
        this.restoreFromFirstTaskAttemptStartEvent(taId);
        this.task.handle((TaskEvent)new TaskEventRecoverTask(this.task.getTaskId(), TaskState.SUCCEEDED, false));
        Assert.assertEquals((Object)TaskStateInternal.SUCCEEDED, (Object)this.task.getInternalState());
        Assert.assertEquals((long)0L, (long)this.taEventHandler.getEvents().size());
    }

    @Test(timeout=5000L)
    public void testRecovery_WithDesired_FAILED() {
        this.restoreFromTaskStartEvent();
        TezTaskAttemptID taId = this.getNewTaskAttemptID(this.task.getTaskId());
        this.restoreFromFirstTaskAttemptStartEvent(taId);
        this.task.handle((TaskEvent)new TaskEventRecoverTask(this.task.getTaskId(), TaskState.FAILED, false));
        Assert.assertEquals((Object)TaskStateInternal.FAILED, (Object)this.task.getInternalState());
        Assert.assertEquals((long)0L, (long)this.taEventHandler.getEvents().size());
    }

    @Test(timeout=5000L)
    public void testRecovery_WithDesired_KILLED() {
        this.restoreFromTaskStartEvent();
        TezTaskAttemptID taId = this.getNewTaskAttemptID(this.task.getTaskId());
        this.restoreFromFirstTaskAttemptStartEvent(taId);
        this.task.handle((TaskEvent)new TaskEventRecoverTask(this.task.getTaskId(), TaskState.KILLED, false));
        Assert.assertEquals((Object)TaskStateInternal.KILLED, (Object)this.task.getInternalState());
        Assert.assertEquals((long)0L, (long)this.taEventHandler.getEvents().size());
    }

    @Test(timeout=5000L)
    public void testRecovery_OneTAStarted_Killed() {
        this.restoreFromTaskStartEvent();
        long taStartTime = this.taskStartTime + 100L;
        TezTaskAttemptID taId = this.getNewTaskAttemptID(this.task.getTaskId());
        TaskState recoveredState = this.task.restoreFromEvent((HistoryEvent)new TaskAttemptStartedEvent(taId, this.vertexName, taStartTime, (ContainerId)Mockito.mock(ContainerId.class), (NodeId)Mockito.mock(NodeId.class), "", "", ""));
        Assert.assertEquals((Object)TaskState.RUNNING, (Object)recoveredState);
        Assert.assertEquals((Object)TaskAttemptStateInternal.NEW, (Object)((TaskAttemptImpl)this.task.getAttempt(taId)).getInternalState());
        Assert.assertEquals((long)1L, (long)this.task.getAttempts().size());
        Assert.assertEquals((long)0L, (long)this.task.getFinishedAttemptsCount());
        Assert.assertEquals((long)0L, (long)this.task.failedAttempts);
        Assert.assertEquals((long)1L, (long)this.task.getUncompletedAttemptsCount());
        Assert.assertEquals(null, (Object)this.task.successfulAttempt);
        long taFinishTime = taStartTime + 100L;
        recoveredState = this.task.restoreFromEvent((HistoryEvent)new TaskAttemptFinishedEvent(taId, this.vertexName, taStartTime, taFinishTime, TaskAttemptState.KILLED, null, "", new TezCounters()));
        Assert.assertEquals((Object)TaskState.RUNNING, (Object)recoveredState);
        Assert.assertEquals((Object)TaskAttemptStateInternal.NEW, (Object)((TaskAttemptImpl)this.task.getAttempt(taId)).getInternalState());
        Assert.assertEquals((long)1L, (long)this.task.getAttempts().size());
        Assert.assertEquals((long)1L, (long)this.task.getFinishedAttemptsCount());
        Assert.assertEquals((long)0L, (long)this.task.failedAttempts);
        Assert.assertEquals((long)0L, (long)this.task.getUncompletedAttemptsCount());
        Assert.assertEquals(null, (Object)this.task.successfulAttempt);
        this.task.handle((TaskEvent)new TaskEventRecoverTask(this.task.getTaskId()));
        this.dispatcher.await();
        Assert.assertEquals((Object)TaskStateInternal.RUNNING, (Object)this.task.getInternalState());
        Assert.assertEquals((Object)TaskAttemptStateInternal.KILLED, (Object)((TaskAttemptImpl)this.task.getAttempt(taId)).getInternalState());
        Assert.assertEquals((long)2L, (long)this.task.getAttempts().size());
        Assert.assertEquals((long)1L, (long)this.task.getFinishedAttemptsCount());
        Assert.assertEquals((long)0L, (long)this.task.failedAttempts);
        Assert.assertEquals((long)1L, (long)this.task.getUncompletedAttemptsCount());
        Assert.assertEquals(null, (Object)this.task.successfulAttempt);
    }

    @Test(timeout=5000L)
    public void testTaskRecovery_MultipleAttempts1() {
        int maxFailedAttempts = this.conf.getInt("tez.am.task.max.failed.attempts", 4);
        this.restoreFromTaskStartEvent();
        for (int i = 0; i < maxFailedAttempts; ++i) {
            TezTaskAttemptID taId = this.getNewTaskAttemptID(this.task.getTaskId());
            this.task.restoreFromEvent((HistoryEvent)new TaskAttemptStartedEvent(taId, this.vertexName, 0L, (ContainerId)Mockito.mock(ContainerId.class), (NodeId)Mockito.mock(NodeId.class), "", "", ""));
            this.task.restoreFromEvent((HistoryEvent)new TaskAttemptFinishedEvent(taId, this.vertexName, 0L, 0L, TaskAttemptState.KILLED, null, "", null));
        }
        Assert.assertEquals((long)maxFailedAttempts, (long)this.task.getAttempts().size());
        Assert.assertEquals((long)0L, (long)this.task.failedAttempts);
        this.task.handle((TaskEvent)new TaskEventRecoverTask(this.task.getTaskId()));
        Assert.assertEquals((Object)TaskStateInternal.RUNNING, (Object)this.task.getInternalState());
        Assert.assertEquals((long)(maxFailedAttempts + 1), (long)this.task.getAttempts().size());
    }

    @Test(timeout=5000L)
    public void testTaskRecovery_MultipleAttempts2() {
        int maxFailedAttempts = this.conf.getInt("tez.am.task.max.failed.attempts", 4);
        this.restoreFromTaskStartEvent();
        for (int i = 0; i < maxFailedAttempts; ++i) {
            TezTaskAttemptID taId = this.getNewTaskAttemptID(this.task.getTaskId());
            this.task.restoreFromEvent((HistoryEvent)new TaskAttemptStartedEvent(taId, this.vertexName, 0L, (ContainerId)Mockito.mock(ContainerId.class), (NodeId)Mockito.mock(NodeId.class), "", "", ""));
            this.task.restoreFromEvent((HistoryEvent)new TaskAttemptFinishedEvent(taId, this.vertexName, 0L, 0L, TaskAttemptState.FAILED, null, "", null));
        }
        Assert.assertEquals((long)maxFailedAttempts, (long)this.task.getAttempts().size());
        Assert.assertEquals((long)maxFailedAttempts, (long)this.task.failedAttempts);
        this.task.handle((TaskEvent)new TaskEventRecoverTask(this.task.getTaskId()));
        Assert.assertEquals((Object)TaskStateInternal.FAILED, (Object)this.task.getInternalState());
        Assert.assertEquals((long)maxFailedAttempts, (long)this.task.getAttempts().size());
    }

    @Test(timeout=5000L)
    public void testTaskRecovery_MultipleAttempts3() throws InterruptedException {
        int maxFailedAttempts = this.conf.getInt("tez.am.task.max.failed.attempts", 4);
        this.restoreFromTaskStartEvent();
        for (int i = 0; i < maxFailedAttempts - 1; ++i) {
            TezTaskAttemptID taId = this.getNewTaskAttemptID(this.task.getTaskId());
            this.task.restoreFromEvent((HistoryEvent)new TaskAttemptStartedEvent(taId, this.vertexName, 0L, (ContainerId)Mockito.mock(ContainerId.class), (NodeId)Mockito.mock(NodeId.class), "", "", ""));
            this.task.restoreFromEvent((HistoryEvent)new TaskAttemptFinishedEvent(taId, this.vertexName, 0L, 0L, TaskAttemptState.FAILED, null, "", null));
        }
        Assert.assertEquals((long)(maxFailedAttempts - 1), (long)this.task.getAttempts().size());
        Assert.assertEquals((long)(maxFailedAttempts - 1), (long)this.task.failedAttempts);
        TezTaskAttemptID newTaskAttemptId = this.getNewTaskAttemptID(this.task.getTaskId());
        TaskState recoveredState = this.task.restoreFromEvent((HistoryEvent)new TaskAttemptStartedEvent(newTaskAttemptId, this.vertexName, 0L, (ContainerId)Mockito.mock(ContainerId.class), (NodeId)Mockito.mock(NodeId.class), "", "", ""));
        Assert.assertEquals((Object)TaskState.RUNNING, (Object)recoveredState);
        Assert.assertEquals((Object)TaskAttemptStateInternal.NEW, (Object)((TaskAttemptImpl)this.task.getAttempt(newTaskAttemptId)).getInternalState());
        Assert.assertEquals((long)maxFailedAttempts, (long)this.task.getAttempts().size());
        this.task.handle((TaskEvent)new TaskEventRecoverTask(this.task.getTaskId()));
        this.dispatcher.await();
        Assert.assertEquals((Object)TaskStateInternal.RUNNING, (Object)this.task.getInternalState());
        Assert.assertEquals((Object)TaskAttemptStateInternal.KILLED, (Object)((TaskAttemptImpl)this.task.getAttempt(newTaskAttemptId)).getInternalState());
        Assert.assertEquals((long)(maxFailedAttempts - 1), (long)this.task.failedAttempts);
        Assert.assertEquals((long)(maxFailedAttempts + 1), (long)this.task.getAttempts().size());
    }

    private TezTaskAttemptID getNewTaskAttemptID(TezTaskID taskId) {
        return TezTaskAttemptID.getInstance((TezTaskID)taskId, (int)this.taskAttemptCounter++);
    }

    private class TestOutputCommitter
    extends OutputCommitter {
        boolean recoverySupported;
        boolean throwExceptionWhenRecovery;

        public TestOutputCommitter(OutputCommitterContext committerContext, boolean recoverySupported, boolean throwExceptionWhenRecovery) {
            super(committerContext);
            this.recoverySupported = false;
            this.throwExceptionWhenRecovery = false;
            this.recoverySupported = recoverySupported;
            this.throwExceptionWhenRecovery = throwExceptionWhenRecovery;
        }

        public void recoverTask(int taskIndex, int previousDAGAttempt) throws Exception {
            if (this.throwExceptionWhenRecovery) {
                throw new Exception("fail recovery Task");
            }
        }

        public boolean isTaskRecoverySupported() {
            return this.recoverySupported;
        }

        public void initialize() throws Exception {
        }

        public void setupOutput() throws Exception {
        }

        public void commitOutput() throws Exception {
        }

        public void abortOutput(VertexStatus.State finalState) throws Exception {
        }
    }

    private class TaskAttemptEventHandler
    implements EventHandler<TaskAttemptEvent> {
        private List<TaskAttemptEvent> events = Lists.newArrayList();

        private TaskAttemptEventHandler() {
        }

        public void handle(TaskAttemptEvent event) {
            this.events.add(event);
            ((TaskAttemptImpl)TestTaskRecovery.this.task.getAttempt(event.getTaskAttemptID())).handle(event);
        }

        public List<TaskAttemptEvent> getEvents() {
            return this.events;
        }
    }

    private class TaskEventHandler
    implements EventHandler<TaskEvent> {
        private TaskEventHandler() {
        }

        public void handle(TaskEvent event) {
            TestTaskRecovery.this.task.handle(event);
        }
    }
}

