/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.api.oldrecords.TaskState;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ContainerContext;
import org.apache.tez.dag.app.TaskAttemptListener;
import org.apache.tez.dag.app.TaskHeartbeatHandler;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.app.dag.TaskAttemptStateInternal;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.event.DAGEventCounterUpdate;
import org.apache.tez.dag.app.dag.event.TaskAttemptEvent;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventType;
import org.apache.tez.dag.app.dag.event.TaskEventTAUpdate;
import org.apache.tez.dag.app.dag.impl.TaskAttemptImpl;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventHandler;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.events.TaskAttemptFinishedEvent;
import org.apache.tez.dag.history.events.TaskAttemptStartedEvent;
import org.apache.tez.dag.history.events.TaskFinishedEvent;
import org.apache.tez.dag.records.TaskAttemptTerminationCause;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestTaskAttemptRecovery {
    private TaskAttemptImpl ta;
    private EventHandler mockEventHandler;
    private long startTime = System.currentTimeMillis();
    private long finishTime = this.startTime + 5000L;
    private TezTaskAttemptID taId;
    private String vertexName = "v1";
    private AppContext mockAppContext;
    private MockHistoryEventHandler mockHistoryEventHandler;
    private Task mockTask;
    private Vertex mockVertex;

    @Before
    public void setUp() {
        this.mockTask = (Task)Mockito.mock(Task.class);
        this.mockVertex = (Vertex)Mockito.mock(Vertex.class);
        Mockito.when((Object)this.mockTask.getVertex()).thenReturn((Object)this.mockVertex);
        this.mockAppContext = (AppContext)Mockito.mock(AppContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.mockAppContext.getCurrentDAG().getVertex((TezVertexID)Matchers.any(TezVertexID.class)).getTask((TezTaskID)Matchers.any(TezTaskID.class))).thenReturn((Object)this.mockTask);
        this.mockHistoryEventHandler = new MockHistoryEventHandler(this.mockAppContext);
        Mockito.when((Object)this.mockAppContext.getHistoryHandler()).thenReturn((Object)this.mockHistoryEventHandler);
        this.mockEventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        TezTaskID taskId = TezTaskID.fromString((String)"task_1407371892933_0001_1_00_000000");
        this.ta = new TaskAttemptImpl(taskId, 0, this.mockEventHandler, (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class), new Configuration(), (Clock)new SystemClock(), (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), this.mockAppContext, false, Resource.newInstance((int)1, (int)1), (ContainerContext)Mockito.mock(ContainerContext.class), false);
        this.taId = this.ta.getID();
    }

    private void restoreFromTAStartEvent() {
        TaskAttemptState recoveredState = this.ta.restoreFromEvent((HistoryEvent)new TaskAttemptStartedEvent(this.taId, this.vertexName, this.startTime, (ContainerId)Mockito.mock(ContainerId.class), (NodeId)Mockito.mock(NodeId.class), "", "", ""));
        Assert.assertEquals((long)this.startTime, (long)this.ta.getLaunchTime());
        Assert.assertEquals((Object)TaskAttemptState.RUNNING, (Object)recoveredState);
    }

    private void restoreFromTAFinishedEvent(TaskAttemptState state) {
        String diag = "test_diag";
        TezCounters counters = (TezCounters)Mockito.mock(TezCounters.class);
        TaskAttemptTerminationCause errorEnum = null;
        if (state != TaskAttemptState.SUCCEEDED) {
            errorEnum = TaskAttemptTerminationCause.APPLICATION_ERROR;
        }
        TaskAttemptState recoveredState = this.ta.restoreFromEvent((HistoryEvent)new TaskAttemptFinishedEvent(this.taId, this.vertexName, this.startTime, this.finishTime, state, errorEnum, diag, counters));
        Assert.assertEquals((long)this.startTime, (long)this.ta.getLaunchTime());
        Assert.assertEquals((long)this.finishTime, (long)this.ta.getFinishTime());
        Assert.assertEquals((Object)counters, (Object)this.ta.reportedStatus.counters);
        Assert.assertEquals((double)1.0, (double)this.ta.reportedStatus.progress, (double)1.0E-6);
        Assert.assertEquals((Object)state, (Object)this.ta.reportedStatus.state);
        Assert.assertEquals((long)1L, (long)this.ta.getDiagnostics().size());
        Assert.assertEquals((Object)diag, this.ta.getDiagnostics().get(0));
        Assert.assertEquals((Object)state, (Object)recoveredState);
        if (state != TaskAttemptState.SUCCEEDED) {
            Assert.assertEquals((Object)errorEnum, (Object)this.ta.getTerminationCause());
        } else {
            Assert.assertEquals((Object)TaskAttemptTerminationCause.UNKNOWN_ERROR, (Object)this.ta.getTerminationCause());
        }
    }

    private void verifyEvents(List<Event> events, Class<? extends Event> eventClass, int expectedTimes) {
        int actualTimes = 0;
        for (Event event : events) {
            if (!eventClass.isInstance(event)) continue;
            ++actualTimes;
        }
        Assert.assertEquals((long)expectedTimes, (long)actualTimes);
    }

    @Test(timeout=5000L)
    public void testTARecovery_NEW() {
        this.ta.handle(new TaskAttemptEvent(this.taId, TaskAttemptEventType.TA_RECOVER));
        Assert.assertEquals((Object)TaskAttemptStateInternal.KILLED, (Object)this.ta.getInternalState());
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)this.mockEventHandler, (VerificationMode)Mockito.times((int)2))).handle((Event)eventCaptor.capture());
        List events = eventCaptor.getAllValues();
        Assert.assertEquals((long)2L, (long)events.size());
        this.verifyEvents(events, TaskEventTAUpdate.class, 1);
        this.verifyEvents(events, DAGEventCounterUpdate.class, 1);
    }

    @Test(timeout=5000L)
    public void testTARecovery_START() {
        this.restoreFromTAStartEvent();
        this.ta.handle(new TaskAttemptEvent(this.taId, TaskAttemptEventType.TA_RECOVER));
        Assert.assertEquals((Object)TaskAttemptStateInternal.KILLED, (Object)this.ta.getInternalState());
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)this.mockEventHandler, (VerificationMode)Mockito.times((int)3))).handle((Event)eventCaptor.capture());
        List events = eventCaptor.getAllValues();
        Assert.assertEquals((long)3L, (long)events.size());
        this.verifyEvents(events, TaskEventTAUpdate.class, 1);
        this.verifyEvents(events, DAGEventCounterUpdate.class, 2);
        this.mockHistoryEventHandler.verfiyTaskAttemptFinishedEvent(this.taId, TaskAttemptState.KILLED, 1);
    }

    @Test(timeout=5000L)
    public void testTARecovery_SUCCEED() {
        this.restoreFromTAStartEvent();
        this.restoreFromTAFinishedEvent(TaskAttemptState.SUCCEEDED);
        this.ta.handle(new TaskAttemptEvent(this.taId, TaskAttemptEventType.TA_RECOVER));
        Assert.assertEquals((Object)TaskAttemptStateInternal.SUCCEEDED, (Object)this.ta.getInternalState());
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)this.mockEventHandler, (VerificationMode)Mockito.times((int)2))).handle((Event)eventCaptor.capture());
        List events = eventCaptor.getAllValues();
        Assert.assertEquals((long)2L, (long)events.size());
        this.verifyEvents(events, DAGEventCounterUpdate.class, 2);
    }

    @Test(timeout=5000L)
    public void testTARecovery_KIILED() {
        this.restoreFromTAStartEvent();
        this.restoreFromTAFinishedEvent(TaskAttemptState.KILLED);
        this.ta.handle(new TaskAttemptEvent(this.taId, TaskAttemptEventType.TA_RECOVER));
        Assert.assertEquals((Object)TaskAttemptStateInternal.KILLED, (Object)this.ta.getInternalState());
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)this.mockEventHandler, (VerificationMode)Mockito.times((int)2))).handle((Event)eventCaptor.capture());
        List events = eventCaptor.getAllValues();
        Assert.assertEquals((long)2L, (long)events.size());
        this.verifyEvents(events, DAGEventCounterUpdate.class, 2);
    }

    @Test(timeout=5000L)
    public void testTARecovery_FAILED() {
        this.restoreFromTAStartEvent();
        this.restoreFromTAFinishedEvent(TaskAttemptState.FAILED);
        this.ta.handle(new TaskAttemptEvent(this.taId, TaskAttemptEventType.TA_RECOVER));
        Assert.assertEquals((Object)TaskAttemptStateInternal.FAILED, (Object)this.ta.getInternalState());
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)this.mockEventHandler, (VerificationMode)Mockito.times((int)2))).handle((Event)eventCaptor.capture());
        List events = eventCaptor.getAllValues();
        Assert.assertEquals((long)2L, (long)events.size());
        this.verifyEvents(events, DAGEventCounterUpdate.class, 2);
    }

    @Test(timeout=5000L)
    public void testRecover_FINISH_BUT_NO_START() {
        TaskAttemptState recoveredState = this.ta.restoreFromEvent((HistoryEvent)new TaskAttemptFinishedEvent(this.taId, this.vertexName, this.startTime, this.finishTime, TaskAttemptState.KILLED, TaskAttemptTerminationCause.APPLICATION_ERROR, "", new TezCounters()));
        Assert.assertEquals((Object)TaskAttemptState.KILLED, (Object)recoveredState);
    }

    public static class MockHistoryEventHandler
    extends HistoryEventHandler {
        private List<DAGHistoryEvent> events = new ArrayList<DAGHistoryEvent>();

        public MockHistoryEventHandler(AppContext context) {
            super(context);
        }

        public void handle(DAGHistoryEvent event) {
            this.events.add(event);
        }

        public void handleCriticalEvent(DAGHistoryEvent event) throws IOException {
            this.events.add(event);
        }

        void verfiyTaskAttemptFinishedEvent(TezTaskAttemptID taId, TaskAttemptState finalState, int expectedTimes) {
            int actualTimes = 0;
            for (DAGHistoryEvent event : this.events) {
                TaskAttemptFinishedEvent tfEvent;
                if (event.getHistoryEvent().getEventType() != HistoryEventType.TASK_ATTEMPT_FINISHED || !(tfEvent = (TaskAttemptFinishedEvent)event.getHistoryEvent()).getTaskAttemptID().equals((Object)taId) || !tfEvent.getState().equals((Object)finalState)) continue;
                ++actualTimes;
            }
            Assert.assertEquals((long)expectedTimes, (long)actualTimes);
        }

        void verifyTaskFinishedEvent(TezTaskID taskId, TaskState finalState, int expectedTimes) {
            int actualTimes = 0;
            for (DAGHistoryEvent event : this.events) {
                TaskFinishedEvent tfEvent;
                if (event.getHistoryEvent().getEventType() != HistoryEventType.TASK_FINISHED || !(tfEvent = (TaskFinishedEvent)event.getHistoryEvent()).getTaskID().equals((Object)taskId) || !tfEvent.getState().equals((Object)finalState)) continue;
                ++actualTimes;
            }
            Assert.assertEquals((long)expectedTimes, (long)actualTimes);
        }
    }
}

