/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.tez.dag.api.EdgeManagerPluginDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.VertexManagerPluginContext;
import org.apache.tez.dag.api.event.VertexState;
import org.apache.tez.dag.api.event.VertexStateUpdate;
import org.apache.tez.dag.app.dag.impl.ImmediateStartVertexManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestImmediateStartVertexManager {
    @Test(timeout=5000L)
    public void testBasic() {
        HashMap<String, EdgeProperty> mockInputVertices = new HashMap<String, EdgeProperty>();
        String mockSrcVertexId1 = "Vertex1";
        EdgeProperty eProp1 = EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"out"), (InputDescriptor)InputDescriptor.create((String)"in"));
        String mockSrcVertexId2 = "Vertex2";
        EdgeProperty eProp2 = EdgeProperty.create((EdgeManagerPluginDescriptor)((EdgeManagerPluginDescriptor)Mockito.mock(EdgeManagerPluginDescriptor.class)), (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"out"), (InputDescriptor)InputDescriptor.create((String)"in"));
        String mockSrcVertexId3 = "Vertex3";
        EdgeProperty eProp3 = EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.BROADCAST, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"out"), (InputDescriptor)InputDescriptor.create((String)"in"));
        String mockManagedVertexId = "Vertex4";
        mockInputVertices.put("Vertex1", eProp1);
        mockInputVertices.put("Vertex2", eProp2);
        mockInputVertices.put("Vertex3", eProp3);
        VertexManagerPluginContext mockContext = (VertexManagerPluginContext)Mockito.mock(VertexManagerPluginContext.class);
        Mockito.when((Object)mockContext.getInputVertexEdgeProperties()).thenReturn(mockInputVertices);
        Mockito.when((Object)mockContext.getVertexName()).thenReturn((Object)"Vertex4");
        Mockito.when((Object)mockContext.getVertexNumTasks("Vertex4")).thenReturn((Object)4);
        Mockito.when((Object)mockContext.getVertexNumTasks("Vertex1")).thenReturn((Object)2);
        Mockito.when((Object)mockContext.getVertexNumTasks("Vertex2")).thenReturn((Object)2);
        Mockito.when((Object)mockContext.getVertexNumTasks("Vertex3")).thenReturn((Object)2);
        final HashSet scheduledTasks = new HashSet();
        ((VertexManagerPluginContext)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                scheduledTasks.clear();
                List tasks = (List)args[0];
                for (VertexManagerPluginContext.TaskWithLocationHint task : tasks) {
                    scheduledTasks.add(task.getTaskIndex());
                }
                return null;
            }
        }).when((Object)mockContext)).scheduleVertexTasks(Matchers.anyList());
        ImmediateStartVertexManager manager = new ImmediateStartVertexManager(mockContext);
        manager.initialize();
        manager.onVertexStarted(null);
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)0))).scheduleVertexTasks(Matchers.anyList());
        manager.onVertexStateUpdated(new VertexStateUpdate("Vertex1", VertexState.CONFIGURED));
        manager.onVertexStateUpdated(new VertexStateUpdate("Vertex2", VertexState.CONFIGURED));
        manager.onVertexStateUpdated(new VertexStateUpdate("Vertex3", VertexState.CONFIGURED));
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)1))).scheduleVertexTasks(Matchers.anyList());
        Assert.assertEquals((long)4L, (long)scheduledTasks.size());
        scheduledTasks.clear();
        final ImmediateStartVertexManager raceManager = new ImmediateStartVertexManager(mockContext);
        ((VertexManagerPluginContext)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Exception {
                raceManager.onVertexStateUpdated(new VertexStateUpdate((String)invocation.getArguments()[0], VertexState.CONFIGURED));
                scheduledTasks.clear();
                return null;
            }
        }).when((Object)mockContext)).registerForVertexStateUpdates(Mockito.anyString(), Mockito.anySet());
        raceManager.initialize();
        raceManager.onVertexStarted(null);
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)2))).scheduleVertexTasks(Matchers.anyList());
        Assert.assertEquals((long)4L, (long)scheduledTasks.size());
    }
}

