/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.dag.TaskAttempt;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.event.DAGEventSchedulerUpdate;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventSchedule;
import org.apache.tez.dag.app.dag.impl.DAGSchedulerNaturalOrder;
import org.apache.tez.dag.records.TezVertexID;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestDAGScheduler {
    MockEventHandler mockEventHandler = new MockEventHandler();

    @Test(timeout=5000L)
    public void testDAGSchedulerNaturalOrder() {
        DAG mockDag = (DAG)Mockito.mock(DAG.class);
        Vertex mockVertex = (Vertex)Mockito.mock(Vertex.class);
        TaskAttempt mockAttempt = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        Mockito.when((Object)mockDag.getVertex((TezVertexID)Mockito.any())).thenReturn((Object)mockVertex);
        Mockito.when((Object)mockVertex.getDistanceFromRoot()).thenReturn((Object)0).thenReturn((Object)1).thenReturn((Object)2);
        DAGEventSchedulerUpdate event = new DAGEventSchedulerUpdate(DAGEventSchedulerUpdate.UpdateType.TA_SCHEDULE, mockAttempt);
        DAGSchedulerNaturalOrder scheduler = new DAGSchedulerNaturalOrder(mockDag, (EventHandler)this.mockEventHandler);
        scheduler.scheduleTask(event);
        Assert.assertEquals((long)1L, (long)this.mockEventHandler.event.getPriorityHighLimit());
        Assert.assertEquals((long)3L, (long)this.mockEventHandler.event.getPriorityLowLimit());
        scheduler.scheduleTask(event);
        Assert.assertEquals((long)4L, (long)this.mockEventHandler.event.getPriorityHighLimit());
        Assert.assertEquals((long)6L, (long)this.mockEventHandler.event.getPriorityLowLimit());
        scheduler.scheduleTask(event);
        Assert.assertEquals((long)7L, (long)this.mockEventHandler.event.getPriorityHighLimit());
        Assert.assertEquals((long)9L, (long)this.mockEventHandler.event.getPriorityLowLimit());
    }

    class MockEventHandler
    implements EventHandler<TaskAttemptEventSchedule> {
        TaskAttemptEventSchedule event;

        MockEventHandler() {
        }

        public void handle(TaskAttemptEventSchedule event) {
            this.event = event;
        }
    }
}

