/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ContainerHeartbeatHandler;
import org.apache.tez.dag.app.TaskAttemptListenerImpTezDag;
import org.apache.tez.dag.app.TaskHeartbeatHandler;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestTaskAttemptListenerImplTezDag {
    @Test(timeout=5000L)
    public void testPortRange() {
        boolean succeedToAllocate = false;
        Random rand = new Random();
        for (int i = 0; i < 10; ++i) {
            int nextPort = 1024 + rand.nextInt(64511);
            if (!this.testPortRange(nextPort)) continue;
            succeedToAllocate = true;
            break;
        }
        if (!succeedToAllocate) {
            Assert.fail((String)"Can not allocate free port even in 10 iterations for TaskAttemptListener");
        }
    }

    @Test(timeout=5000L)
    public void testPortRange_NotSpecified() {
        Configuration conf = new Configuration();
        TaskAttemptListenerImpTezDag taskAttemptListener = new TaskAttemptListenerImpTezDag((AppContext)Mockito.mock(AppContext.class), (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), (ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), null);
        taskAttemptListener.init(conf);
        taskAttemptListener.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testPortRange(int port) {
        boolean succeedToAllocate = true;
        TaskAttemptListenerImpTezDag taskAttemptListener = null;
        try {
            Configuration conf = new Configuration();
            conf.set("tez.am.task.am.port-range", port + "-" + port);
            taskAttemptListener = new TaskAttemptListenerImpTezDag((AppContext)Mockito.mock(AppContext.class), (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), (ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), null);
            taskAttemptListener.init(conf);
            taskAttemptListener.start();
            int resultedPort = taskAttemptListener.getAddress().getPort();
            Assert.assertEquals((long)port, (long)resultedPort);
        }
        catch (Exception e) {
            succeedToAllocate = false;
        }
        finally {
            if (taskAttemptListener != null) {
                try {
                    taskAttemptListener.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Assert.fail((String)"fail to stop TaskAttemptListener");
                }
            }
        }
        return succeedToAllocate;
    }
}

