/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.app.MockDAGAppMaster;
import org.apache.tez.dag.app.MockTezClient;
import org.apache.tez.dag.app.dag.DAGState;
import org.apache.tez.dag.app.dag.TaskAttempt;
import org.apache.tez.dag.app.dag.event.DAGAppMasterEvent;
import org.apache.tez.dag.app.dag.event.DAGAppMasterEventSchedulingServiceError;
import org.apache.tez.dag.app.dag.impl.DAGImpl;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.junit.Assert;
import org.junit.Test;

public class TestMockDAGAppMaster {
    static Configuration defaultConf;
    static FileSystem localFs;
    static Path workDir;

    @Test(timeout=5000L)
    public void testLocalResourceSetup() throws Exception {
        TezConfiguration tezconf = new TezConfiguration(defaultConf);
        MockTezClient tezClient = new MockTezClient("testMockAM", tezconf, true, null, null, null, null);
        tezClient.start();
        MockDAGAppMaster mockApp = tezClient.getLocalClient().getMockApp();
        MockDAGAppMaster.MockContainerLauncher mockLauncher = mockApp.getContainerLauncher();
        mockLauncher.startScheduling(false);
        HashMap lrDAG = Maps.newHashMap();
        String lrName1 = "LR1";
        lrDAG.put(lrName1, LocalResource.newInstance((URL)URL.newInstance((String)"file", (String)"localhost", (int)0, (String)"/test"), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)1L, (long)1L));
        HashMap lrVertex = Maps.newHashMap();
        String lrName2 = "LR2";
        lrVertex.put(lrName2, LocalResource.newInstance((URL)URL.newInstance((String)"file", (String)"localhost", (int)0, (String)"/test1"), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)1L, (long)1L));
        DAG dag = DAG.create((String)"test").addTaskLocalFiles((Map)lrDAG);
        Vertex vA = Vertex.create((String)"A", (ProcessorDescriptor)ProcessorDescriptor.create((String)"Proc.class"), (int)5).addTaskLocalFiles((Map)lrVertex);
        dag.addVertex(vA);
        DAGClient dagClient = tezClient.submitDAG(dag);
        mockLauncher.waitTillContainersLaunched();
        MockDAGAppMaster.MockContainerLauncher.ContainerData cData = mockLauncher.getContainers().values().iterator().next();
        ContainerLaunchContext launchContext = cData.launchContext;
        Map taskLR = launchContext.getLocalResources();
        Assert.assertTrue((boolean)taskLR.containsKey(lrName1));
        Assert.assertTrue((boolean)taskLR.containsKey(lrName2));
        mockLauncher.startScheduling(true);
        dagClient.waitForCompletion();
        Assert.assertEquals((Object)DAGStatus.State.SUCCEEDED, (Object)dagClient.getDAGStatus(null).getState());
        tezClient.stop();
    }

    @Test(timeout=5000L)
    public void testInternalPreemption() throws Exception {
        TezConfiguration tezconf = new TezConfiguration(defaultConf);
        MockTezClient tezClient = new MockTezClient("testMockAM", tezconf, true, null, null, null, null);
        tezClient.start();
        MockDAGAppMaster mockApp = tezClient.getLocalClient().getMockApp();
        MockDAGAppMaster.MockContainerLauncher mockLauncher = mockApp.getContainerLauncher();
        mockLauncher.startScheduling(false);
        DAG dag = DAG.create((String)"test");
        Vertex vA = Vertex.create((String)"A", (ProcessorDescriptor)ProcessorDescriptor.create((String)"Proc.class"), (int)1);
        dag.addVertex(vA);
        DAGClient dagClient = tezClient.submitDAG(dag);
        mockLauncher.waitTillContainersLaunched();
        MockDAGAppMaster.MockContainerLauncher.ContainerData cData = mockLauncher.getContainers().values().iterator().next();
        DAGImpl dagImpl = (DAGImpl)mockApp.getContext().getCurrentDAG();
        mockApp.getTaskSchedulerEventHandler().preemptContainer(cData.cId);
        mockLauncher.startScheduling(true);
        dagClient.waitForCompletion();
        Assert.assertEquals((Object)DAGStatus.State.SUCCEEDED, (Object)dagClient.getDAGStatus(null).getState());
        TezVertexID vertexId = TezVertexID.getInstance((TezDAGID)dagImpl.getID(), (int)0);
        TezTaskAttemptID killedTaId = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexId, (int)0), (int)0);
        TaskAttempt killedTa = dagImpl.getVertex(vA.getName()).getTask(0).getAttempt(killedTaId);
        Assert.assertEquals((Object)TaskAttemptState.KILLED, (Object)killedTa.getState());
        tezClient.stop();
    }

    @Test(timeout=10000L)
    public void testMultipleSubmissions() throws Exception {
        HashMap lrDAG = Maps.newHashMap();
        String lrName1 = "LR1";
        lrDAG.put(lrName1, LocalResource.newInstance((URL)URL.newInstance((String)"file", (String)"localhost", (int)0, (String)"/test"), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)1L, (long)1L));
        HashMap lrVertex = Maps.newHashMap();
        String lrName2 = "LR2";
        lrVertex.put(lrName2, LocalResource.newInstance((URL)URL.newInstance((String)"file", (String)"localhost", (int)0, (String)"/test1"), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)1L, (long)1L));
        DAG dag = DAG.create((String)"test").addTaskLocalFiles((Map)lrDAG);
        Vertex vA = Vertex.create((String)"A", (ProcessorDescriptor)ProcessorDescriptor.create((String)"Proc.class"), (int)5).addTaskLocalFiles((Map)lrVertex);
        dag.addVertex(vA);
        TezConfiguration tezconf = new TezConfiguration(defaultConf);
        MockTezClient tezClient = new MockTezClient("testMockAM", tezconf, true, null, null, null, null);
        tezClient.start();
        DAGClient dagClient = tezClient.submitDAG(dag);
        dagClient.waitForCompletion();
        Assert.assertEquals((Object)DAGStatus.State.SUCCEEDED, (Object)dagClient.getDAGStatus(null).getState());
        tezClient.stop();
        tezClient = new MockTezClient("testMockAM", tezconf, true, null, null, null, null);
        tezClient.start();
        dagClient = tezClient.submitDAG(dag);
        dagClient.waitForCompletion();
        Assert.assertEquals((Object)DAGStatus.State.SUCCEEDED, (Object)dagClient.getDAGStatus(null).getState());
        tezClient.stop();
    }

    @Test(timeout=10000L)
    public void testSchedulerErrorHandling() throws Exception {
        TezConfiguration tezconf = new TezConfiguration(defaultConf);
        MockTezClient tezClient = new MockTezClient("testMockAM", tezconf, true, null, null, null, null);
        tezClient.start();
        MockDAGAppMaster mockApp = tezClient.getLocalClient().getMockApp();
        MockDAGAppMaster.MockContainerLauncher mockLauncher = mockApp.getContainerLauncher();
        mockLauncher.startScheduling(false);
        DAG dag = DAG.create((String)"test");
        Vertex vA = Vertex.create((String)"A", (ProcessorDescriptor)ProcessorDescriptor.create((String)"Proc.class"), (int)5);
        dag.addVertex(vA);
        tezClient.submitDAG(dag);
        mockLauncher.waitTillContainersLaunched();
        mockApp.handle((DAGAppMasterEvent)new DAGAppMasterEventSchedulingServiceError((Throwable)new RuntimeException("Mock error")));
        while (!mockApp.getShutdownHandler().wasShutdownInvoked()) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((Object)DAGState.RUNNING, (Object)mockApp.getContext().getCurrentDAG().getState());
    }

    static {
        try {
            defaultConf = new Configuration(false);
            defaultConf.set("fs.defaultFS", "file:///");
            defaultConf.setBoolean("tez.local.mode", true);
            localFs = FileSystem.getLocal((Configuration)defaultConf);
            workDir = new Path(new Path(System.getProperty("test.build.data", "/tmp")), "TestDAGAppMaster").makeQualified(localFs);
        }
        catch (IOException e) {
            throw new RuntimeException("init failure", e);
        }
    }
}

