/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.web;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.webapp.Controller;
import org.apache.tez.common.security.ACLManager;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.web.AMWebController;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezVertexID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class TestAMWebController {
    AppContext mockAppContext;
    Controller.RequestContext mockRequestContext;
    HttpServletResponse mockResponse;
    HttpServletRequest mockRequest;
    String[] userGroups = new String[0];
    @Captor
    ArgumentCaptor<Map<String, AMWebController.ProgressInfo>> singleResultCaptor;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.mockAppContext = (AppContext)Mockito.mock(AppContext.class);
        Configuration conf = new Configuration(false);
        conf.set("tez.tez-ui.history-url.base", "http://uihost:9001/foo");
        Mockito.when((Object)this.mockAppContext.getAMConf()).thenReturn((Object)conf);
        this.mockRequestContext = (Controller.RequestContext)Mockito.mock(Controller.RequestContext.class);
        this.mockResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        this.mockRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
    }

    @Test(timeout=5000L)
    public void testCorsHeadersAreSet() {
        AMWebController amWebController = new AMWebController(this.mockRequestContext, this.mockAppContext, "TEST_HISTORY_URL");
        AMWebController spy = (AMWebController)Mockito.spy((Object)amWebController);
        ((AMWebController)Mockito.doReturn((Object)this.mockResponse).when((Object)spy)).response();
        spy.setCorsHeaders();
        ((HttpServletResponse)Mockito.verify((Object)this.mockResponse)).setHeader("Access-Control-Allow-Origin", "http://uihost:9001");
        ((HttpServletResponse)Mockito.verify((Object)this.mockResponse)).setHeader("Access-Control-Allow-Credentials", "true");
        ((HttpServletResponse)Mockito.verify((Object)this.mockResponse)).setHeader("Access-Control-Allow-Methods", "GET, HEAD");
        ((HttpServletResponse)Mockito.verify((Object)this.mockResponse)).setHeader("Access-Control-Allow-Headers", "X-Requested-With,Content-Type,Accept,Origin");
    }

    @Test(timeout=5000L)
    public void sendErrorResponseIfNoAccess() throws Exception {
        AMWebController amWebController = new AMWebController(this.mockRequestContext, this.mockAppContext, "TEST_HISTORY_URL");
        AMWebController spy = (AMWebController)Mockito.spy((Object)amWebController);
        ((AMWebController)Mockito.doReturn((Object)false).when((Object)spy)).hasAccess();
        ((AMWebController)Mockito.doNothing().when((Object)spy)).setCorsHeaders();
        ((AMWebController)Mockito.doReturn((Object)this.mockResponse).when((Object)spy)).response();
        ((AMWebController)Mockito.doReturn((Object)this.mockRequest).when((Object)spy)).request();
        ((HttpServletRequest)Mockito.doReturn((Object)"dummyuser").when((Object)this.mockRequest)).getRemoteUser();
        spy.getDagProgress();
        ((HttpServletResponse)Mockito.verify((Object)this.mockResponse)).sendError(Matchers.eq((int)401), Matchers.anyString());
        Mockito.reset((Object[])new HttpServletResponse[]{this.mockResponse});
        spy.getVertexProgress();
        ((HttpServletResponse)Mockito.verify((Object)this.mockResponse)).sendError(Matchers.eq((int)401), Matchers.anyString());
        Mockito.reset((Object[])new HttpServletResponse[]{this.mockResponse});
        spy.getVertexProgresses();
        ((HttpServletResponse)Mockito.verify((Object)this.mockResponse)).sendError(Matchers.eq((int)401), Matchers.anyString());
    }

    @Test(timeout=5000L)
    public void testDagProgressResponse() {
        AMWebController amWebController = new AMWebController(this.mockRequestContext, this.mockAppContext, "TEST_HISTORY_URL");
        AMWebController spy = (AMWebController)Mockito.spy((Object)amWebController);
        DAG mockDAG = (DAG)Mockito.mock(DAG.class);
        ((AMWebController)Mockito.doReturn((Object)true).when((Object)spy)).hasAccess();
        ((AMWebController)Mockito.doNothing().when((Object)spy)).setCorsHeaders();
        ((AMWebController)Mockito.doReturn((Object)"42").when((Object)spy)).$("dagID");
        ((AMWebController)Mockito.doReturn((Object)this.mockResponse).when((Object)spy)).response();
        ((DAG)Mockito.doReturn((Object)TezDAGID.fromString((String)"dag_1422960590892_0007_42")).when((Object)mockDAG)).getID();
        ((DAG)Mockito.doReturn((Object)Float.valueOf(66.0f)).when((Object)mockDAG)).getProgress();
        ((AppContext)Mockito.doReturn((Object)mockDAG).when((Object)this.mockAppContext)).getCurrentDAG();
        ((AMWebController)Mockito.doNothing().when((Object)spy)).renderJSON(Matchers.any());
        spy.getDagProgress();
        ((AMWebController)Mockito.verify((Object)spy)).renderJSON(this.singleResultCaptor.capture());
        Map result = (Map)this.singleResultCaptor.getValue();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.containsKey("dagProgress"));
        AMWebController.ProgressInfo progressInfo = (AMWebController.ProgressInfo)result.get("dagProgress");
        Assert.assertTrue((boolean)"dag_1422960590892_0007_42".equals(progressInfo.getId()));
        Assert.assertEquals((double)66.0, (double)progressInfo.getProgress(), (double)0.1);
    }

    @Test(timeout=5000L)
    public void testVertexProgressResponse() {
        AMWebController amWebController = new AMWebController(this.mockRequestContext, this.mockAppContext, "TEST_HISTORY_URL");
        AMWebController spy = (AMWebController)Mockito.spy((Object)amWebController);
        DAG mockDAG = (DAG)Mockito.mock(DAG.class);
        Vertex mockVertex = (Vertex)Mockito.mock(Vertex.class);
        ((AMWebController)Mockito.doReturn((Object)true).when((Object)spy)).hasAccess();
        ((AMWebController)Mockito.doReturn((Object)"42").when((Object)spy)).$("dagID");
        ((AMWebController)Mockito.doReturn((Object)"43").when((Object)spy)).$("vertexID");
        ((AMWebController)Mockito.doReturn((Object)this.mockResponse).when((Object)spy)).response();
        ((DAG)Mockito.doReturn((Object)TezDAGID.fromString((String)"dag_1422960590892_0007_42")).when((Object)mockDAG)).getID();
        ((AppContext)Mockito.doReturn((Object)mockDAG).when((Object)this.mockAppContext)).getCurrentDAG();
        ((DAG)Mockito.doReturn((Object)mockVertex).when((Object)mockDAG)).getVertex((TezVertexID)Matchers.any(TezVertexID.class));
        ((Vertex)Mockito.doReturn((Object)Float.valueOf(66.0f)).when((Object)mockVertex)).getProgress();
        ((AMWebController)Mockito.doNothing().when((Object)spy)).renderJSON(Matchers.any());
        ((AMWebController)Mockito.doNothing().when((Object)spy)).setCorsHeaders();
        spy.getVertexProgress();
        ((AMWebController)Mockito.verify((Object)spy)).renderJSON(this.singleResultCaptor.capture());
        Map result = (Map)this.singleResultCaptor.getValue();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.containsKey("vertexProgress"));
        AMWebController.ProgressInfo progressInfo = (AMWebController.ProgressInfo)result.get("vertexProgress");
        Assert.assertTrue((boolean)"vertex_1422960590892_0007_42_43".equals(progressInfo.getId()));
        Assert.assertEquals((double)66.0, (double)progressInfo.getProgress(), (double)0.1);
    }

    @Test(timeout=5000L)
    public void testHasAccessWithAclsDisabled() {
        Configuration conf = new Configuration(false);
        conf.setBoolean("tez.am.acls.enabled", false);
        ACLManager aclManager = new ACLManager("amUser", conf);
        Mockito.when((Object)this.mockAppContext.getAMACLManager()).thenReturn((Object)aclManager);
        Assert.assertEquals((Object)true, (Object)AMWebController._hasAccess(null, (AppContext)this.mockAppContext));
        UserGroupInformation mockUser = UserGroupInformation.createUserForTesting((String)"mockUser", (String[])this.userGroups);
        Assert.assertEquals((Object)true, (Object)AMWebController._hasAccess((UserGroupInformation)mockUser, (AppContext)this.mockAppContext));
    }

    @Test(timeout=5000L)
    public void testHasAccess() {
        Configuration conf = new Configuration(false);
        conf.setBoolean("tez.am.acls.enabled", true);
        ACLManager aclManager = new ACLManager("amUser", conf);
        Mockito.when((Object)this.mockAppContext.getAMACLManager()).thenReturn((Object)aclManager);
        Assert.assertEquals((Object)false, (Object)AMWebController._hasAccess(null, (AppContext)this.mockAppContext));
        UserGroupInformation mockUser = UserGroupInformation.createUserForTesting((String)"mockUser", (String[])this.userGroups);
        Assert.assertEquals((Object)false, (Object)AMWebController._hasAccess((UserGroupInformation)mockUser, (AppContext)this.mockAppContext));
        UserGroupInformation testUser = UserGroupInformation.createUserForTesting((String)"amUser", (String[])this.userGroups);
        Assert.assertEquals((Object)true, (Object)AMWebController._hasAccess((UserGroupInformation)testUser, (AppContext)this.mockAppContext));
    }
}

