/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm.container;

import com.google.common.collect.Maps;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.tez.common.security.TokenCache;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ContainerContext;
import org.apache.tez.dag.app.ContainerHeartbeatHandler;
import org.apache.tez.dag.app.TaskAttemptListener;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventContainerTerminated;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventContainerTerminatedBySystem;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventContainerTerminating;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventNodeFailed;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventType;
import org.apache.tez.dag.app.rm.AMSchedulerEventType;
import org.apache.tez.dag.app.rm.NMCommunicatorEventType;
import org.apache.tez.dag.app.rm.container.AMContainerEvent;
import org.apache.tez.dag.app.rm.container.AMContainerEventAssignTA;
import org.apache.tez.dag.app.rm.container.AMContainerEventCompleted;
import org.apache.tez.dag.app.rm.container.AMContainerEventLaunchFailed;
import org.apache.tez.dag.app.rm.container.AMContainerEventLaunchRequest;
import org.apache.tez.dag.app.rm.container.AMContainerEventLaunched;
import org.apache.tez.dag.app.rm.container.AMContainerEventNodeFailed;
import org.apache.tez.dag.app.rm.container.AMContainerEventStopRequest;
import org.apache.tez.dag.app.rm.container.AMContainerEventTASucceeded;
import org.apache.tez.dag.app.rm.container.AMContainerEventType;
import org.apache.tez.dag.app.rm.container.AMContainerImpl;
import org.apache.tez.dag.app.rm.container.AMContainerState;
import org.apache.tez.dag.app.rm.container.AMContainerTask;
import org.apache.tez.dag.app.rm.container.ContainerContextMatcher;
import org.apache.tez.dag.app.rm.container.ContainerSignatureMatcher;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.HistoryEventHandler;
import org.apache.tez.dag.records.TaskAttemptTerminationCause;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestAMContainer {
    @Test(timeout=5000L)
    public void tetSingleSuccessfulTaskFlow() {
        WrappedContainer wc = new WrappedContainer();
        wc.verifyState(AMContainerState.ALLOCATED);
        wc.launchContainer();
        wc.verifyState(AMContainerState.LAUNCHING);
        wc.verifyCountAndGetOutgoingEvents(1);
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.verifyState(AMContainerState.LAUNCHING);
        wc.verifyNoOutgoingEvents();
        Assert.assertEquals((Object)wc.taskAttemptID, wc.amContainer.getQueuedTaskAttempts().get(0));
        wc.containerLaunched();
        wc.verifyState(AMContainerState.IDLE);
        wc.verifyNoOutgoingEvents();
        Assert.assertEquals((Object)wc.taskAttemptID, wc.amContainer.getQueuedTaskAttempts().get(0));
        Assert.assertNull((Object)wc.amContainer.getRunningTaskAttempt());
        ((TaskAttemptListener)Mockito.verify((Object)wc.tal)).registerRunningContainer(wc.containerID);
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).register((Object)wc.containerID);
        AMContainerTask pulledTask = wc.pullTaskToRun();
        wc.verifyState(AMContainerState.RUNNING);
        wc.verifyNoOutgoingEvents();
        Assert.assertFalse((boolean)pulledTask.shouldDie());
        Assert.assertEquals((Object)wc.taskSpec.getTaskAttemptID(), (Object)pulledTask.getTask().getTaskAttemptID());
        Assert.assertEquals((Object)wc.taskAttemptID, (Object)wc.amContainer.getRunningTaskAttempt());
        Assert.assertEquals((long)0L, (long)wc.amContainer.getQueuedTaskAttempts().size());
        wc.taskAttemptSucceeded(wc.taskAttemptID);
        wc.verifyState(AMContainerState.IDLE);
        wc.verifyNoOutgoingEvents();
        Assert.assertNull((Object)wc.amContainer.getRunningTaskAttempt());
        ((TaskAttemptListener)Mockito.verify((Object)wc.tal)).unregisterTaskAttempt(wc.taskAttemptID);
        wc.containerCompleted();
        wc.verifyHistoryStopEvent();
        wc.verifyState(AMContainerState.COMPLETED);
        wc.verifyNoOutgoingEvents();
        ((TaskAttemptListener)Mockito.verify((Object)wc.tal)).unregisterRunningContainer(wc.containerID);
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).unregister((Object)wc.containerID);
        Assert.assertEquals((long)1L, (long)wc.amContainer.getAllTaskAttempts().size());
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
    }

    @Test(timeout=5000L)
    public void testSingleSuccessfulTaskFlow2() {
        WrappedContainer wc = new WrappedContainer();
        wc.verifyState(AMContainerState.ALLOCATED);
        wc.launchContainer();
        wc.verifyState(AMContainerState.LAUNCHING);
        wc.verifyCountAndGetOutgoingEvents(1);
        wc.containerLaunched();
        wc.verifyState(AMContainerState.IDLE);
        wc.verifyNoOutgoingEvents();
        Assert.assertEquals((long)0L, (long)wc.amContainer.getQueuedTaskAttempts().size());
        ((TaskAttemptListener)Mockito.verify((Object)wc.tal)).registerRunningContainer(wc.containerID);
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).register((Object)wc.containerID);
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.verifyState(AMContainerState.IDLE);
        wc.verifyNoOutgoingEvents();
        Assert.assertEquals((Object)wc.taskAttemptID, wc.amContainer.getQueuedTaskAttempts().get(0));
        Assert.assertNull((Object)wc.amContainer.getRunningTaskAttempt());
        AMContainerTask pulledTask = wc.pullTaskToRun();
        wc.verifyState(AMContainerState.RUNNING);
        wc.verifyNoOutgoingEvents();
        Assert.assertFalse((boolean)pulledTask.shouldDie());
        Assert.assertEquals((Object)wc.taskSpec.getTaskAttemptID(), (Object)pulledTask.getTask().getTaskAttemptID());
        Assert.assertEquals((Object)wc.taskAttemptID, (Object)wc.amContainer.getRunningTaskAttempt());
        Assert.assertEquals((long)0L, (long)wc.amContainer.getQueuedTaskAttempts().size());
        wc.taskAttemptSucceeded(wc.taskAttemptID);
        wc.verifyState(AMContainerState.IDLE);
        wc.verifyNoOutgoingEvents();
        Assert.assertNull((Object)wc.amContainer.getRunningTaskAttempt());
        ((TaskAttemptListener)Mockito.verify((Object)wc.tal)).unregisterTaskAttempt(wc.taskAttemptID);
        wc.containerCompleted();
        wc.verifyHistoryStopEvent();
        wc.verifyState(AMContainerState.COMPLETED);
        wc.verifyNoOutgoingEvents();
        ((TaskAttemptListener)Mockito.verify((Object)wc.tal)).unregisterRunningContainer(wc.containerID);
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).unregister((Object)wc.containerID);
        Assert.assertEquals((long)1L, (long)wc.amContainer.getAllTaskAttempts().size());
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
    }

    @Test(timeout=5000L)
    public void testSingleSuccessfulTaskFlowStopRequest() {
        WrappedContainer wc = new WrappedContainer();
        wc.verifyState(AMContainerState.ALLOCATED);
        wc.launchContainer();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.containerLaunched();
        wc.pullTaskToRun();
        wc.taskAttemptSucceeded(wc.taskAttemptID);
        wc.stopRequest();
        wc.verifyState(AMContainerState.STOP_REQUESTED);
        wc.verifyCountAndGetOutgoingEvents(1);
        Assert.assertTrue((wc.verifyCountAndGetOutgoingEvents(1).get(0).getType() == NMCommunicatorEventType.CONTAINER_STOP_REQUEST ? 1 : 0) != 0);
        wc.nmStopSent();
        wc.verifyState(AMContainerState.STOPPING);
        wc.verifyNoOutgoingEvents();
        wc.containerCompleted();
        wc.verifyHistoryStopEvent();
        wc.verifyState(AMContainerState.COMPLETED);
        wc.verifyNoOutgoingEvents();
        ((TaskAttemptListener)Mockito.verify((Object)wc.tal)).unregisterRunningContainer(wc.containerID);
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).unregister((Object)wc.containerID);
        Assert.assertEquals((long)0L, (long)wc.amContainer.getQueuedTaskAttempts().size());
        Assert.assertNull((Object)wc.amContainer.getRunningTaskAttempt());
        Assert.assertEquals((long)1L, (long)wc.amContainer.getAllTaskAttempts().size());
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
    }

    @Test(timeout=5000L)
    public void testSingleSuccessfulTaskFlowFailedNMStopRequest() {
        WrappedContainer wc = new WrappedContainer();
        wc.verifyState(AMContainerState.ALLOCATED);
        wc.launchContainer();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.containerLaunched();
        wc.pullTaskToRun();
        wc.taskAttemptSucceeded(wc.taskAttemptID);
        wc.stopRequest();
        wc.verifyState(AMContainerState.STOP_REQUESTED);
        wc.verifyCountAndGetOutgoingEvents(1);
        Assert.assertTrue((wc.verifyCountAndGetOutgoingEvents(1).get(0).getType() == NMCommunicatorEventType.CONTAINER_STOP_REQUEST ? 1 : 0) != 0);
        wc.nmStopFailed();
        wc.verifyState(AMContainerState.STOPPING);
        wc.verifyCountAndGetOutgoingEvents(1);
        Assert.assertTrue((wc.verifyCountAndGetOutgoingEvents(1).get(0).getType() == AMSchedulerEventType.S_CONTAINER_DEALLOCATE ? 1 : 0) != 0);
        wc.containerCompleted();
        wc.verifyHistoryStopEvent();
        wc.verifyState(AMContainerState.COMPLETED);
        wc.verifyNoOutgoingEvents();
        ((TaskAttemptListener)Mockito.verify((Object)wc.tal)).unregisterRunningContainer(wc.containerID);
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).unregister((Object)wc.containerID);
        Assert.assertEquals((long)0L, (long)wc.amContainer.getQueuedTaskAttempts().size());
        Assert.assertNull((Object)wc.amContainer.getRunningTaskAttempt());
        Assert.assertEquals((long)1L, (long)wc.amContainer.getAllTaskAttempts().size());
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
    }

    @Test(timeout=5000L)
    public void testMultipleAllocationsAtIdle() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.containerLaunched();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.verifyState(AMContainerState.IDLE);
        TezTaskAttemptID taID2 = TezTaskAttemptID.getInstance((TezTaskID)wc.taskID, (int)2);
        wc.assignTaskAttempt(taID2);
        wc.verifyState(AMContainerState.STOP_REQUESTED);
        ((TaskAttemptListener)Mockito.verify((Object)wc.tal)).unregisterRunningContainer(wc.containerID);
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).unregister((Object)wc.containerID);
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(3);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{NMCommunicatorEventType.CONTAINER_STOP_REQUEST, TaskAttemptEventType.TA_CONTAINER_TERMINATING, TaskAttemptEventType.TA_CONTAINER_TERMINATING});
        Assert.assertTrue((boolean)wc.amContainer.isInErrorState());
        wc.nmStopSent();
        wc.containerCompleted();
        wc.verifyHistoryStopEvent();
        outgoingEvents = wc.verifyCountAndGetOutgoingEvents(2);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATED, TaskAttemptEventType.TA_CONTAINER_TERMINATED});
        Assert.assertNull((Object)wc.amContainer.getRunningTaskAttempt());
        Assert.assertEquals((long)0L, (long)wc.amContainer.getQueuedTaskAttempts().size());
        Assert.assertEquals((long)2L, (long)wc.amContainer.getAllTaskAttempts().size());
    }

    @Test(timeout=5000L)
    public void testAllocationAtRunning() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.containerLaunched();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.pullTaskToRun();
        wc.verifyState(AMContainerState.RUNNING);
        TezTaskAttemptID taID2 = TezTaskAttemptID.getInstance((TezTaskID)wc.taskID, (int)2);
        wc.assignTaskAttempt(taID2);
        wc.verifyState(AMContainerState.STOP_REQUESTED);
        ((TaskAttemptListener)Mockito.verify((Object)wc.tal)).unregisterRunningContainer(wc.containerID);
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).unregister((Object)wc.containerID);
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(3);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{NMCommunicatorEventType.CONTAINER_STOP_REQUEST, TaskAttemptEventType.TA_CONTAINER_TERMINATING, TaskAttemptEventType.TA_CONTAINER_TERMINATING});
        Assert.assertTrue((boolean)wc.amContainer.isInErrorState());
        wc.nmStopSent();
        wc.containerCompleted();
        wc.verifyHistoryStopEvent();
        outgoingEvents = wc.verifyCountAndGetOutgoingEvents(2);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATED, TaskAttemptEventType.TA_CONTAINER_TERMINATED});
        Assert.assertNull((Object)wc.amContainer.getRunningTaskAttempt());
        Assert.assertEquals((long)0L, (long)wc.amContainer.getQueuedTaskAttempts().size());
        Assert.assertEquals((long)2L, (long)wc.amContainer.getAllTaskAttempts().size());
    }

    @Test(timeout=5000L)
    public void testMultipleAllocationsAtLaunching() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.pullTaskToRun();
        wc.verifyState(AMContainerState.LAUNCHING);
        TezTaskAttemptID taID2 = TezTaskAttemptID.getInstance((TezTaskID)wc.taskID, (int)2);
        wc.assignTaskAttempt(taID2);
        wc.verifyState(AMContainerState.STOP_REQUESTED);
        ((TaskAttemptListener)Mockito.verify((Object)wc.tal)).unregisterRunningContainer(wc.containerID);
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).unregister((Object)wc.containerID);
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(3);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{NMCommunicatorEventType.CONTAINER_STOP_REQUEST, TaskAttemptEventType.TA_CONTAINER_TERMINATING, TaskAttemptEventType.TA_CONTAINER_TERMINATING});
        Assert.assertTrue((boolean)wc.amContainer.isInErrorState());
        wc.nmStopSent();
        wc.containerCompleted();
        wc.verifyHistoryStopEvent();
        outgoingEvents = wc.verifyCountAndGetOutgoingEvents(2);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATED, TaskAttemptEventType.TA_CONTAINER_TERMINATED});
        Assert.assertNull((Object)wc.amContainer.getRunningTaskAttempt());
        Assert.assertEquals((long)0L, (long)wc.amContainer.getQueuedTaskAttempts().size());
        Assert.assertEquals((long)2L, (long)wc.amContainer.getAllTaskAttempts().size());
    }

    @Test(timeout=5000L)
    public void testContainerTimedOutAtRunning() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.containerLaunched();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.pullTaskToRun();
        wc.verifyState(AMContainerState.RUNNING);
        wc.containerTimedOut();
        wc.verifyState(AMContainerState.STOP_REQUESTED);
        ((TaskAttemptListener)Mockito.verify((Object)wc.tal)).unregisterRunningContainer(wc.containerID);
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).unregister((Object)wc.containerID);
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(2);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATING, NMCommunicatorEventType.CONTAINER_STOP_REQUEST});
        wc.containerCompleted();
        wc.verifyHistoryStopEvent();
        outgoingEvents = wc.verifyCountAndGetOutgoingEvents(1);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATED});
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
        Assert.assertNull((Object)wc.amContainer.getRunningTaskAttempt());
        Assert.assertEquals((long)0L, (long)wc.amContainer.getQueuedTaskAttempts().size());
        Assert.assertEquals((long)1L, (long)wc.amContainer.getAllTaskAttempts().size());
    }

    @Test(timeout=5000L)
    public void testLaunchFailure() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.verifyState(AMContainerState.LAUNCHING);
        wc.launchFailed();
        wc.verifyState(AMContainerState.STOPPING);
        ((TaskAttemptListener)Mockito.verify((Object)wc.tal)).registerRunningContainer(wc.containerID);
        ((TaskAttemptListener)Mockito.verify((Object)wc.tal)).unregisterRunningContainer(wc.containerID);
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(2);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATING, AMSchedulerEventType.S_CONTAINER_DEALLOCATE});
        for (Event e : outgoingEvents) {
            if (e.getType() != TaskAttemptEventType.TA_CONTAINER_TERMINATING) continue;
            Assert.assertEquals((Object)TaskAttemptTerminationCause.CONTAINER_LAUNCH_FAILED, (Object)((TaskAttemptEventContainerTerminating)e).getTerminationCause());
        }
        wc.containerCompleted();
        outgoingEvents = wc.verifyCountAndGetOutgoingEvents(1);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATED});
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
    }

    @Test(timeout=5000L)
    public void testContainerCompletedAtAllocated() {
        WrappedContainer wc = new WrappedContainer();
        wc.verifyState(AMContainerState.ALLOCATED);
        wc.containerCompleted();
        wc.verifyState(AMContainerState.COMPLETED);
        wc.verifyNoOutgoingEvents();
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
    }

    @Test(timeout=5000L)
    public void testContainerCompletedAtLaunching() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.containerCompleted();
        wc.verifyState(AMContainerState.COMPLETED);
        ((TaskAttemptListener)Mockito.verify((Object)wc.tal)).registerRunningContainer(wc.containerID);
        ((TaskAttemptListener)Mockito.verify((Object)wc.tal)).unregisterRunningContainer(wc.containerID);
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(1);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATED});
        Assert.assertEquals((Object)TaskAttemptTerminationCause.CONTAINER_LAUNCH_FAILED, (Object)((TaskAttemptEventContainerTerminated)outgoingEvents.get(0)).getTerminationCause());
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
        wc.containerLaunched();
        wc.verifyNoOutgoingEvents();
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
    }

    @Test(timeout=5000L)
    public void testContainerCompletedAtLaunchingSpecificClusterError() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.containerCompleted(-101, TaskAttemptTerminationCause.NODE_DISK_ERROR);
        wc.verifyState(AMContainerState.COMPLETED);
        ((TaskAttemptListener)Mockito.verify((Object)wc.tal)).registerRunningContainer(wc.containerID);
        ((TaskAttemptListener)Mockito.verify((Object)wc.tal)).unregisterRunningContainer(wc.containerID);
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(1);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATED_BY_SYSTEM});
        Assert.assertEquals((Object)TaskAttemptTerminationCause.NODE_DISK_ERROR, (Object)((TaskAttemptEventContainerTerminatedBySystem)outgoingEvents.get(0)).getTerminationCause());
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
        wc.containerLaunched();
        wc.verifyNoOutgoingEvents();
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
    }

    @Test(timeout=5000L)
    public void testContainerCompletedAtLaunchingSpecificError() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.containerCompleted(-100, TaskAttemptTerminationCause.NODE_FAILED);
        wc.verifyState(AMContainerState.COMPLETED);
        ((TaskAttemptListener)Mockito.verify((Object)wc.tal)).registerRunningContainer(wc.containerID);
        ((TaskAttemptListener)Mockito.verify((Object)wc.tal)).unregisterRunningContainer(wc.containerID);
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(1);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATED});
        Assert.assertEquals((Object)TaskAttemptTerminationCause.NODE_FAILED, (Object)((TaskAttemptEventContainerTerminated)outgoingEvents.get(0)).getTerminationCause());
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
        wc.containerLaunched();
        wc.verifyNoOutgoingEvents();
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
    }

    @Test(timeout=5000L)
    public void testContainerCompletedAtIdle() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.containerLaunched();
        wc.verifyState(AMContainerState.IDLE);
        wc.containerCompleted();
        wc.verifyState(AMContainerState.COMPLETED);
        ((TaskAttemptListener)Mockito.verify((Object)wc.tal)).registerRunningContainer(wc.containerID);
        ((TaskAttemptListener)Mockito.verify((Object)wc.tal)).unregisterRunningContainer(wc.containerID);
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).register((Object)wc.containerID);
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).unregister((Object)wc.containerID);
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(1);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATED});
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
        wc.pullTaskToRun();
        wc.verifyNoOutgoingEvents();
        wc.verifyHistoryStopEvent();
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
    }

    @Test(timeout=5000L)
    public void testContainerCompletedAtRunning() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.containerLaunched();
        wc.pullTaskToRun();
        wc.verifyState(AMContainerState.RUNNING);
        wc.containerCompleted();
        wc.verifyState(AMContainerState.COMPLETED);
        ((TaskAttemptListener)Mockito.verify((Object)wc.tal)).registerRunningContainer(wc.containerID);
        ((TaskAttemptListener)Mockito.verify((Object)wc.tal)).unregisterRunningContainer(wc.containerID);
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).register((Object)wc.containerID);
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).unregister((Object)wc.containerID);
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(1);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATED});
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
        wc.taskAttemptSucceeded(wc.taskAttemptID);
        wc.verifyNoOutgoingEvents();
        wc.verifyHistoryStopEvent();
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
    }

    @Test(timeout=5000L)
    public void testContainerPreemptedAtRunning() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.containerLaunched();
        wc.pullTaskToRun();
        wc.verifyState(AMContainerState.RUNNING);
        wc.containerCompleted(-102, TaskAttemptTerminationCause.EXTERNAL_PREEMPTION);
        wc.verifyState(AMContainerState.COMPLETED);
        ((TaskAttemptListener)Mockito.verify((Object)wc.tal)).registerRunningContainer(wc.containerID);
        ((TaskAttemptListener)Mockito.verify((Object)wc.tal)).unregisterRunningContainer(wc.containerID);
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).register((Object)wc.containerID);
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).unregister((Object)wc.containerID);
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(1);
        Assert.assertEquals((Object)TaskAttemptTerminationCause.EXTERNAL_PREEMPTION, (Object)((TaskAttemptEventContainerTerminatedBySystem)outgoingEvents.get(0)).getTerminationCause());
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATED_BY_SYSTEM});
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
        wc.taskAttemptSucceeded(wc.taskAttemptID);
        wc.verifyNoOutgoingEvents();
        wc.verifyHistoryStopEvent();
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
    }

    @Test(timeout=5000L)
    public void testContainerInternallyPreemptedAtRunning() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.containerLaunched();
        wc.pullTaskToRun();
        wc.verifyState(AMContainerState.RUNNING);
        wc.containerCompleted(-1000, TaskAttemptTerminationCause.INTERNAL_PREEMPTION);
        wc.verifyState(AMContainerState.COMPLETED);
        ((TaskAttemptListener)Mockito.verify((Object)wc.tal)).registerRunningContainer(wc.containerID);
        ((TaskAttemptListener)Mockito.verify((Object)wc.tal)).unregisterRunningContainer(wc.containerID);
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).register((Object)wc.containerID);
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).unregister((Object)wc.containerID);
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(1);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATED_BY_SYSTEM});
        Assert.assertEquals((Object)TaskAttemptTerminationCause.INTERNAL_PREEMPTION, (Object)((TaskAttemptEventContainerTerminatedBySystem)outgoingEvents.get(0)).getTerminationCause());
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
        wc.taskAttemptSucceeded(wc.taskAttemptID);
        wc.verifyNoOutgoingEvents();
        wc.verifyHistoryStopEvent();
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
    }

    @Test(timeout=5000L)
    public void testContainerDiskFailedAtRunning() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.containerLaunched();
        wc.pullTaskToRun();
        wc.verifyState(AMContainerState.RUNNING);
        wc.containerCompleted(-101, TaskAttemptTerminationCause.NODE_DISK_ERROR);
        wc.verifyState(AMContainerState.COMPLETED);
        ((TaskAttemptListener)Mockito.verify((Object)wc.tal)).registerRunningContainer(wc.containerID);
        ((TaskAttemptListener)Mockito.verify((Object)wc.tal)).unregisterRunningContainer(wc.containerID);
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).register((Object)wc.containerID);
        ((ContainerHeartbeatHandler)Mockito.verify((Object)wc.chh)).unregister((Object)wc.containerID);
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(1);
        Assert.assertEquals((Object)TaskAttemptTerminationCause.NODE_DISK_ERROR, (Object)((TaskAttemptEventContainerTerminatedBySystem)outgoingEvents.get(0)).getTerminationCause());
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATED_BY_SYSTEM});
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
        wc.taskAttemptSucceeded(wc.taskAttemptID);
        wc.verifyNoOutgoingEvents();
        wc.verifyHistoryStopEvent();
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
    }

    @Test(timeout=5000L)
    public void testTaskAssignedToCompletedContainer() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.containerLaunched();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.pullTaskToRun();
        wc.taskAttemptSucceeded(wc.taskAttemptID);
        wc.containerCompleted();
        wc.verifyState(AMContainerState.COMPLETED);
        TezTaskAttemptID taID2 = TezTaskAttemptID.getInstance((TezTaskID)wc.taskID, (int)2);
        wc.assignTaskAttempt(taID2);
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(1);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATED});
        TaskAttemptEventContainerTerminated ctEvent = (TaskAttemptEventContainerTerminated)outgoingEvents.get(0);
        Assert.assertEquals((Object)taID2, (Object)ctEvent.getTaskAttemptID());
        wc.verifyHistoryStopEvent();
        Assert.assertTrue((boolean)wc.amContainer.isInErrorState());
    }

    @Test(timeout=5000L)
    public void testTaskPullAtLaunching() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        AMContainerTask pulledTask = wc.pullTaskToRun();
        wc.verifyState(AMContainerState.LAUNCHING);
        wc.verifyNoOutgoingEvents();
        Assert.assertFalse((boolean)pulledTask.shouldDie());
        Assert.assertNull((Object)pulledTask.getTask());
    }

    @Test(timeout=5000L)
    public void testNodeFailedAtIdle() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.containerLaunched();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.verifyState(AMContainerState.IDLE);
        wc.nodeFailed();
        wc.verifyState(AMContainerState.STOPPING);
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(3);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_NODE_FAILED, TaskAttemptEventType.TA_CONTAINER_TERMINATING, AMSchedulerEventType.S_CONTAINER_DEALLOCATE});
        for (Event event : outgoingEvents) {
            if (event.getType() != TaskAttemptEventType.TA_NODE_FAILED) continue;
            TaskAttemptEventNodeFailed nfEvent = (TaskAttemptEventNodeFailed)event;
            Assert.assertTrue((boolean)nfEvent.getDiagnosticInfo().contains("nodeFailed"));
        }
        wc.containerCompleted();
        wc.verifyHistoryStopEvent();
        outgoingEvents = wc.verifyCountAndGetOutgoingEvents(1);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATED});
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
    }

    @Test(timeout=5000L)
    public void testNodeFailedAtIdleMultipleAttempts() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.containerLaunched();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.pullTaskToRun();
        wc.taskAttemptSucceeded(wc.taskAttemptID);
        wc.verifyState(AMContainerState.IDLE);
        TezTaskAttemptID taID2 = TezTaskAttemptID.getInstance((TezTaskID)wc.taskID, (int)2);
        wc.assignTaskAttempt(taID2);
        wc.pullTaskToRun();
        wc.taskAttemptSucceeded(taID2);
        wc.verifyState(AMContainerState.IDLE);
        wc.nodeFailed();
        wc.verifyState(AMContainerState.STOPPING);
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(3);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_NODE_FAILED, TaskAttemptEventType.TA_NODE_FAILED, AMSchedulerEventType.S_CONTAINER_DEALLOCATE});
        for (Event event : outgoingEvents) {
            if (event.getType() != TaskAttemptEventType.TA_NODE_FAILED) continue;
            TaskAttemptEventNodeFailed nfEvent = (TaskAttemptEventNodeFailed)event;
            Assert.assertTrue((boolean)nfEvent.getDiagnosticInfo().contains("nodeFailed"));
        }
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
        wc.containerCompleted();
        wc.verifyNoOutgoingEvents();
        wc.verifyHistoryStopEvent();
        Assert.assertNull((Object)wc.amContainer.getRunningTaskAttempt());
        Assert.assertEquals((long)0L, (long)wc.amContainer.getQueuedTaskAttempts().size());
        Assert.assertEquals((long)2L, (long)wc.amContainer.getAllTaskAttempts().size());
    }

    @Test(timeout=5000L)
    public void testNodeFailedAtRunningMultipleAttempts() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.containerLaunched();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.pullTaskToRun();
        wc.taskAttemptSucceeded(wc.taskAttemptID);
        TezTaskAttemptID taID2 = TezTaskAttemptID.getInstance((TezTaskID)wc.taskID, (int)2);
        wc.assignTaskAttempt(taID2);
        wc.pullTaskToRun();
        wc.verifyState(AMContainerState.RUNNING);
        wc.nodeFailed();
        wc.verifyState(AMContainerState.STOPPING);
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(4);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_NODE_FAILED, TaskAttemptEventType.TA_NODE_FAILED, TaskAttemptEventType.TA_CONTAINER_TERMINATING, AMSchedulerEventType.S_CONTAINER_DEALLOCATE});
        for (Event event : outgoingEvents) {
            if (event.getType() != TaskAttemptEventType.TA_NODE_FAILED) continue;
            TaskAttemptEventNodeFailed nfEvent = (TaskAttemptEventNodeFailed)event;
            Assert.assertTrue((boolean)nfEvent.getDiagnosticInfo().contains("nodeFailed"));
        }
        wc.containerCompleted();
        wc.verifyHistoryStopEvent();
        outgoingEvents = wc.verifyCountAndGetOutgoingEvents(1);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_CONTAINER_TERMINATED});
        Assert.assertFalse((boolean)wc.amContainer.isInErrorState());
        Assert.assertNull((Object)wc.amContainer.getRunningTaskAttempt());
        Assert.assertEquals((long)0L, (long)wc.amContainer.getQueuedTaskAttempts().size());
        Assert.assertEquals((long)2L, (long)wc.amContainer.getAllTaskAttempts().size());
    }

    @Test(timeout=5000L)
    public void testNodeFailedAtCompletedMultipleSuccessfulTAs() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.containerLaunched();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.pullTaskToRun();
        wc.taskAttemptSucceeded(wc.taskAttemptID);
        TezTaskAttemptID taID2 = TezTaskAttemptID.getInstance((TezTaskID)wc.taskID, (int)2);
        wc.assignTaskAttempt(taID2);
        wc.pullTaskToRun();
        wc.taskAttemptSucceeded(taID2);
        wc.stopRequest();
        wc.nmStopSent();
        wc.containerCompleted();
        wc.verifyState(AMContainerState.COMPLETED);
        wc.nodeFailed();
        List<Event> outgoingEvents = wc.verifyCountAndGetOutgoingEvents(2);
        this.verifyUnOrderedOutgoingEventTypes(outgoingEvents, new Enum[]{TaskAttemptEventType.TA_NODE_FAILED, TaskAttemptEventType.TA_NODE_FAILED});
        Assert.assertNull((Object)wc.amContainer.getRunningTaskAttempt());
        Assert.assertEquals((long)0L, (long)wc.amContainer.getQueuedTaskAttempts().size());
        Assert.assertEquals((long)2L, (long)wc.amContainer.getAllTaskAttempts().size());
    }

    @Test(timeout=5000L)
    public void testDuplicateCompletedEvents() {
        WrappedContainer wc = new WrappedContainer();
        wc.launchContainer();
        wc.containerLaunched();
        wc.assignTaskAttempt(wc.taskAttemptID);
        wc.pullTaskToRun();
        wc.taskAttemptSucceeded(wc.taskAttemptID);
        TezTaskAttemptID taID2 = TezTaskAttemptID.getInstance((TezTaskID)wc.taskID, (int)2);
        wc.assignTaskAttempt(taID2);
        wc.pullTaskToRun();
        wc.taskAttemptSucceeded(taID2);
        wc.stopRequest();
        wc.nmStopSent();
        wc.containerCompleted();
        wc.verifyState(AMContainerState.COMPLETED);
        wc.verifyNoOutgoingEvents();
        wc.containerCompleted();
        wc.verifyNoOutgoingEvents();
        wc.verifyHistoryStopEvent();
    }

    @Test(timeout=5000L)
    public void testLocalResourceAddition() {
        WrappedContainer wc = new WrappedContainer();
        String rsrc1 = "rsrc1";
        String rsrc2 = "rsrc2";
        String rsrc3 = "rsrc3";
        HashMap initialResources = Maps.newHashMap();
        initialResources.put(rsrc1, this.createLocalResource(rsrc1));
        wc.launchContainer(initialResources, new Credentials());
        wc.containerLaunched();
        wc.assignTaskAttempt(wc.taskAttemptID);
        AMContainerTask task1 = wc.pullTaskToRun();
        Assert.assertEquals((long)0L, (long)task1.getAdditionalResources().size());
        wc.taskAttemptSucceeded(wc.taskAttemptID);
        HashMap additionalResources = Maps.newHashMap();
        additionalResources.put(rsrc2, this.createLocalResource(rsrc2));
        additionalResources.put(rsrc3, this.createLocalResource(rsrc3));
        TezTaskAttemptID taID2 = TezTaskAttemptID.getInstance((TezTaskID)wc.taskID, (int)2);
        wc.assignTaskAttempt(taID2, additionalResources, new Credentials());
        AMContainerTask task2 = wc.pullTaskToRun();
        Map pullTaskAdditionalResources = task2.getAdditionalResources();
        Assert.assertEquals((long)2L, (long)pullTaskAdditionalResources.size());
        pullTaskAdditionalResources.remove(rsrc2);
        pullTaskAdditionalResources.remove(rsrc3);
        Assert.assertEquals((long)0L, (long)pullTaskAdditionalResources.size());
        wc.taskAttemptSucceeded(taID2);
        HashMap containerLRs = new HashMap(wc.amContainer.containerLocalResources);
        Assert.assertEquals((long)3L, (long)containerLRs.size());
        containerLRs.remove(rsrc1);
        containerLRs.remove(rsrc2);
        containerLRs.remove(rsrc3);
        Assert.assertEquals((long)0L, (long)containerLRs.size());
        TezTaskAttemptID taID3 = TezTaskAttemptID.getInstance((TezTaskID)wc.taskID, (int)3);
        wc.assignTaskAttempt(taID3, new HashMap<String, LocalResource>(), new Credentials());
        AMContainerTask task3 = wc.pullTaskToRun();
        Assert.assertEquals((long)0L, (long)task3.getAdditionalResources().size());
        wc.taskAttemptSucceeded(taID3);
        wc.containerCompleted();
        Assert.assertNull((Object)wc.amContainer.containerLocalResources);
        Assert.assertNull((Object)wc.amContainer.additionalLocalResources);
    }

    @Test(timeout=5000L)
    public void testCredentialsTransfer() {
        WrappedContainerMultipleDAGs wc = new WrappedContainerMultipleDAGs();
        TezDAGID dagID2 = TezDAGID.getInstance((String)"800", (int)500, (int)2);
        TezDAGID dagID3 = TezDAGID.getInstance((String)"800", (int)500, (int)3);
        TezVertexID vertexID2 = TezVertexID.getInstance((TezDAGID)dagID2, (int)1);
        TezVertexID vertexID3 = TezVertexID.getInstance((TezDAGID)dagID3, (int)1);
        TezTaskID taskID2 = TezTaskID.getInstance((TezVertexID)vertexID2, (int)1);
        TezTaskID taskID3 = TezTaskID.getInstance((TezVertexID)vertexID3, (int)1);
        TezTaskAttemptID attempt11 = TezTaskAttemptID.getInstance((TezTaskID)wc.taskID, (int)200);
        TezTaskAttemptID attempt12 = TezTaskAttemptID.getInstance((TezTaskID)wc.taskID, (int)300);
        TezTaskAttemptID attempt21 = TezTaskAttemptID.getInstance((TezTaskID)taskID2, (int)200);
        TezTaskAttemptID attempt22 = TezTaskAttemptID.getInstance((TezTaskID)taskID2, (int)300);
        TezTaskAttemptID attempt31 = TezTaskAttemptID.getInstance((TezTaskID)taskID3, (int)200);
        TezTaskAttemptID attempt32 = TezTaskAttemptID.getInstance((TezTaskID)taskID3, (int)300);
        HashMap<String, LocalResource> LRs = new HashMap<String, LocalResource>();
        AMContainerTask fetchedTask = null;
        Token amGenToken = (Token)Mockito.mock(Token.class);
        Token token1 = (Token)Mockito.mock(Token.class);
        Token token3 = (Token)Mockito.mock(Token.class);
        Credentials containerCredentials = new Credentials();
        TokenCache.setSessionToken((Token)amGenToken, (Credentials)containerCredentials);
        Text token1Name = new Text("tokenDag1");
        Text token3Name = new Text("tokenDag3");
        Credentials dag1Credentials = new Credentials();
        dag1Credentials.addToken(new Text(token1Name), token1);
        Credentials dag3Credentials = new Credentials();
        dag3Credentials.addToken(new Text(token3Name), token3);
        wc.launchContainer(new HashMap<String, LocalResource>(), containerCredentials);
        wc.containerLaunched();
        wc.assignTaskAttempt(attempt11, LRs, dag1Credentials);
        fetchedTask = wc.pullTaskToRun();
        Assert.assertTrue((boolean)fetchedTask.haveCredentialsChanged());
        Assert.assertNotNull((Object)fetchedTask.getCredentials());
        Assert.assertNotNull((Object)fetchedTask.getCredentials().getToken(token1Name));
        wc.taskAttemptSucceeded(attempt11);
        wc.assignTaskAttempt(attempt12, LRs, dag1Credentials);
        fetchedTask = wc.pullTaskToRun();
        Assert.assertFalse((boolean)fetchedTask.haveCredentialsChanged());
        Assert.assertNull((Object)fetchedTask.getCredentials());
        wc.taskAttemptSucceeded(attempt12);
        wc.setNewDAGID(dagID2);
        wc.assignTaskAttempt(attempt21, LRs, null);
        fetchedTask = wc.pullTaskToRun();
        Assert.assertTrue((boolean)fetchedTask.haveCredentialsChanged());
        Assert.assertNull((Object)fetchedTask.getCredentials());
        wc.taskAttemptSucceeded(attempt21);
        wc.assignTaskAttempt(attempt22, LRs, null);
        fetchedTask = wc.pullTaskToRun();
        Assert.assertFalse((boolean)fetchedTask.haveCredentialsChanged());
        Assert.assertNull((Object)fetchedTask.getCredentials());
        wc.taskAttemptSucceeded(attempt22);
        wc.setNewDAGID(dagID3);
        wc.assignTaskAttempt(attempt31, LRs, dag3Credentials);
        fetchedTask = wc.pullTaskToRun();
        Assert.assertTrue((boolean)fetchedTask.haveCredentialsChanged());
        Assert.assertNotNull((Object)fetchedTask.getCredentials());
        Assert.assertNotNull((Object)fetchedTask.getCredentials().getToken(token3Name));
        Assert.assertNull((Object)fetchedTask.getCredentials().getToken(token1Name));
        wc.taskAttemptSucceeded(attempt31);
        wc.assignTaskAttempt(attempt32, LRs, dag1Credentials);
        fetchedTask = wc.pullTaskToRun();
        Assert.assertFalse((boolean)fetchedTask.haveCredentialsChanged());
        Assert.assertNull((Object)fetchedTask.getCredentials());
        wc.taskAttemptSucceeded(attempt32);
    }

    private void verifyUnOrderedOutgoingEventTypes(List<Event> events, Enum<?> ... expectedTypes) {
        LinkedList expectedTypeList = new LinkedList();
        for (Enum<?> expectedType : expectedTypes) {
            expectedTypeList.add(expectedType);
        }
        LinkedList<Event> eventsCopy = new LinkedList<Event>(events);
        Iterator expectedTypeIterator = expectedTypeList.iterator();
        block1: while (expectedTypeIterator.hasNext()) {
            Enum expectedType = (Enum)expectedTypeIterator.next();
            Iterator iter = eventsCopy.iterator();
            while (iter.hasNext()) {
                Event e = (Event)iter.next();
                if (e.getType() != expectedType) continue;
                iter.remove();
                expectedTypeIterator.remove();
                continue block1;
            }
        }
        Assert.assertTrue((String)("Did not find types : " + expectedTypeList + " in outgoing event list"), (boolean)expectedTypeList.isEmpty());
        Assert.assertTrue((String)("Found unexpected events: " + eventsCopy + " in outgoing event list"), (boolean)eventsCopy.isEmpty());
    }

    private LocalResource createLocalResource(String name) {
        LocalResource lr = LocalResource.newInstance((URL)URL.newInstance(null, (String)"localhost", (int)2321, (String)name), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.APPLICATION, (long)1L, (long)1000000L);
        return lr;
    }

    private static class WrappedContainerMultipleDAGs
    extends WrappedContainer {
        private TezDAGID newDAGID = null;

        private WrappedContainerMultipleDAGs() {
        }

        @Override
        protected void mockDAGID() {
            ((AppContext)Mockito.doAnswer((Answer)new Answer<TezDAGID>(){

                public TezDAGID answer(InvocationOnMock invocation) throws Throwable {
                    return WrappedContainerMultipleDAGs.this.newDAGID == null ? WrappedContainerMultipleDAGs.this.dagID : WrappedContainerMultipleDAGs.this.newDAGID;
                }
            }).when((Object)this.appContext)).getCurrentDAGID();
        }

        void setNewDAGID(TezDAGID newDAGID) {
            this.newDAGID = newDAGID;
        }
    }

    private static class WrappedContainer {
        long rmIdentifier = 2000L;
        ApplicationId applicationID = ApplicationId.newInstance((long)this.rmIdentifier, (int)1);
        ApplicationAttemptId appAttemptID = ApplicationAttemptId.newInstance((ApplicationId)this.applicationID, (int)1);
        ContainerId containerID = ContainerId.newInstance((ApplicationAttemptId)this.appAttemptID, (int)1);
        NodeId nodeID = NodeId.newInstance((String)"host", (int)12500);
        String nodeHttpAddress = "host:12501";
        Resource resource = Resource.newInstance((int)1024, (int)1);
        Priority priority = Priority.newInstance((int)1);
        Container container = Container.newInstance((ContainerId)this.containerID, (NodeId)this.nodeID, (String)this.nodeHttpAddress, (Resource)this.resource, (Priority)this.priority, null);
        ContainerHeartbeatHandler chh = (ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class);
        TaskAttemptListener tal;
        EventHandler eventHandler;
        AppContext appContext;
        HistoryEventHandler historyEventHandler;
        TezDAGID dagID;
        TezVertexID vertexID;
        TezTaskID taskID;
        TezTaskAttemptID taskAttemptID;
        TaskSpec taskSpec;
        public AMContainerImpl amContainer;

        public WrappedContainer(boolean shouldProfile, String profileString) {
            InetSocketAddress addr = new InetSocketAddress("localhost", 0);
            this.tal = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
            ((TaskAttemptListener)Mockito.doReturn((Object)addr).when((Object)this.tal)).getAddress();
            this.dagID = TezDAGID.getInstance((ApplicationId)this.applicationID, (int)1);
            this.vertexID = TezVertexID.getInstance((TezDAGID)this.dagID, (int)1);
            this.taskID = TezTaskID.getInstance((TezVertexID)this.vertexID, (int)1);
            this.taskAttemptID = TezTaskAttemptID.getInstance((TezTaskID)this.taskID, (int)1);
            this.eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
            this.historyEventHandler = (HistoryEventHandler)Mockito.mock(HistoryEventHandler.class);
            Configuration conf = new Configuration(false);
            this.appContext = (AppContext)Mockito.mock(AppContext.class);
            ((AppContext)Mockito.doReturn(new HashMap()).when((Object)this.appContext)).getApplicationACLs();
            ((AppContext)Mockito.doReturn((Object)this.eventHandler).when((Object)this.appContext)).getEventHandler();
            ((AppContext)Mockito.doReturn((Object)this.appAttemptID).when((Object)this.appContext)).getApplicationAttemptId();
            ((AppContext)Mockito.doReturn((Object)this.applicationID).when((Object)this.appContext)).getApplicationID();
            ((AppContext)Mockito.doReturn((Object)new SystemClock()).when((Object)this.appContext)).getClock();
            ((AppContext)Mockito.doReturn((Object)this.historyEventHandler).when((Object)this.appContext)).getHistoryHandler();
            ((AppContext)Mockito.doReturn((Object)conf).when((Object)this.appContext)).getAMConf();
            this.mockDAGID();
            this.taskSpec = (TaskSpec)Mockito.mock(TaskSpec.class);
            ((TaskSpec)Mockito.doReturn((Object)this.taskAttemptID).when((Object)this.taskSpec)).getTaskAttemptID();
            this.amContainer = new AMContainerImpl(this.container, this.chh, this.tal, (ContainerSignatureMatcher)new ContainerContextMatcher(), this.appContext);
        }

        public WrappedContainer() {
            this(false, null);
        }

        protected void mockDAGID() {
            ((AppContext)Mockito.doReturn((Object)this.dagID).when((Object)this.appContext)).getCurrentDAGID();
        }

        public void verifyNoOutgoingEvents() {
            ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.never())).handle((Event)Matchers.any(Event.class));
        }

        public List<Event> verifyCountAndGetOutgoingEvents(int invocations) {
            ArgumentCaptor args = ArgumentCaptor.forClass(Event.class);
            ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)invocations))).handle((Event)args.capture());
            return args.getAllValues();
        }

        public void verifyHistoryStopEvent() {
            ArgumentCaptor args = ArgumentCaptor.forClass(DAGHistoryEvent.class);
            ((HistoryEventHandler)Mockito.verify((Object)this.historyEventHandler, (VerificationMode)Mockito.times((int)1))).handle((DAGHistoryEvent)args.capture());
            Assert.assertEquals((long)1L, (long)args.getAllValues().size());
        }

        public void launchContainer() {
            this.launchContainer(new HashMap<String, LocalResource>(), new Credentials());
        }

        public void launchContainer(Map<String, LocalResource> localResources, Credentials credentials) {
            Mockito.reset((Object[])new EventHandler[]{this.eventHandler});
            Token jobToken = (Token)Mockito.mock(Token.class);
            TokenCache.setSessionToken((Token)jobToken, (Credentials)credentials);
            this.amContainer.handle((AMContainerEvent)new AMContainerEventLaunchRequest(this.containerID, this.vertexID, new ContainerContext(localResources, credentials, new HashMap(), "")));
        }

        public void assignTaskAttempt(TezTaskAttemptID taID) {
            this.assignTaskAttempt(taID, new HashMap<String, LocalResource>(), new Credentials());
        }

        public void assignTaskAttempt(TezTaskAttemptID taID, Map<String, LocalResource> additionalResources, Credentials credentials) {
            Mockito.reset((Object[])new EventHandler[]{this.eventHandler});
            this.amContainer.handle((AMContainerEvent)new AMContainerEventAssignTA(this.containerID, taID, (Object)this.taskSpec, additionalResources, credentials));
        }

        public AMContainerTask pullTaskToRun() {
            Mockito.reset((Object[])new EventHandler[]{this.eventHandler});
            return this.amContainer.pullTaskContext();
        }

        public void containerLaunched() {
            Mockito.reset((Object[])new EventHandler[]{this.eventHandler});
            this.amContainer.handle((AMContainerEvent)new AMContainerEventLaunched(this.containerID));
        }

        public void taskAttemptSucceeded(TezTaskAttemptID taID) {
            Mockito.reset((Object[])new EventHandler[]{this.eventHandler});
            this.amContainer.handle((AMContainerEvent)new AMContainerEventTASucceeded(this.containerID, taID));
        }

        public void stopRequest() {
            Mockito.reset((Object[])new EventHandler[]{this.eventHandler});
            this.amContainer.handle((AMContainerEvent)new AMContainerEventStopRequest(this.containerID));
        }

        public void nmStopSent() {
            Mockito.reset((Object[])new EventHandler[]{this.eventHandler});
            this.amContainer.handle(new AMContainerEvent(this.containerID, AMContainerEventType.C_NM_STOP_SENT));
        }

        public void nmStopFailed() {
            Mockito.reset((Object[])new EventHandler[]{this.eventHandler});
            this.amContainer.handle(new AMContainerEvent(this.containerID, AMContainerEventType.C_NM_STOP_FAILED));
        }

        public void containerCompleted() {
            Mockito.reset((Object[])new EventHandler[]{this.eventHandler});
            this.amContainer.handle((AMContainerEvent)new AMContainerEventCompleted(this.containerID, 0, null, TaskAttemptTerminationCause.CONTAINER_EXITED));
        }

        public void containerCompleted(int exitStatus, TaskAttemptTerminationCause errCause) {
            Mockito.reset((Object[])new EventHandler[]{this.eventHandler});
            this.amContainer.handle((AMContainerEvent)new AMContainerEventCompleted(this.containerID, exitStatus, null, errCause));
        }

        public void containerTimedOut() {
            Mockito.reset((Object[])new EventHandler[]{this.eventHandler});
            this.amContainer.handle(new AMContainerEvent(this.containerID, AMContainerEventType.C_TIMED_OUT));
        }

        public void launchFailed() {
            Mockito.reset((Object[])new EventHandler[]{this.eventHandler});
            this.amContainer.handle((AMContainerEvent)new AMContainerEventLaunchFailed(this.containerID, "launchFailed"));
        }

        public void nodeFailed() {
            Mockito.reset((Object[])new EventHandler[]{this.eventHandler});
            this.amContainer.handle((AMContainerEvent)new AMContainerEventNodeFailed(this.containerID, "nodeFailed"));
        }

        public void verifyState(AMContainerState state) {
            Assert.assertEquals((String)("Expected state: " + state + ", but found: " + this.amContainer.getState()), (Object)state, (Object)this.amContainer.getState());
        }
    }
}

