/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.dag.api.TaskLocationHint;
import org.apache.tez.dag.api.client.DAGClientServer;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.dag.TaskAttempt;
import org.apache.tez.dag.app.dag.impl.TaskAttemptImpl;
import org.apache.tez.dag.app.dag.impl.TaskImpl;
import org.apache.tez.dag.app.dag.impl.VertexImpl;
import org.apache.tez.dag.app.rm.AMSchedulerEvent;
import org.apache.tez.dag.app.rm.AMSchedulerEventTALaunchRequest;
import org.apache.tez.dag.app.rm.TaskSchedulerEventHandler;
import org.apache.tez.dag.app.rm.TaskSchedulerService;
import org.apache.tez.dag.app.rm.container.AMContainer;
import org.apache.tez.dag.app.rm.container.AMContainerEventCompleted;
import org.apache.tez.dag.app.rm.container.AMContainerEventType;
import org.apache.tez.dag.app.rm.container.AMContainerMap;
import org.apache.tez.dag.app.rm.container.ContainerSignatureMatcher;
import org.apache.tez.dag.app.web.WebUIService;
import org.apache.tez.dag.records.TaskAttemptTerminationCause;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestTaskSchedulerEventHandler {
    AppContext mockAppContext;
    DAGClientServer mockClientService;
    TestEventHandler mockEventHandler;
    ContainerSignatureMatcher mockSigMatcher;
    MockTaskSchedulerEventHandler schedulerHandler;
    TaskSchedulerService mockTaskScheduler;
    AMContainerMap mockAMContainerMap;
    WebUIService mockWebUIService;

    @Before
    public void setup() {
        this.mockAppContext = (AppContext)Mockito.mock(AppContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        ((AppContext)Mockito.doReturn((Object)new Configuration(false)).when((Object)this.mockAppContext)).getAMConf();
        this.mockClientService = (DAGClientServer)Mockito.mock(DAGClientServer.class);
        this.mockEventHandler = new TestEventHandler();
        this.mockSigMatcher = (ContainerSignatureMatcher)Mockito.mock(ContainerSignatureMatcher.class);
        this.mockTaskScheduler = (TaskSchedulerService)Mockito.mock(TaskSchedulerService.class);
        this.mockAMContainerMap = (AMContainerMap)Mockito.mock(AMContainerMap.class);
        this.mockWebUIService = (WebUIService)Mockito.mock(WebUIService.class);
        Mockito.when((Object)this.mockAppContext.getAllContainers()).thenReturn((Object)this.mockAMContainerMap);
        Mockito.when((Object)this.mockClientService.getBindAddress()).thenReturn((Object)new InetSocketAddress(10000));
        this.schedulerHandler = new MockTaskSchedulerEventHandler(this.mockAppContext, this.mockClientService, this.mockEventHandler, this.mockSigMatcher, this.mockWebUIService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testTaskBasedAffinity() throws Exception {
        Configuration conf = new Configuration(false);
        this.schedulerHandler.init(conf);
        this.schedulerHandler.start();
        TaskAttemptImpl mockTaskAttempt = (TaskAttemptImpl)Mockito.mock(TaskAttemptImpl.class);
        TezTaskAttemptID taId = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
        String affVertexName = "srcVertex";
        int affTaskIndex = 1;
        TaskLocationHint locHint = TaskLocationHint.createTaskLocationHint((String)affVertexName, (int)affTaskIndex);
        VertexImpl affVertex = (VertexImpl)Mockito.mock(VertexImpl.class);
        TaskImpl affTask = (TaskImpl)Mockito.mock(TaskImpl.class);
        TaskAttemptImpl affAttempt = (TaskAttemptImpl)Mockito.mock(TaskAttemptImpl.class);
        ContainerId affCId = (ContainerId)Mockito.mock(ContainerId.class);
        Mockito.when((Object)affVertex.getTotalTasks()).thenReturn((Object)2);
        Mockito.when((Object)affVertex.getTask(affTaskIndex)).thenReturn((Object)affTask);
        Mockito.when((Object)affTask.getSuccessfulAttempt()).thenReturn((Object)affAttempt);
        Mockito.when((Object)affAttempt.getAssignedContainerID()).thenReturn((Object)affCId);
        Mockito.when((Object)this.mockAppContext.getCurrentDAG().getVertex(affVertexName)).thenReturn((Object)affVertex);
        Resource resource = Resource.newInstance((int)100, (int)1);
        AMSchedulerEventTALaunchRequest event = new AMSchedulerEventTALaunchRequest(taId, resource, null, (TaskAttempt)mockTaskAttempt, locHint, 3, null);
        this.schedulerHandler.notify.set(false);
        this.schedulerHandler.handle((AMSchedulerEvent)event);
        AtomicBoolean atomicBoolean = this.schedulerHandler.notify;
        synchronized (atomicBoolean) {
            while (!this.schedulerHandler.notify.get()) {
                this.schedulerHandler.notify.wait();
            }
        }
        ((TaskSchedulerService)Mockito.verify((Object)this.mockTaskScheduler, (VerificationMode)Mockito.times((int)1))).allocateTask((Object)mockTaskAttempt, resource, affCId, Priority.newInstance((int)3), null, (Object)event);
        this.schedulerHandler.stop();
        this.schedulerHandler.close();
    }

    @Test(timeout=5000L)
    public void testContainerPreempted() throws IOException {
        Configuration conf = new Configuration(false);
        this.schedulerHandler.init(conf);
        this.schedulerHandler.start();
        String diagnostics = "Container preempted by RM.";
        TaskAttemptImpl mockTask = (TaskAttemptImpl)Mockito.mock(TaskAttemptImpl.class);
        ContainerStatus mockStatus = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        ContainerId mockCId = (ContainerId)Mockito.mock(ContainerId.class);
        AMContainer mockAMContainer = (AMContainer)Mockito.mock(AMContainer.class);
        Mockito.when((Object)this.mockAMContainerMap.get(mockCId)).thenReturn((Object)mockAMContainer);
        Mockito.when((Object)mockAMContainer.getContainerId()).thenReturn((Object)mockCId);
        Mockito.when((Object)mockStatus.getContainerId()).thenReturn((Object)mockCId);
        Mockito.when((Object)mockStatus.getDiagnostics()).thenReturn((Object)diagnostics);
        Mockito.when((Object)mockStatus.getExitStatus()).thenReturn((Object)-102);
        this.schedulerHandler.containerCompleted(mockTask, mockStatus);
        Assert.assertEquals((long)1L, (long)this.mockEventHandler.events.size());
        Event event = this.mockEventHandler.events.get(0);
        Assert.assertEquals((Object)AMContainerEventType.C_COMPLETED, (Object)event.getType());
        AMContainerEventCompleted completedEvent = (AMContainerEventCompleted)event;
        Assert.assertEquals((Object)mockCId, (Object)completedEvent.getContainerId());
        Assert.assertEquals((Object)"Container preempted externally. Container preempted by RM.", (Object)completedEvent.getDiagnostics());
        Assert.assertTrue((boolean)completedEvent.isPreempted());
        Assert.assertEquals((Object)TaskAttemptTerminationCause.EXTERNAL_PREEMPTION, (Object)completedEvent.getTerminationCause());
        Assert.assertFalse((boolean)completedEvent.isDiskFailed());
        this.schedulerHandler.stop();
        this.schedulerHandler.close();
    }

    @Test(timeout=5000L)
    public void testContainerInternalPreempted() throws IOException {
        Configuration conf = new Configuration(false);
        this.schedulerHandler.init(conf);
        this.schedulerHandler.start();
        ContainerId mockCId = (ContainerId)Mockito.mock(ContainerId.class);
        ((TaskSchedulerService)Mockito.verify((Object)this.mockTaskScheduler, (VerificationMode)Mockito.times((int)0))).deallocateContainer((ContainerId)Matchers.any());
        this.schedulerHandler.preemptContainer(mockCId);
        ((TaskSchedulerService)Mockito.verify((Object)this.mockTaskScheduler, (VerificationMode)Mockito.times((int)1))).deallocateContainer(mockCId);
        Assert.assertEquals((long)1L, (long)this.mockEventHandler.events.size());
        Event event = this.mockEventHandler.events.get(0);
        Assert.assertEquals((Object)AMContainerEventType.C_COMPLETED, (Object)event.getType());
        AMContainerEventCompleted completedEvent = (AMContainerEventCompleted)event;
        Assert.assertEquals((Object)mockCId, (Object)completedEvent.getContainerId());
        Assert.assertEquals((Object)"Container preempted internally", (Object)completedEvent.getDiagnostics());
        Assert.assertTrue((boolean)completedEvent.isPreempted());
        Assert.assertFalse((boolean)completedEvent.isDiskFailed());
        Assert.assertEquals((Object)TaskAttemptTerminationCause.INTERNAL_PREEMPTION, (Object)completedEvent.getTerminationCause());
        this.schedulerHandler.stop();
        this.schedulerHandler.close();
    }

    @Test(timeout=5000L)
    public void testContainerDiskFailed() throws IOException {
        Configuration conf = new Configuration(false);
        this.schedulerHandler.init(conf);
        this.schedulerHandler.start();
        String diagnostics = "NM disk failed.";
        TaskAttemptImpl mockTask = (TaskAttemptImpl)Mockito.mock(TaskAttemptImpl.class);
        ContainerStatus mockStatus = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        ContainerId mockCId = (ContainerId)Mockito.mock(ContainerId.class);
        AMContainer mockAMContainer = (AMContainer)Mockito.mock(AMContainer.class);
        Mockito.when((Object)this.mockAMContainerMap.get(mockCId)).thenReturn((Object)mockAMContainer);
        Mockito.when((Object)mockAMContainer.getContainerId()).thenReturn((Object)mockCId);
        Mockito.when((Object)mockStatus.getContainerId()).thenReturn((Object)mockCId);
        Mockito.when((Object)mockStatus.getDiagnostics()).thenReturn((Object)diagnostics);
        Mockito.when((Object)mockStatus.getExitStatus()).thenReturn((Object)-101);
        this.schedulerHandler.containerCompleted(mockTask, mockStatus);
        Assert.assertEquals((long)1L, (long)this.mockEventHandler.events.size());
        Event event = this.mockEventHandler.events.get(0);
        Assert.assertEquals((Object)AMContainerEventType.C_COMPLETED, (Object)event.getType());
        AMContainerEventCompleted completedEvent = (AMContainerEventCompleted)event;
        Assert.assertEquals((Object)mockCId, (Object)completedEvent.getContainerId());
        Assert.assertEquals((Object)"Container disk failed. NM disk failed.", (Object)completedEvent.getDiagnostics());
        Assert.assertFalse((boolean)completedEvent.isPreempted());
        Assert.assertTrue((boolean)completedEvent.isDiskFailed());
        Assert.assertEquals((Object)TaskAttemptTerminationCause.NODE_DISK_ERROR, (Object)completedEvent.getTerminationCause());
        this.schedulerHandler.stop();
        this.schedulerHandler.close();
    }

    @Test(timeout=5000L)
    public void testHistoryUrlConf() throws Exception {
        Configuration conf = this.schedulerHandler.appContext.getAMConf();
        conf.set("tez.tez-ui.history-url.base", "http://ui-host:9999");
        Assert.assertTrue((boolean)"".equals(this.schedulerHandler.getHistoryUrl()));
        conf.set("tez.history.logging.service.class", "org.apache.tez.dag.history.logging.ats.ATSHistoryLoggingService");
        ApplicationId mockApplicationId = (ApplicationId)Mockito.mock(ApplicationId.class);
        ((ApplicationId)Mockito.doReturn((Object)"TEST_APP_ID").when((Object)mockApplicationId)).toString();
        ((AppContext)Mockito.doReturn((Object)mockApplicationId).when((Object)this.mockAppContext)).getApplicationID();
        Assert.assertTrue((boolean)"http://ui-host:9999/#/tez-app/TEST_APP_ID".equals(this.schedulerHandler.getHistoryUrl()));
        conf.set("tez.tez-ui.history-url.base", "http://ui-host:9998/");
        Assert.assertTrue((boolean)"http://ui-host:9998/#/tez-app/TEST_APP_ID".equals(this.schedulerHandler.getHistoryUrl()));
        conf.set("tez.tez-ui.history-url.base", "ui-host:9998/");
        Assert.assertTrue((boolean)"http://ui-host:9998/#/tez-app/TEST_APP_ID".equals(this.schedulerHandler.getHistoryUrl()));
        conf.set("tez.am.tez-ui.history-url.template", "__HISTORY_URL_BASE__#/somepath");
        Assert.assertTrue((boolean)"http://ui-host:9998/#/somepath".equals(this.schedulerHandler.getHistoryUrl()));
        conf.set("tez.am.tez-ui.history-url.template", "__HISTORY_URL_BASE__?viewPath=tez-app/__APPLICATION_ID__");
        conf.set("tez.tez-ui.history-url.base", "http://localhost/ui/tez");
        Assert.assertTrue((boolean)"http://localhost/ui/tez?viewPath=tez-app/TEST_APP_ID".equals(this.schedulerHandler.getHistoryUrl()));
    }

    class MockTaskSchedulerEventHandler
    extends TaskSchedulerEventHandler {
        AtomicBoolean notify;

        public MockTaskSchedulerEventHandler(AppContext appContext, DAGClientServer clientService, EventHandler eventHandler, ContainerSignatureMatcher containerSignatureMatcher, WebUIService webUI) {
            super(appContext, clientService, eventHandler, containerSignatureMatcher, webUI);
            this.notify = new AtomicBoolean(false);
        }

        protected TaskSchedulerService createTaskScheduler(String host, int port, String trackingUrl, AppContext appContext) {
            return TestTaskSchedulerEventHandler.this.mockTaskScheduler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void notifyForTest() {
            AtomicBoolean atomicBoolean = this.notify;
            synchronized (atomicBoolean) {
                this.notify.set(true);
                this.notify.notifyAll();
            }
        }
    }

    class TestEventHandler
    implements EventHandler {
        List<Event> events = Lists.newLinkedList();

        TestEventHandler() {
        }

        public void handle(Event event) {
            this.events.add(event);
        }
    }
}

