/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm;

import com.google.common.collect.Sets;
import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.util.RackResolver;
import org.apache.tez.common.MockDNSToSwitchMapping;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.DAGAppMasterState;
import org.apache.tez.dag.app.rm.TaskSchedulerService;
import org.apache.tez.dag.app.rm.TestTaskSchedulerHelpers;
import org.apache.tez.dag.app.rm.TezAMRMClientAsync;
import org.apache.tez.dag.app.rm.YarnTaskSchedulerService;
import org.apache.tez.dag.app.rm.container.ContainerSignatureMatcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestTaskScheduler {
    RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    static ContainerSignatureMatcher containerSignatureMatcher = new TestTaskSchedulerHelpers.AlwaysMatchesContainerMatcher();

    @BeforeClass
    public static void beforeClass() {
        MockDNSToSwitchMapping.initializeMockRackResolver();
    }

    @Test(timeout=10000L)
    public void testTaskSchedulerNoReuse() throws Exception {
        RackResolver.init((Configuration)new YarnConfiguration());
        TaskSchedulerService.TaskSchedulerAppCallback mockApp = (TaskSchedulerService.TaskSchedulerAppCallback)Mockito.mock(TaskSchedulerService.TaskSchedulerAppCallback.class);
        AppContext mockAppContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)mockAppContext.getAMState()).thenReturn((Object)DAGAppMasterState.RUNNING);
        TezAMRMClientAsync mockRMClient = (TezAMRMClientAsync)Mockito.mock(TezAMRMClientAsync.class);
        String appHost = "host";
        int appPort = 0;
        String appUrl = "url";
        TestTaskSchedulerHelpers.TaskSchedulerWithDrainableAppCallback scheduler = new TestTaskSchedulerHelpers.TaskSchedulerWithDrainableAppCallback(mockApp, new TestTaskSchedulerHelpers.AlwaysMatchesContainerMatcher(), appHost, appPort, appUrl, (TezAMRMClientAsync<YarnTaskSchedulerService.CookieContainerRequest>)mockRMClient, mockAppContext);
        TestTaskSchedulerHelpers.TaskSchedulerAppCallbackDrainable drainableAppCallback = scheduler.getDrainableAppCallback();
        Configuration conf = new Configuration();
        conf.setBoolean("tez.am.container.reuse.enabled", false);
        int interval = 100;
        conf.setInt("tez.am.am-rm.heartbeat.interval-ms.max", interval);
        scheduler.init(conf);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).init(conf);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).setHeartbeatInterval(interval);
        RegisterApplicationMasterResponse mockRegResponse = (RegisterApplicationMasterResponse)Mockito.mock(RegisterApplicationMasterResponse.class);
        Resource mockMaxResource = (Resource)Mockito.mock(Resource.class);
        Map mockAcls = (Map)Mockito.mock(Map.class);
        Mockito.when((Object)mockRegResponse.getMaximumResourceCapability()).thenReturn((Object)mockMaxResource);
        Mockito.when((Object)mockRegResponse.getApplicationACLs()).thenReturn((Object)mockAcls);
        ByteBuffer mockKey = (ByteBuffer)Mockito.mock(ByteBuffer.class);
        Mockito.when((Object)mockRegResponse.getClientToAMTokenMasterKey()).thenReturn((Object)mockKey);
        Mockito.when((Object)mockRMClient.registerApplicationMaster(Matchers.anyString(), Matchers.anyInt(), Matchers.anyString())).thenReturn((Object)mockRegResponse);
        scheduler.start();
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).start();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).registerApplicationMaster(appHost, appPort, appUrl);
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp)).setApplicationRegistrationData(mockMaxResource, mockAcls, mockKey);
        Mockito.when((Object)mockRMClient.getClusterNodeCount()).thenReturn((Object)5);
        Assert.assertEquals((long)5L, (long)scheduler.getClusterNodeCount());
        Resource mockClusterResource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)mockRMClient.getAvailableResources()).thenReturn((Object)mockClusterResource);
        Assert.assertEquals((Object)mockClusterResource, (Object)mockRMClient.getAvailableResources());
        Object mockTask1 = Mockito.mock(Object.class);
        Object mockCookie1 = Mockito.mock(Object.class);
        Resource mockCapability = (Resource)Mockito.mock(Resource.class);
        String[] hosts = new String[]{"host1", "host5"};
        String[] racks = new String[]{"/default-rack", "/default-rack"};
        Priority mockPriority = (Priority)Mockito.mock(Priority.class);
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(YarnTaskSchedulerService.CookieContainerRequest.class);
        scheduler.allocateTask(mockTask1, mockCapability, hosts, racks, mockPriority, null, mockCookie1);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)1))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)Matchers.any()));
        Assert.assertFalse((boolean)scheduler.deallocateTask(mockTask1, true));
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)0))).containerBeingReleased((ContainerId)Matchers.any(ContainerId.class));
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)1))).removeContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)Matchers.any()));
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Matchers.any());
        Assert.assertFalse((boolean)scheduler.deallocateTask(mockTask1, true));
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)0))).containerBeingReleased((ContainerId)Matchers.any(ContainerId.class));
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)1))).removeContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)Matchers.any()));
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Matchers.any());
        Object mockTask2 = Mockito.mock(Object.class);
        Object mockCookie2 = Mockito.mock(Object.class);
        Object mockTask3 = Mockito.mock(Object.class);
        Object mockCookie3 = Mockito.mock(Object.class);
        scheduler.allocateTask(mockTask1, mockCapability, hosts, racks, mockPriority, null, mockCookie1);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)2))).addContainerRequest((AMRMClient.ContainerRequest)requestCaptor.capture());
        YarnTaskSchedulerService.CookieContainerRequest request1 = (YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.getValue();
        scheduler.allocateTask(mockTask2, mockCapability, hosts, racks, mockPriority, null, mockCookie2);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)3))).addContainerRequest((AMRMClient.ContainerRequest)requestCaptor.capture());
        YarnTaskSchedulerService.CookieContainerRequest request2 = (YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.getValue();
        scheduler.allocateTask(mockTask3, mockCapability, hosts, racks, mockPriority, null, mockCookie3);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)4))).addContainerRequest((AMRMClient.ContainerRequest)requestCaptor.capture());
        YarnTaskSchedulerService.CookieContainerRequest request3 = (YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.getValue();
        ArrayList<Container> containers = new ArrayList<Container>();
        Container mockContainer1 = (Container)Mockito.mock(Container.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockContainer1.getNodeId().getHost()).thenReturn((Object)"host1");
        ContainerId mockCId1 = (ContainerId)Mockito.mock(ContainerId.class);
        Mockito.when((Object)mockContainer1.getId()).thenReturn((Object)mockCId1);
        containers.add(mockContainer1);
        Container mockContainer2 = (Container)Mockito.mock(Container.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockContainer2.getNodeId().getHost()).thenReturn((Object)"host2");
        ContainerId mockCId2 = (ContainerId)Mockito.mock(ContainerId.class);
        Mockito.when((Object)mockContainer2.getId()).thenReturn((Object)mockCId2);
        containers.add(mockContainer2);
        Container mockContainer3 = (Container)Mockito.mock(Container.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockContainer3.getNodeId().getHost()).thenReturn((Object)"host3");
        ContainerId mockCId3 = (ContainerId)Mockito.mock(ContainerId.class);
        Mockito.when((Object)mockContainer3.getId()).thenReturn((Object)mockCId3);
        containers.add(mockContainer3);
        Container mockContainer4 = (Container)Mockito.mock(Container.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockContainer4.getNodeId().getHost()).thenReturn((Object)"host4");
        ContainerId mockCId4 = (ContainerId)Mockito.mock(ContainerId.class);
        Mockito.when((Object)mockContainer4.getId()).thenReturn((Object)mockCId4);
        containers.add(mockContainer4);
        ArrayList<YarnTaskSchedulerService.CookieContainerRequest> hostContainers = new ArrayList<YarnTaskSchedulerService.CookieContainerRequest>();
        hostContainers.add(request1);
        hostContainers.add(request2);
        hostContainers.add(request3);
        ArrayList<YarnTaskSchedulerService.CookieContainerRequest> rackContainers = new ArrayList<YarnTaskSchedulerService.CookieContainerRequest>();
        rackContainers.add(request2);
        rackContainers.add(request3);
        ArrayList<YarnTaskSchedulerService.CookieContainerRequest> anyContainers = new ArrayList<YarnTaskSchedulerService.CookieContainerRequest>();
        anyContainers.add(request3);
        final LinkedList<ArrayList<YarnTaskSchedulerService.CookieContainerRequest>> hostList = new LinkedList<ArrayList<YarnTaskSchedulerService.CookieContainerRequest>>();
        hostList.add(hostContainers);
        final LinkedList<ArrayList<YarnTaskSchedulerService.CookieContainerRequest>> rackList = new LinkedList<ArrayList<YarnTaskSchedulerService.CookieContainerRequest>>();
        rackList.add(rackContainers);
        final LinkedList<ArrayList<YarnTaskSchedulerService.CookieContainerRequest>> anyList = new LinkedList<ArrayList<YarnTaskSchedulerService.CookieContainerRequest>>();
        anyList.add(anyContainers);
        final LinkedList emptyList = new LinkedList();
        Mockito.when((Object)mockRMClient.getMatchingRequests((Priority)Matchers.any(), (String)Matchers.eq((Object)"host1"), (Resource)Matchers.any())).thenAnswer((Answer)new Answer<List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>>>(){

            public List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>> answer(InvocationOnMock invocation) throws Throwable {
                return hostList;
            }
        });
        Mockito.when((Object)mockRMClient.getMatchingRequests((Priority)Matchers.any(), (String)Matchers.eq((Object)"/default-rack"), (Resource)Matchers.any())).thenAnswer((Answer)new Answer<List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>>>(){

            public List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>> answer(InvocationOnMock invocation) throws Throwable {
                return rackList;
            }
        }).thenAnswer((Answer)new Answer<List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>>>(){

            public List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>> answer(InvocationOnMock invocation) throws Throwable {
                return emptyList;
            }
        });
        Mockito.when((Object)mockRMClient.getMatchingRequests((Priority)Matchers.any(), (String)Matchers.eq((Object)"*"), (Resource)Matchers.any())).thenAnswer((Answer)new Answer<List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>>>(){

            public List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>> answer(InvocationOnMock invocation) throws Throwable {
                return anyList;
            }
        }).thenAnswer((Answer)new Answer<List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>>>(){

            public List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>> answer(InvocationOnMock invocation) throws Throwable {
                return emptyList;
            }
        });
        scheduler.onContainersAllocated(containers);
        drainableAppCallback.drain();
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp)).taskAllocated(mockTask1, mockCookie1, mockContainer1);
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp)).taskAllocated(mockTask2, mockCookie2, mockContainer2);
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp)).taskAllocated(mockTask3, mockCookie3, mockContainer3);
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)3))).taskAllocated(Matchers.any(), Matchers.any(), (Container)Matchers.any());
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).removeContainerRequest((AMRMClient.ContainerRequest)request1);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).removeContainerRequest((AMRMClient.ContainerRequest)request2);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).removeContainerRequest((AMRMClient.ContainerRequest)request3);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).releaseAssignedContainer(mockCId4);
        Assert.assertTrue((boolean)scheduler.deallocateTask(mockTask1, true));
        drainableAppCallback.drain();
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp)).containerBeingReleased(mockCId1);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).releaseAssignedContainer(mockCId1);
        Assert.assertEquals((Object)mockTask2, (Object)scheduler.deallocateContainer(mockCId2));
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).releaseAssignedContainer(mockCId2);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)3))).releaseAssignedContainer((ContainerId)Matchers.any());
        ArrayList<ContainerStatus> statuses = new ArrayList<ContainerStatus>();
        ContainerStatus mockStatus1 = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        Mockito.when((Object)mockStatus1.getContainerId()).thenReturn((Object)mockCId1);
        statuses.add(mockStatus1);
        ContainerStatus mockStatus2 = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        Mockito.when((Object)mockStatus2.getContainerId()).thenReturn((Object)mockCId2);
        statuses.add(mockStatus2);
        ContainerStatus mockStatus3 = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        Mockito.when((Object)mockStatus3.getContainerId()).thenReturn((Object)mockCId3);
        statuses.add(mockStatus3);
        ContainerStatus mockStatus4 = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        Mockito.when((Object)mockStatus4.getContainerId()).thenReturn((Object)mockCId4);
        statuses.add(mockStatus4);
        scheduler.onContainersCompleted(statuses);
        drainableAppCallback.drain();
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp)).containerCompleted(mockTask1, mockStatus1);
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp)).containerCompleted(mockTask2, mockStatus2);
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp)).containerCompleted(mockTask3, mockStatus3);
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)3))).containerCompleted(Matchers.any(), (ContainerStatus)Matchers.any());
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)3))).releaseAssignedContainer((ContainerId)Matchers.any());
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)0))).addNodeToBlacklist((NodeId)Matchers.any());
        String badHost = "host6";
        NodeId badNodeId = (NodeId)Mockito.mock(NodeId.class);
        Mockito.when((Object)badNodeId.getHost()).thenReturn((Object)badHost);
        scheduler.blacklistNode(badNodeId);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)1))).addNodeToBlacklist(badNodeId);
        Object mockTask4 = Mockito.mock(Object.class);
        Object mockCookie4 = Mockito.mock(Object.class);
        scheduler.allocateTask(mockTask4, mockCapability, null, null, mockPriority, null, mockCookie4);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)5))).addContainerRequest((AMRMClient.ContainerRequest)requestCaptor.capture());
        YarnTaskSchedulerService.CookieContainerRequest request4 = (YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.getValue();
        anyContainers.clear();
        anyContainers.add(request4);
        Container mockContainer5 = (Container)Mockito.mock(Container.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockContainer5.getNodeId().getHost()).thenReturn((Object)badHost);
        Mockito.when((Object)mockContainer5.getNodeId()).thenReturn((Object)badNodeId);
        ContainerId mockCId5 = (ContainerId)Mockito.mock(ContainerId.class);
        Mockito.when((Object)mockContainer5.getId()).thenReturn((Object)mockCId5);
        containers.clear();
        containers.add(mockContainer5);
        Mockito.when((Object)mockRMClient.getMatchingRequests((Priority)Matchers.any(), (String)Matchers.eq((Object)"*"), (Resource)Matchers.any())).thenAnswer((Answer)new Answer<List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>>>(){

            public List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>> answer(InvocationOnMock invocation) throws Throwable {
                return anyList;
            }
        }).thenAnswer((Answer)new Answer<List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>>>(){

            public List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>> answer(InvocationOnMock invocation) throws Throwable {
                return emptyList;
            }
        });
        scheduler.onContainersAllocated(containers);
        drainableAppCallback.drain();
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)3))).taskAllocated(Matchers.any(), Matchers.any(), (Container)Matchers.any());
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).releaseAssignedContainer(mockCId5);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)4))).releaseAssignedContainer((ContainerId)Matchers.any());
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)6))).addContainerRequest((AMRMClient.ContainerRequest)requestCaptor.capture());
        YarnTaskSchedulerService.CookieContainerRequest request5 = (YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.getValue();
        anyContainers.clear();
        anyContainers.add(request5);
        Container mockContainer6 = (Container)Mockito.mock(Container.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockContainer6.getNodeId().getHost()).thenReturn((Object)"host7");
        ContainerId mockCId6 = (ContainerId)Mockito.mock(ContainerId.class);
        Mockito.when((Object)mockContainer6.getId()).thenReturn((Object)mockCId6);
        containers.clear();
        containers.add(mockContainer6);
        Mockito.when((Object)mockRMClient.getMatchingRequests((Priority)Matchers.any(), (String)Matchers.eq((Object)"*"), (Resource)Matchers.any())).thenAnswer((Answer)new Answer<List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>>>(){

            public List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>> answer(InvocationOnMock invocation) throws Throwable {
                return anyList;
            }
        }).thenAnswer((Answer)new Answer<List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>>>(){

            public List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>> answer(InvocationOnMock invocation) throws Throwable {
                return emptyList;
            }
        });
        scheduler.onContainersAllocated(containers);
        drainableAppCallback.drain();
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)4))).taskAllocated(Matchers.any(), Matchers.any(), (Container)Matchers.any());
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp)).taskAllocated(mockTask4, mockCookie4, mockContainer6);
        Assert.assertTrue((boolean)scheduler.deallocateTask(mockTask4, true));
        drainableAppCallback.drain();
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp)).containerBeingReleased(mockCId6);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).releaseAssignedContainer(mockCId6);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)5))).releaseAssignedContainer((ContainerId)Matchers.any());
        scheduler.unblacklistNode(badNodeId);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)1))).removeNodeFromBlacklist(badNodeId);
        Assert.assertEquals((long)0L, (long)scheduler.blacklistedNodes.size());
        float progress = 0.5f;
        Mockito.when((Object)Float.valueOf(mockApp.getProgress())).thenReturn((Object)Float.valueOf(progress));
        Assert.assertEquals((float)progress, (float)scheduler.getProgress(), (float)0.0f);
        scheduler.allocateTask(mockTask1, mockCapability, hosts, racks, mockPriority, null, mockCookie1);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)7))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)Matchers.any()));
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)6))).removeContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)Matchers.any()));
        scheduler.allocateTask(mockTask1, mockCapability, hosts, racks, mockPriority, null, mockCookie1);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)7))).removeContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)Matchers.any()));
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)8))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)Matchers.any()));
        Assert.assertFalse((boolean)scheduler.deallocateTask(mockTask1, true));
        List mockUpdatedNodes = (List)Mockito.mock(List.class);
        scheduler.onNodesUpdated(mockUpdatedNodes);
        drainableAppCallback.drain();
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp)).nodesUpdated(mockUpdatedNodes);
        Exception mockException = (Exception)Mockito.mock(Exception.class);
        scheduler.onError(mockException);
        drainableAppCallback.drain();
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp)).onError((Throwable)mockException);
        scheduler.onShutdownRequest();
        drainableAppCallback.drain();
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp)).appShutdownRequested();
        String appMsg = "success";
        TaskSchedulerService.TaskSchedulerAppCallback.AppFinalStatus finalStatus = new TaskSchedulerService.TaskSchedulerAppCallback.AppFinalStatus(FinalApplicationStatus.SUCCEEDED, appMsg, appUrl);
        Mockito.when((Object)mockApp.getFinalAppStatus()).thenReturn((Object)finalStatus);
        scheduler.stop();
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).unregisterApplicationMaster(FinalApplicationStatus.SUCCEEDED, appMsg, appUrl);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).stop();
        scheduler.close();
    }

    @Test(timeout=10000L)
    public void testTaskSchedulerWithReuse() throws Exception {
        AtomicBoolean drainNotifier;
        RackResolver.init((Configuration)new YarnConfiguration());
        TaskSchedulerService.TaskSchedulerAppCallback mockApp = (TaskSchedulerService.TaskSchedulerAppCallback)Mockito.mock(TaskSchedulerService.TaskSchedulerAppCallback.class);
        AppContext mockAppContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)mockAppContext.getAMState()).thenReturn((Object)DAGAppMasterState.RUNNING);
        TezAMRMClientAsync mockRMClient = (TezAMRMClientAsync)Mockito.mock(TezAMRMClientAsync.class);
        String appHost = "host";
        int appPort = 0;
        String appUrl = "url";
        TestTaskSchedulerHelpers.TaskSchedulerWithDrainableAppCallback scheduler = new TestTaskSchedulerHelpers.TaskSchedulerWithDrainableAppCallback(mockApp, new TestTaskSchedulerHelpers.AlwaysMatchesContainerMatcher(), appHost, appPort, appUrl, (TezAMRMClientAsync<YarnTaskSchedulerService.CookieContainerRequest>)mockRMClient, mockAppContext);
        final TestTaskSchedulerHelpers.TaskSchedulerAppCallbackDrainable drainableAppCallback = scheduler.getDrainableAppCallback();
        Configuration conf = new Configuration();
        conf.setLong("tez.am.container.reuse.locality.delay-allocation-millis", 0L);
        conf.setLong("tez.am.container.idle.release-timeout-min.millis", 0L);
        conf.setLong("tez.am.container.idle.release-timeout-max.millis", 0L);
        scheduler.init(conf);
        drainableAppCallback.drain();
        RegisterApplicationMasterResponse mockRegResponse = (RegisterApplicationMasterResponse)Mockito.mock(RegisterApplicationMasterResponse.class);
        Resource mockMaxResource = (Resource)Mockito.mock(Resource.class);
        Map mockAcls = (Map)Mockito.mock(Map.class);
        Mockito.when((Object)mockRegResponse.getMaximumResourceCapability()).thenReturn((Object)mockMaxResource);
        Mockito.when((Object)mockRegResponse.getApplicationACLs()).thenReturn((Object)mockAcls);
        Mockito.when((Object)mockRMClient.registerApplicationMaster(Matchers.anyString(), Matchers.anyInt(), Matchers.anyString())).thenReturn((Object)mockRegResponse);
        Resource mockClusterResource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)mockRMClient.getAvailableResources()).thenReturn((Object)mockClusterResource);
        scheduler.start();
        drainableAppCallback.drain();
        Object mockTask1 = Mockito.mock(Object.class);
        Mockito.when((Object)mockTask1.toString()).thenReturn((Object)"task1");
        Object mockCookie1 = Mockito.mock(Object.class);
        Resource mockCapability = (Resource)Mockito.mock(Resource.class);
        String[] hosts = new String[]{"host1", "host5"};
        String[] racks = new String[]{"/default-rack", "/default-rack"};
        final Priority mockPriority1 = Priority.newInstance((int)1);
        final Priority mockPriority2 = Priority.newInstance((int)2);
        final Priority mockPriority3 = Priority.newInstance((int)3);
        final Priority mockPriority4 = Priority.newInstance((int)4);
        final Priority mockPriority5 = Priority.newInstance((int)5);
        Object mockTask2 = Mockito.mock(Object.class);
        Mockito.when((Object)mockTask2.toString()).thenReturn((Object)"task2");
        Object mockCookie2 = Mockito.mock(Object.class);
        Object mockTask3 = Mockito.mock(Object.class);
        Mockito.when((Object)mockTask3.toString()).thenReturn((Object)"task3");
        Object mockCookie3 = Mockito.mock(Object.class);
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(YarnTaskSchedulerService.CookieContainerRequest.class);
        scheduler.allocateTask(mockTask1, mockCapability, hosts, racks, mockPriority1, null, mockCookie1);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)1))).addContainerRequest((AMRMClient.ContainerRequest)requestCaptor.capture());
        YarnTaskSchedulerService.CookieContainerRequest request1 = (YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.getValue();
        scheduler.allocateTask(mockTask2, mockCapability, hosts, racks, mockPriority2, null, mockCookie2);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)2))).addContainerRequest((AMRMClient.ContainerRequest)requestCaptor.capture());
        YarnTaskSchedulerService.CookieContainerRequest request2 = (YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.getValue();
        scheduler.allocateTask(mockTask3, mockCapability, hosts, racks, mockPriority3, null, mockCookie3);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)3))).addContainerRequest((AMRMClient.ContainerRequest)requestCaptor.capture());
        YarnTaskSchedulerService.CookieContainerRequest request3 = (YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.getValue();
        ArrayList<Container> containers = new ArrayList<Container>();
        Container mockContainer4 = (Container)Mockito.mock(Container.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockContainer4.getNodeId().getHost()).thenReturn((Object)"host4");
        Mockito.when((Object)mockContainer4.toString()).thenReturn((Object)"container4");
        Mockito.when((Object)mockContainer4.getPriority()).thenReturn((Object)mockPriority4);
        ContainerId mockCId4 = (ContainerId)Mockito.mock(ContainerId.class);
        Mockito.when((Object)mockContainer4.getId()).thenReturn((Object)mockCId4);
        Mockito.when((Object)mockCId4.toString()).thenReturn((Object)"container4");
        containers.add(mockContainer4);
        Container mockContainer1 = (Container)Mockito.mock(Container.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockContainer1.getNodeId().getHost()).thenReturn((Object)"host1");
        Mockito.when((Object)mockContainer1.getPriority()).thenReturn((Object)mockPriority1);
        Mockito.when((Object)mockContainer1.toString()).thenReturn((Object)"container1");
        ContainerId mockCId1 = (ContainerId)Mockito.mock(ContainerId.class);
        Mockito.when((Object)mockContainer1.getId()).thenReturn((Object)mockCId1);
        Mockito.when((Object)mockCId1.toString()).thenReturn((Object)"container1");
        containers.add(mockContainer1);
        Container mockContainer2 = (Container)Mockito.mock(Container.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockContainer2.getNodeId().getHost()).thenReturn((Object)"host2");
        Mockito.when((Object)mockContainer2.getPriority()).thenReturn((Object)mockPriority2);
        Mockito.when((Object)mockContainer2.toString()).thenReturn((Object)"container2");
        ContainerId mockCId2 = (ContainerId)Mockito.mock(ContainerId.class);
        Mockito.when((Object)mockContainer2.getId()).thenReturn((Object)mockCId2);
        Mockito.when((Object)mockCId2.toString()).thenReturn((Object)"container2");
        containers.add(mockContainer2);
        Container mockContainer3 = (Container)Mockito.mock(Container.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockContainer3.getNodeId().getHost()).thenReturn((Object)"host3");
        Mockito.when((Object)mockContainer3.getPriority()).thenReturn((Object)mockPriority3);
        Mockito.when((Object)mockContainer3.toString()).thenReturn((Object)"container3");
        ContainerId mockCId3 = (ContainerId)Mockito.mock(ContainerId.class);
        Mockito.when((Object)mockContainer3.getId()).thenReturn((Object)mockCId3);
        Mockito.when((Object)mockCId3.toString()).thenReturn((Object)"container3");
        containers.add(mockContainer3);
        ArrayList<YarnTaskSchedulerService.CookieContainerRequest> hostContainers = new ArrayList<YarnTaskSchedulerService.CookieContainerRequest>();
        hostContainers.add(request1);
        ArrayList<YarnTaskSchedulerService.CookieContainerRequest> rackContainers = new ArrayList<YarnTaskSchedulerService.CookieContainerRequest>();
        rackContainers.add(request2);
        ArrayList<YarnTaskSchedulerService.CookieContainerRequest> anyContainers = new ArrayList<YarnTaskSchedulerService.CookieContainerRequest>();
        anyContainers.add(request3);
        final LinkedList<ArrayList<YarnTaskSchedulerService.CookieContainerRequest>> hostList = new LinkedList<ArrayList<YarnTaskSchedulerService.CookieContainerRequest>>();
        hostList.add(hostContainers);
        final LinkedList<ArrayList<YarnTaskSchedulerService.CookieContainerRequest>> rackList = new LinkedList<ArrayList<YarnTaskSchedulerService.CookieContainerRequest>>();
        rackList.add(rackContainers);
        final LinkedList<ArrayList<YarnTaskSchedulerService.CookieContainerRequest>> anyList = new LinkedList<ArrayList<YarnTaskSchedulerService.CookieContainerRequest>>();
        anyList.add(anyContainers);
        final LinkedList emptyList = new LinkedList();
        Mockito.when((Object)mockRMClient.getMatchingRequestsForTopPriority((String)Matchers.eq((Object)"host1"), (Resource)Matchers.any())).thenAnswer((Answer)new Answer<List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>>>(){

            public List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>> answer(InvocationOnMock invocation) throws Throwable {
                return hostList;
            }
        });
        Mockito.when((Object)mockRMClient.getMatchingRequestsForTopPriority((String)Matchers.eq((Object)"/default-rack"), (Resource)Matchers.any())).thenAnswer((Answer)new Answer<List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>>>(){

            public List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>> answer(InvocationOnMock invocation) throws Throwable {
                return rackList;
            }
        }).thenAnswer((Answer)new Answer<List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>>>(){

            public List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>> answer(InvocationOnMock invocation) throws Throwable {
                return emptyList;
            }
        });
        Mockito.when((Object)mockRMClient.getMatchingRequestsForTopPriority((String)Matchers.eq((Object)"*"), (Resource)Matchers.any())).thenAnswer((Answer)new Answer<List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>>>(){

            public List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>> answer(InvocationOnMock invocation) throws Throwable {
                return anyList;
            }
        }).thenAnswer((Answer)new Answer<List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>>>(){

            public List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>> answer(InvocationOnMock invocation) throws Throwable {
                return emptyList;
            }
        });
        Mockito.when((Object)mockRMClient.getTopPriority()).then((Answer)new Answer<Priority>(){

            public Priority answer(InvocationOnMock invocation) throws Throwable {
                int allocations = drainableAppCallback.count.get();
                if (allocations == 0) {
                    return mockPriority1;
                }
                if (allocations == 1) {
                    return mockPriority2;
                }
                if (allocations == 2) {
                    return mockPriority3;
                }
                if (allocations == 3) {
                    return mockPriority4;
                }
                return null;
            }
        });
        scheduler.delayedContainerManager.drainedDelayedContainersForTest = drainNotifier = new AtomicBoolean(false);
        scheduler.onContainersAllocated(containers);
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        drainableAppCallback.drain();
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)3))).taskAllocated(Matchers.any(), Matchers.any(), (Container)Matchers.any());
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp)).taskAllocated(mockTask1, mockCookie1, mockContainer1);
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp)).taskAllocated(mockTask2, mockCookie2, mockContainer2);
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp)).taskAllocated(mockTask3, mockCookie3, mockContainer3);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).removeContainerRequest((AMRMClient.ContainerRequest)request1);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).removeContainerRequest((AMRMClient.ContainerRequest)request2);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).removeContainerRequest((AMRMClient.ContainerRequest)request3);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).releaseAssignedContainer(mockCId4);
        Assert.assertTrue((boolean)scheduler.deallocateTask(mockTask1, true));
        drainableAppCallback.drain();
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp)).containerBeingReleased(mockCId1);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).releaseAssignedContainer(mockCId1);
        Assert.assertEquals((Object)mockTask2, (Object)scheduler.deallocateContainer(mockCId2));
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).releaseAssignedContainer(mockCId2);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)3))).releaseAssignedContainer((ContainerId)Matchers.any());
        ArrayList<ContainerStatus> statuses = new ArrayList<ContainerStatus>();
        ContainerStatus mockStatus1 = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        Mockito.when((Object)mockStatus1.getContainerId()).thenReturn((Object)mockCId1);
        statuses.add(mockStatus1);
        ContainerStatus mockStatus2 = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        Mockito.when((Object)mockStatus2.getContainerId()).thenReturn((Object)mockCId2);
        statuses.add(mockStatus2);
        ContainerStatus mockStatus3 = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        Mockito.when((Object)mockStatus3.getContainerId()).thenReturn((Object)mockCId3);
        statuses.add(mockStatus3);
        ContainerStatus mockStatus4 = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        Mockito.when((Object)mockStatus4.getContainerId()).thenReturn((Object)mockCId4);
        statuses.add(mockStatus4);
        scheduler.onContainersCompleted(statuses);
        drainableAppCallback.drain();
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp)).containerCompleted(mockTask1, mockStatus1);
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp)).containerCompleted(mockTask2, mockStatus2);
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp)).containerCompleted(mockTask3, mockStatus3);
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)3))).containerCompleted(Matchers.any(), (ContainerStatus)Matchers.any());
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)3))).releaseAssignedContainer((ContainerId)Matchers.any());
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)0))).addNodeToBlacklist((NodeId)Matchers.any());
        String badHost = "host6";
        NodeId badNodeId = (NodeId)Mockito.mock(NodeId.class);
        Mockito.when((Object)badNodeId.getHost()).thenReturn((Object)badHost);
        scheduler.blacklistNode(badNodeId);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)1))).addNodeToBlacklist(badNodeId);
        Object mockTask4 = Mockito.mock(Object.class);
        Mockito.when((Object)mockTask4.toString()).thenReturn((Object)"task4");
        Object mockCookie4 = Mockito.mock(Object.class);
        scheduler.allocateTask(mockTask4, mockCapability, null, null, mockPriority4, null, mockCookie4);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)4))).addContainerRequest((AMRMClient.ContainerRequest)requestCaptor.capture());
        YarnTaskSchedulerService.CookieContainerRequest request4 = (YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.getValue();
        anyContainers.clear();
        anyContainers.add(request4);
        Container mockContainer5 = (Container)Mockito.mock(Container.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockContainer5.getNodeId().getHost()).thenReturn((Object)badHost);
        Mockito.when((Object)mockContainer5.getNodeId()).thenReturn((Object)badNodeId);
        ContainerId mockCId5 = (ContainerId)Mockito.mock(ContainerId.class);
        Mockito.when((Object)mockContainer5.toString()).thenReturn((Object)"container5");
        Mockito.when((Object)mockCId5.toString()).thenReturn((Object)"container5");
        Mockito.when((Object)mockContainer5.getId()).thenReturn((Object)mockCId5);
        Mockito.when((Object)mockContainer5.getPriority()).thenReturn((Object)mockPriority4);
        containers.clear();
        containers.add(mockContainer5);
        Mockito.when((Object)mockRMClient.getMatchingRequestsForTopPriority((String)Matchers.eq((Object)"*"), (Resource)Matchers.any())).thenAnswer((Answer)new Answer<List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>>>(){

            public List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>> answer(InvocationOnMock invocation) throws Throwable {
                return anyList;
            }
        }).thenAnswer((Answer)new Answer<List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>>>(){

            public List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>> answer(InvocationOnMock invocation) throws Throwable {
                return emptyList;
            }
        });
        drainNotifier.set(false);
        scheduler.onContainersAllocated(containers);
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        drainableAppCallback.drain();
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)3))).taskAllocated(Matchers.any(), Matchers.any(), (Container)Matchers.any());
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).releaseAssignedContainer(mockCId5);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)4))).releaseAssignedContainer((ContainerId)Matchers.any());
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)5))).addContainerRequest((AMRMClient.ContainerRequest)requestCaptor.capture());
        YarnTaskSchedulerService.CookieContainerRequest request5 = (YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.getValue();
        anyContainers.clear();
        anyContainers.add(request5);
        Container mockContainer6 = (Container)Mockito.mock(Container.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockContainer6.getNodeId().getHost()).thenReturn((Object)"host7");
        ContainerId mockCId6 = (ContainerId)Mockito.mock(ContainerId.class);
        Mockito.when((Object)mockContainer6.getId()).thenReturn((Object)mockCId6);
        Mockito.when((Object)mockContainer6.toString()).thenReturn((Object)"container6");
        Mockito.when((Object)mockCId6.toString()).thenReturn((Object)"container6");
        containers.clear();
        containers.add(mockContainer6);
        Mockito.when((Object)mockRMClient.getMatchingRequestsForTopPriority((String)Matchers.eq((Object)"*"), (Resource)Matchers.any())).thenAnswer((Answer)new Answer<List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>>>(){

            public List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>> answer(InvocationOnMock invocation) throws Throwable {
                return anyList;
            }
        }).thenAnswer((Answer)new Answer<List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>>>(){

            public List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>> answer(InvocationOnMock invocation) throws Throwable {
                return emptyList;
            }
        });
        drainNotifier.set(false);
        scheduler.onContainersAllocated(containers);
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        drainableAppCallback.drain();
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)4))).taskAllocated(Matchers.any(), Matchers.any(), (Container)Matchers.any());
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp)).taskAllocated(mockTask4, mockCookie4, mockContainer6);
        Assert.assertTrue((boolean)scheduler.deallocateTask(mockTask4, true));
        drainableAppCallback.drain();
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp)).containerBeingReleased(mockCId6);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).releaseAssignedContainer(mockCId6);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)5))).releaseAssignedContainer((ContainerId)Matchers.any());
        scheduler.unblacklistNode(badNodeId);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)1))).removeNodeFromBlacklist(badNodeId);
        Assert.assertEquals((long)0L, (long)scheduler.blacklistedNodes.size());
        final AtomicBoolean fudgePriority = new AtomicBoolean(true);
        Mockito.when((Object)mockRMClient.getTopPriority()).then((Answer)new Answer<Priority>(){

            public Priority answer(InvocationOnMock invocation) throws Throwable {
                if (fudgePriority.get()) {
                    return mockPriority4;
                }
                return mockPriority5;
            }
        });
        Object mockTask5 = Mockito.mock(Object.class);
        Mockito.when((Object)mockTask5.toString()).thenReturn((Object)"task5");
        Object mockCookie5 = Mockito.mock(Object.class);
        scheduler.allocateTask(mockTask5, mockCapability, hosts, racks, mockPriority5, null, mockCookie5);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)6))).addContainerRequest((AMRMClient.ContainerRequest)requestCaptor.capture());
        YarnTaskSchedulerService.CookieContainerRequest request6 = (YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.getValue();
        drainableAppCallback.drain();
        containers.clear();
        Container mockContainer7 = (Container)Mockito.mock(Container.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockContainer7.getNodeId().getHost()).thenReturn((Object)"host5");
        ContainerId mockCId7 = (ContainerId)Mockito.mock(ContainerId.class);
        Mockito.when((Object)mockContainer7.toString()).thenReturn((Object)"container7");
        Mockito.when((Object)mockCId7.toString()).thenReturn((Object)"container7");
        Mockito.when((Object)mockContainer7.getId()).thenReturn((Object)mockCId7);
        Mockito.when((Object)mockContainer7.getPriority()).thenReturn((Object)mockPriority5);
        containers.add(mockContainer7);
        Container mockContainer8 = (Container)Mockito.mock(Container.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockContainer8.getNodeId().getHost()).thenReturn((Object)"host5");
        ContainerId mockCId8 = (ContainerId)Mockito.mock(ContainerId.class);
        Mockito.when((Object)mockContainer8.toString()).thenReturn((Object)"container8");
        Mockito.when((Object)mockCId8.toString()).thenReturn((Object)"container8");
        Mockito.when((Object)mockContainer8.getId()).thenReturn((Object)mockCId8);
        Mockito.when((Object)mockContainer8.getPriority()).thenReturn((Object)mockPriority5);
        containers.add(mockContainer8);
        drainNotifier.set(false);
        scheduler.onContainersAllocated(containers);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)5))).releaseAssignedContainer((ContainerId)Matchers.any());
        Object mockTask6 = Mockito.mock(Object.class);
        Mockito.when((Object)mockTask6.toString()).thenReturn((Object)"task6");
        Object mockCookie6 = Mockito.mock(Object.class);
        scheduler.allocateTask(mockTask6, mockCapability, mockCId7, mockPriority5, null, mockCookie6);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)7))).addContainerRequest((AMRMClient.ContainerRequest)requestCaptor.capture());
        YarnTaskSchedulerService.CookieContainerRequest request7 = (YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.getValue();
        hostContainers.clear();
        hostContainers.add(request6);
        hostContainers.add(request7);
        Mockito.when((Object)mockRMClient.getMatchingRequestsForTopPriority((String)Matchers.eq((Object)"host5"), (Resource)Matchers.any())).thenAnswer((Answer)new Answer<List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>>>(){

            public List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>> answer(InvocationOnMock invocation) throws Throwable {
                return hostList;
            }
        });
        fudgePriority.set(false);
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        drainableAppCallback.drain();
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)6))).taskAllocated(Matchers.any(), Matchers.any(), (Container)Matchers.any());
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp)).taskAllocated(mockTask6, mockCookie6, mockContainer7);
        Assert.assertTrue((boolean)scheduler.deallocateTask(mockTask5, true));
        Assert.assertTrue((boolean)scheduler.deallocateTask(mockTask6, true));
        drainableAppCallback.drain();
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp)).containerBeingReleased(mockCId7);
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp)).containerBeingReleased(mockCId8);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).releaseAssignedContainer(mockCId7);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).releaseAssignedContainer(mockCId8);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)7))).releaseAssignedContainer((ContainerId)Matchers.any());
        float progress = 0.5f;
        Mockito.when((Object)Float.valueOf(mockApp.getProgress())).thenReturn((Object)Float.valueOf(progress));
        Assert.assertEquals((float)progress, (float)scheduler.getProgress(), (float)0.0f);
        List mockUpdatedNodes = (List)Mockito.mock(List.class);
        scheduler.onNodesUpdated(mockUpdatedNodes);
        drainableAppCallback.drain();
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp)).nodesUpdated(mockUpdatedNodes);
        Exception mockException = (Exception)Mockito.mock(Exception.class);
        scheduler.onError(mockException);
        drainableAppCallback.drain();
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp)).onError((Throwable)mockException);
        scheduler.onShutdownRequest();
        drainableAppCallback.drain();
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)mockApp)).appShutdownRequested();
        String appMsg = "success";
        TaskSchedulerService.TaskSchedulerAppCallback.AppFinalStatus finalStatus = new TaskSchedulerService.TaskSchedulerAppCallback.AppFinalStatus(FinalApplicationStatus.SUCCEEDED, appMsg, appUrl);
        Mockito.when((Object)mockApp.getFinalAppStatus()).thenReturn((Object)finalStatus);
        scheduler.stop();
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).unregisterApplicationMaster(FinalApplicationStatus.SUCCEEDED, appMsg, appUrl);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).stop();
        scheduler.close();
    }

    @Test(timeout=5000L)
    public void testTaskSchedulerDetermineMinHeldContainers() throws Exception {
        RackResolver.init((Configuration)new YarnConfiguration());
        TaskSchedulerService.TaskSchedulerAppCallback mockApp = (TaskSchedulerService.TaskSchedulerAppCallback)Mockito.mock(TaskSchedulerService.TaskSchedulerAppCallback.class);
        AppContext mockAppContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)mockAppContext.getAMState()).thenReturn((Object)DAGAppMasterState.RUNNING);
        Mockito.when((Object)mockAppContext.isSession()).thenReturn((Object)true);
        TezAMRMClientAsync mockRMClient = (TezAMRMClientAsync)Mockito.mock(TezAMRMClientAsync.class);
        String appHost = "host";
        int appPort = 0;
        String appUrl = "url";
        TestTaskSchedulerHelpers.TaskSchedulerWithDrainableAppCallback scheduler = new TestTaskSchedulerHelpers.TaskSchedulerWithDrainableAppCallback(mockApp, new TestTaskSchedulerHelpers.AlwaysMatchesContainerMatcher(), appHost, appPort, appUrl, (TezAMRMClientAsync<YarnTaskSchedulerService.CookieContainerRequest>)mockRMClient, mockAppContext);
        TestTaskSchedulerHelpers.TaskSchedulerAppCallbackDrainable drainableAppCallback = scheduler.getDrainableAppCallback();
        Configuration conf = new Configuration();
        scheduler.init(conf);
        RegisterApplicationMasterResponse mockRegResponse = (RegisterApplicationMasterResponse)Mockito.mock(RegisterApplicationMasterResponse.class);
        Resource mockMaxResource = (Resource)Mockito.mock(Resource.class);
        Map mockAcls = (Map)Mockito.mock(Map.class);
        Mockito.when((Object)mockRegResponse.getMaximumResourceCapability()).thenReturn((Object)mockMaxResource);
        Mockito.when((Object)mockRegResponse.getApplicationACLs()).thenReturn((Object)mockAcls);
        Mockito.when((Object)mockRMClient.registerApplicationMaster(Matchers.anyString(), Matchers.anyInt(), Matchers.anyString())).thenReturn((Object)mockRegResponse);
        Resource mockClusterResource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)mockRMClient.getAvailableResources()).thenReturn((Object)mockClusterResource);
        scheduler.start();
        String rack1 = "r1";
        String rack2 = "r2";
        String rack3 = "r3";
        String node1Rack1 = "n1r1";
        String node2Rack1 = "n2r1";
        String node1Rack2 = "n1r2";
        String node2Rack2 = "n2r2";
        String node1Rack3 = "n1r3";
        ApplicationAttemptId appId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)0), (int)0);
        Resource r = Resource.newInstance((int)0, (int)0);
        ContainerId mockCId1 = ContainerId.newInstance((ApplicationAttemptId)appId, (int)0);
        Container c1 = (Container)Mockito.mock(Container.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)c1.getNodeId().getHost()).thenReturn((Object)"");
        YarnTaskSchedulerService.HeldContainer hc1 = (YarnTaskSchedulerService.HeldContainer)Mockito.spy((Object)new YarnTaskSchedulerService.HeldContainer(c1, 0L, 0L, null, containerSignatureMatcher));
        Mockito.when((Object)hc1.getNode()).thenReturn((Object)node1Rack1);
        Mockito.when((Object)hc1.getRack()).thenReturn((Object)rack1);
        Mockito.when((Object)c1.getId()).thenReturn((Object)mockCId1);
        Mockito.when((Object)c1.getResource()).thenReturn((Object)r);
        Mockito.when((Object)hc1.getContainer()).thenReturn((Object)c1);
        ContainerId mockCId2 = ContainerId.newInstance((ApplicationAttemptId)appId, (int)1);
        Container c2 = (Container)Mockito.mock(Container.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)c2.getNodeId().getHost()).thenReturn((Object)"");
        YarnTaskSchedulerService.HeldContainer hc2 = (YarnTaskSchedulerService.HeldContainer)Mockito.spy((Object)new YarnTaskSchedulerService.HeldContainer(c2, 0L, 0L, null, containerSignatureMatcher));
        Mockito.when((Object)hc2.getNode()).thenReturn((Object)node2Rack1);
        Mockito.when((Object)hc2.getRack()).thenReturn((Object)rack1);
        Mockito.when((Object)c2.getId()).thenReturn((Object)mockCId2);
        Mockito.when((Object)c2.getResource()).thenReturn((Object)r);
        Mockito.when((Object)hc2.getContainer()).thenReturn((Object)c2);
        ContainerId mockCId3 = ContainerId.newInstance((ApplicationAttemptId)appId, (int)2);
        Container c3 = (Container)Mockito.mock(Container.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)c3.getNodeId().getHost()).thenReturn((Object)"");
        YarnTaskSchedulerService.HeldContainer hc3 = (YarnTaskSchedulerService.HeldContainer)Mockito.spy((Object)new YarnTaskSchedulerService.HeldContainer(c3, 0L, 0L, null, containerSignatureMatcher));
        Mockito.when((Object)hc3.getNode()).thenReturn((Object)node1Rack1);
        Mockito.when((Object)hc3.getRack()).thenReturn((Object)rack1);
        Mockito.when((Object)c3.getId()).thenReturn((Object)mockCId3);
        Mockito.when((Object)c3.getResource()).thenReturn((Object)r);
        Mockito.when((Object)hc3.getContainer()).thenReturn((Object)c3);
        ContainerId mockCId4 = ContainerId.newInstance((ApplicationAttemptId)appId, (int)3);
        Container c4 = (Container)Mockito.mock(Container.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)c4.getNodeId().getHost()).thenReturn((Object)"");
        YarnTaskSchedulerService.HeldContainer hc4 = (YarnTaskSchedulerService.HeldContainer)Mockito.spy((Object)new YarnTaskSchedulerService.HeldContainer(c4, 0L, 0L, null, containerSignatureMatcher));
        Mockito.when((Object)hc4.getNode()).thenReturn((Object)node2Rack1);
        Mockito.when((Object)hc4.getRack()).thenReturn((Object)rack1);
        Mockito.when((Object)c4.getId()).thenReturn((Object)mockCId4);
        Mockito.when((Object)c4.getResource()).thenReturn((Object)r);
        Mockito.when((Object)hc4.getContainer()).thenReturn((Object)c4);
        ContainerId mockCId5 = ContainerId.newInstance((ApplicationAttemptId)appId, (int)4);
        Container c5 = (Container)Mockito.mock(Container.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)c5.getNodeId().getHost()).thenReturn((Object)"");
        YarnTaskSchedulerService.HeldContainer hc5 = (YarnTaskSchedulerService.HeldContainer)Mockito.spy((Object)new YarnTaskSchedulerService.HeldContainer(c5, 0L, 0L, null, containerSignatureMatcher));
        Mockito.when((Object)hc5.getNode()).thenReturn((Object)node1Rack2);
        Mockito.when((Object)hc5.getRack()).thenReturn((Object)rack2);
        Mockito.when((Object)c5.getId()).thenReturn((Object)mockCId5);
        Mockito.when((Object)c5.getResource()).thenReturn((Object)r);
        Mockito.when((Object)hc5.getContainer()).thenReturn((Object)c5);
        ContainerId mockCId6 = ContainerId.newInstance((ApplicationAttemptId)appId, (int)5);
        Container c6 = (Container)Mockito.mock(Container.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)c6.getNodeId().getHost()).thenReturn((Object)"");
        YarnTaskSchedulerService.HeldContainer hc6 = (YarnTaskSchedulerService.HeldContainer)Mockito.spy((Object)new YarnTaskSchedulerService.HeldContainer(c6, 0L, 0L, null, containerSignatureMatcher));
        Mockito.when((Object)hc6.getNode()).thenReturn((Object)node2Rack2);
        Mockito.when((Object)hc6.getRack()).thenReturn((Object)rack2);
        Mockito.when((Object)c6.getId()).thenReturn((Object)mockCId6);
        Mockito.when((Object)c6.getResource()).thenReturn((Object)r);
        Mockito.when((Object)hc6.getContainer()).thenReturn((Object)c6);
        ContainerId mockCId7 = ContainerId.newInstance((ApplicationAttemptId)appId, (int)6);
        Container c7 = (Container)Mockito.mock(Container.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)c7.getNodeId().getHost()).thenReturn((Object)"");
        YarnTaskSchedulerService.HeldContainer hc7 = (YarnTaskSchedulerService.HeldContainer)Mockito.spy((Object)new YarnTaskSchedulerService.HeldContainer(c7, 0L, 0L, null, containerSignatureMatcher));
        Mockito.when((Object)hc7.getNode()).thenReturn((Object)node1Rack3);
        Mockito.when((Object)hc7.getRack()).thenReturn((Object)rack3);
        Mockito.when((Object)c7.getId()).thenReturn((Object)mockCId7);
        Mockito.when((Object)c7.getResource()).thenReturn((Object)r);
        Mockito.when((Object)hc7.getContainer()).thenReturn((Object)c7);
        scheduler.heldContainers.put(mockCId1, hc1);
        scheduler.heldContainers.put(mockCId2, hc2);
        scheduler.heldContainers.put(mockCId3, hc3);
        scheduler.heldContainers.put(mockCId4, hc4);
        scheduler.heldContainers.put(mockCId5, hc5);
        scheduler.heldContainers.put(mockCId6, hc6);
        scheduler.heldContainers.put(mockCId7, hc7);
        scheduler.sessionNumMinHeldContainers = 0;
        scheduler.determineMinHeldContainers();
        Assert.assertEquals((long)0L, (long)scheduler.sessionMinHeldContainers.size());
        scheduler.sessionNumMinHeldContainers = 7;
        scheduler.determineMinHeldContainers();
        Assert.assertEquals((long)7L, (long)scheduler.sessionMinHeldContainers.size());
        scheduler.sessionNumMinHeldContainers = 5;
        scheduler.determineMinHeldContainers();
        Assert.assertEquals((long)5L, (long)scheduler.sessionMinHeldContainers.size());
        HashSet heldContainers = Sets.newHashSet();
        for (ContainerId cId : scheduler.sessionMinHeldContainers) {
            heldContainers.add(scheduler.heldContainers.get(cId));
        }
        HashSet racks = Sets.newHashSet();
        HashSet nodes = Sets.newHashSet();
        for (YarnTaskSchedulerService.HeldContainer hc : heldContainers) {
            nodes.add(hc.getNode());
            racks.add(hc.getRack());
        }
        Assert.assertEquals((long)5L, (long)nodes.size());
        Assert.assertTrue((nodes.contains(node1Rack1) && nodes.contains(node2Rack1) && nodes.contains(node1Rack2) && nodes.contains(node2Rack2) && nodes.contains(node1Rack3) ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)racks.size());
        Assert.assertTrue((racks.contains(rack1) && racks.contains(rack2) && racks.contains(rack3) ? 1 : 0) != 0);
        long currTime = System.currentTimeMillis();
        heldContainers.clear();
        heldContainers.addAll(scheduler.heldContainers.values());
        for (YarnTaskSchedulerService.HeldContainer hc : heldContainers) {
            Mockito.when((Object)hc.isNew()).thenReturn((Object)true);
            scheduler.delayedContainerManager.addDelayedContainer(hc.getContainer(), currTime);
        }
        Thread.sleep(1000L);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)2))).releaseAssignedContainer((ContainerId)Matchers.any());
        Assert.assertEquals((long)5L, (long)scheduler.heldContainers.size());
        String appMsg = "success";
        TaskSchedulerService.TaskSchedulerAppCallback.AppFinalStatus finalStatus = new TaskSchedulerService.TaskSchedulerAppCallback.AppFinalStatus(FinalApplicationStatus.SUCCEEDED, appMsg, appUrl);
        Mockito.when((Object)mockApp.getFinalAppStatus()).thenReturn((Object)finalStatus);
        scheduler.stop();
        scheduler.close();
    }

    @Test(timeout=5000L)
    public void testTaskSchedulerRandomReuseExpireTime() throws Exception {
        RackResolver.init((Configuration)new YarnConfiguration());
        TaskSchedulerService.TaskSchedulerAppCallback mockApp = (TaskSchedulerService.TaskSchedulerAppCallback)Mockito.mock(TaskSchedulerService.TaskSchedulerAppCallback.class);
        AppContext mockAppContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)mockAppContext.getAMState()).thenReturn((Object)DAGAppMasterState.RUNNING);
        TezAMRMClientAsync mockRMClient = (TezAMRMClientAsync)Mockito.mock(TezAMRMClientAsync.class);
        String appHost = "host";
        int appPort = 0;
        String appUrl = "url";
        TestTaskSchedulerHelpers.TaskSchedulerWithDrainableAppCallback scheduler1 = new TestTaskSchedulerHelpers.TaskSchedulerWithDrainableAppCallback(mockApp, new TestTaskSchedulerHelpers.AlwaysMatchesContainerMatcher(), appHost, appPort, appUrl, (TezAMRMClientAsync<YarnTaskSchedulerService.CookieContainerRequest>)mockRMClient, mockAppContext);
        TestTaskSchedulerHelpers.TaskSchedulerWithDrainableAppCallback scheduler2 = new TestTaskSchedulerHelpers.TaskSchedulerWithDrainableAppCallback(mockApp, new TestTaskSchedulerHelpers.AlwaysMatchesContainerMatcher(), appHost, appPort, appUrl, (TezAMRMClientAsync<YarnTaskSchedulerService.CookieContainerRequest>)mockRMClient, mockAppContext);
        long minTime = 1000L;
        long maxTime = 100000L;
        Configuration conf1 = new Configuration();
        conf1.setLong("tez.am.container.idle.release-timeout-min.millis", minTime);
        conf1.setLong("tez.am.container.idle.release-timeout-max.millis", minTime);
        scheduler1.init(conf1);
        Configuration conf2 = new Configuration();
        conf2.setLong("tez.am.container.idle.release-timeout-min.millis", minTime);
        conf2.setLong("tez.am.container.idle.release-timeout-max.millis", maxTime);
        scheduler2.init(conf2);
        RegisterApplicationMasterResponse mockRegResponse = (RegisterApplicationMasterResponse)Mockito.mock(RegisterApplicationMasterResponse.class);
        Resource mockMaxResource = (Resource)Mockito.mock(Resource.class);
        Map mockAcls = (Map)Mockito.mock(Map.class);
        Mockito.when((Object)mockRegResponse.getMaximumResourceCapability()).thenReturn((Object)mockMaxResource);
        Mockito.when((Object)mockRegResponse.getApplicationACLs()).thenReturn((Object)mockAcls);
        Mockito.when((Object)mockRMClient.registerApplicationMaster(Matchers.anyString(), Matchers.anyInt(), Matchers.anyString())).thenReturn((Object)mockRegResponse);
        Resource mockClusterResource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)mockRMClient.getAvailableResources()).thenReturn((Object)mockClusterResource);
        scheduler1.start();
        scheduler2.start();
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)minTime, (long)scheduler1.getHeldContainerExpireTime(0L));
        }
        long lastExpireTime = 0L;
        for (int i = 0; i < 10; ++i) {
            long currExpireTime = scheduler2.getHeldContainerExpireTime(0L);
            Assert.assertTrue((String)("min: " + minTime + " curr: " + currExpireTime + " max: " + maxTime), (minTime <= currExpireTime && currExpireTime <= maxTime ? 1 : 0) != 0);
            Assert.assertNotEquals((long)lastExpireTime, (long)currExpireTime);
            lastExpireTime = currExpireTime;
        }
        String appMsg = "success";
        TaskSchedulerService.TaskSchedulerAppCallback.AppFinalStatus finalStatus = new TaskSchedulerService.TaskSchedulerAppCallback.AppFinalStatus(FinalApplicationStatus.SUCCEEDED, appMsg, appUrl);
        Mockito.when((Object)mockApp.getFinalAppStatus()).thenReturn((Object)finalStatus);
        scheduler1.stop();
        scheduler1.close();
        scheduler2.stop();
        scheduler2.close();
    }

    @Test(timeout=5000L)
    public void testTaskSchedulerPreemption() throws Exception {
        RackResolver.init((Configuration)new YarnConfiguration());
        TaskSchedulerService.TaskSchedulerAppCallback mockApp = (TaskSchedulerService.TaskSchedulerAppCallback)Mockito.mock(TaskSchedulerService.TaskSchedulerAppCallback.class);
        AppContext mockAppContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)mockAppContext.getAMState()).thenReturn((Object)DAGAppMasterState.RUNNING);
        TezAMRMClientAsync mockRMClient = (TezAMRMClientAsync)Mockito.mock(TezAMRMClientAsync.class);
        String appHost = "host";
        int appPort = 0;
        String appUrl = "url";
        final TestTaskSchedulerHelpers.TaskSchedulerWithDrainableAppCallback scheduler = new TestTaskSchedulerHelpers.TaskSchedulerWithDrainableAppCallback(mockApp, new TestTaskSchedulerHelpers.PreemptionMatcher(), appHost, appPort, appUrl, (TezAMRMClientAsync<YarnTaskSchedulerService.CookieContainerRequest>)mockRMClient, mockAppContext);
        TestTaskSchedulerHelpers.TaskSchedulerAppCallbackDrainable drainableAppCallback = scheduler.getDrainableAppCallback();
        Configuration conf = new Configuration();
        conf.setBoolean("tez.am.container.reuse.enabled", false);
        scheduler.init(conf);
        RegisterApplicationMasterResponse mockRegResponse = (RegisterApplicationMasterResponse)Mockito.mock(RegisterApplicationMasterResponse.class);
        Mockito.when((Object)mockRMClient.registerApplicationMaster(Matchers.anyString(), Matchers.anyInt(), Matchers.anyString())).thenReturn((Object)mockRegResponse);
        scheduler.start();
        Resource totalResource = Resource.newInstance((int)4000, (int)4);
        Mockito.when((Object)mockRMClient.getAvailableResources()).thenReturn((Object)totalResource);
        scheduler.getProgress();
        drainableAppCallback.drain();
        Assert.assertEquals((Object)totalResource, (Object)scheduler.getTotalResources());
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Matchers.any());
        Object mockTask1 = Mockito.mock(Object.class);
        Object mockTask2 = Mockito.mock(Object.class);
        Object mockTask3 = Mockito.mock(Object.class);
        Object mockTask3Wait = Mockito.mock(Object.class);
        Object mockTask3Retry = Mockito.mock(Object.class);
        Object mockTask3KillA = Mockito.mock(Object.class);
        Object mockTask3KillB = Mockito.mock(Object.class);
        Object obj3 = new Object();
        Priority pri2 = Priority.newInstance((int)2);
        Priority pri4 = Priority.newInstance((int)4);
        Priority pri5 = Priority.newInstance((int)5);
        Priority pri6 = Priority.newInstance((int)6);
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(YarnTaskSchedulerService.CookieContainerRequest.class);
        final ArrayList<Object> anyContainers = new ArrayList<Object>();
        Resource taskAsk = Resource.newInstance((int)1024, (int)1);
        scheduler.allocateTask(mockTask1, taskAsk, null, null, pri2, null, null);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)1))).addContainerRequest((AMRMClient.ContainerRequest)requestCaptor.capture());
        anyContainers.add(requestCaptor.getValue());
        scheduler.allocateTask(mockTask3, taskAsk, null, null, pri6, obj3, null);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)2))).addContainerRequest((AMRMClient.ContainerRequest)requestCaptor.capture());
        anyContainers.add(requestCaptor.getValue());
        scheduler.allocateTask(mockTask3KillA, taskAsk, null, null, pri6, obj3, null);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)3))).addContainerRequest((AMRMClient.ContainerRequest)requestCaptor.capture());
        anyContainers.add(requestCaptor.getValue());
        scheduler.allocateTask(mockTask3KillB, taskAsk, null, null, pri6, obj3, null);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)4))).addContainerRequest((AMRMClient.ContainerRequest)requestCaptor.capture());
        anyContainers.add(requestCaptor.getValue());
        Resource freeResource = Resource.newInstance((int)500, (int)0);
        Mockito.when((Object)mockRMClient.getAvailableResources()).thenReturn((Object)freeResource);
        scheduler.getProgress();
        drainableAppCallback.drain();
        Assert.assertEquals((Object)totalResource, (Object)scheduler.getTotalResources());
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Matchers.any());
        final LinkedList<ArrayList<Object>> anyList = new LinkedList<ArrayList<Object>>();
        final LinkedList emptyList = new LinkedList();
        anyList.add(anyContainers);
        ArrayList<Container> containers = new ArrayList<Container>();
        Container mockContainer1 = (Container)Mockito.mock(Container.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockContainer1.getNodeId().getHost()).thenReturn((Object)"host1");
        Mockito.when((Object)mockContainer1.getResource()).thenReturn((Object)taskAsk);
        Mockito.when((Object)mockContainer1.getPriority()).thenReturn((Object)pri2);
        ContainerId mockCId1 = (ContainerId)Mockito.mock(ContainerId.class);
        Mockito.when((Object)mockContainer1.getId()).thenReturn((Object)mockCId1);
        containers.add(mockContainer1);
        Container mockContainer2 = (Container)Mockito.mock(Container.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockContainer2.getNodeId().getHost()).thenReturn((Object)"host1");
        Mockito.when((Object)mockContainer2.getResource()).thenReturn((Object)taskAsk);
        Mockito.when((Object)mockContainer2.getPriority()).thenReturn((Object)pri6);
        ContainerId mockCId2 = (ContainerId)Mockito.mock(ContainerId.class);
        Mockito.when((Object)mockContainer2.getId()).thenReturn((Object)mockCId2);
        containers.add(mockContainer2);
        Container mockContainer3A = (Container)Mockito.mock(Container.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockContainer3A.getNodeId().getHost()).thenReturn((Object)"host1");
        Mockito.when((Object)mockContainer3A.getResource()).thenReturn((Object)taskAsk);
        Mockito.when((Object)mockContainer3A.getPriority()).thenReturn((Object)pri6);
        ContainerId mockCId3A = (ContainerId)Mockito.mock(ContainerId.class);
        Mockito.when((Object)mockContainer3A.getId()).thenReturn((Object)mockCId3A);
        containers.add(mockContainer3A);
        Container mockContainer3B = (Container)Mockito.mock(Container.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockContainer3B.getNodeId().getHost()).thenReturn((Object)"host1");
        Mockito.when((Object)mockContainer3B.getResource()).thenReturn((Object)taskAsk);
        Mockito.when((Object)mockContainer3B.getPriority()).thenReturn((Object)pri2);
        ContainerId mockCId3B = (ContainerId)Mockito.mock(ContainerId.class);
        Mockito.when((Object)mockContainer3B.getId()).thenReturn((Object)mockCId3B);
        containers.add(mockContainer3B);
        Mockito.when((Object)mockRMClient.getMatchingRequests((Priority)Matchers.any(), (String)Matchers.eq((Object)"host1"), (Resource)Matchers.any())).thenAnswer((Answer)new Answer<List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>>>(){

            public List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>> answer(InvocationOnMock invocation) throws Throwable {
                return emptyList;
            }
        });
        Mockito.when((Object)mockRMClient.getMatchingRequests((Priority)Matchers.any(), (String)Matchers.eq((Object)"/default-rack"), (Resource)Matchers.any())).thenAnswer((Answer)new Answer<List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>>>(){

            public List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>> answer(InvocationOnMock invocation) throws Throwable {
                return emptyList;
            }
        });
        Mockito.when((Object)mockRMClient.getMatchingRequests((Priority)Matchers.any(), (String)Matchers.eq((Object)"*"), (Resource)Matchers.any())).thenAnswer((Answer)new Answer<List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>>>(){
            int calls = 0;

            public List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>> answer(InvocationOnMock invocation) throws Throwable {
                if (this.calls > 0) {
                    anyContainers.remove(0);
                }
                ++this.calls;
                return anyList;
            }
        });
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                ContainerId cId = (ContainerId)args[0];
                scheduler.deallocateContainer(cId);
                return null;
            }
        }).when((Object)mockApp)).preemptContainer((ContainerId)Matchers.any());
        scheduler.onContainersAllocated(containers);
        drainableAppCallback.drain();
        Assert.assertEquals((long)4L, (long)scheduler.taskAllocations.size());
        Assert.assertEquals((long)4096L, (long)scheduler.allocatedResources.getMemory());
        Assert.assertEquals((Object)mockCId1, (Object)((Container)scheduler.taskAllocations.get(mockTask1)).getId());
        Assert.assertEquals((Object)mockCId2, (Object)((Container)scheduler.taskAllocations.get(mockTask3)).getId());
        Assert.assertEquals((Object)mockCId3A, (Object)((Container)scheduler.taskAllocations.get(mockTask3KillA)).getId());
        Assert.assertEquals((Object)mockCId3B, (Object)((Container)scheduler.taskAllocations.get(mockTask3KillB)).getId());
        scheduler.getProgress();
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Matchers.any());
        Object mockTask3WaitCookie = new Object();
        scheduler.allocateTask(mockTask3Wait, taskAsk, null, null, pri6, obj3, mockTask3WaitCookie);
        scheduler.getProgress();
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Matchers.any());
        Priority pri8 = Priority.newInstance((int)8);
        Container mockContainer4 = (Container)Mockito.mock(Container.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockContainer4.getNodeId().getHost()).thenReturn((Object)"host1");
        Mockito.when((Object)mockContainer4.getResource()).thenReturn((Object)taskAsk);
        Mockito.when((Object)mockContainer4.getPriority()).thenReturn((Object)pri8);
        ContainerId mockCId4 = (ContainerId)Mockito.mock(ContainerId.class);
        Mockito.when((Object)mockContainer4.getId()).thenReturn((Object)mockCId4);
        containers.clear();
        containers.add(mockContainer4);
        YarnTaskSchedulerService.HeldContainer heldContainer = new YarnTaskSchedulerService.HeldContainer(mockContainer4, -1L, -1L, null, containerSignatureMatcher);
        scheduler.delayedContainerManager.delayedContainers.add(heldContainer);
        scheduler.getProgress();
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Matchers.any());
        heldContainer.incrementAssignmentAttempts();
        scheduler.getProgress();
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Matchers.any());
        heldContainer.incrementAssignmentAttempts();
        heldContainer.incrementAssignmentAttempts();
        scheduler.getProgress();
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)1))).releaseAssignedContainer((ContainerId)Matchers.any());
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)1))).releaseAssignedContainer(mockCId4);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)5))).addContainerRequest((AMRMClient.ContainerRequest)requestCaptor.capture());
        YarnTaskSchedulerService.CookieContainerRequest reAdded = (YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.getValue();
        Assert.assertEquals((Object)pri6, (Object)reAdded.getPriority());
        Assert.assertEquals((Object)taskAsk, (Object)reAdded.getCapability());
        Assert.assertEquals((Object)mockTask3WaitCookie, (Object)reAdded.getCookie().getAppCookie());
        scheduler.delayedContainerManager.delayedContainers.clear();
        scheduler.allocateTask(mockTask3Retry, taskAsk, null, null, pri5, obj3, null);
        scheduler.getProgress();
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)1))).releaseAssignedContainer((ContainerId)Matchers.any());
        for (int i = 0; i < 11; ++i) {
            scheduler.allocateTask(mockTask2, taskAsk, null, null, pri4, null, null);
        }
        drainableAppCallback.drain();
        scheduler.getProgress();
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)2))).releaseAssignedContainer((ContainerId)Matchers.any());
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)1))).releaseAssignedContainer(mockCId3B);
        scheduler.getProgress();
        scheduler.getProgress();
        scheduler.getProgress();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)2))).releaseAssignedContainer((ContainerId)Matchers.any());
        scheduler.getProgress();
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)3))).releaseAssignedContainer((ContainerId)Matchers.any());
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)1))).releaseAssignedContainer(mockCId3A);
        TaskSchedulerService.TaskSchedulerAppCallback.AppFinalStatus finalStatus = new TaskSchedulerService.TaskSchedulerAppCallback.AppFinalStatus(FinalApplicationStatus.SUCCEEDED, "", appUrl);
        Mockito.when((Object)mockApp.getFinalAppStatus()).thenReturn((Object)finalStatus);
        scheduler.stop();
        drainableAppCallback.drain();
        scheduler.close();
    }

    @Test(timeout=5000L)
    public void testLocalityMatching() throws Exception {
        RackResolver.init((Configuration)new Configuration());
        TaskSchedulerService.TaskSchedulerAppCallback appClient = (TaskSchedulerService.TaskSchedulerAppCallback)Mockito.mock(TaskSchedulerService.TaskSchedulerAppCallback.class);
        TezAMRMClientAsync amrmClient = (TezAMRMClientAsync)Mockito.mock(TezAMRMClientAsync.class);
        AppContext mockAppContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)mockAppContext.getAMState()).thenReturn((Object)DAGAppMasterState.RUNNING);
        TestTaskSchedulerHelpers.TaskSchedulerWithDrainableAppCallback taskScheduler = new TestTaskSchedulerHelpers.TaskSchedulerWithDrainableAppCallback(appClient, new TestTaskSchedulerHelpers.AlwaysMatchesContainerMatcher(), "host", 0, "", (TezAMRMClientAsync<YarnTaskSchedulerService.CookieContainerRequest>)amrmClient, mockAppContext);
        TestTaskSchedulerHelpers.TaskSchedulerAppCallbackDrainable drainableAppCallback = taskScheduler.getDrainableAppCallback();
        Configuration conf = new Configuration();
        conf.setBoolean("tez.am.container.reuse.enabled", false);
        taskScheduler.init(conf);
        RegisterApplicationMasterResponse mockRegResponse = (RegisterApplicationMasterResponse)Mockito.mock(RegisterApplicationMasterResponse.class);
        Resource mockMaxResource = (Resource)Mockito.mock(Resource.class);
        Map mockAcls = (Map)Mockito.mock(Map.class);
        Mockito.when((Object)mockRegResponse.getMaximumResourceCapability()).thenReturn((Object)mockMaxResource);
        Mockito.when((Object)mockRegResponse.getApplicationACLs()).thenReturn((Object)mockAcls);
        Mockito.when((Object)amrmClient.registerApplicationMaster(Matchers.anyString(), Matchers.anyInt(), Matchers.anyString())).thenReturn((Object)mockRegResponse);
        taskScheduler.start();
        Resource resource = Resource.newInstance((int)1024, (int)1);
        Priority priority = Priority.newInstance((int)1);
        String[] hostsTask1 = new String[]{"host1"};
        String[] hostsTask2 = new String[]{"non-allocated-host"};
        String[] defaultRack = new String[]{"/default-rack"};
        String[] otherRack = new String[]{"/other-rack"};
        Object mockTask1 = Mockito.mock(Object.class);
        YarnTaskSchedulerService.CookieContainerRequest mockCookie1 = (YarnTaskSchedulerService.CookieContainerRequest)Mockito.mock(YarnTaskSchedulerService.CookieContainerRequest.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockCookie1.getCookie().getTask()).thenReturn(mockTask1);
        Object mockTask2 = Mockito.mock(Object.class);
        YarnTaskSchedulerService.CookieContainerRequest mockCookie2 = (YarnTaskSchedulerService.CookieContainerRequest)Mockito.mock(YarnTaskSchedulerService.CookieContainerRequest.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockCookie2.getCookie().getTask()).thenReturn(mockTask2);
        Container containerHost1 = this.createContainer(1, "host1", resource, priority);
        Container containerHost3 = this.createContainer(2, "host3", resource, priority);
        LinkedList<Container> allocatedContainers = new LinkedList<Container>();
        allocatedContainers.add(containerHost3);
        allocatedContainers.add(containerHost1);
        final HashMap<String, AbstractList> matchingMap = new HashMap<String, AbstractList>();
        taskScheduler.allocateTask(mockTask1, resource, hostsTask1, defaultRack, priority, null, mockCookie1);
        drainableAppCallback.drain();
        ArrayList<YarnTaskSchedulerService.CookieContainerRequest> host1List = new ArrayList<YarnTaskSchedulerService.CookieContainerRequest>();
        host1List.add(mockCookie1);
        ArrayList<YarnTaskSchedulerService.CookieContainerRequest> defaultRackList = new ArrayList<YarnTaskSchedulerService.CookieContainerRequest>();
        defaultRackList.add(mockCookie1);
        matchingMap.put(hostsTask1[0], host1List);
        matchingMap.put(defaultRack[0], defaultRackList);
        ArrayList<YarnTaskSchedulerService.CookieContainerRequest> nonAllocatedHostList = new ArrayList<YarnTaskSchedulerService.CookieContainerRequest>();
        nonAllocatedHostList.add(mockCookie2);
        ArrayList<YarnTaskSchedulerService.CookieContainerRequest> otherRackList = new ArrayList<YarnTaskSchedulerService.CookieContainerRequest>();
        otherRackList.add(mockCookie2);
        taskScheduler.allocateTask(mockTask2, resource, hostsTask2, otherRack, priority, null, mockCookie2);
        drainableAppCallback.drain();
        matchingMap.put(hostsTask2[0], nonAllocatedHostList);
        matchingMap.put(otherRack[0], otherRackList);
        LinkedList<YarnTaskSchedulerService.CookieContainerRequest> anyList = new LinkedList<YarnTaskSchedulerService.CookieContainerRequest>();
        anyList.add(mockCookie1);
        anyList.add(mockCookie2);
        matchingMap.put("*", anyList);
        final LinkedList emptyList = new LinkedList();
        Mockito.when((Object)amrmClient.getMatchingRequests((Priority)Matchers.any(), Matchers.anyString(), (Resource)Matchers.any())).thenAnswer((Answer)new Answer<List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>>>(){

            public List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>> answer(InvocationOnMock invocation) throws Throwable {
                String location = (String)invocation.getArguments()[1];
                if (matchingMap.get(location) != null) {
                    YarnTaskSchedulerService.CookieContainerRequest matched = (YarnTaskSchedulerService.CookieContainerRequest)((List)matchingMap.get(location)).get(0);
                    Iterator iter = matchingMap.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry entry = iter.next();
                        if (!((List)entry.getValue()).remove(matched) || ((List)entry.getValue()).size() != 0) continue;
                        iter.remove();
                    }
                    return Collections.singletonList(Collections.singletonList(matched));
                }
                return emptyList;
            }
        });
        taskScheduler.onContainersAllocated(allocatedContainers);
        drainableAppCallback.drain();
        ArgumentCaptor taskCaptor = ArgumentCaptor.forClass(Object.class);
        ArgumentCaptor containerCaptor = ArgumentCaptor.forClass(Container.class);
        ((TaskSchedulerService.TaskSchedulerAppCallback)Mockito.verify((Object)appClient, (VerificationMode)Mockito.times((int)2))).taskAllocated(taskCaptor.capture(), Matchers.any(), (Container)containerCaptor.capture());
        List assignedContainers = containerCaptor.getAllValues();
        int container1Pos = assignedContainers.indexOf(containerHost1);
        Assert.assertTrue((String)("Container: " + containerHost1 + " was not assigned"), (container1Pos != -1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Task 1 was not allocated to containerHost1", (Object)mockTask1, taskCaptor.getAllValues().get(container1Pos));
        int container2Pos = assignedContainers.indexOf(containerHost3);
        Assert.assertTrue((String)("Container: " + containerHost3 + " was not assigned"), (container2Pos != -1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Task 2 was not allocated to containerHost3", (Object)mockTask2, taskCaptor.getAllValues().get(container2Pos));
        TaskSchedulerService.TaskSchedulerAppCallback.AppFinalStatus finalStatus = new TaskSchedulerService.TaskSchedulerAppCallback.AppFinalStatus(FinalApplicationStatus.SUCCEEDED, "", "");
        Mockito.when((Object)appClient.getFinalAppStatus()).thenReturn((Object)finalStatus);
        taskScheduler.close();
    }

    @Test(timeout=5000L)
    public void testScaleDownPercentage() {
        Assert.assertEquals((long)100L, (long)YarnTaskSchedulerService.scaleDownByPreemptionPercentage((int)100, (int)100));
        Assert.assertEquals((long)70L, (long)YarnTaskSchedulerService.scaleDownByPreemptionPercentage((int)100, (int)70));
        Assert.assertEquals((long)50L, (long)YarnTaskSchedulerService.scaleDownByPreemptionPercentage((int)100, (int)50));
        Assert.assertEquals((long)10L, (long)YarnTaskSchedulerService.scaleDownByPreemptionPercentage((int)100, (int)10));
        Assert.assertEquals((long)5L, (long)YarnTaskSchedulerService.scaleDownByPreemptionPercentage((int)100, (int)5));
        Assert.assertEquals((long)1L, (long)YarnTaskSchedulerService.scaleDownByPreemptionPercentage((int)100, (int)1));
        Assert.assertEquals((long)1L, (long)YarnTaskSchedulerService.scaleDownByPreemptionPercentage((int)5, (int)5));
        Assert.assertEquals((long)1L, (long)YarnTaskSchedulerService.scaleDownByPreemptionPercentage((int)1, (int)10));
        Assert.assertEquals((long)1L, (long)YarnTaskSchedulerService.scaleDownByPreemptionPercentage((int)1, (int)70));
        Assert.assertEquals((long)1L, (long)YarnTaskSchedulerService.scaleDownByPreemptionPercentage((int)1, (int)1));
    }

    private Container createContainer(int id, String host, Resource resource, Priority priority) {
        ContainerId containerID = ContainerId.newInstance((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1), (int)id);
        NodeId nodeID = NodeId.newInstance((String)host, (int)0);
        Container container = Container.newInstance((ContainerId)containerID, (NodeId)nodeID, (String)(host + ":0"), (Resource)resource, (Priority)priority, null);
        return container;
    }
}

