/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.DAGAppMaster;
import org.apache.tez.dag.app.RecoveryParser;
import org.apache.tez.dag.app.dag.DAGState;
import org.apache.tez.dag.app.dag.impl.DAGImpl;
import org.apache.tez.dag.app.dag.impl.TestDAGImpl;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.events.DAGCommitStartedEvent;
import org.apache.tez.dag.history.events.DAGFinishedEvent;
import org.apache.tez.dag.history.events.DAGInitializedEvent;
import org.apache.tez.dag.history.events.DAGStartedEvent;
import org.apache.tez.dag.history.events.DAGSubmittedEvent;
import org.apache.tez.dag.history.recovery.RecoveryService;
import org.apache.tez.dag.records.TezDAGID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestRecoveryParser {
    private static String TEST_ROOT_DIR = "target/" + TestRecoveryParser.class.getName() + "-tmpDir";
    private RecoveryParser parser;
    private FileSystem localFS;
    private Configuration conf;
    private Path recoveryPath;
    private DAGAppMaster mockAppMaster;
    private DAGImpl mockDAGImpl;

    @Before
    public void setUp() throws IllegalArgumentException, IOException {
        this.conf = new Configuration();
        this.localFS = FileSystem.getLocal((Configuration)this.conf);
        this.recoveryPath = new Path(TEST_ROOT_DIR + "/recovery");
        this.localFS.delete(new Path(TEST_ROOT_DIR), true);
        this.mockAppMaster = (DAGAppMaster)Mockito.mock(DAGAppMaster.class);
        this.mockAppMaster.dagNames = new HashSet();
        this.mockAppMaster.dagIDs = new HashSet();
        Mockito.when((Object)this.mockAppMaster.getConfig()).thenReturn((Object)new Configuration());
        this.mockDAGImpl = (DAGImpl)Mockito.mock(DAGImpl.class);
        Mockito.when((Object)this.mockAppMaster.createDAG((DAGProtos.DAGPlan)Mockito.any(DAGProtos.DAGPlan.class), (TezDAGID)Mockito.any(TezDAGID.class))).thenReturn((Object)this.mockDAGImpl);
        this.parser = new RecoveryParser(this.mockAppMaster, this.localFS, this.recoveryPath, 3);
    }

    private RecoveryParser.DAGSummaryData createDAGSummaryData(TezDAGID dagId, boolean completed) {
        RecoveryParser.DAGSummaryData data = new RecoveryParser.DAGSummaryData(dagId);
        data.completed = completed;
        return data;
    }

    @Test(timeout=5000L)
    public void testGetLastCompletedDAG() {
        HashMap<TezDAGID, RecoveryParser.DAGSummaryData> summaryDataMap = new HashMap<TezDAGID, RecoveryParser.DAGSummaryData>();
        int lastCompletedDAGId = new Random().nextInt(20) + 1;
        for (int i = 1; i <= lastCompletedDAGId; ++i) {
            ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
            TezDAGID dagId = TezDAGID.getInstance((ApplicationId)appId, (int)i);
            summaryDataMap.put(dagId, this.createDAGSummaryData(dagId, true));
        }
        RecoveryParser.DAGSummaryData lastCompletedDAG = this.parser.getLastCompletedOrInProgressDAG(summaryDataMap);
        Assert.assertEquals((long)lastCompletedDAGId, (long)lastCompletedDAG.dagId.getId());
    }

    @Test(timeout=5000L)
    public void testGetLastInProgressDAG() {
        HashMap<TezDAGID, RecoveryParser.DAGSummaryData> summaryDataMap = new HashMap<TezDAGID, RecoveryParser.DAGSummaryData>();
        int dagNum = 20;
        int lastInProgressDAGId = new Random().nextInt(dagNum) + 1;
        for (int i = 1; i <= dagNum; ++i) {
            ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
            TezDAGID dagId = TezDAGID.getInstance((ApplicationId)appId, (int)i);
            if (i == lastInProgressDAGId) {
                summaryDataMap.put(dagId, this.createDAGSummaryData(dagId, false));
                continue;
            }
            summaryDataMap.put(dagId, this.createDAGSummaryData(dagId, true));
        }
        RecoveryParser.DAGSummaryData lastInProgressDAG = this.parser.getLastCompletedOrInProgressDAG(summaryDataMap);
        Assert.assertEquals((long)lastInProgressDAGId, (long)lastInProgressDAG.dagId.getId());
    }

    @Test(timeout=5000L)
    public void testSkipAllOtherEvents_1() throws IOException {
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)appContext.getCurrentRecoveryDir()).thenReturn((Object)new Path(this.recoveryPath + "/1"));
        Mockito.when((Object)appContext.getClock()).thenReturn((Object)new SystemClock());
        DAGProtos.DAGPlan dagPlan = TestDAGImpl.createTestDAGPlan();
        RecoveryService rService = new RecoveryService(appContext);
        Configuration conf = new Configuration();
        conf.setBoolean("tez.test.recovery.drain_event", true);
        rService.init(conf);
        rService.start();
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGSubmittedEvent(dagID, 1L, dagPlan, ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1), null, "user", new Configuration())));
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGInitializedEvent(dagID, 1L, "user", dagPlan.getName(), null)));
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGCommitStartedEvent(dagID, System.currentTimeMillis())));
        rService.stop();
        Mockito.when((Object)appContext.getCurrentRecoveryDir()).thenReturn((Object)new Path(this.recoveryPath + "/2"));
        rService = new RecoveryService(appContext);
        rService.init(conf);
        rService.start();
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGStartedEvent(dagID, 1L, "user", "dag1")));
        rService.stop();
        RecoveryParser.RecoveredDAGData dagData = this.parser.parseRecoveryData();
        Assert.assertEquals((Object)true, (Object)dagData.nonRecoverable);
        Assert.assertTrue((boolean)dagData.reason.contains("DAG Commit was in progress, not recoverable,"));
        ((DAGAppMaster)Mockito.verify((Object)this.mockAppMaster)).createDAG((DAGProtos.DAGPlan)Mockito.any(DAGProtos.DAGPlan.class), (TezDAGID)Mockito.any(TezDAGID.class));
        ((DAGImpl)Mockito.verify((Object)dagData.recoveredDAG, (VerificationMode)Mockito.never())).restoreFromEvent((HistoryEvent)Mockito.isA(DAGInitializedEvent.class));
        ((DAGImpl)Mockito.verify((Object)dagData.recoveredDAG, (VerificationMode)Mockito.never())).restoreFromEvent((HistoryEvent)Mockito.isA(DAGStartedEvent.class));
    }

    @Test(timeout=5000L)
    public void testSkipAllOtherEvents_2() throws IOException {
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)appContext.getCurrentRecoveryDir()).thenReturn((Object)new Path(this.recoveryPath + "/1"));
        Mockito.when((Object)appContext.getClock()).thenReturn((Object)new SystemClock());
        DAGProtos.DAGPlan dagPlan = TestDAGImpl.createTestDAGPlan();
        RecoveryService rService = new RecoveryService(appContext);
        Configuration conf = new Configuration();
        conf.setBoolean("tez.test.recovery.drain_event", true);
        rService.init(conf);
        rService.start();
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGSubmittedEvent(dagID, 1L, dagPlan, ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1), null, "user", new Configuration())));
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGInitializedEvent(dagID, 1L, "user", dagPlan.getName(), null)));
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGFinishedEvent(dagID, 1L, 2L, DAGState.FAILED, "diag", null, "user", "dag1", null, appAttemptId)));
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGStartedEvent(dagID, 1L, "user", "dag1")));
        rService.stop();
        Mockito.when((Object)appContext.getCurrentRecoveryDir()).thenReturn((Object)new Path(this.recoveryPath + "/2"));
        rService = new RecoveryService(appContext);
        rService.init(conf);
        rService.start();
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGStartedEvent(dagID, 1L, "user", "dag1")));
        rService.stop();
        RecoveryParser.RecoveredDAGData dagData = this.parser.parseRecoveryData();
        Assert.assertEquals((Object)false, (Object)dagData.nonRecoverable);
        Assert.assertEquals((Object)DAGState.FAILED, (Object)dagData.dagState);
        Assert.assertEquals((Object)true, (Object)dagData.isCompleted);
        ((DAGAppMaster)Mockito.verify((Object)this.mockAppMaster)).createDAG((DAGProtos.DAGPlan)Mockito.any(DAGProtos.DAGPlan.class), (TezDAGID)Mockito.any(TezDAGID.class));
        ((DAGImpl)Mockito.verify((Object)dagData.recoveredDAG)).restoreFromEvent((HistoryEvent)Mockito.isA(DAGInitializedEvent.class));
        ((DAGImpl)Mockito.verify((Object)dagData.recoveredDAG)).restoreFromEvent((HistoryEvent)Mockito.isA(DAGFinishedEvent.class));
        ((DAGImpl)Mockito.verify((Object)dagData.recoveredDAG, (VerificationMode)Mockito.never())).restoreFromEvent((HistoryEvent)Mockito.isA(DAGStartedEvent.class));
    }

    @Test(timeout=5000L)
    public void testLastCorruptedRecoveryRecord() throws IOException {
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)appContext.getCurrentRecoveryDir()).thenReturn((Object)new Path(this.recoveryPath + "/1"));
        Mockito.when((Object)appContext.getClock()).thenReturn((Object)new SystemClock());
        DAGProtos.DAGPlan dagPlan = TestDAGImpl.createTestDAGPlan();
        RecoveryService rService = new RecoveryService(appContext);
        Configuration conf = new Configuration();
        conf.setBoolean("tez.test.recovery.drain_event", true);
        rService.init(conf);
        rService.start();
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGSubmittedEvent(dagID, 1L, dagPlan, ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1), null, "user", new Configuration())));
        rService.await();
        ((FSDataOutputStream)rService.outputStreamMap.get(dagID)).writeUTF("INVALID_DATA");
        rService.stop();
        Mockito.when((Object)appContext.getCurrentRecoveryDir()).thenReturn((Object)new Path(this.recoveryPath + "/2"));
        rService = new RecoveryService(appContext);
        rService.init(conf);
        rService.start();
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGInitializedEvent(dagID, 1L, "user", dagPlan.getName(), null)));
        rService.await();
        ((FSDataOutputStream)rService.outputStreamMap.get(dagID)).writeUTF("INVALID_DATA");
        rService.stop();
        RecoveryParser.RecoveredDAGData dagData = this.parser.parseRecoveryData();
        Assert.assertEquals((Object)false, (Object)dagData.isCompleted);
        Assert.assertEquals(null, (Object)dagData.reason);
        Assert.assertEquals((Object)false, (Object)dagData.nonRecoverable);
        ((DAGAppMaster)Mockito.verify((Object)this.mockAppMaster)).createDAG((DAGProtos.DAGPlan)Mockito.any(DAGProtos.DAGPlan.class), (TezDAGID)Mockito.any(TezDAGID.class));
        ((DAGImpl)Mockito.verify((Object)dagData.recoveredDAG)).restoreFromEvent((HistoryEvent)Mockito.isA(DAGInitializedEvent.class));
    }

    @Test(timeout=5000L)
    public void testLastCorruptedSummaryRecord() throws IOException {
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)appContext.getCurrentRecoveryDir()).thenReturn((Object)new Path(this.recoveryPath + "/1"));
        Mockito.when((Object)appContext.getClock()).thenReturn((Object)new SystemClock());
        RecoveryService rService = new RecoveryService(appContext);
        Configuration conf = new Configuration();
        conf.setBoolean("tez.test.recovery.drain_event", true);
        rService.init(conf);
        rService.start();
        DAGProtos.DAGPlan dagPlan = TestDAGImpl.createTestDAGPlan();
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGSubmittedEvent(dagID, 1L, dagPlan, ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1), null, "user", new Configuration())));
        rService.summaryStream.writeChars("INVALID_DATA");
        rService.stop();
        try {
            this.parser.parseRecoveryData();
            Assert.fail();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

