/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.task;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.log4j.Logger;
import org.apache.tez.common.ContainerContext;
import org.apache.tez.common.ContainerTask;
import org.apache.tez.common.TezTaskUmbilicalProtocol;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.api.events.TaskAttemptCompletedEvent;
import org.apache.tez.runtime.api.events.TaskAttemptFailedEvent;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.runtime.api.impl.TezHeartbeatRequest;
import org.apache.tez.runtime.api.impl.TezHeartbeatResponse;
import org.apache.tez.runtime.library.processor.SimpleProcessor;
import org.apache.tez.runtime.task.ContainerReporter;
import org.apache.tez.runtime.task.TaskReporter;
import org.apache.tez.runtime.task.TezTaskRunner;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestTaskExecution {
    private static final Logger LOG = Logger.getLogger(TestTaskExecution.class);
    private static final String HEARTBEAT_EXCEPTION_STRING = "HeartbeatException";
    private static final Configuration defaultConf = new Configuration();
    private static final FileSystem localFs;
    private static final Path workDir;
    private static final ExecutorService taskExecutor;

    @Before
    public void reset() {
        TestProcessor.reset();
    }

    @AfterClass
    public static void shutdown() {
        taskExecutor.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleSuccessfulTask() throws IOException, InterruptedException, TezException, ExecutionException {
        ListeningExecutorService executor = null;
        try {
            ExecutorService rawExecutor = Executors.newFixedThreadPool(1);
            executor = MoreExecutors.listeningDecorator((ExecutorService)rawExecutor);
            ApplicationId appId = ApplicationId.newInstance((long)10000L, (int)1);
            TezTaskUmbilicalForTest umbilical = new TezTaskUmbilicalForTest();
            TaskReporter taskReporter = this.createTaskReporter(appId, umbilical);
            TezTaskRunner taskRunner = this.createTaskRunner(appId, umbilical, taskReporter, executor, TestProcessor.CONF_EMPTY);
            Future<Boolean> taskRunnerFuture = taskExecutor.submit(new TaskRunnerCallable(taskRunner));
            TestProcessor.signal();
            boolean result = taskRunnerFuture.get();
            Assert.assertTrue((boolean)result);
            Assert.assertNull((Object)taskReporter.currentCallable);
            umbilical.verifyTaskSuccessEvent();
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleSuccessfulTasks() throws IOException, InterruptedException, TezException, ExecutionException {
        ListeningExecutorService executor = null;
        try {
            ExecutorService rawExecutor = Executors.newFixedThreadPool(1);
            executor = MoreExecutors.listeningDecorator((ExecutorService)rawExecutor);
            ApplicationId appId = ApplicationId.newInstance((long)10000L, (int)1);
            TezTaskUmbilicalForTest umbilical = new TezTaskUmbilicalForTest();
            TaskReporter taskReporter = this.createTaskReporter(appId, umbilical);
            TezTaskRunner taskRunner = this.createTaskRunner(appId, umbilical, taskReporter, executor, TestProcessor.CONF_EMPTY);
            Future<Boolean> taskRunnerFuture = taskExecutor.submit(new TaskRunnerCallable(taskRunner));
            TestProcessor.signal();
            boolean result = taskRunnerFuture.get();
            Assert.assertTrue((boolean)result);
            Assert.assertNull((Object)taskReporter.currentCallable);
            umbilical.verifyTaskSuccessEvent();
            umbilical.resetTrackedEvents();
            taskRunner = this.createTaskRunner(appId, umbilical, taskReporter, executor, TestProcessor.CONF_EMPTY);
            taskRunnerFuture = taskExecutor.submit(new TaskRunnerCallable(taskRunner));
            TestProcessor.signal();
            result = taskRunnerFuture.get();
            Assert.assertTrue((boolean)result);
            Assert.assertNull((Object)taskReporter.currentCallable);
            umbilical.verifyTaskSuccessEvent();
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailedTask() throws IOException, InterruptedException, TezException {
        ListeningExecutorService executor = null;
        try {
            ExecutorService rawExecutor = Executors.newFixedThreadPool(1);
            executor = MoreExecutors.listeningDecorator((ExecutorService)rawExecutor);
            ApplicationId appId = ApplicationId.newInstance((long)10000L, (int)1);
            TezTaskUmbilicalForTest umbilical = new TezTaskUmbilicalForTest();
            TaskReporter taskReporter = this.createTaskReporter(appId, umbilical);
            TezTaskRunner taskRunner = this.createTaskRunner(appId, umbilical, taskReporter, executor, TestProcessor.CONF_THROW_TEZ_EXCEPTION);
            Future<Boolean> taskRunnerFuture = taskExecutor.submit(new TaskRunnerCallable(taskRunner));
            TestProcessor.awaitStart();
            TestProcessor.signal();
            try {
                taskRunnerFuture.get();
                Assert.fail((String)"Expecting the task to fail");
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                LOG.info((Object)cause.getClass().getName());
                Assert.assertTrue((boolean)(cause instanceof TezException));
            }
            Assert.assertNull((Object)taskReporter.currentCallable);
            umbilical.verifyTaskFailedEvent("Failure while running task:org.apache.tez.dag.api.TezException: TezException");
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailedTask2() throws IOException, InterruptedException, TezException {
        ListeningExecutorService executor = null;
        try {
            ExecutorService rawExecutor = Executors.newFixedThreadPool(1);
            executor = MoreExecutors.listeningDecorator((ExecutorService)rawExecutor);
            ApplicationId appId = ApplicationId.newInstance((long)10000L, (int)1);
            TezTaskUmbilicalForTest umbilical = new TezTaskUmbilicalForTest();
            TaskReporter taskReporter = this.createTaskReporter(appId, umbilical);
            TezTaskRunner taskRunner = this.createTaskRunner(appId, umbilical, taskReporter, executor, "NotExitedProcessor", TestProcessor.CONF_THROW_TEZ_EXCEPTION);
            Future<Boolean> taskRunnerFuture = taskExecutor.submit(new TaskRunnerCallable(taskRunner));
            try {
                taskRunnerFuture.get();
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                LOG.info((Object)cause.getClass().getName());
                Assert.assertTrue((boolean)(cause instanceof TezException));
            }
            Assert.assertNull((Object)taskReporter.currentCallable);
            umbilical.verifyTaskFailedEvent("Failure while running task:org.apache.tez.dag.api.TezUncheckedException: Unable to load class: NotExitedProcessor");
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeartbeatException() throws IOException, InterruptedException, TezException {
        ListeningExecutorService executor = null;
        try {
            ExecutorService rawExecutor = Executors.newFixedThreadPool(1);
            executor = MoreExecutors.listeningDecorator((ExecutorService)rawExecutor);
            ApplicationId appId = ApplicationId.newInstance((long)10000L, (int)1);
            TezTaskUmbilicalForTest umbilical = new TezTaskUmbilicalForTest();
            TaskReporter taskReporter = this.createTaskReporter(appId, umbilical);
            TezTaskRunner taskRunner = this.createTaskRunner(appId, umbilical, taskReporter, executor, TestProcessor.CONF_EMPTY);
            Future<Boolean> taskRunnerFuture = taskExecutor.submit(new TaskRunnerCallable(taskRunner));
            TestProcessor.awaitStart();
            umbilical.signalThrowException();
            umbilical.awaitRegisteredEvent();
            try {
                taskRunnerFuture.get();
                Assert.fail((String)"Expecting the task to fail");
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                Assert.assertTrue((boolean)(cause instanceof IOException));
                Assert.assertTrue((boolean)cause.getMessage().contains(HEARTBEAT_EXCEPTION_STRING));
            }
            TestProcessor.awaitCompletion();
            Assert.assertTrue((boolean)TestProcessor.wasInterrupted());
            Assert.assertNull((Object)taskReporter.currentCallable);
            umbilical.verifyNoCompletionEvents();
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeartbeatShouldDie() throws IOException, InterruptedException, TezException, ExecutionException {
        ListeningExecutorService executor = null;
        try {
            ExecutorService rawExecutor = Executors.newFixedThreadPool(1);
            executor = MoreExecutors.listeningDecorator((ExecutorService)rawExecutor);
            ApplicationId appId = ApplicationId.newInstance((long)10000L, (int)1);
            TezTaskUmbilicalForTest umbilical = new TezTaskUmbilicalForTest();
            TaskReporter taskReporter = this.createTaskReporter(appId, umbilical);
            TezTaskRunner taskRunner = this.createTaskRunner(appId, umbilical, taskReporter, executor, TestProcessor.CONF_EMPTY);
            Future<Boolean> taskRunnerFuture = taskExecutor.submit(new TaskRunnerCallable(taskRunner));
            TestProcessor.awaitStart();
            umbilical.signalSendShouldDie();
            umbilical.awaitRegisteredEvent();
            boolean result = taskRunnerFuture.get();
            Assert.assertFalse((boolean)result);
            TestProcessor.awaitCompletion();
            Assert.assertTrue((boolean)TestProcessor.wasInterrupted());
            Assert.assertNull((Object)taskReporter.currentCallable);
            umbilical.verifyNoCompletionEvents();
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTaskShouldDie() throws InterruptedException, ExecutionException {
        ListeningExecutorService executor = null;
        try {
            ExecutorService rawExecutor = Executors.newFixedThreadPool(1);
            executor = MoreExecutors.listeningDecorator((ExecutorService)rawExecutor);
            ApplicationId appId = ApplicationId.newInstance((long)10000L, (int)1);
            ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
            ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)1);
            TezTaskUmbilicalForTest umbilical = new TezTaskUmbilicalForTest();
            ContainerContext containerContext = new ContainerContext(containerId.toString());
            ContainerReporter containerReporter = new ContainerReporter((TezTaskUmbilicalProtocol)umbilical, containerContext, 100);
            ListenableFuture getTaskFuture = executor.submit((Callable)containerReporter);
            getTaskFuture.get();
            Assert.assertEquals((long)1L, (long)umbilical.getTaskInvocations);
        }
        finally {
            executor.shutdownNow();
        }
    }

    private TaskReporter createTaskReporter(ApplicationId appId, TezTaskUmbilicalForTest umbilical) {
        TaskReporter taskReporter = new TaskReporter((TezTaskUmbilicalProtocol)umbilical, 100L, 1000L, 100, new AtomicLong(0L), this.createContainerId(appId).toString());
        return taskReporter;
    }

    private TezTaskRunner createTaskRunner(ApplicationId appId, TezTaskUmbilicalForTest umbilical, TaskReporter taskReporter, ListeningExecutorService executor, byte[] processorConf) throws IOException {
        return this.createTaskRunner(appId, umbilical, taskReporter, executor, TestProcessor.class.getName(), processorConf);
    }

    private TezTaskRunner createTaskRunner(ApplicationId appId, TezTaskUmbilicalForTest umbilical, TaskReporter taskReporter, ListeningExecutorService executor, String processorClass, byte[] processorConf) throws IOException {
        TezConfiguration tezConf = new TezConfiguration(defaultConf);
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        Path testDir = new Path(workDir, UUID.randomUUID().toString());
        String[] localDirs = new String[]{testDir.toString()};
        TezDAGID dagId = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexId = TezVertexID.getInstance((TezDAGID)dagId, (int)1);
        TezTaskID taskId = TezTaskID.getInstance((TezVertexID)vertexId, (int)1);
        TezTaskAttemptID taskAttemptId = TezTaskAttemptID.getInstance((TezTaskID)taskId, (int)1);
        ProcessorDescriptor processorDescriptor = (ProcessorDescriptor)ProcessorDescriptor.create((String)processorClass).setUserPayload(UserPayload.create((ByteBuffer)ByteBuffer.wrap(processorConf)));
        TaskSpec taskSpec = new TaskSpec(taskAttemptId, "dagName", "vertexName", -1, processorDescriptor, new ArrayList(), new ArrayList(), null);
        TezTaskRunner taskRunner = new TezTaskRunner((Configuration)tezConf, ugi, localDirs, taskSpec, (TezTaskUmbilicalProtocol)umbilical, 1, new HashMap(), (Multimap)HashMultimap.create(), taskReporter, executor, null);
        return taskRunner;
    }

    private ContainerId createContainerId(ApplicationId appId) {
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)1);
        return containerId;
    }

    static {
        taskExecutor = Executors.newFixedThreadPool(1);
        defaultConf.set("fs.defaultFS", "file:///");
        try {
            localFs = FileSystem.getLocal((Configuration)defaultConf);
            Path wd = new Path(System.getProperty("test.build.data", "/tmp"), TestTaskExecution.class.getSimpleName());
            workDir = localFs.makeQualified(wd);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class TezTaskUmbilicalForTest
    implements TezTaskUmbilicalProtocol {
        private static final Logger LOG = Logger.getLogger(TezTaskUmbilicalForTest.class);
        private final List<TezEvent> requestEvents = new LinkedList<TezEvent>();
        private final ReentrantLock umbilicalLock = new ReentrantLock();
        private final Condition eventCondition = this.umbilicalLock.newCondition();
        private boolean pendingEvent = false;
        private boolean eventEnacted = false;
        volatile int getTaskInvocations = 0;
        private boolean shouldThrowException = false;
        private boolean shouldSendDieSignal = false;

        private TezTaskUmbilicalForTest() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void signalThrowException() {
            this.umbilicalLock.lock();
            try {
                this.shouldThrowException = true;
                this.pendingEvent = true;
            }
            finally {
                this.umbilicalLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void signalSendShouldDie() {
            this.umbilicalLock.lock();
            try {
                this.shouldSendDieSignal = true;
                this.pendingEvent = true;
            }
            finally {
                this.umbilicalLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void awaitRegisteredEvent() throws InterruptedException {
            this.umbilicalLock.lock();
            try {
                if (this.eventEnacted) {
                    return;
                }
                LOG.info((Object)"Awaiting event");
                this.eventCondition.await();
            }
            finally {
                this.umbilicalLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetTrackedEvents() {
            this.umbilicalLock.lock();
            try {
                this.requestEvents.clear();
            }
            finally {
                this.umbilicalLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void verifyNoCompletionEvents() {
            this.umbilicalLock.lock();
            try {
                for (TezEvent event : this.requestEvents) {
                    if (event.getEvent() instanceof TaskAttemptFailedEvent) {
                        Assert.fail((String)"Found a TaskAttemptFailedEvent when not expected");
                    }
                    if (!(event.getEvent() instanceof TaskAttemptCompletedEvent)) continue;
                    Assert.fail((String)"Found a TaskAttemptCompletedvent when not expected");
                }
            }
            finally {
                this.umbilicalLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void verifyTaskFailedEvent(String diagnostics) {
            this.umbilicalLock.lock();
            try {
                for (TezEvent event : this.requestEvents) {
                    if (!(event.getEvent() instanceof TaskAttemptFailedEvent)) continue;
                    TaskAttemptFailedEvent failedEvent = (TaskAttemptFailedEvent)event.getEvent();
                    if (failedEvent.getDiagnostics().startsWith(diagnostics)) {
                        return;
                    }
                    Assert.fail((String)"No detailed diagnostics message in TaskAttemptFailedEvent");
                }
                Assert.fail((String)"No TaskAttemptFailedEvents sent over umbilical");
            }
            finally {
                this.umbilicalLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void verifyTaskSuccessEvent() {
            this.umbilicalLock.lock();
            try {
                for (TezEvent event : this.requestEvents) {
                    if (!(event.getEvent() instanceof TaskAttemptCompletedEvent)) continue;
                    return;
                }
                Assert.fail((String)"No TaskAttemptFailedEvents sent over umbilical");
            }
            finally {
                this.umbilicalLock.unlock();
            }
        }

        public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
            return 0L;
        }

        public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
            return null;
        }

        public ContainerTask getTask(ContainerContext containerContext) throws IOException {
            ++this.getTaskInvocations;
            return new ContainerTask(null, true, null, null, false);
        }

        public boolean canCommit(TezTaskAttemptID taskid) throws IOException {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TezHeartbeatResponse heartbeat(TezHeartbeatRequest request) throws IOException, TezException {
            this.umbilicalLock.lock();
            if (request.getEvents() != null) {
                this.requestEvents.addAll(request.getEvents());
            }
            try {
                if (this.shouldThrowException) {
                    LOG.info((Object)"TestUmbilical throwing Exception");
                    throw new IOException(TestTaskExecution.HEARTBEAT_EXCEPTION_STRING);
                }
                TezHeartbeatResponse response = new TezHeartbeatResponse();
                response.setLastRequestId(request.getRequestId());
                if (this.shouldSendDieSignal) {
                    LOG.info((Object)"TestUmbilical returning shouldDie=true");
                    response.setShouldDie();
                }
                TezHeartbeatResponse tezHeartbeatResponse = response;
                return tezHeartbeatResponse;
            }
            finally {
                if (this.pendingEvent) {
                    this.eventEnacted = true;
                    LOG.info((Object)"Signalling Event");
                    this.eventCondition.signal();
                }
                this.umbilicalLock.unlock();
            }
        }
    }

    public static class TestProcessor
    extends SimpleProcessor {
        public static final byte[] CONF_EMPTY = new byte[]{0};
        public static final byte[] CONF_THROW_IO_EXCEPTION = new byte[]{1};
        public static final byte[] CONF_THROW_TEZ_EXCEPTION = new byte[]{2};
        public static final byte[] CONF_SIGNAL_FATAL_AND_THROW = new byte[]{4};
        public static final byte[] CONF_SIGNAL_FATAL_AND_LOOP = new byte[]{8};
        public static final byte[] CONF_SIGNAL_FATAL_AND_COMPLETE = new byte[]{16};
        private static final Logger LOG = Logger.getLogger(TestProcessor.class);
        private static final ReentrantLock processorLock = new ReentrantLock();
        private static final Condition processorCondition = processorLock.newCondition();
        private static final Condition completionCondition = processorLock.newCondition();
        private static final Condition runningCondition = processorLock.newCondition();
        private static boolean completed = false;
        private static boolean running = false;
        private static boolean signalled = false;
        public static boolean receivedInterrupt = false;
        private boolean throwIOException = false;
        private boolean throwTezException = false;
        private boolean signalFatalAndThrow = false;
        private boolean signalFatalAndLoop = false;
        private boolean signalFatalAndComplete = false;

        public TestProcessor(ProcessorContext context) {
            super(context);
        }

        public void initialize() throws Exception {
            this.parseConf(this.getContext().getUserPayload().deepCopyAsArray());
        }

        private void parseConf(byte[] bytes) {
            byte b = bytes[0];
            this.throwIOException = (b & 1) > 1;
            this.throwTezException = (b & 2) > 1;
            this.signalFatalAndThrow = (b & 4) > 1;
            this.signalFatalAndLoop = (b & 8) > 1;
            this.signalFatalAndComplete = (b & 0x10) > 1;
        }

        public static void reset() {
            signalled = false;
            receivedInterrupt = false;
            completed = false;
            running = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void signal() {
            LOG.info((Object)"Signalled");
            processorLock.lock();
            try {
                signalled = true;
                processorCondition.signal();
            }
            finally {
                processorLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void awaitStart() throws InterruptedException {
            LOG.info((Object)"Awaiting Process run");
            processorLock.lock();
            try {
                if (running) {
                    return;
                }
                runningCondition.await();
            }
            finally {
                processorLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void awaitCompletion() throws InterruptedException {
            LOG.info((Object)"Await completion");
            processorLock.lock();
            try {
                if (completed) {
                    return;
                }
                completionCondition.await();
            }
            finally {
                processorLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean wasInterrupted() {
            processorLock.lock();
            try {
                boolean bl = receivedInterrupt;
                return bl;
            }
            finally {
                processorLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws Exception {
            block12: {
                processorLock.lock();
                running = true;
                runningCondition.signal();
                LOG.info((Object)("Signal is: " + signalled));
                if (!signalled) {
                    LOG.info((Object)"Waiting for processor signal");
                    processorCondition.await();
                }
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                LOG.info((Object)"Received processor signal");
                if (this.throwIOException) {
                    throw new IOException();
                }
                if (this.throwTezException) {
                    throw new TezException("TezException");
                }
                if (this.signalFatalAndThrow) {
                    IOException io = new IOException("FATALERROR");
                    this.getContext().fatalError((Throwable)io, "FATALERROR");
                    throw io;
                }
                if (!this.signalFatalAndComplete) break block12;
                IOException io = new IOException("FATALERROR");
                this.getContext().fatalError((Throwable)io, "FATALERROR");
                completed = true;
                completionCondition.signal();
                processorLock.unlock();
                return;
            }
            try {
                try {
                    if (this.signalFatalAndLoop) {
                        IOException io = new IOException("FATALERROR");
                        this.getContext().fatalError((Throwable)io, "FATALERROR");
                        LOG.info((Object)"Waiting for Processor signal again");
                        processorCondition.await();
                        LOG.info((Object)"Received second processor signal");
                    }
                }
                catch (InterruptedException e) {
                    receivedInterrupt = true;
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                completed = true;
                completionCondition.signal();
                processorLock.unlock();
            }
        }
    }

    private static class TaskRunnerCallable
    implements Callable<Boolean> {
        private final TezTaskRunner taskRunner;

        public TaskRunnerCallable(TezTaskRunner taskRunner) {
            this.taskRunner = taskRunner;
        }

        @Override
        public Boolean call() throws Exception {
            return this.taskRunner.run();
        }
    }
}

