/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.utils;

import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.dag.utils.TaskSpecificLaunchCmdOption;
import org.junit.Assert;
import org.junit.Test;

public class TestTaskSpecificLaunchCmdOption {
    static Configuration conf = new Configuration();

    private TaskSpecificLaunchCmdOption getOptions(Configuration conf, String tasks) {
        return this.getOptions(conf, tasks, "dummyOpts");
    }

    private TaskSpecificLaunchCmdOption getOptions(Configuration conf, String tasks, String launchOpts) {
        conf.set("tez.task-specific.launch.cmd-opts.list", tasks);
        conf.set("tez.task-specific.launch.cmd-opts", launchOpts);
        return new TaskSpecificLaunchCmdOption(conf);
    }

    @Test
    public void testTaskSpecificJavaOptions() {
        Random rnd = new Random();
        Configuration conf = new Configuration();
        TaskSpecificLaunchCmdOption option = this.getOptions(conf, "");
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", 0));
        option = this.getOptions(conf, "v[0,1,2]");
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v", 0));
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v", 1));
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v", 2));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v1", rnd.nextInt(Integer.MAX_VALUE)));
        option = this.getOptions(conf, "v[,5]", "dummyOpts");
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v", 5));
        option = this.getOptions(conf, "v 1[1,5]", "dummyOpts");
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v 1", 1));
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v 1", 5));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", rnd.nextInt(Integer.MAX_VALUE)));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("1", rnd.nextInt(Integer.MAX_VALUE)));
        option = this.getOptions(conf, "v 1[1,5], 5 [50,60], m  1[10, 11],", "dummyOpts");
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v 1", 1));
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v 1", 5));
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("m  1", 10));
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("m  1", 11));
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("5", 50));
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("5", 60));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("5", 600));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("m  1", 1));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("1", rnd.nextInt(Integer.MAX_VALUE)));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("", rnd.nextInt(Integer.MAX_VALUE)));
        option = this.getOptions(conf, "v 1[1,5], 5 [50,60],  @#425[10, 11]", "dummyOpts");
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v 1", 1));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("@#425", 10));
        option = this.getOptions(conf, "v[0,1,2];v2[5,6:8]");
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v", 0));
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v", 1));
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v", 2));
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v2", 5));
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v2", 6));
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v2", 7));
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v2", 8));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v5", rnd.nextInt(Integer.MAX_VALUE)));
        option = this.getOptions(conf, "v[1:3,5]");
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v", 1));
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v", 2));
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v", 3));
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v", 5));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v5", rnd.nextInt(Integer.MAX_VALUE)));
        option = this.getOptions(conf, "v[3:1,5]");
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v", 1));
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v", 2));
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v", 3));
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v", 5));
        option = this.getOptions(conf, "v[-1]");
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", 1));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", -1));
        option = this.getOptions(conf, "v[]");
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v", 0));
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v", rnd.nextInt(Integer.MAX_VALUE)));
        option = this.getOptions(conf, "v[,, ,]");
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v", rnd.nextInt(Integer.MAX_VALUE)));
        option = this.getOptions(conf, "v[    ]");
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v", rnd.nextInt(Integer.MAX_VALUE)));
        option = this.getOptions(conf, "v[:,,]");
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", rnd.nextInt(Integer.MAX_VALUE)));
        option = this.getOptions(conf, " v[3:1,4]");
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v", 4));
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v", 1));
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v", 3));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", rnd.nextInt(Integer.MAX_VALUE)));
        option = this.getOptions(conf, " v[1:3,4, 5]");
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v", 4));
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v", 2));
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v", 4));
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v", 1));
        Assert.assertTrue((boolean)option.addTaskSpecificLaunchCmdOption("v", 5));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", rnd.nextInt(Integer.MAX_VALUE)));
        option = this.getOptions(conf, " v[:,,:, 5]");
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", 0));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", 5));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", 1));
        option = this.getOptions(conf, " v[ : ,,]");
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", 0));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", rnd.nextInt(Integer.MAX_VALUE)));
        option = this.getOptions(conf, "v12#fs[0,1,2]");
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v12#fs", 0));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("fs", 0));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("#", 0));
        option = this.getOptions(conf, "v[-3:1,5]");
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", 0));
        option = this.getOptions(conf, " ^&*%[0,1,2]");
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("^&*%", 0));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", 0));
        option = this.getOptions(conf, "^&*%[0,1,2]");
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("^&*%", 0));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", 0));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("^&*%", rnd.nextInt(Integer.MAX_VALUE)));
        option = this.getOptions(conf, "v[-1]");
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", 1));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", -1));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", rnd.nextInt(Integer.MAX_VALUE)));
        option = this.getOptions(conf, " [:, 4:]");
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", 1));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", 4));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("", 0));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", rnd.nextInt(Integer.MAX_VALUE)));
        option = this.getOptions(conf, "v[:,,:]");
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", 1));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", 4));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("", 0));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", rnd.nextInt(Integer.MAX_VALUE)));
        option = this.getOptions(conf, "v[:5,1]");
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", 0));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", 1));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", 2));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", 3));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", 4));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", 5));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", 6));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", rnd.nextInt(Integer.MAX_VALUE)));
        option = this.getOptions(conf, "v[1:,5]");
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", 1));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", 5));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", rnd.nextInt(Integer.MAX_VALUE)));
        option = this.getOptions(conf, "v[:1,5]");
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", 0));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", 1));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", 5));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", -1));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", rnd.nextInt(Integer.MAX_VALUE)));
        option = this.getOptions(conf, " v[1:,4, 5],    [5,4]");
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", 4));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", 1));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", 5));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", 3));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption(" ", 4));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", rnd.nextInt(Integer.MAX_VALUE)));
        option = this.getOptions(conf, " v[-3:1,4]");
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", 4));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", 1));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", 3));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", -3));
        Assert.assertFalse((boolean)option.addTaskSpecificLaunchCmdOption("v", rnd.nextInt(Integer.MAX_VALUE)));
    }

    @Test
    public void testConfigOptions() {
        Configuration conf = new Configuration();
        TaskSpecificLaunchCmdOption taskSpecificLaunchCmdOption = this.getOptions(conf, "", "");
        String optionStr = taskSpecificLaunchCmdOption.getTaskSpecificOption("", "", 0);
        Assert.assertTrue((boolean)optionStr.trim().equals(""));
        taskSpecificLaunchCmdOption = this.getOptions(conf, "", "dir=__VERTEX_NAME__");
        optionStr = taskSpecificLaunchCmdOption.getTaskSpecificOption("", "Map 1", 0);
        Assert.assertTrue((boolean)optionStr.equals("dir=Map1"));
        taskSpecificLaunchCmdOption = this.getOptions(conf, "", "dir=__TASK_INDEX__");
        optionStr = taskSpecificLaunchCmdOption.getTaskSpecificOption("", "Map 1", 0);
        Assert.assertTrue((boolean)optionStr.equals("dir=0"));
        taskSpecificLaunchCmdOption = this.getOptions(conf, "v[1,3,4]", "dir=/tmp/__VERTEX_NAME__/__TASK_INDEX__");
        optionStr = taskSpecificLaunchCmdOption.getTaskSpecificOption("", "v", 1);
        Assert.assertTrue((boolean)optionStr.equals("dir=/tmp/v/1"));
        optionStr = taskSpecificLaunchCmdOption.getTaskSpecificOption("", "v", 3);
        Assert.assertTrue((boolean)optionStr.equals("dir=/tmp/v/3"));
        optionStr = taskSpecificLaunchCmdOption.getTaskSpecificOption("", "v", 4);
        Assert.assertTrue((boolean)optionStr.equals("dir=/tmp/v/4"));
    }
}

