/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.logging.impl;

import java.util.Random;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.api.oldrecords.TaskState;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.dag.DAGState;
import org.apache.tez.dag.app.dag.VertexState;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.events.AMLaunchedEvent;
import org.apache.tez.dag.history.events.AMStartedEvent;
import org.apache.tez.dag.history.events.ContainerLaunchedEvent;
import org.apache.tez.dag.history.events.ContainerStoppedEvent;
import org.apache.tez.dag.history.events.DAGCommitStartedEvent;
import org.apache.tez.dag.history.events.DAGFinishedEvent;
import org.apache.tez.dag.history.events.DAGInitializedEvent;
import org.apache.tez.dag.history.events.DAGStartedEvent;
import org.apache.tez.dag.history.events.DAGSubmittedEvent;
import org.apache.tez.dag.history.events.TaskAttemptFinishedEvent;
import org.apache.tez.dag.history.events.TaskAttemptStartedEvent;
import org.apache.tez.dag.history.events.TaskFinishedEvent;
import org.apache.tez.dag.history.events.TaskStartedEvent;
import org.apache.tez.dag.history.events.VertexCommitStartedEvent;
import org.apache.tez.dag.history.events.VertexFinishedEvent;
import org.apache.tez.dag.history.events.VertexGroupCommitFinishedEvent;
import org.apache.tez.dag.history.events.VertexGroupCommitStartedEvent;
import org.apache.tez.dag.history.events.VertexInitializedEvent;
import org.apache.tez.dag.history.events.VertexParallelismUpdatedEvent;
import org.apache.tez.dag.history.events.VertexRecoverableEventsGeneratedEvent;
import org.apache.tez.dag.history.events.VertexStartedEvent;
import org.apache.tez.dag.history.logging.impl.HistoryEventJsonConversion;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.codehaus.jettison.json.JSONException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestHistoryEventJsonConversion {
    private ApplicationAttemptId applicationAttemptId;
    private ApplicationId applicationId;
    private String user = "user";
    private Random random = new Random();
    private TezDAGID tezDAGID;
    private TezVertexID tezVertexID;
    private TezTaskID tezTaskID;
    private TezTaskAttemptID tezTaskAttemptID;
    private DAGProtos.DAGPlan dagPlan;
    private ContainerId containerId;
    private NodeId nodeId;

    @Before
    public void setup() {
        this.applicationId = ApplicationId.newInstance((long)9999L, (int)1);
        this.applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)this.applicationId, (int)1);
        this.tezDAGID = TezDAGID.getInstance((ApplicationId)this.applicationId, (int)this.random.nextInt());
        this.tezVertexID = TezVertexID.getInstance((TezDAGID)this.tezDAGID, (int)this.random.nextInt());
        this.tezTaskID = TezTaskID.getInstance((TezVertexID)this.tezVertexID, (int)this.random.nextInt());
        this.tezTaskAttemptID = TezTaskAttemptID.getInstance((TezTaskID)this.tezTaskID, (int)this.random.nextInt());
        this.dagPlan = DAGProtos.DAGPlan.newBuilder().setName("DAGPlanMock").build();
        this.containerId = ContainerId.newInstance((ApplicationAttemptId)this.applicationAttemptId, (int)111);
        this.nodeId = NodeId.newInstance((String)"node", (int)13435);
    }

    @Test
    public void testHandlerExists() throws JSONException {
        for (HistoryEventType eventType : HistoryEventType.values()) {
            VertexParallelismUpdatedEvent event = null;
            switch (eventType) {
                case AM_LAUNCHED: {
                    event = new AMLaunchedEvent(this.applicationAttemptId, (long)this.random.nextInt(), (long)this.random.nextInt(), this.user);
                    break;
                }
                case AM_STARTED: {
                    event = new AMStartedEvent(this.applicationAttemptId, (long)this.random.nextInt(), this.user);
                    break;
                }
                case DAG_SUBMITTED: {
                    event = new DAGSubmittedEvent(this.tezDAGID, (long)this.random.nextInt(), this.dagPlan, this.applicationAttemptId, null, this.user);
                    break;
                }
                case DAG_INITIALIZED: {
                    event = new DAGInitializedEvent(this.tezDAGID, (long)this.random.nextInt(), this.user, this.dagPlan.getName());
                    break;
                }
                case DAG_STARTED: {
                    event = new DAGStartedEvent(this.tezDAGID, (long)this.random.nextInt(), this.user, this.dagPlan.getName());
                    break;
                }
                case DAG_FINISHED: {
                    event = new DAGFinishedEvent(this.tezDAGID, (long)this.random.nextInt(), (long)this.random.nextInt(), DAGState.ERROR, null, null, this.user, this.dagPlan.getName());
                    break;
                }
                case VERTEX_INITIALIZED: {
                    event = new VertexInitializedEvent(this.tezVertexID, "v1", (long)this.random.nextInt(), (long)this.random.nextInt(), this.random.nextInt(), "proc", null);
                    break;
                }
                case VERTEX_STARTED: {
                    event = new VertexStartedEvent(this.tezVertexID, (long)this.random.nextInt(), (long)this.random.nextInt());
                    break;
                }
                case VERTEX_PARALLELISM_UPDATED: {
                    event = new VertexParallelismUpdatedEvent();
                    break;
                }
                case VERTEX_FINISHED: {
                    event = new VertexFinishedEvent(this.tezVertexID, "v1", (long)this.random.nextInt(), (long)this.random.nextInt(), (long)this.random.nextInt(), (long)this.random.nextInt(), (long)this.random.nextInt(), VertexState.ERROR, null, null, null, null);
                    break;
                }
                case TASK_STARTED: {
                    event = new TaskStartedEvent(this.tezTaskID, "v1", (long)this.random.nextInt(), (long)this.random.nextInt());
                    break;
                }
                case TASK_FINISHED: {
                    event = new TaskFinishedEvent(this.tezTaskID, "v1", (long)this.random.nextInt(), (long)this.random.nextInt(), this.tezTaskAttemptID, TaskState.FAILED, null, null);
                    break;
                }
                case TASK_ATTEMPT_STARTED: {
                    event = new TaskAttemptStartedEvent(this.tezTaskAttemptID, "v1", (long)this.random.nextInt(), this.containerId, this.nodeId, null, null);
                    break;
                }
                case TASK_ATTEMPT_FINISHED: {
                    event = new TaskAttemptFinishedEvent(this.tezTaskAttemptID, "v1", (long)this.random.nextInt(), (long)this.random.nextInt(), TaskAttemptState.FAILED, null, null);
                    break;
                }
                case CONTAINER_LAUNCHED: {
                    event = new ContainerLaunchedEvent(this.containerId, (long)this.random.nextInt(), this.applicationAttemptId);
                    break;
                }
                case CONTAINER_STOPPED: {
                    event = new ContainerStoppedEvent(this.containerId, (long)this.random.nextInt(), -1, this.applicationAttemptId);
                    break;
                }
                case VERTEX_DATA_MOVEMENT_EVENTS_GENERATED: {
                    event = new VertexRecoverableEventsGeneratedEvent();
                    break;
                }
                case DAG_COMMIT_STARTED: {
                    event = new DAGCommitStartedEvent();
                    break;
                }
                case VERTEX_COMMIT_STARTED: {
                    event = new VertexCommitStartedEvent();
                    break;
                }
                case VERTEX_GROUP_COMMIT_STARTED: {
                    event = new VertexGroupCommitStartedEvent();
                    break;
                }
                case VERTEX_GROUP_COMMIT_FINISHED: {
                    event = new VertexGroupCommitFinishedEvent();
                    break;
                }
                default: {
                    Assert.fail((String)("Unhandled event type " + eventType));
                }
            }
            if (event == null || !event.isHistoryEvent()) continue;
            HistoryEventJsonConversion.convertToJson((HistoryEvent)event);
        }
    }
}

