/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm.node;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.rm.AMSchedulerEventNodeBlacklistUpdate;
import org.apache.tez.dag.app.rm.AMSchedulerEventType;
import org.apache.tez.dag.app.rm.TaskSchedulerEventHandler;
import org.apache.tez.dag.app.rm.container.AMContainerEventNodeFailed;
import org.apache.tez.dag.app.rm.container.AMContainerEventType;
import org.apache.tez.dag.app.rm.container.AMContainerMap;
import org.apache.tez.dag.app.rm.node.AMNodeEvent;
import org.apache.tez.dag.app.rm.node.AMNodeEventContainerAllocated;
import org.apache.tez.dag.app.rm.node.AMNodeEventNodeCountUpdated;
import org.apache.tez.dag.app.rm.node.AMNodeEventStateChanged;
import org.apache.tez.dag.app.rm.node.AMNodeEventTaskAttemptEnded;
import org.apache.tez.dag.app.rm.node.AMNodeEventTaskAttemptSucceeded;
import org.apache.tez.dag.app.rm.node.AMNodeEventType;
import org.apache.tez.dag.app.rm.node.AMNodeImpl;
import org.apache.tez.dag.app.rm.node.AMNodeMap;
import org.apache.tez.dag.app.rm.node.AMNodeState;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAMNodeMap {
    private static final Log LOG = LogFactory.getLog(TestAMNodeMap.class);
    DrainDispatcher dispatcher;
    EventHandler eventHandler;

    @Before
    public void setup() {
        this.dispatcher = new DrainDispatcher();
        this.dispatcher.init(new Configuration());
        this.dispatcher.start();
        this.eventHandler = this.dispatcher.getEventHandler();
    }

    @After
    public void teardown() {
        this.dispatcher.stop();
    }

    @Test(timeout=5000L)
    public void testHealthUpdateKnownNode() {
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        AMNodeMap amNodeMap = new AMNodeMap(this.eventHandler, appContext);
        amNodeMap.init(new Configuration(false));
        amNodeMap.start();
        NodeId nodeId = NodeId.newInstance((String)"host1", (int)2342);
        amNodeMap.nodeSeen(nodeId);
        NodeReport nodeReport = TestAMNodeMap.generateNodeReport(nodeId, NodeState.UNHEALTHY);
        amNodeMap.handle((AMNodeEvent)new AMNodeEventStateChanged(nodeReport));
        this.dispatcher.await();
        Assert.assertEquals((Object)AMNodeState.UNHEALTHY, (Object)amNodeMap.get(nodeId).getState());
        amNodeMap.stop();
    }

    @Test(timeout=5000L)
    public void testHealthUpdateUnknownNode() {
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        AMNodeMap amNodeMap = new AMNodeMap(this.eventHandler, appContext);
        amNodeMap.init(new Configuration(false));
        amNodeMap.start();
        NodeId nodeId = NodeId.newInstance((String)"unknownhost", (int)2342);
        NodeReport nodeReport = TestAMNodeMap.generateNodeReport(nodeId, NodeState.UNHEALTHY);
        amNodeMap.handle((AMNodeEvent)new AMNodeEventStateChanged(nodeReport));
        this.dispatcher.await();
        amNodeMap.stop();
    }

    @Test(timeout=10000L)
    public void testNodeSelfBlacklist() throws InterruptedException {
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        Configuration conf = new Configuration(false);
        conf.setInt("tez.am.maxtaskfailures.per.node", 2);
        TestEventHandler handler = new TestEventHandler();
        AMNodeMap amNodeMap = new AMNodeMap((EventHandler)handler, appContext);
        AMContainerMap amContainerMap = (AMContainerMap)Mockito.mock(AMContainerMap.class);
        TaskSchedulerEventHandler taskSchedulerEventHandler = (TaskSchedulerEventHandler)Mockito.mock(TaskSchedulerEventHandler.class);
        this.dispatcher.register(AMNodeEventType.class, (EventHandler)amNodeMap);
        this.dispatcher.register(AMContainerEventType.class, (EventHandler)amContainerMap);
        this.dispatcher.register(AMSchedulerEventType.class, (EventHandler)taskSchedulerEventHandler);
        amNodeMap.init(conf);
        amNodeMap.start();
        amNodeMap.handle((AMNodeEvent)new AMNodeEventNodeCountUpdated(4));
        NodeId nodeId = NodeId.newInstance((String)"host1", (int)1234);
        NodeId nodeId2 = NodeId.newInstance((String)"host2", (int)1234);
        NodeId nodeId3 = NodeId.newInstance((String)"host3", (int)1234);
        NodeId nodeId4 = NodeId.newInstance((String)"host4", (int)1234);
        amNodeMap.nodeSeen(nodeId);
        amNodeMap.nodeSeen(nodeId2);
        amNodeMap.nodeSeen(nodeId3);
        amNodeMap.nodeSeen(nodeId4);
        AMNodeImpl node = (AMNodeImpl)amNodeMap.get(nodeId);
        ContainerId cId1 = (ContainerId)Mockito.mock(ContainerId.class);
        ContainerId cId2 = (ContainerId)Mockito.mock(ContainerId.class);
        ContainerId cId3 = (ContainerId)Mockito.mock(ContainerId.class);
        amNodeMap.handle((AMNodeEvent)new AMNodeEventContainerAllocated(nodeId, cId1));
        amNodeMap.handle((AMNodeEvent)new AMNodeEventContainerAllocated(nodeId, cId2));
        amNodeMap.handle((AMNodeEvent)new AMNodeEventContainerAllocated(nodeId, cId3));
        Assert.assertEquals((long)3L, (long)node.containers.size());
        TezTaskAttemptID ta1 = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
        TezTaskAttemptID ta2 = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
        TezTaskAttemptID ta3 = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
        amNodeMap.handle((AMNodeEvent)new AMNodeEventTaskAttemptSucceeded(nodeId, cId1, ta1));
        Assert.assertEquals((long)1L, (long)node.numSuccessfulTAs);
        amNodeMap.handle((AMNodeEvent)new AMNodeEventTaskAttemptEnded(nodeId, cId2, ta2, true));
        Assert.assertEquals((long)1L, (long)node.numSuccessfulTAs);
        Assert.assertEquals((long)1L, (long)node.numFailedTAs);
        Assert.assertEquals((Object)AMNodeState.ACTIVE, (Object)node.getState());
        amNodeMap.handle((AMNodeEvent)new AMNodeEventTaskAttemptEnded(nodeId, cId2, ta2, true));
        Assert.assertEquals((long)1L, (long)node.numSuccessfulTAs);
        Assert.assertEquals((long)1L, (long)node.numFailedTAs);
        Assert.assertEquals((Object)AMNodeState.ACTIVE, (Object)node.getState());
        amNodeMap.handle((AMNodeEvent)new AMNodeEventTaskAttemptEnded(nodeId, cId3, ta3, true));
        this.dispatcher.await();
        Assert.assertEquals((long)1L, (long)node.numSuccessfulTAs);
        Assert.assertEquals((long)2L, (long)node.numFailedTAs);
        Assert.assertEquals((Object)AMNodeState.BLACKLISTED, (Object)node.getState());
        Assert.assertEquals((long)5L, (long)handler.events.size());
        Assert.assertEquals((Object)AMContainerEventType.C_NODE_FAILED, (Object)handler.events.get(0).getType());
        Assert.assertEquals((Object)cId1, (Object)((AMContainerEventNodeFailed)handler.events.get(0)).getContainerId());
        Assert.assertEquals((Object)AMContainerEventType.C_NODE_FAILED, (Object)handler.events.get(1).getType());
        Assert.assertEquals((Object)cId2, (Object)((AMContainerEventNodeFailed)handler.events.get(1)).getContainerId());
        Assert.assertEquals((Object)AMContainerEventType.C_NODE_FAILED, (Object)handler.events.get(2).getType());
        Assert.assertEquals((Object)cId3, (Object)((AMContainerEventNodeFailed)handler.events.get(2)).getContainerId());
        Assert.assertEquals((Object)AMSchedulerEventType.S_NODE_BLACKLISTED, (Object)handler.events.get(3).getType());
        Assert.assertEquals((Object)node.getNodeId(), (Object)((AMSchedulerEventNodeBlacklistUpdate)handler.events.get(3)).getNodeId());
        Assert.assertEquals((Object)AMNodeEventType.N_NODE_WAS_BLACKLISTED, (Object)handler.events.get(4).getType());
        Assert.assertEquals((Object)node.getNodeId(), (Object)((AMNodeEvent)handler.events.get(4)).getNodeId());
        ContainerId cId4 = (ContainerId)Mockito.mock(ContainerId.class);
        ContainerId cId5 = (ContainerId)Mockito.mock(ContainerId.class);
        TezTaskAttemptID ta4 = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
        TezTaskAttemptID ta5 = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
        AMNodeImpl node2 = (AMNodeImpl)amNodeMap.get(nodeId2);
        amNodeMap.handle((AMNodeEvent)new AMNodeEventContainerAllocated(nodeId2, cId4));
        amNodeMap.handle((AMNodeEvent)new AMNodeEventContainerAllocated(nodeId2, cId5));
        amNodeMap.handle((AMNodeEvent)new AMNodeEventTaskAttemptEnded(nodeId2, cId4, ta4, true));
        Assert.assertEquals((long)1L, (long)node2.numFailedTAs);
        Assert.assertEquals((Object)AMNodeState.ACTIVE, (Object)node2.getState());
        handler.events.clear();
        amNodeMap.handle((AMNodeEvent)new AMNodeEventTaskAttemptEnded(nodeId2, cId5, ta5, true));
        this.dispatcher.await();
        Assert.assertEquals((long)2L, (long)node2.numFailedTAs);
        Assert.assertEquals((Object)AMNodeState.FORCED_ACTIVE, (Object)node2.getState());
        AMNodeImpl node3 = (AMNodeImpl)amNodeMap.get(nodeId3);
        Assert.assertEquals((Object)AMNodeState.FORCED_ACTIVE, (Object)node3.getState());
        Assert.assertEquals((long)10L, (long)handler.events.size());
        Assert.assertEquals((Object)AMContainerEventType.C_NODE_FAILED, (Object)handler.events.get(0).getType());
        Assert.assertEquals((Object)AMContainerEventType.C_NODE_FAILED, (Object)handler.events.get(1).getType());
        Assert.assertEquals((Object)AMSchedulerEventType.S_NODE_BLACKLISTED, (Object)handler.events.get(2).getType());
        Assert.assertEquals((Object)AMNodeEventType.N_NODE_WAS_BLACKLISTED, (Object)handler.events.get(3).getType());
        Assert.assertEquals((Object)AMNodeEventType.N_IGNORE_BLACKLISTING_ENABLED, (Object)handler.events.get(4).getType());
        Assert.assertEquals((Object)AMNodeEventType.N_IGNORE_BLACKLISTING_ENABLED, (Object)handler.events.get(5).getType());
        Assert.assertEquals((Object)AMNodeEventType.N_IGNORE_BLACKLISTING_ENABLED, (Object)handler.events.get(6).getType());
        Assert.assertEquals((Object)AMNodeEventType.N_IGNORE_BLACKLISTING_ENABLED, (Object)handler.events.get(7).getType());
        Assert.assertEquals((Object)AMSchedulerEventType.S_NODE_UNBLACKLISTED, (Object)handler.events.get(8).getType());
        Assert.assertEquals((Object)AMSchedulerEventType.S_NODE_UNBLACKLISTED, (Object)handler.events.get(9).getType());
        Thread.sleep(500L);
        this.dispatcher.await();
        handler.events.clear();
        amNodeMap.handle((AMNodeEvent)new AMNodeEventNodeCountUpdated(8));
        this.dispatcher.await();
        Thread.sleep(1000L);
        this.dispatcher.await();
        LOG.info((Object)"Completed waiting for dispatcher to process all pending events");
        Assert.assertEquals((Object)AMNodeState.BLACKLISTED, (Object)node.getState());
        Assert.assertEquals((Object)AMNodeState.BLACKLISTED, (Object)node2.getState());
        Assert.assertEquals((Object)AMNodeState.ACTIVE, (Object)node3.getState());
        Assert.assertEquals((long)8L, (long)handler.events.size());
        int index = 0;
        int numBlacklistingDisabledEvents = 0;
        int numNodeBlacklistedEvents = 0;
        int numNodeWasBlacklistedEvents = 0;
        for (Event event : handler.events) {
            LOG.info((Object)("Logging event: index:" + index++ + " type: " + event.getType()));
            if (event.getType() == AMNodeEventType.N_IGNORE_BLACKLISTING_DISABLED) {
                ++numBlacklistingDisabledEvents;
                continue;
            }
            if (event.getType() == AMSchedulerEventType.S_NODE_BLACKLISTED) {
                ++numNodeBlacklistedEvents;
                continue;
            }
            if (event.getType() == AMNodeEventType.N_NODE_WAS_BLACKLISTED) {
                ++numNodeWasBlacklistedEvents;
                continue;
            }
            Assert.assertTrue((String)("Unexpected event: " + event.getType()), (boolean)false);
        }
        Assert.assertEquals((long)4L, (long)numBlacklistingDisabledEvents);
        Assert.assertEquals((long)2L, (long)numNodeBlacklistedEvents);
        Assert.assertEquals((long)2L, (long)numNodeWasBlacklistedEvents);
        amNodeMap.stop();
    }

    private static NodeReport generateNodeReport(NodeId nodeId, NodeState nodeState) {
        NodeReport nodeReport = NodeReport.newInstance((NodeId)nodeId, (NodeState)nodeState, (String)(nodeId.getHost() + ":3433"), (String)"/default-rack", (Resource)Resource.newInstance((int)0, (int)0), (Resource)Resource.newInstance((int)10240, (int)12), (int)10, (String)nodeState.toString(), (long)System.currentTimeMillis());
        return nodeReport;
    }

    class TestEventHandler
    implements EventHandler {
        List<Event> events = Lists.newLinkedList();

        TestEventHandler() {
        }

        public void handle(Event event) {
            this.events.add(event);
            TestAMNodeMap.this.eventHandler.handle(event);
        }
    }
}

