/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.dag.api.client.DAGClientServer;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.dag.impl.TaskAttemptImpl;
import org.apache.tez.dag.app.rm.TaskSchedulerEventHandler;
import org.apache.tez.dag.app.rm.TaskSchedulerService;
import org.apache.tez.dag.app.rm.container.AMContainer;
import org.apache.tez.dag.app.rm.container.AMContainerEventCompleted;
import org.apache.tez.dag.app.rm.container.AMContainerEventType;
import org.apache.tez.dag.app.rm.container.AMContainerMap;
import org.apache.tez.dag.app.rm.container.ContainerSignatureMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestTaskSchedulerEventHandler {
    AppContext mockAppContext;
    DAGClientServer mockClientService;
    TestEventHandler mockEventHandler;
    ContainerSignatureMatcher mockSigMatcher;
    MockTaskSchedulerEventHandler schedulerHandler;
    TaskSchedulerService mockTaskScheduler;
    AMContainerMap mockAMContainerMap;

    @Before
    public void setup() {
        this.mockAppContext = (AppContext)Mockito.mock(AppContext.class);
        this.mockClientService = (DAGClientServer)Mockito.mock(DAGClientServer.class);
        this.mockEventHandler = new TestEventHandler();
        this.mockSigMatcher = (ContainerSignatureMatcher)Mockito.mock(ContainerSignatureMatcher.class);
        this.mockTaskScheduler = (TaskSchedulerService)Mockito.mock(TaskSchedulerService.class);
        this.mockAMContainerMap = (AMContainerMap)Mockito.mock(AMContainerMap.class);
        Mockito.when((Object)this.mockAppContext.getAllContainers()).thenReturn((Object)this.mockAMContainerMap);
        Mockito.when((Object)this.mockClientService.getBindAddress()).thenReturn((Object)new InetSocketAddress(10000));
        this.schedulerHandler = new MockTaskSchedulerEventHandler(this.mockAppContext, this.mockClientService, this.mockEventHandler, this.mockSigMatcher);
    }

    @Test(timeout=5000L)
    public void testContainerPreempted() throws IOException {
        Configuration conf = new Configuration(false);
        this.schedulerHandler.init(conf);
        this.schedulerHandler.start();
        String diagnostics = "Container preempted by RM.";
        TaskAttemptImpl mockTask = (TaskAttemptImpl)Mockito.mock(TaskAttemptImpl.class);
        ContainerStatus mockStatus = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        ContainerId mockCId = (ContainerId)Mockito.mock(ContainerId.class);
        AMContainer mockAMContainer = (AMContainer)Mockito.mock(AMContainer.class);
        Mockito.when((Object)this.mockAMContainerMap.get(mockCId)).thenReturn((Object)mockAMContainer);
        Mockito.when((Object)mockAMContainer.getContainerId()).thenReturn((Object)mockCId);
        Mockito.when((Object)mockStatus.getContainerId()).thenReturn((Object)mockCId);
        Mockito.when((Object)mockStatus.getDiagnostics()).thenReturn((Object)diagnostics);
        Mockito.when((Object)mockStatus.getExitStatus()).thenReturn((Object)-102);
        this.schedulerHandler.containerCompleted(mockTask, mockStatus);
        Assert.assertEquals((long)1L, (long)this.mockEventHandler.events.size());
        Event event = this.mockEventHandler.events.get(0);
        Assert.assertEquals((Object)AMContainerEventType.C_COMPLETED, (Object)event.getType());
        AMContainerEventCompleted completedEvent = (AMContainerEventCompleted)event;
        Assert.assertEquals((Object)mockCId, (Object)completedEvent.getContainerId());
        Assert.assertEquals((Object)"Container preempted externally. Container preempted by RM.", (Object)completedEvent.getDiagnostics());
        Assert.assertTrue((boolean)completedEvent.isPreempted());
        Assert.assertFalse((boolean)completedEvent.isDiskFailed());
        this.schedulerHandler.stop();
        this.schedulerHandler.close();
    }

    @Test(timeout=5000L)
    public void testContainerDiskFailed() throws IOException {
        Configuration conf = new Configuration(false);
        this.schedulerHandler.init(conf);
        this.schedulerHandler.start();
        String diagnostics = "NM disk failed.";
        TaskAttemptImpl mockTask = (TaskAttemptImpl)Mockito.mock(TaskAttemptImpl.class);
        ContainerStatus mockStatus = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        ContainerId mockCId = (ContainerId)Mockito.mock(ContainerId.class);
        AMContainer mockAMContainer = (AMContainer)Mockito.mock(AMContainer.class);
        Mockito.when((Object)this.mockAMContainerMap.get(mockCId)).thenReturn((Object)mockAMContainer);
        Mockito.when((Object)mockAMContainer.getContainerId()).thenReturn((Object)mockCId);
        Mockito.when((Object)mockStatus.getContainerId()).thenReturn((Object)mockCId);
        Mockito.when((Object)mockStatus.getDiagnostics()).thenReturn((Object)diagnostics);
        Mockito.when((Object)mockStatus.getExitStatus()).thenReturn((Object)-101);
        this.schedulerHandler.containerCompleted(mockTask, mockStatus);
        Assert.assertEquals((long)1L, (long)this.mockEventHandler.events.size());
        Event event = this.mockEventHandler.events.get(0);
        Assert.assertEquals((Object)AMContainerEventType.C_COMPLETED, (Object)event.getType());
        AMContainerEventCompleted completedEvent = (AMContainerEventCompleted)event;
        Assert.assertEquals((Object)mockCId, (Object)completedEvent.getContainerId());
        Assert.assertEquals((Object)"Container disk failed. NM disk failed.", (Object)completedEvent.getDiagnostics());
        Assert.assertFalse((boolean)completedEvent.isPreempted());
        Assert.assertTrue((boolean)completedEvent.isDiskFailed());
        this.schedulerHandler.stop();
        this.schedulerHandler.close();
    }

    class MockTaskSchedulerEventHandler
    extends TaskSchedulerEventHandler {
        public MockTaskSchedulerEventHandler(AppContext appContext, DAGClientServer clientService, EventHandler eventHandler, ContainerSignatureMatcher containerSignatureMatcher) {
            super(appContext, clientService, eventHandler, containerSignatureMatcher);
        }

        protected TaskSchedulerService createTaskScheduler(String host, int port, String trackingUrl, AppContext appContext) {
            return TestTaskSchedulerEventHandler.this.mockTaskScheduler;
        }
    }

    class TestEventHandler
    implements EventHandler {
        List<Event> events = Lists.newLinkedList();

        TestEventHandler() {
        }

        public void handle(Event event) {
            this.events.add(event);
        }
    }
}

