/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm;

import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.dag.app.rm.LocalTaskSchedulerService;
import org.junit.Assert;
import org.junit.Test;

public class TestLocalTaskSchedulerService {
    LocalTaskSchedulerService ltss;
    int core = 10;

    @Test
    public void testCreateResource() {
        long value = 0x400000L;
        Resource resource = LocalTaskSchedulerService.createResource((long)value, (int)this.core);
        Assert.assertEquals((long)((int)(value / 0x100000L)), (long)resource.getMemory());
    }

    @Test
    public void testCreateResourceLargerThanIntMax() {
        try {
            LocalTaskSchedulerService.createResource((long)Long.MAX_VALUE, (int)this.core);
            Assert.fail((String)"No exception thrown.");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof IllegalArgumentException));
            Assert.assertTrue((boolean)ex.getMessage().contains("Out of range:"));
        }
    }

    @Test
    public void testCreateResourceWithNegativeValue() {
        try {
            LocalTaskSchedulerService.createResource((long)-1048576L, (int)this.core);
            Assert.fail((String)"No exception thrown.");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof IllegalArgumentException));
            Assert.assertTrue((boolean)ex.getMessage().contains("Negative Memory or Core provided!"));
        }
    }
}

