/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm;

import java.util.LinkedHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.rm.LocalTaskSchedulerService;
import org.apache.tez.dag.app.rm.TaskSchedulerService;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestLocalTaskScheduler {
    public AppContext createMockAppContext() {
        ApplicationId appId = ApplicationId.newInstance((long)2000L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        ((AppContext)Mockito.doReturn((Object)appAttemptId).when((Object)appContext)).getApplicationAttemptId();
        return appContext;
    }

    @Test
    public void maxTasksAllocationsCannotBeExceeded() {
        int i;
        int MAX_TASKS = 4;
        TezConfiguration tezConf = new TezConfiguration();
        tezConf.setInt("tez.am.inline.task.execution.max-tasks", 4);
        LocalTaskSchedulerService.LocalContainerFactory containerFactory = new LocalTaskSchedulerService.LocalContainerFactory(this.createMockAppContext());
        LinkedHashMap taskAllocations = new LinkedHashMap();
        PriorityBlockingQueue taskRequestQueue = new PriorityBlockingQueue();
        TaskSchedulerService.TaskSchedulerAppCallback appClientDelegate = (TaskSchedulerService.TaskSchedulerAppCallback)Mockito.mock(TaskSchedulerService.TaskSchedulerAppCallback.class);
        LocalTaskSchedulerService.AsyncDelegateRequestHandler requestHandler = new LocalTaskSchedulerService.AsyncDelegateRequestHandler(taskRequestQueue, containerFactory, taskAllocations, appClientDelegate, (Configuration)tezConf);
        for (i = 0; i < 4; ++i) {
            Priority priority = Priority.newInstance((int)20);
            requestHandler.addAllocateTaskRequest((Object)new Long(i), null, priority, null);
            requestHandler.processRequest();
        }
        Assert.assertEquals((String)"Wrong number of allocate tasks", (long)4L, (long)taskAllocations.size());
        Assert.assertTrue((String)"Another allocation should not fit", (boolean)requestHandler.shouldWait());
        for (i = 0; i < 4; ++i) {
            requestHandler.addDeallocateTaskRequest((Object)new Long(i));
            requestHandler.processRequest();
        }
        Assert.assertEquals((String)"Wrong number of allocate tasks", (long)0L, (long)taskAllocations.size());
    }
}

