/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ContainerContext;
import org.apache.tez.dag.app.TaskAttemptListener;
import org.apache.tez.dag.app.TaskHeartbeatHandler;
import org.apache.tez.dag.app.dag.TaskAttemptStateInternal;
import org.apache.tez.dag.app.dag.event.DAGEventCounterUpdate;
import org.apache.tez.dag.app.dag.event.TaskAttemptEvent;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventType;
import org.apache.tez.dag.app.dag.event.TaskEventTAUpdate;
import org.apache.tez.dag.app.dag.impl.TaskAttemptImpl;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.events.TaskAttemptFinishedEvent;
import org.apache.tez.dag.history.events.TaskAttemptStartedEvent;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestTaskAttemptRecovery {
    private TaskAttemptImpl ta;
    private EventHandler mockEventHandler;
    private long startTime = System.currentTimeMillis();
    private long finishTime = this.startTime + 5000L;
    private TezTaskAttemptID taId = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
    private String vertexName = "v1";

    @Before
    public void setUp() {
        this.mockEventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        TezTaskID taskId = TezTaskID.fromString((String)"task_1407371892933_0001_1_00_000000");
        this.ta = new TaskAttemptImpl(taskId, 0, this.mockEventHandler, (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class), new Configuration(), (Clock)new SystemClock(), (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), (AppContext)Mockito.mock(AppContext.class), false, Resource.newInstance((int)1, (int)1), (ContainerContext)Mockito.mock(ContainerContext.class), false);
    }

    private void restoreFromTAStartEvent() {
        TaskAttemptState recoveredState = this.ta.restoreFromEvent((HistoryEvent)new TaskAttemptStartedEvent(this.taId, this.vertexName, this.startTime, (ContainerId)Mockito.mock(ContainerId.class), (NodeId)Mockito.mock(NodeId.class), "", ""));
        Assert.assertEquals((long)this.startTime, (long)this.ta.getLaunchTime());
        Assert.assertEquals((Object)TaskAttemptState.RUNNING, (Object)recoveredState);
    }

    private void restoreFromTAFinishedEvent(TaskAttemptState state) {
        String diag = "test_diag";
        TezCounters counters = (TezCounters)Mockito.mock(TezCounters.class);
        TaskAttemptState recoveredState = this.ta.restoreFromEvent((HistoryEvent)new TaskAttemptFinishedEvent(this.taId, this.vertexName, this.startTime, this.finishTime, state, diag, counters));
        Assert.assertEquals((long)this.startTime, (long)this.ta.getLaunchTime());
        Assert.assertEquals((long)this.finishTime, (long)this.ta.getFinishTime());
        Assert.assertEquals((Object)counters, (Object)this.ta.reportedStatus.counters);
        Assert.assertEquals((double)1.0, (double)this.ta.reportedStatus.progress, (double)1.0E-6);
        Assert.assertEquals((Object)state, (Object)this.ta.reportedStatus.state);
        Assert.assertEquals((long)1L, (long)this.ta.getDiagnostics().size());
        Assert.assertEquals((Object)diag, this.ta.getDiagnostics().get(0));
        Assert.assertEquals((Object)state, (Object)recoveredState);
    }

    private void verifyEvents(List<Event> events, Class<? extends Event> eventClass, int expectedTimes) {
        int actualTimes = 0;
        for (Event event : events) {
            if (!eventClass.isInstance(event)) continue;
            ++actualTimes;
        }
        Assert.assertEquals((long)expectedTimes, (long)actualTimes);
    }

    @Test
    public void testTARecovery_NEW() {
        this.ta.handle(new TaskAttemptEvent(this.taId, TaskAttemptEventType.TA_RECOVER));
        Assert.assertEquals((Object)TaskAttemptStateInternal.KILLED, (Object)this.ta.getInternalState());
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)this.mockEventHandler, (VerificationMode)Mockito.times((int)2))).handle((Event)eventCaptor.capture());
        List events = eventCaptor.getAllValues();
        Assert.assertEquals((long)2L, (long)events.size());
        this.verifyEvents(events, TaskEventTAUpdate.class, 1);
        this.verifyEvents(events, DAGEventCounterUpdate.class, 1);
    }

    @Test
    public void testTARecovery_START() {
        this.restoreFromTAStartEvent();
        this.ta.handle(new TaskAttemptEvent(this.taId, TaskAttemptEventType.TA_RECOVER));
        Assert.assertEquals((Object)TaskAttemptStateInternal.KILLED, (Object)this.ta.getInternalState());
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)this.mockEventHandler, (VerificationMode)Mockito.times((int)3))).handle((Event)eventCaptor.capture());
        List events = eventCaptor.getAllValues();
        Assert.assertEquals((long)3L, (long)events.size());
        this.verifyEvents(events, TaskEventTAUpdate.class, 1);
        this.verifyEvents(events, DAGEventCounterUpdate.class, 2);
    }

    @Test
    public void testTARecovery_SUCCEED() {
        this.restoreFromTAStartEvent();
        this.restoreFromTAFinishedEvent(TaskAttemptState.SUCCEEDED);
        this.ta.handle(new TaskAttemptEvent(this.taId, TaskAttemptEventType.TA_RECOVER));
        Assert.assertEquals((Object)TaskAttemptStateInternal.SUCCEEDED, (Object)this.ta.getInternalState());
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)this.mockEventHandler, (VerificationMode)Mockito.times((int)2))).handle((Event)eventCaptor.capture());
        List events = eventCaptor.getAllValues();
        Assert.assertEquals((long)2L, (long)events.size());
        this.verifyEvents(events, DAGEventCounterUpdate.class, 2);
    }

    @Test
    public void testTARecovery_KIILED() {
        this.restoreFromTAStartEvent();
        this.restoreFromTAFinishedEvent(TaskAttemptState.KILLED);
        this.ta.handle(new TaskAttemptEvent(this.taId, TaskAttemptEventType.TA_RECOVER));
        Assert.assertEquals((Object)TaskAttemptStateInternal.KILLED, (Object)this.ta.getInternalState());
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)this.mockEventHandler, (VerificationMode)Mockito.times((int)2))).handle((Event)eventCaptor.capture());
        List events = eventCaptor.getAllValues();
        Assert.assertEquals((long)2L, (long)events.size());
        this.verifyEvents(events, DAGEventCounterUpdate.class, 2);
    }

    @Test
    public void testTARecovery_FAILED() {
        this.restoreFromTAStartEvent();
        this.restoreFromTAFinishedEvent(TaskAttemptState.FAILED);
        this.ta.handle(new TaskAttemptEvent(this.taId, TaskAttemptEventType.TA_RECOVER));
        Assert.assertEquals((Object)TaskAttemptStateInternal.FAILED, (Object)this.ta.getInternalState());
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)this.mockEventHandler, (VerificationMode)Mockito.times((int)2))).handle((Event)eventCaptor.capture());
        List events = eventCaptor.getAllValues();
        Assert.assertEquals((long)2L, (long)events.size());
        this.verifyEvents(events, DAGEventCounterUpdate.class, 2);
    }

    @Test
    public void testRecover_FINISH_BUT_NO_START() {
        try {
            this.restoreFromTAFinishedEvent(TaskAttemptState.SUCCEEDED);
            Assert.fail((String)"Should fail due to no TaskAttemptStartEvent before TaskAttemptFinishedEvent");
        }
        catch (Throwable e) {
            Assert.assertEquals((Object)"Finished Event seen but no Started Event was encountered earlier", (Object)e.getMessage());
        }
    }
}

