/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app;

import java.io.IOException;
import java.util.HashMap;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.dag.app.DAGAppMaster;
import org.apache.tez.dag.app.RecoveryParser;
import org.apache.tez.dag.records.TezDAGID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRecoveryParser {
    private static String TEST_ROOT_DIR = "target/" + TestRecoveryParser.class.getName() + "-tmpDir";
    private RecoveryParser parser;

    @Before
    public void setUp() throws IllegalArgumentException, IOException {
        DAGAppMaster mockAppMaster = (DAGAppMaster)Mockito.mock(DAGAppMaster.class);
        Mockito.when((Object)mockAppMaster.getConfig()).thenReturn((Object)new Configuration());
        this.parser = new RecoveryParser(mockAppMaster, (FileSystem)Mockito.mock(FileSystem.class), new Path(TEST_ROOT_DIR), 3);
    }

    private RecoveryParser.DAGSummaryData createDAGSummaryData(TezDAGID dagId, boolean completed) {
        RecoveryParser.DAGSummaryData data = new RecoveryParser.DAGSummaryData(dagId);
        data.completed = completed;
        return data;
    }

    @Test
    public void testGetLastCompletedDAG() {
        HashMap<TezDAGID, RecoveryParser.DAGSummaryData> summaryDataMap = new HashMap<TezDAGID, RecoveryParser.DAGSummaryData>();
        int lastCompletedDAGId = new Random().nextInt(100);
        for (int i = 1; i <= lastCompletedDAGId; ++i) {
            ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
            TezDAGID dagId = TezDAGID.getInstance((ApplicationId)appId, (int)i);
            summaryDataMap.put(dagId, this.createDAGSummaryData(dagId, true));
        }
        RecoveryParser.DAGSummaryData lastCompletedDAG = this.parser.getLastCompletedOrInProgressDAG(summaryDataMap);
        Assert.assertEquals((long)lastCompletedDAGId, (long)lastCompletedDAG.dagId.getId());
    }

    @Test
    public void testGetLastInProgressDAG() {
        HashMap<TezDAGID, RecoveryParser.DAGSummaryData> summaryDataMap = new HashMap<TezDAGID, RecoveryParser.DAGSummaryData>();
        int dagNum = 100;
        int lastInProgressDAGId = new Random().nextInt(dagNum);
        for (int i = 1; i <= dagNum; ++i) {
            ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
            TezDAGID dagId = TezDAGID.getInstance((ApplicationId)appId, (int)i);
            if (i == lastInProgressDAGId) {
                summaryDataMap.put(dagId, this.createDAGSummaryData(dagId, false));
                continue;
            }
            summaryDataMap.put(dagId, this.createDAGSummaryData(dagId, true));
        }
        RecoveryParser.DAGSummaryData lastInProgressDAG = this.parser.getLastCompletedOrInProgressDAG(summaryDataMap);
        Assert.assertEquals((long)lastInProgressDAGId, (long)lastInProgressDAG.dagId.getId());
    }
}

