/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.tez.common.ContainerContext;
import org.apache.tez.common.ContainerTask;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.DAGAppMaster;
import org.apache.tez.dag.app.TaskAttemptListenerImpTezDag;
import org.apache.tez.dag.app.dag.event.VertexEventRouteEvent;
import org.apache.tez.dag.app.launcher.ContainerLauncher;
import org.apache.tez.dag.app.rm.NMCommunicatorEvent;
import org.apache.tez.dag.app.rm.NMCommunicatorEventType;
import org.apache.tez.dag.app.rm.NMCommunicatorLaunchRequestEvent;
import org.apache.tez.dag.app.rm.NMCommunicatorStopRequestEvent;
import org.apache.tez.dag.app.rm.container.AMContainerEvent;
import org.apache.tez.dag.app.rm.container.AMContainerEventLaunched;
import org.apache.tez.dag.app.rm.container.AMContainerEventType;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.events.TaskAttemptCompletedEvent;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.TezEvent;

public class MockDAGAppMaster
extends DAGAppMaster {
    MockContainerLauncher containerLauncher;

    public MockDAGAppMaster(ApplicationAttemptId applicationAttemptId, ContainerId containerId, String nmHost, int nmPort, int nmHttpPort, Clock clock, long appSubmitTime, boolean isSession, String workingDirectory, AtomicBoolean launcherGoFlag) {
        super(applicationAttemptId, containerId, nmHost, nmPort, nmHttpPort, clock, appSubmitTime, isSession, workingDirectory);
        this.containerLauncher = new MockContainerLauncher(launcherGoFlag);
    }

    protected ContainerLauncher createContainerLauncher(AppContext context) throws UnknownHostException {
        return this.containerLauncher;
    }

    public MockContainerLauncher getContainerLauncher() {
        return this.containerLauncher;
    }

    public class MockContainerLauncher
    extends AbstractService
    implements ContainerLauncher,
    Runnable {
        BlockingQueue<NMCommunicatorEvent> eventQueue;
        Thread eventHandlingThread;
        Map<ContainerId, ContainerData> containers;
        TaskAttemptListenerImpTezDag taListener;
        AtomicBoolean startScheduling;
        AtomicBoolean goFlag;
        Map<TezTaskID, Integer> preemptedTasks;

        public MockContainerLauncher(AtomicBoolean goFlag) {
            super("MockContainerLauncher");
            this.eventQueue = new LinkedBlockingQueue<NMCommunicatorEvent>();
            this.containers = Maps.newConcurrentMap();
            this.startScheduling = new AtomicBoolean(true);
            this.preemptedTasks = Maps.newConcurrentMap();
            this.goFlag = goFlag;
        }

        public void serviceStart() throws Exception {
            this.taListener = (TaskAttemptListenerImpTezDag)MockDAGAppMaster.this.getTaskAttemptListener();
            this.eventHandlingThread = new Thread(this);
            this.eventHandlingThread.start();
        }

        public void serviceStop() throws Exception {
            if (this.eventHandlingThread != null) {
                this.eventHandlingThread.interrupt();
                this.eventHandlingThread.join(2000L);
            }
        }

        public void handle(NMCommunicatorEvent event) {
            switch ((NMCommunicatorEventType)event.getType()) {
                case CONTAINER_LAUNCH_REQUEST: {
                    this.launch((NMCommunicatorLaunchRequestEvent)event);
                    break;
                }
                case CONTAINER_STOP_REQUEST: {
                    this.stop((NMCommunicatorStopRequestEvent)event);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitToGo() {
            if (this.goFlag == null) {
                return;
            }
            AtomicBoolean atomicBoolean = this.goFlag;
            synchronized (atomicBoolean) {
                this.goFlag.set(true);
                this.goFlag.notify();
                try {
                    this.goFlag.wait();
                }
                catch (InterruptedException e) {
                    throw new TezUncheckedException((Throwable)e);
                }
            }
        }

        public void startScheduling(boolean value) {
            this.startScheduling.set(value);
        }

        public Map<ContainerId, ContainerData> getContainers() {
            return this.containers;
        }

        public void preemptContainerForTask(TezTaskID tId, int uptoVersion) {
            this.preemptedTasks.put(tId, uptoVersion);
        }

        public void preemptContainer(ContainerData cData) {
            MockDAGAppMaster.this.getTaskSchedulerEventHandler().containerCompleted(null, ContainerStatus.newInstance((ContainerId)cData.cId, null, (String)"Preempted", (int)-102));
            cData.clear();
        }

        void stop(NMCommunicatorStopRequestEvent event) {
            this.containers.remove(event.getContainerId());
            MockDAGAppMaster.this.getContext().getEventHandler().handle((Event)new AMContainerEvent(event.getContainerId(), AMContainerEventType.C_NM_STOP_SENT));
        }

        void launch(NMCommunicatorLaunchRequestEvent event) {
            this.containers.put(event.getContainerId(), new ContainerData(event.getContainerId(), event.getContainerLaunchContext()));
            MockDAGAppMaster.this.getContext().getEventHandler().handle((Event)new AMContainerEventLaunched(event.getContainerId()));
        }

        public void waitTillContainersLaunched() throws InterruptedException {
            while (this.containers.isEmpty()) {
                Thread.sleep(50L);
            }
        }

        @Override
        public void run() {
            this.waitToGo();
            while (true) {
                if (!this.startScheduling.get()) {
                    continue;
                }
                for (Map.Entry<ContainerId, ContainerData> entry : this.containers.entrySet()) {
                    ContainerData cData = entry.getValue();
                    ContainerId cId = entry.getKey();
                    if (cData.taId == null) {
                        try {
                            ContainerTask cTask = this.taListener.getTask(new ContainerContext(cId.toString()));
                            if (cTask == null) continue;
                            if (cTask.shouldDie()) {
                                this.containers.remove(cId);
                                continue;
                            }
                            cData.taId = cTask.getTaskSpec().getTaskAttemptID();
                            cData.vName = cTask.getTaskSpec().getVertexName();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    if (cData.completed) continue;
                    Integer version = this.preemptedTasks.get(cData.taId.getTaskID());
                    if (version != null && cData.taId.getId() <= version) {
                        this.preemptContainer(cData);
                        continue;
                    }
                    TezVertexID vertexId = cData.taId.getTaskID().getVertexID();
                    cData.completed = true;
                    MockDAGAppMaster.this.getContext().getEventHandler().handle((Event)new VertexEventRouteEvent(vertexId, Collections.singletonList(new TezEvent((org.apache.tez.runtime.api.Event)new TaskAttemptCompletedEvent(), new EventMetaData(EventMetaData.EventProducerConsumerType.SYSTEM, cData.vName, "", cData.taId)))));
                    cData.clear();
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    System.out.println("Interrupted in mock container launcher thread");
                    return;
                }
            }
        }

        public class ContainerData {
            ContainerId cId;
            TezTaskAttemptID taId;
            String vName;
            ContainerLaunchContext launchContext;
            boolean completed;

            public ContainerData(ContainerId cId, ContainerLaunchContext context) {
                this.cId = cId;
                this.launchContext = context;
            }

            void clear() {
                this.taId = null;
                this.vName = null;
                this.completed = false;
                this.launchContext = null;
            }
        }
    }
}

