/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.upload.services;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileCleaner;
import org.apache.tapestry5.ioc.Configuration;
import org.apache.tapestry5.ioc.MappedConfiguration;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.OrderedConfiguration;
import org.apache.tapestry5.ioc.annotations.Scope;
import org.apache.tapestry5.ioc.services.PerthreadManager;
import org.apache.tapestry5.ioc.services.RegistryShutdownHub;
import org.apache.tapestry5.ioc.services.RegistryShutdownListener;
import org.apache.tapestry5.ioc.services.ThreadCleanupListener;
import org.apache.tapestry5.services.HttpServletRequestFilter;
import org.apache.tapestry5.services.LibraryMapping;
import org.apache.tapestry5.upload.internal.services.MultipartDecoderImpl;
import org.apache.tapestry5.upload.internal.services.MultipartServletRequestFilter;
import org.apache.tapestry5.upload.services.MultipartDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadModule {
    private static final AtomicBoolean needToAddShutdownListener = new AtomicBoolean(true);
    private static final String NO_LIMIT = "-1";

    public static void contributeComponentClassResolver(Configuration<LibraryMapping> configuration) {
        configuration.add((Object)new LibraryMapping("core", "org.apache.tapestry5.upload"));
    }

    @Scope(value="perthread")
    public static MultipartDecoder buildMultipartDecoder(PerthreadManager perthreadManager, RegistryShutdownHub shutdownHub, ObjectLocator locator) {
        MultipartDecoderImpl multipartDecoder = (MultipartDecoderImpl)locator.autobuild(MultipartDecoderImpl.class);
        perthreadManager.addThreadCleanupListener((ThreadCleanupListener)multipartDecoder);
        if (needToAddShutdownListener.getAndSet(false)) {
            shutdownHub.addRegistryShutdownListener(new RegistryShutdownListener(){

                public void registryDidShutdown() {
                    FileCleaner.exitWhenFinished();
                }
            });
        }
        return multipartDecoder;
    }

    public static void contributeHttpServletRequestHandler(OrderedConfiguration<HttpServletRequestFilter> configuration, MultipartDecoder multipartDecoder) {
        configuration.add("MultipartFilter", (Object)new MultipartServletRequestFilter(multipartDecoder), new String[]{"after:IgnoredPaths"});
    }

    public static void contributeFactoryDefaults(MappedConfiguration<String, String> configuration) {
        configuration.add((Object)"upload.repository-threshold", (Object)Integer.toString(10240));
        configuration.add((Object)"upload.repository-location", (Object)System.getProperty("java.io.tmpdir"));
        configuration.add((Object)"upload.requestsize-max", (Object)NO_LIMIT);
        configuration.add((Object)"upload.filesize-max", (Object)NO_LIMIT);
    }
}

