/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.upload.internal.services;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.ThreadCleanupListener;
import org.apache.tapestry5.upload.internal.services.ParametersServletRequestWrapper;
import org.apache.tapestry5.upload.internal.services.UploadMessages;
import org.apache.tapestry5.upload.internal.services.UploadedFileItem;
import org.apache.tapestry5.upload.services.MultipartDecoder;
import org.apache.tapestry5.upload.services.UploadedFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartDecoderImpl
implements MultipartDecoder,
ThreadCleanupListener {
    private final Map<String, UploadedFileItem> uploads = CollectionFactory.newMap();
    private final String repositoryLocation;
    private final int repositoryThreshold;
    private final long maxRequestSize;
    private final long maxFileSize;

    public MultipartDecoderImpl(@Inject @Symbol(value="upload.repository-location") String repositoryLocation, @Symbol(value="upload.repository-threshold") int repositoryThreshold, @Symbol(value="upload.requestsize-max") long maxRequestSize, @Symbol(value="upload.filesize-max") long maxFileSize) {
        this.repositoryLocation = repositoryLocation;
        this.repositoryThreshold = repositoryThreshold;
        this.maxRequestSize = maxRequestSize;
        this.maxFileSize = maxFileSize;
    }

    @Override
    public UploadedFile getFileUpload(String parameterName) {
        return this.uploads.get(parameterName);
    }

    @Override
    public HttpServletRequest decode(HttpServletRequest request) {
        List<FileItem> fileItems = this.parseRequest(request);
        return this.processFileItems(request, fileItems);
    }

    public void threadDidCleanup() {
        for (UploadedFileItem uploaded : this.uploads.values()) {
            uploaded.cleanup();
        }
    }

    protected List<FileItem> parseRequest(HttpServletRequest request) {
        try {
            return this.createFileUpload().parseRequest(request);
        }
        catch (FileUploadException e) {
            throw new RuntimeException(UploadMessages.unableToDecode(), e);
        }
    }

    protected ServletFileUpload createFileUpload() {
        DiskFileItemFactory factory = new DiskFileItemFactory(this.repositoryThreshold, new File(this.repositoryLocation));
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setSizeMax(this.maxRequestSize);
        upload.setFileSizeMax(this.maxFileSize);
        return upload;
    }

    protected HttpServletRequest processFileItems(HttpServletRequest request, List<FileItem> fileItems) {
        if (fileItems == null || fileItems.isEmpty()) {
            return request;
        }
        ParametersServletRequestWrapper wrapper = new ParametersServletRequestWrapper(request);
        String encoding = request.getCharacterEncoding();
        for (FileItem item : fileItems) {
            if (item.isFormField()) {
                String fieldValue;
                try {
                    fieldValue = encoding == null ? item.getString() : item.getString(encoding);
                }
                catch (UnsupportedEncodingException e) {
                    fieldValue = item.getString();
                }
                wrapper.addParameter(item.getFieldName(), fieldValue);
                continue;
            }
            wrapper.addParameter(item.getFieldName(), item.getName());
            this.addUploadedFile(item.getFieldName(), new UploadedFileItem(item));
        }
        return wrapper;
    }

    protected void addUploadedFile(String name, UploadedFileItem file) {
        this.uploads.put(name, file);
    }
}

