/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.javadoc;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Writer;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XDocStreamer {
    final File xdoc;
    final Writer writer;
    private static final Runnable NO_OP = new Runnable(){

        @Override
        public void run() {
        }
    };

    private void write(String text) {
        try {
            this.writer.write(text);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Runnable writeClose(final String elementName) {
        return new Runnable(){

            @Override
            public void run() {
                XDocStreamer.this.write("</");
                XDocStreamer.this.write(elementName);
                XDocStreamer.this.write(">");
            }
        };
    }

    public XDocStreamer(File xdoc, Writer writer) {
        this.xdoc = xdoc;
        this.writer = writer;
    }

    public void writeContent() throws SAXException {
        SaxHandler handler = new SaxHandler();
        XMLReader reader = XMLReaderFactory.createXMLReader();
        reader.setContentHandler(handler);
        reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.xdoc));
            reader.parse(new InputSource(is));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    class SaxHandler
    implements ContentHandler,
    LexicalHandler {
        final Stack<Runnable> endElementHandlers = CollectionFactory.newStack();
        ParserState state = ParserState.IGNORING;

        SaxHandler() {
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
            if (this.state == ParserState.IGNORING) {
                this.endElementHandlers.push((Object)NO_OP);
                return;
            }
            this.state = ParserState.COPYING_CDATA;
            this.endElementHandlers.push((Object)new Runnable(){

                @Override
                public void run() {
                    SaxHandler.this.state = ParserState.COPYING;
                }
            });
        }

        @Override
        public void endCDATA() throws SAXException {
            ((Runnable)this.endElementHandlers.pop()).run();
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (this.state == ParserState.IGNORING) {
                if (localName.equals("body")) {
                    this.state = ParserState.COPYING;
                }
                this.endElementHandlers.push((Object)NO_OP);
                return;
            }
            if (localName.equals("section")) {
                String name = this.getAttribute(atts, "name");
                XDocStreamer.this.write(String.format("<dt><h3>%s</h3></dt><dd>", name));
                this.endElementHandlers.push((Object)XDocStreamer.this.writeClose("dd"));
                return;
            }
            if (localName.equals("subsection")) {
                this.writeSectionHeader(atts, "h3");
                return;
            }
            if (localName.equals("source")) {
                XDocStreamer.this.write("<pre>");
                this.endElementHandlers.push((Object)XDocStreamer.this.writeClose("pre"));
                return;
            }
            XDocStreamer.this.write("<");
            XDocStreamer.this.write(localName);
            for (int i = 0; i < atts.getLength(); ++i) {
                XDocStreamer.this.write(String.format(" %s=\"%s\"", atts.getLocalName(i), atts.getValue(i)));
            }
            XDocStreamer.this.write(">");
            this.endElementHandlers.push((Object)XDocStreamer.this.writeClose(localName));
        }

        private void writeSectionHeader(Attributes atts, String elementName) {
            String name = this.getAttribute(atts, "name");
            XDocStreamer.this.write(String.format("<%s>%s</%1$s>", elementName, name));
            this.endElementHandlers.push((Object)NO_OP);
        }

        private String getAttribute(Attributes atts, String name) {
            for (int i = 0; i < atts.getLength(); ++i) {
                if (!atts.getLocalName(i).equals(name)) continue;
                return atts.getValue(i);
            }
            throw new RuntimeException(String.format("No '%s' attribute present.", name));
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ((Runnable)this.endElementHandlers.pop()).run();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            try {
                switch (this.state) {
                    case IGNORING: {
                        break;
                    }
                    case COPYING: {
                        XDocStreamer.this.writer.write(ch, start, length);
                        break;
                    }
                    case COPYING_CDATA: {
                        block12: for (int i = start; i < start + length; ++i) {
                            switch (ch[i]) {
                                case '<': {
                                    XDocStreamer.this.write("&lt;");
                                    continue block12;
                                }
                                case '>': {
                                    XDocStreamer.this.write("&gt;");
                                    continue block12;
                                }
                                case '&': {
                                    XDocStreamer.this.write("&amp;");
                                    continue block12;
                                }
                                default: {
                                    XDocStreamer.this.writer.write(ch[i]);
                                }
                            }
                        }
                        break;
                    }
                }
            }
            catch (IOException ex) {
                throw new SAXException(ex);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }
    }

    static enum ParserState {
        IGNORING,
        COPYING,
        COPYING_CDATA;

    }
}

