/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.tamaya.model;

/**
 * This enumeration defines the types of supported validations.
 */
public enum ModelType {
    /**
     * A configuration section.
     */
    Section,
    /**
     * A configuration paramter.
     */
    Parameter,
    /**
     * ConfigModel to ensure a certain configuration filter is installed.
     */
    Filter,
    /**
     * ConfigModel to ensure a certain combination policy is active.
     */
    CombinationPolicy,
    /**
     * ConfigModel that is a container of other validations.
     */
    Group,
    /**
     * ConfigModel to simply check availability for a class on the current classpath.
     */
    LoadableClass
}
