/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.consul;

import com.google.common.base.Optional;
import com.google.common.net.HostAndPort;
import com.orbitz.consul.Consul;
import com.orbitz.consul.KeyValueClient;
import com.orbitz.consul.model.kv.Value;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.consul.ConsulBackends;
import org.apache.tamaya.mutableconfig.propertysources.AbstractMutablePropertySource;
import org.apache.tamaya.mutableconfig.propertysources.ConfigChangeContext;
import org.apache.tamaya.spi.PropertyValue;
import org.apache.tamaya.spi.PropertyValueBuilder;

public class ConsulPropertySource
extends AbstractMutablePropertySource {
    private static final Logger LOG = Logger.getLogger(ConsulPropertySource.class.getName());
    private String prefix = System.getProperty("tamaya.consul.prefix", "");

    public int getOrdinal() {
        PropertyValue configuredOrdinal = this.get("tamaya.ordinal");
        if (configuredOrdinal != null) {
            try {
                return Integer.parseInt(configuredOrdinal.getValue());
            }
            catch (Exception e) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "Configured Ordinal is not an int number: " + configuredOrdinal, e);
            }
        }
        return this.getDefaultOrdinal();
    }

    public int getDefaultOrdinal() {
        return 1000;
    }

    public String getName() {
        return "consul";
    }

    public PropertyValue get(String key) {
        if (!key.startsWith(this.prefix)) {
            return null;
        }
        String reqKey = key = key.substring(this.prefix.length());
        if (key.startsWith("_")) {
            reqKey = key.substring(1);
            if (reqKey.endsWith(".createdIndex")) {
                reqKey = reqKey.substring(0, reqKey.length() - ".createdIndex".length());
            } else if (reqKey.endsWith(".modifiedIndex")) {
                reqKey = reqKey.substring(0, reqKey.length() - ".modifiedIndex".length());
            } else if (reqKey.endsWith(".ttl")) {
                reqKey = reqKey.substring(0, reqKey.length() - ".ttl".length());
            } else if (reqKey.endsWith(".expiration")) {
                reqKey = reqKey.substring(0, reqKey.length() - ".expiration".length());
            } else if (reqKey.endsWith(".source")) {
                reqKey = reqKey.substring(0, reqKey.length() - ".source".length());
            }
        }
        for (HostAndPort hostAndPort : ConsulBackends.getConsulBackends()) {
            try {
                Consul consul = Consul.builder().withHostAndPort(hostAndPort).build();
                KeyValueClient kvClient = consul.keyValueClient();
                Optional valueOpt = kvClient.getValue(reqKey);
                if (!valueOpt.isPresent()) {
                    LOG.log(Level.FINE, "key not found in consul: " + reqKey);
                    continue;
                }
                Value value = (Value)valueOpt.get();
                HashMap<String, String> props = new HashMap<String, String>();
                props.put(reqKey + ".createIndex", String.valueOf(value.getCreateIndex()));
                props.put(reqKey + ".modifyIndex", String.valueOf(value.getModifyIndex()));
                props.put(reqKey + ".lockIndex", String.valueOf(value.getLockIndex()));
                props.put(reqKey + ".flags", String.valueOf(value.getFlags()));
                return new PropertyValueBuilder(key, (String)value.getValue().get(), this.getName()).setContextData(props).build();
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "etcd access failed on " + hostAndPort + ", trying next...", e);
            }
        }
        return null;
    }

    public Map<String, String> getProperties() {
        return Collections.emptyMap();
    }

    private Map<String, String> mapPrefix(Map<String, String> props) {
        if (this.prefix.isEmpty()) {
            return props;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            if (entry.getKey().startsWith("_")) {
                map.put("_" + this.prefix + entry.getKey().substring(1), entry.getValue());
                continue;
            }
            map.put(this.prefix + entry.getKey(), entry.getValue());
        }
        return map;
    }

    public boolean isScannable() {
        return false;
    }

    protected void commitInternal(ConfigChangeContext context) {
        for (HostAndPort hostAndPort : ConsulBackends.getConsulBackends()) {
            try {
                Consul consul = Consul.builder().withHostAndPort(hostAndPort).build();
                KeyValueClient kvClient = consul.keyValueClient();
                for (String string : context.getRemovedProperties()) {
                    try {
                        kvClient.deleteKey(string);
                    }
                    catch (Exception e) {
                        LOG.info("Failed to remove key from consul: " + string);
                    }
                }
                for (Map.Entry entry : context.getAddedProperties().entrySet()) {
                    String key = (String)entry.getKey();
                    try {
                        kvClient.putValue(key, (String)entry.getValue());
                    }
                    catch (Exception e) {
                        LOG.info("Failed to add key to consul: " + (String)entry.getKey() + "=" + (String)entry.getValue());
                    }
                }
                break;
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "consul access failed on " + hostAndPort + ", trying next...", e);
            }
        }
    }
}

