/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.consul;

import com.google.common.net.HostAndPort;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ConsulBackends {
    private static final Logger LOG = Logger.getLogger(ConsulBackends.class.getName());
    private static List<HostAndPort> consulBackends = new ArrayList<HostAndPort>();

    private ConsulBackends() {
    }

    public static List<HostAndPort> getConsulBackends() {
        return consulBackends;
    }

    static {
        String serverURLs = System.getProperty("tamaya.consul.urls");
        if (serverURLs == null) {
            serverURLs = System.getenv("tamaya.consul.urls");
        }
        if (serverURLs == null) {
            serverURLs = "127.0.0.1:8300";
        }
        for (String url : serverURLs.split("\\,")) {
            try {
                consulBackends.add(HostAndPort.fromString((String)url.trim()));
                LOG.info("Using consul endoint: " + url);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Error initializing consul accessor for URL: " + url, e);
            }
        }
    }
}

