/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.inject.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Utils {
    private static final Logger LOG = Logger.getLogger(Utils.class.getName());

    private Utils() {
    }

    public static <T extends Annotation, R extends Annotation> Collection<T> getAnnotations(AnnotatedElement annotated, Class<T> repeatableAnnotation, Class<R> annotationContainer) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        R containerAnnot = annotated.getAnnotation(annotationContainer);
        if (containerAnnot != null) {
            try {
                Method valueMethod = annotationContainer.getMethod("keys", new Class[0]);
                result.addAll(Arrays.asList((Annotation[])valueMethod.invoke(containerAnnot, new Object[0])));
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to evaluate repeatable annotation.", e);
            }
        } else {
            T annot = annotated.getAnnotation(repeatableAnnotation);
            if (annot != null) {
                result.add((Annotation)annot);
            }
        }
        return result;
    }

    public static <T extends Annotation, R extends Annotation> Collection<T> getAnnotations(AccessibleObject annotated, Class<T> repeatableAnnotation, Class<R> annotationContainer) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        R containerAnnot = annotated.getAnnotation(annotationContainer);
        if (containerAnnot != null) {
            try {
                Method valueMethod = annotationContainer.getMethod("keys", new Class[0]);
                result.addAll(Arrays.asList((Annotation[])valueMethod.invoke(containerAnnot, new Object[0])));
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to evaluate repeatable annotation.", e);
            }
        } else {
            T annot = annotated.getAnnotation(repeatableAnnotation);
            if (annot != null) {
                result.add((Annotation)annot);
            }
        }
        return result;
    }

    public static <T extends Annotation> T getAnnotation(Class<T> annotationType, AnnotatedElement ... objects) {
        for (AnnotatedElement obj : objects) {
            T annot = obj.getAnnotation(annotationType);
            if (annot == null) continue;
            return annot;
        }
        return null;
    }
}

