/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.inject.internal;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.ConfigurationProvider;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.events.ConfigEvent;
import org.apache.tamaya.events.ConfigEventManager;
import org.apache.tamaya.events.spi.BaseConfigEvent;
import org.apache.tamaya.inject.api.Config;
import org.apache.tamaya.inject.api.ConfigDefaultSections;
import org.apache.tamaya.inject.api.InjectionUtils;
import org.apache.tamaya.inject.api.WithPropertyConverter;
import org.apache.tamaya.inject.spi.ConfiguredType;
import org.apache.tamaya.resolver.spi.ExpressionEvaluator;
import org.apache.tamaya.spi.ConfigurationContext;
import org.apache.tamaya.spi.ConversionContext;
import org.apache.tamaya.spi.PropertyConverter;
import org.apache.tamaya.spi.ServiceContextManager;

final class InjectionHelper {
    private static final Logger LOG = Logger.getLogger(InjectionHelper.class.getName());
    private static final boolean RESOLUTION_MODULE_LOADED = InjectionHelper.checkResolutionModuleLoaded();
    private static final boolean EVENTS_AVAILABLE = InjectionHelper.checkForEvents();

    private static boolean checkForEvents() {
        try {
            Class.forName("org.apache.tamaya.events.FrozenConfiguration");
            LOG.info("Detected tamaya-events is loaded, will trigger ConfigEvents...");
            return true;
        }
        catch (Exception e) {
            LOG.info("Detected tamaya-events not found, will not trigger any ConfigEvents...");
            return false;
        }
    }

    private static boolean checkResolutionModuleLoaded() {
        try {
            Class.forName("org.apache.tamaya.resolver.internal.DefaultExpressionEvaluator");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private InjectionHelper() {
    }

    public static String getConfigValue(Method method, Configuration config) {
        return InjectionHelper.getConfigValue(method, null, config);
    }

    public static String getConfigValue(Method method, String[] retKey, Configuration config) {
        ConfigDefaultSections areasAnnot = method.getDeclaringClass().getAnnotation(ConfigDefaultSections.class);
        return InjectionHelper.getConfigValueInternal(method, areasAnnot, retKey, config);
    }

    public static String getConfigValue(Field field, Configuration config) {
        return InjectionHelper.getConfigValue(field, null, config);
    }

    public static String getConfigValue(Field field, String[] retKey, Configuration config) {
        ConfigDefaultSections areasAnnot = field.getDeclaringClass().getAnnotation(ConfigDefaultSections.class);
        return InjectionHelper.getConfigValueInternal(field, areasAnnot, retKey, config);
    }

    private static String getConfigValueInternal(AnnotatedElement element, ConfigDefaultSections areasAnnot, String[] retKey, Configuration config) {
        Config prop = element.getAnnotation(Config.class);
        List keys = prop == null ? InjectionUtils.evaluateKeys((Member)((Member)((Object)element)), (ConfigDefaultSections)areasAnnot) : InjectionUtils.evaluateKeys((Member)((Member)((Object)element)), (ConfigDefaultSections)areasAnnot, (Config)prop);
        String configValue = InjectionHelper.evaluteConfigValue(keys, retKey, config);
        if (configValue == null) {
            if (prop.defaultValue().isEmpty()) {
                return null;
            }
            return prop.defaultValue();
        }
        return configValue;
    }

    private static String evaluteConfigValue(List<String> keys, String[] retKey, Configuration config) {
        String configValue = null;
        for (String key : keys) {
            configValue = config.get(key);
            if (configValue == null) continue;
            if (retKey == null || retKey.length <= 0) break;
            retKey[0] = key;
            break;
        }
        return configValue;
    }

    public static <T> T adaptValue(AnnotatedElement element, TypeLiteral<T> targetType, String key, String configValue) {
        Class converterType;
        Object adaptedValue = null;
        WithPropertyConverter converterAnnot = element.getAnnotation(WithPropertyConverter.class);
        if (converterAnnot != null && !(converterType = converterAnnot.value()).getName().equals(WithPropertyConverter.class.getName())) {
            try {
                ConversionContext ctx = new ConversionContext.Builder(key, targetType).setAnnotatedElement(element).build();
                PropertyConverter converter = (PropertyConverter)PropertyConverter.class.cast(converterType.newInstance());
                adaptedValue = converter.convert(configValue, ctx);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to convert using explicit PropertyConverter on " + element + ", trying default conversion.", e);
            }
        }
        if (adaptedValue != null) {
            return (T)adaptedValue;
        }
        if (String.class == targetType.getType()) {
            return (T)configValue;
        }
        if (configValue == null) {
            return null;
        }
        ConfigurationContext configContext = ConfigurationProvider.getConfiguration().getContext();
        List converters = configContext.getPropertyConverters(targetType);
        ConversionContext ctx = new ConversionContext.Builder(ConfigurationProvider.getConfiguration(), configContext, key, targetType).setAnnotatedElement(element).build();
        for (PropertyConverter converter : converters) {
            adaptedValue = converter.convert(configValue, ctx);
            if (adaptedValue == null) continue;
            return (T)adaptedValue;
        }
        throw new ConfigException("Non convertible property type: " + element);
    }

    public static boolean isResolutionModuleLoaded() {
        return RESOLUTION_MODULE_LOADED;
    }

    public static String evaluateValue(String expression) {
        if (!RESOLUTION_MODULE_LOADED) {
            return expression;
        }
        ExpressionEvaluator evaluator = (ExpressionEvaluator)ServiceContextManager.getServiceContext().getService(ExpressionEvaluator.class);
        if (evaluator != null) {
            return evaluator.evaluateExpression("<injection>", expression);
        }
        return expression;
    }

    static void sendConfigurationEvent(ConfiguredType event) {
        if (EVENTS_AVAILABLE) {
            ConfigEventManager.fireEvent((ConfigEvent)new BaseConfigEvent<ConfiguredType>(event, ConfiguredType.class){});
        }
    }
}

