/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.inject.internal;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.annotation.Priority;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.ConfigurationProvider;
import org.apache.tamaya.inject.ConfigurationInjector;
import org.apache.tamaya.inject.api.Config;
import org.apache.tamaya.inject.api.ConfigDefaultSections;
import org.apache.tamaya.inject.api.ConfiguredItemSupplier;
import org.apache.tamaya.inject.api.NoConfig;
import org.apache.tamaya.inject.internal.ConfigTemplateInvocationHandler;
import org.apache.tamaya.inject.internal.ConfiguredTypeImpl;
import org.apache.tamaya.inject.internal.InjectionHelper;
import org.apache.tamaya.inject.spi.ConfiguredType;

@Priority(value=0)
public final class DefaultConfigurationInjector
implements ConfigurationInjector {
    private final Map<Class<?>, ConfiguredType> configuredTypes = new ConcurrentHashMap();
    private static final Logger LOG = Logger.getLogger(DefaultConfigurationInjector.class.getName());

    public ConfiguredType registerType(Class<?> type) {
        ConfiguredType confType = this.configuredTypes.get(type);
        if (confType == null && this.isConfigured(type)) {
            confType = new ConfiguredTypeImpl(type);
            this.configuredTypes.put(type, confType);
            InjectionHelper.sendConfigurationEvent(confType);
        }
        return confType;
    }

    private boolean isConfigured(Class<?> type) {
        if (type.getClass().isAnnotationPresent(ConfigDefaultSections.class)) {
            return true;
        }
        for (Field field : type.getDeclaredFields()) {
            if (!field.isAnnotationPresent(NoConfig.class) && !field.isAnnotationPresent(Config.class)) continue;
            return true;
        }
        for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
            if (!accessibleObject.isAnnotationPresent(NoConfig.class) && !accessibleObject.isAnnotationPresent(Config.class)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> T configure(T instance) {
        return this.configure(instance, ConfigurationProvider.getConfiguration());
    }

    @Override
    public <T> T configure(T instance, Configuration config) {
        Class<?> type = Objects.requireNonNull(instance).getClass();
        ConfiguredType configuredType = this.registerType(type);
        if (configuredType != null) {
            configuredType.configure(instance, config);
        } else {
            LOG.info("Instance passed is not annotated for configuration: " + instance);
        }
        return instance;
    }

    @Override
    public <T> T createTemplate(Class<T> templateType) {
        return this.createTemplate(templateType, ConfigurationProvider.getConfiguration());
    }

    @Override
    public <T> T createTemplate(Class<T> templateType, Configuration config) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        return templateType.cast(Proxy.newProxyInstance(cl, new Class[]{ConfiguredItemSupplier.class, Objects.requireNonNull(templateType)}, (InvocationHandler)new ConfigTemplateInvocationHandler(templateType)));
    }

    @Override
    public <T> ConfiguredItemSupplier<T> getConfiguredSupplier(ConfiguredItemSupplier<T> supplier) {
        return this.getConfiguredSupplier(supplier, ConfigurationProvider.getConfiguration());
    }

    @Override
    public <T> ConfiguredItemSupplier<T> getConfiguredSupplier(final ConfiguredItemSupplier<T> supplier, final Configuration config) {
        return new ConfiguredItemSupplier<T>(){

            public T get() {
                return DefaultConfigurationInjector.this.configure(supplier.get(), config);
            }
        };
    }
}

