/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.inject.internal;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.ConfigurationProvider;
import org.apache.tamaya.inject.api.Config;
import org.apache.tamaya.inject.api.ConfigAutoInject;
import org.apache.tamaya.inject.api.ConfigDefaultSections;
import org.apache.tamaya.inject.api.NoConfig;
import org.apache.tamaya.inject.internal.ConfiguredFieldImpl;
import org.apache.tamaya.inject.internal.ConfiguredSetterMethod;
import org.apache.tamaya.inject.spi.ConfiguredField;
import org.apache.tamaya.inject.spi.ConfiguredMethod;
import org.apache.tamaya.inject.spi.ConfiguredType;

public class ConfiguredTypeImpl
implements ConfiguredType {
    private static final Logger LOG = Logger.getLogger(ConfiguredTypeImpl.class.getName());
    private final List<ConfiguredField> configuredFields = new ArrayList<ConfiguredField>();
    private final List<ConfiguredMethod> configuredSetterMethods = new ArrayList<ConfiguredMethod>();
    private final Class type;

    public ConfiguredTypeImpl(Class type) {
        this.type = Objects.requireNonNull(type);
        ConfigDefaultSections confType = type.getAnnotation(ConfigDefaultSections.class);
        ConfigAutoInject autoInject = type.getAnnotation(ConfigAutoInject.class);
        if (confType != null) {
            this.initFields(type, autoInject != null);
            this.initMethods(type, autoInject != null);
        } else {
            this.initFields(type, false);
            this.initMethods(type, false);
        }
    }

    private void initFields(Class type, boolean autoConfigure) {
        for (Field f : type.getDeclaredFields()) {
            if (f.isAnnotationPresent(NoConfig.class)) {
                LOG.finest("Ignored @NoConfig annotated field " + f.getClass().getName() + "#" + f.toGenericString());
                continue;
            }
            if (Modifier.isFinal(f.getModifiers())) {
                LOG.finest("Ignored final field " + f.getClass().getName() + "#" + f.toGenericString());
                continue;
            }
            if (f.isSynthetic()) {
                LOG.finest("Ignored synthetic field " + f.getClass().getName() + "#" + f.toGenericString());
                continue;
            }
            try {
                if (!ConfiguredTypeImpl.isConfiguredField(f) && !autoConfigure) continue;
                ConfiguredFieldImpl configuredField = new ConfiguredFieldImpl(f);
                this.configuredFields.add(configuredField);
                LOG.finer("Registered field " + f.getClass().getName() + "#" + f.toGenericString());
            }
            catch (Exception e) {
                throw new ConfigException("Failed to initialized configured field: " + f.getDeclaringClass().getName() + '.' + f.getName(), (Throwable)e);
            }
        }
    }

    private void initMethods(Class type, boolean autoConfigure) {
        for (Method m : type.getDeclaredMethods()) {
            Config propAnnot;
            if (m.isAnnotationPresent(NoConfig.class)) {
                LOG.finest("Ignored @NoConfig annotated method " + m.getClass().getName() + "#" + m.toGenericString());
                continue;
            }
            if (m.isSynthetic()) {
                LOG.finest("Ignored synthetic method " + m.getClass().getName() + "#" + m.toGenericString());
                continue;
            }
            if (!ConfiguredTypeImpl.isConfiguredMethod(m) && !autoConfigure || !this.addPropertySetter(m, propAnnot = m.getAnnotation(Config.class))) continue;
            LOG.finer("Added configured setter: " + m.getClass().getName() + "#" + m.toGenericString());
        }
    }

    private boolean addPropertySetter(Method m, Config prop) {
        Class<?> returnType;
        if (prop != null && m.getParameterTypes().length == 1 && Void.TYPE.equals(returnType = m.getReturnType())) {
            try {
                this.configuredSetterMethods.add(new ConfiguredSetterMethod(m));
                return true;
            }
            catch (Exception e) {
                throw new ConfigException("Failed to initialized configured setter method: " + m.getDeclaringClass().getName() + '.' + m.getName(), (Throwable)e);
            }
        }
        return false;
    }

    public void configure(Object instance) {
        this.configure(instance, ConfigurationProvider.getConfiguration());
    }

    public void configure(Object instance, Configuration config) {
        for (ConfiguredField field : this.configuredFields) {
            field.configure(instance, config);
        }
        for (ConfiguredMethod method : this.configuredSetterMethods) {
            method.configure(instance, config);
        }
    }

    public static boolean isConfigured(Class type) {
        if (type.getAnnotation(ConfigDefaultSections.class) != null) {
            return true;
        }
        for (Field field : type.getDeclaredFields()) {
            if (!ConfiguredTypeImpl.isConfiguredField(field)) continue;
            return true;
        }
        for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
            if (!ConfiguredTypeImpl.isConfiguredMethod((Method)accessibleObject)) continue;
            return true;
        }
        return false;
    }

    public static boolean isConfiguredField(Field field) {
        return field.isAnnotationPresent(Config.class);
    }

    public static boolean isConfiguredMethod(Method method) {
        return method.isAnnotationPresent(Config.class);
    }

    public Class getType() {
        return this.type;
    }

    public String getName() {
        return this.type.getName();
    }

    public Collection<ConfiguredField> getConfiguredFields() {
        return this.configuredFields;
    }

    public Collection<ConfiguredMethod> getConfiguredMethods() {
        return this.configuredSetterMethods;
    }

    public String toString() {
        return "ConfigDefaultSections{" + this.getType().getName() + '}';
    }
}

