/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.inject.internal;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Objects;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.inject.api.InjectionUtils;
import org.apache.tamaya.inject.internal.InjectionHelper;
import org.apache.tamaya.inject.spi.ConfiguredMethod;

public class ConfiguredSetterMethod
implements ConfiguredMethod {
    private Method setterMethod;
    private Collection<String> configuredKeys;

    public ConfiguredSetterMethod(Method method) {
        if (Void.TYPE.equals(method.getReturnType()) && method.getParameterTypes().length == 1) {
            this.setterMethod = method;
        }
    }

    public void configure(Object target, Configuration config) throws ConfigException {
        String[] retKey = new String[1];
        String configValue = InjectionHelper.getConfigValue(this.setterMethod, retKey, config);
        Objects.requireNonNull(target);
        try {
            String evaluatedString = configValue != null ? InjectionHelper.evaluateValue(configValue) : configValue;
            Object value = InjectionHelper.adaptValue(this.setterMethod, TypeLiteral.of(this.setterMethod.getParameterTypes()[0]), retKey[0], evaluatedString);
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    ConfiguredSetterMethod.this.setterMethod.setAccessible(true);
                    return ConfiguredSetterMethod.this.setterMethod;
                }
            });
            this.setterMethod.invoke(target, value);
        }
        catch (Exception e) {
            throw new ConfigException("Failed to annotation configured method: " + this.setterMethod.getDeclaringClass().getName() + '.' + this.setterMethod.getName(), (Throwable)e);
        }
    }

    public Collection<String> getConfiguredKeys() {
        return InjectionUtils.getKeys((Method)this.setterMethod);
    }

    public Class<?>[] getParameterTypes() {
        return this.setterMethod.getParameterTypes();
    }

    public Method getAnnotatedMethod() {
        return this.setterMethod;
    }

    public String getName() {
        return this.setterMethod.getName();
    }

    public String getSignature() {
        return "void " + this.setterMethod.getName() + '(' + this.printTypes(this.getParameterTypes()) + ')';
    }

    private String printTypes(Class<?>[] parameterTypes) {
        StringBuilder b = new StringBuilder();
        for (Class<?> cl : parameterTypes) {
            b.append(cl.getName());
            b.append(',');
        }
        if (b.length() > 0) {
            b.setLength(b.length() - 1);
        }
        return b.toString();
    }
}

