/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.inject.internal;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Objects;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.ConfigurationProvider;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.inject.api.DynamicValue;
import org.apache.tamaya.inject.api.InjectionUtils;
import org.apache.tamaya.inject.internal.DefaultDynamicValue;
import org.apache.tamaya.inject.internal.InjectionHelper;
import org.apache.tamaya.inject.spi.ConfiguredField;

public class ConfiguredFieldImpl
implements ConfiguredField {
    protected final Field annotatedField;

    public ConfiguredFieldImpl(Field field) {
        Objects.requireNonNull(field);
        this.annotatedField = field;
    }

    public void configure(Object target, Configuration config) throws ConfigException {
        if (this.annotatedField.getType() == DynamicValue.class) {
            this.applyDynamicValue(target);
        } else {
            this.applyValue(target, config, false);
        }
    }

    private void applyDynamicValue(Object target) throws ConfigException {
        Objects.requireNonNull(target);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    ConfiguredFieldImpl.this.annotatedField.setAccessible(true);
                    return ConfiguredFieldImpl.this.annotatedField;
                }
            });
            this.annotatedField.set(target, DefaultDynamicValue.of(this.annotatedField, ConfigurationProvider.getConfiguration()));
        }
        catch (Exception e) {
            throw new ConfigException("Failed to annotation configured field: " + this.annotatedField.getDeclaringClass().getName() + '.' + this.annotatedField.getName(), (Throwable)e);
        }
    }

    private void applyValue(Object target, Configuration config, boolean resolve) throws ConfigException {
        Objects.requireNonNull(target);
        try {
            String[] retKey = new String[1];
            String configValue = InjectionHelper.getConfigValue(this.annotatedField, retKey, config);
            String evaluatedValue = resolve && configValue != null ? InjectionHelper.evaluateValue(configValue) : configValue;
            Object value = InjectionHelper.adaptValue(this.annotatedField, TypeLiteral.of(this.annotatedField.getType()), retKey[0], evaluatedValue);
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    ConfiguredFieldImpl.this.annotatedField.setAccessible(true);
                    return ConfiguredFieldImpl.this.annotatedField;
                }
            });
            this.annotatedField.set(target, value);
        }
        catch (Exception e) {
            throw new ConfigException("Failed to evaluate annotated field: " + this.annotatedField.getDeclaringClass().getName() + '.' + this.annotatedField.getName(), (Throwable)e);
        }
    }

    public Class<?> getType() {
        return this.annotatedField.getType();
    }

    public Collection<String> getConfiguredKeys() {
        return InjectionUtils.getKeys((Field)this.annotatedField);
    }

    public String toString() {
        return "ConfiguredField[" + this.getSignature() + ']';
    }

    public String getName() {
        return this.annotatedField.getName();
    }

    public String getSignature() {
        return this.getName() + ':' + this.getType().getName();
    }

    public Field getAnnotatedField() {
        return this.annotatedField;
    }
}

