/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.inject.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.ConfigurationProvider;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.inject.api.DynamicValue;
import org.apache.tamaya.inject.internal.ConfiguredTypeImpl;
import org.apache.tamaya.inject.internal.DefaultDynamicValue;
import org.apache.tamaya.inject.internal.InjectionHelper;
import org.apache.tamaya.inject.spi.ConfiguredType;

public final class ConfigTemplateInvocationHandler
implements InvocationHandler {
    private final ConfiguredType type;

    public ConfigTemplateInvocationHandler(Class<?> type) {
        this.type = new ConfiguredTypeImpl(Objects.requireNonNull(type));
        if (!type.isInterface()) {
            throw new IllegalArgumentException("Can only proxy interfaces as configuration templates.");
        }
        InjectionHelper.sendConfigurationEvent(this.type);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Configuration config = ConfigurationProvider.getConfiguration();
        if ("toString".equals(method.getName())) {
            return "Configured Proxy -> " + this.type.getType().getName();
        }
        if ("hashCode".equals(method.getName())) {
            return Objects.hashCode(proxy);
        }
        if ("equals".equals(method.getName())) {
            return Objects.equals(proxy, args[0]);
        }
        if ("get".equals(method.getName())) {
            return config;
        }
        if (method.getReturnType() == DynamicValue.class) {
            return DefaultDynamicValue.of(method, config);
        }
        String[] retKey = new String[1];
        String configValue = InjectionHelper.getConfigValue(method, retKey, config);
        return InjectionHelper.adaptValue(method, TypeLiteral.of(method.getReturnType()), retKey[0], configValue);
    }
}

