/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.clsupport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

class ServiceContainer {
    private static final Logger LOG = Logger.getLogger(ServiceContainer.class.getName());
    private static final String PREFIX = "META-INF/services/";
    private final AccessControlContext acc;
    private final WeakReference<ClassLoader> classLoaderRef;
    private final Map<Class<?>, Map<String, Object>> servicesLoaded = new ConcurrentHashMap();
    private final Map<Class, Object> singletons = new ConcurrentHashMap<Class, Object>();
    private final Map<Class, List<URL>> configsLoaded = new ConcurrentHashMap<Class, List<URL>>();

    ServiceContainer(ClassLoader classLoader) {
        this.acc = System.getSecurityManager() != null ? AccessController.getContext() : null;
        this.classLoaderRef = new WeakReference<ClassLoader>(classLoader);
    }

    public ClassLoader getClassLoader() {
        ClassLoader cl = (ClassLoader)this.classLoaderRef.get();
        if (cl == null) {
            throw new IllegalStateException("Classloader reference removed, not active anynire.");
        }
        return cl;
    }

    public <T> void loadServices(Class<?> type, Collection<ServiceContainer> preceedingContainers) {
        Map<String, Object> services = this.servicesLoaded.get(type);
        if (services == null) {
            services = new LinkedHashMap<String, Object>();
            this.servicesLoaded.put(type, services);
        }
        block0: for (URL config : this.getConfigs(type)) {
            for (ServiceContainer cont : preceedingContainers) {
                if (!cont.getConfigs(type).contains(config)) continue;
                LOG.finer("Ignoring already loaded config: " + config);
                continue block0;
            }
            Collection<String> serviceNames = this.parse(type, config);
            for (String s : serviceNames) {
                for (ServiceContainer cont : preceedingContainers) {
                    if (!cont.containsService(type, s)) continue;
                    LOG.finest("Ignoring duplicate service: " + s);
                }
                LOG.info("Loading component: " + s);
                services.put(s, this.create(type, s));
            }
        }
    }

    private Collection<URL> getConfigs(Class<?> type) {
        List<URL> result = this.configsLoaded.get(type);
        if (result == null) {
            ClassLoader cl = (ClassLoader)this.classLoaderRef.get();
            if (cl == null) {
                throw new IllegalStateException("CLassLoader dereferenced already.");
            }
            result = new ArrayList<URL>();
            try {
                Enumeration<URL> resources = cl.getResources(PREFIX + type.getName());
                while (resources.hasMoreElements()) {
                    result.add(resources.nextElement());
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Failed to read service config for " + type.getName() + " from " + cl, e);
            }
            this.configsLoaded.put(type, result);
            LOG.log(Level.FINE, "Found service config for " + type.getName() + ": " + result);
        }
        return result;
    }

    private boolean containsService(Class<?> type, String serviceClassName) {
        Map<String, Object> services = this.servicesLoaded.get(type);
        return services != null && services.containsKey(serviceClassName);
    }

    private <S> S create(Class<S> serviceType, String className) {
        Class<?> c = null;
        ClassLoader classLoader = this.getClassLoader();
        try {
            c = Class.forName(className, false, classLoader);
        }
        catch (ClassNotFoundException x) {
            ServiceContainer.fail(serviceType, "Provider " + className + " not found");
        }
        if (!serviceType.isAssignableFrom(c)) {
            ServiceContainer.fail(serviceType, "Provider " + className + " not a subtype");
        }
        try {
            return serviceType.cast(c.newInstance());
        }
        catch (Throwable x) {
            ServiceContainer.fail(serviceType, "Provider " + className + " could not be instantiated", x);
            throw new Error();
        }
    }

    public <T> Collection<T> getServices(Class<T> serviceType) {
        Map<String, Object> services = this.servicesLoaded.get(serviceType);
        if (services != null) {
            return services.values();
        }
        return Collections.emptySet();
    }

    public boolean isTypeLoaded(Class<?> serviceType) {
        return this.servicesLoaded.containsKey(serviceType);
    }

    public Collection<URL> load(Class<?> serviceType) {
        return this.load(serviceType, (Collection)Collection.class.cast(Collections.emptySet()));
    }

    public Collection<URL> load(Class<?> serviceType, Collection<URL> configsLoaded) {
        ArrayList<URL> result = new ArrayList<URL>();
        try {
            Enumeration<URL> resources = this.getClassLoader().getResources(PREFIX + serviceType.getName());
            while (resources.hasMoreElements()) {
                URL res = resources.nextElement();
                if (configsLoaded.contains(res)) continue;
                result.add(res);
            }
            return result;
        }
        catch (Exception e) {
            ServiceContainer.fail(serviceType, "Failed to load service config: META-INF/services/" + serviceType.getName(), e);
            return result;
        }
    }

    private int parseLine(Class<?> serviceType, URL u, BufferedReader r, int lc, List<String> names) throws IOException, ServiceConfigurationError {
        int n;
        String ln = r.readLine();
        if (ln == null) {
            return -1;
        }
        int ci = ln.indexOf(35);
        if (ci >= 0) {
            ln = ln.substring(0, ci);
        }
        if ((n = (ln = ln.trim()).length()) != 0) {
            int cp;
            if (ln.indexOf(32) >= 0 || ln.indexOf(9) >= 0) {
                ServiceContainer.fail(serviceType, u, lc, "Illegal configuration-file syntax");
            }
            if (!Character.isJavaIdentifierStart(cp = ln.codePointAt(0))) {
                ServiceContainer.fail(serviceType, u, lc, "Illegal provider-class name: " + ln);
            }
            for (int i = Character.charCount(cp); i < n; i += Character.charCount(cp)) {
                cp = ln.codePointAt(i);
                if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
                ServiceContainer.fail(serviceType, u, lc, "Illegal provider-class name: " + ln);
            }
            Map<String, Object> services = this.servicesLoaded.get(serviceType);
            if (services == null || !services.containsKey(ln) && !names.contains(ln)) {
                names.add(ln);
            }
        }
        return lc + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<String> parse(Class<?> service, URL u) throws ServiceConfigurationError {
        InputStream in = null;
        BufferedReader r = null;
        ArrayList<String> names = new ArrayList<String>();
        try {
            in = u.openStream();
            r = new BufferedReader(new InputStreamReader(in, "utf-8"));
            int lc = 1;
            while ((lc = this.parseLine(service, u, r, lc, names)) >= 0) {
            }
        }
        catch (IOException x) {
            ServiceContainer.fail(service, "Error reading configuration file", x);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException y) {
                ServiceContainer.fail(service, "Error closing configuration file", y);
            }
        }
        return names;
    }

    private static void fail(Class<?> service, String msg, Throwable cause) throws ServiceConfigurationError {
        LOG.log(Level.SEVERE, "Failed to load: " + service.getName() + ": " + msg, cause);
    }

    private static void fail(Class<?> service, String msg) throws ServiceConfigurationError {
        LOG.log(Level.SEVERE, "Failed to load: " + service.getName() + ": " + msg);
    }

    private static void fail(Class<?> service, URL u, int line, String msg) throws ServiceConfigurationError {
        ServiceContainer.fail(service, u + ":" + line + ": " + msg);
    }

    public <T> T getSingleton(Class<T> serviceType) {
        return (T)this.singletons.get(serviceType);
    }

    <T> void setSingleton(Class<T> type, T instance) {
        LOG.info("Caching singleton for " + type.getName() + " and classloader: " + this.getClassLoader().toString() + ": " + instance);
        this.singletons.put(type, instance);
    }
}

