/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.clsupport;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Priority;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.clsupport.AbstractClassloaderAwareItemLoader;
import org.apache.tamaya.clsupport.ServiceContainer;
import org.apache.tamaya.spi.ServiceContext;

@Priority(value=10)
public class CLAwareServiceContext
extends AbstractClassloaderAwareItemLoader<ServiceContainer>
implements ServiceContext {
    private static final Logger LOG = Logger.getLogger(CLAwareServiceContext.class.getName());
    private static final String PREFIX = "META-INF/services/";

    public CLAwareServiceContext() {
    }

    public CLAwareServiceContext(ClassLoader classLoader) {
        super(classLoader);
    }

    @Override
    protected ServiceContainer createItem(ClassLoader classLoader) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Loading services for classloader: " + classLoader);
        }
        return new ServiceContainer(classLoader);
    }

    @Override
    protected void updateItem(ServiceContainer currentContainer, ClassLoader classLoader) {
    }

    public int ordinal() {
        return 10;
    }

    public <T> T getService(Class<T> serviceType) {
        return this.getService(serviceType, CLAwareServiceContext.getDefaultClassLoader());
    }

    public <T> T getService(Class<T> serviceType, ClassLoader classLoader) {
        ServiceContainer container;
        Object singleton;
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Evaluating services for classloader: " + classLoader);
        }
        if ((singleton = (container = (ServiceContainer)this.getItemNoParent(classLoader, true)).getSingleton(serviceType)) != null) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Evaluated singleton of type " + serviceType.getName() + " to " + singleton);
            }
            return singleton;
        }
        List<T> services = this.getServices(serviceType, classLoader);
        singleton = services.isEmpty() ? null : this.getServiceWithHighestPriority(services, serviceType);
        if (singleton != null) {
            container.setSingleton(serviceType, singleton);
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Evaluated singleton of type " + serviceType.getName() + " to " + singleton);
        }
        return singleton;
    }

    public <T> List<T> getServices(Class<T> serviceType) {
        return this.getServices(serviceType, AbstractClassloaderAwareItemLoader.getDefaultClassLoader());
    }

    public <T> List<T> getServices(Class<T> serviceType, ClassLoader classLoader) {
        ArrayList<T> services = new ArrayList<T>();
        ArrayList<ServiceContainer> containers = new ArrayList<ServiceContainer>();
        for (ClassLoader cl = classLoader; cl != null; cl = cl.getParent()) {
            ServiceContainer container = (ServiceContainer)this.getItemNoParent(cl, true);
            containers.add(container);
        }
        ArrayList<ServiceContainer> prevContainers = new ArrayList<ServiceContainer>();
        Collections.reverse(containers);
        for (ServiceContainer container : containers) {
            if (!container.isTypeLoaded(serviceType)) {
                container.loadServices(serviceType, prevContainers);
            }
            services.addAll(container.getServices(serviceType));
            prevContainers.add(container);
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Evaluated services of type " + serviceType.getName() + " to " + services);
        }
        return services;
    }

    private <T> T getServiceWithHighestPriority(Collection<? extends T> services, Class<T> serviceType) {
        if (services.size() == 1) {
            return services.iterator().next();
        }
        Integer highestPriority = null;
        int highestPriorityServiceCount = 0;
        T highestService = null;
        for (T service : services) {
            int prio = CLAwareServiceContext.getPriority(service);
            if (highestPriority == null || highestPriority < prio) {
                highestService = service;
                highestPriorityServiceCount = 1;
                highestPriority = prio;
                continue;
            }
            if (highestPriority != prio) continue;
            ++highestPriorityServiceCount;
        }
        if (highestPriorityServiceCount > 1) {
            throw new ConfigException(MessageFormat.format("Found {0} implementations for Service {1} with Priority {2}: {3}", highestPriorityServiceCount, serviceType.getName(), highestPriority, services));
        }
        return highestService;
    }

    public static int getPriority(Object o) {
        int prio = 0;
        Priority priority = o.getClass().getAnnotation(Priority.class);
        if (priority != null) {
            prio = priority.value();
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Evaluated priority for " + o.getClass().getName() + " to " + prio);
        }
        return prio;
    }
}

