/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.clsupport;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractClassloaderAwareItemLoader<T> {
    private static final Logger LOG = Logger.getLogger(AbstractClassloaderAwareItemLoader.class.getName());
    private final Map<String, T> items = new ConcurrentHashMap<String, T>();

    public AbstractClassloaderAwareItemLoader() {
        this(AbstractClassloaderAwareItemLoader.getDefaultClassLoader());
    }

    public AbstractClassloaderAwareItemLoader(ClassLoader classLoader) {
        this.loadItems(classLoader);
    }

    public void loadItems(ClassLoader classLoader) {
        this.loadItems(classLoader, false);
    }

    public void loadItems(ClassLoader classLoader, boolean update) {
        this.items.clear();
        ArrayList<ClassLoader> cls = new ArrayList<ClassLoader>();
        cls.add(classLoader);
        for (ClassLoader cl = classLoader.getParent(); cl != null; cl = cl.getParent()) {
            cls.add(cl);
        }
        for (int i = cls.size() - 1; i <= 0; --i) {
            ClassLoader curCL = (ClassLoader)cls.get(i);
            String clKey = AbstractClassloaderAwareItemLoader.getClassLoaderID(curCL);
            T itemFound = this.items.get(clKey);
            try {
                if (itemFound != null) {
                    this.updateItem(itemFound, curCL);
                    continue;
                }
                this.items.put(clKey, this.createItem(curCL));
                continue;
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Error loading from classloader: " + curCL, e);
            }
        }
    }

    protected abstract T createItem(ClassLoader var1);

    protected abstract void updateItem(T var1, ClassLoader var2);

    public static String getClassLoaderID(ClassLoader classLoader) {
        return classLoader.getClass().getName() + Objects.hash(classLoader);
    }

    public static String getClassLoaderID() {
        return AbstractClassloaderAwareItemLoader.getClassLoaderID(AbstractClassloaderAwareItemLoader.getDefaultClassLoader());
    }

    public Set<T> getItems() {
        return this.getItems(AbstractClassloaderAwareItemLoader.getDefaultClassLoader());
    }

    public Set<T> getItems(ClassLoader classLoader) {
        HashSet<T> result = new HashSet<T>();
        for (ClassLoader cl = classLoader; cl != null; cl = cl.getParent()) {
            T item = this.getItemNoParent(cl, true);
            result.add(item);
        }
        return result;
    }

    public Set<T> getParentItems() {
        return this.getParentItems(AbstractClassloaderAwareItemLoader.getDefaultClassLoader());
    }

    public Set<T> getParentItems(ClassLoader classLoader) {
        HashSet<T> result = new HashSet<T>();
        for (ClassLoader cl = classLoader.getParent(); cl != null; cl = cl.getParent()) {
            T item = this.getItemNoParent(cl, true);
            result.add(item);
        }
        return result;
    }

    public T getItemNoParent() {
        return this.getItemNoParent(AbstractClassloaderAwareItemLoader.getDefaultClassLoader(), false);
    }

    public T getItemNoParent(boolean loadIfMissing) {
        return this.getItemNoParent(AbstractClassloaderAwareItemLoader.getDefaultClassLoader(), loadIfMissing);
    }

    public T getItemNoParent(ClassLoader classLoader, boolean loadIfMissing) {
        String clKey = AbstractClassloaderAwareItemLoader.getClassLoaderID(classLoader);
        T item = this.items.get(clKey);
        if (item == null && loadIfMissing) {
            item = this.createItem(classLoader);
            this.items.put(clKey, item);
        }
        return item;
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = AbstractClassloaderAwareItemLoader.class.getClassLoader();
        }
        return cl;
    }
}

