/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.optional;

import java.util.Objects;
import org.apache.tamaya.ConfigurationProvider;
import org.apache.tamaya.optional.EvaluationPolicy;
import org.apache.tamaya.optional.ValueProvider;

public final class OptionalConfiguration {
    private static final boolean TAMAYA_LOADED = OptionalConfiguration.initTamayaLoaded();
    private static final String TAMAYA_CONFIGURATION = "org.apache.tamaya.Configuration";
    public static final ValueProvider DEFAULT_PROVIDER = new ValueProvider(){

        @Override
        public <T> T get(String key, Class<T> type) {
            if (String.class == type) {
                String value = System.getProperty(key);
                if (value == null) {
                    value = System.getenv(key);
                }
                return (T)value;
            }
            return null;
        }
    };
    public static final ValueProvider NULLPROVIDER = new ValueProvider(){

        @Override
        public <T> T get(String key, Class<T> type) {
            return null;
        }
    };
    private final ValueProvider provider;
    private final EvaluationPolicy policy;

    private static boolean initTamayaLoaded() {
        try {
            Class.forName(TAMAYA_CONFIGURATION);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private OptionalConfiguration(EvaluationPolicy policy, ValueProvider provider) {
        this.provider = Objects.requireNonNull(provider);
        this.policy = Objects.requireNonNull(policy);
    }

    public static OptionalConfiguration of(EvaluationPolicy policy, ValueProvider provider) {
        return new OptionalConfiguration(policy, provider);
    }

    public static OptionalConfiguration of(EvaluationPolicy policy) {
        return new OptionalConfiguration(policy, DEFAULT_PROVIDER);
    }

    public String get(String key) {
        return this.get(key, String.class);
    }

    public String getOrDefault(String key, String defaultValue) {
        String value = this.get(key, String.class);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public <T> T get(String key, Class<T> type) {
        T value = this.provider.get(key, type);
        T tamayaValue = this.getTamaya(key, type);
        switch (this.policy) {
            case OTHER_OVERRIDES_TAMAYA: {
                return value != null ? value : tamayaValue;
            }
            case TAMAYA_OVERRIDES_OTHER: {
                return tamayaValue != null ? tamayaValue : value;
            }
            case THROWS_EXCEPTION: {
                if (tamayaValue == value || (tamayaValue == null || tamayaValue.equals(value)) && (value == null || !TAMAYA_LOADED || value.equals(tamayaValue))) break;
                throw new IllegalStateException("Incompatible configuration values: key=" + key + "=" + value + "(provider)/" + tamayaValue + "(Tamaya");
            }
        }
        return value;
    }

    public <T> T getOrDefault(String key, Class<T> type, T defaultValue) {
        T value = this.get(key, type);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private <T> T getTamaya(String key, Class<T> type) {
        if (TAMAYA_LOADED) {
            return (T)ConfigurationProvider.getConfiguration().get(key, type);
        }
        return null;
    }
}

